/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CollectionsUtil {
    public static <T> List<T> nullForbiddingListWrap(List<T> orig) {
        return new NullPreventingListWrapper<T>(true, orig);
    }

    public static <T> List<T> nullForbiddingArrayList() {
        return new NullPreventingListWrapper(true, new ArrayList());
    }

    public static <T> List<T> nullDiscardingListWrap(List<T> orig) {
        return new NullPreventingListWrapper<T>(false, orig);
    }

    public static class NullPreventingListWrapper<T>
    implements List<T> {
        private final boolean throwOnNull;
        private final List<T> orig;

        public NullPreventingListWrapper(boolean throwOnNull, List<T> orig) {
            this.throwOnNull = throwOnNull;
            this.orig = orig;
        }

        private boolean checkNullInsert(T t) {
            if (t == null) {
                if (this.throwOnNull) {
                    throw new NullPointerException("null not allowed in this list");
                }
                return false;
            }
            return true;
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isEmpty() {
            return this.orig.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.orig.contains(o);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.orig.iterator();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return this.orig.toArray();
        }

        @Override
        @NotNull
        public <T1> T1[] toArray(@NotNull T1[] t1s) {
            return this.orig.toArray(t1s);
        }

        @Override
        public boolean add(T t) {
            if (this.checkNullInsert(t)) {
                return this.orig.add(t);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return this.orig.remove(o);
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> collection) {
            return this.orig.containsAll(collection);
        }

        private Collection<? extends T> preventNullInCollection(Collection<? extends T> collection) {
            if (this.throwOnNull) {
                if (collection.stream().anyMatch(Objects::isNull)) {
                    throw new NullPointerException("null not allowed in this list");
                }
                return collection;
            }
            return collection.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> collection) {
            return this.orig.addAll(this.preventNullInCollection(collection));
        }

        @Override
        public boolean addAll(int i, @NotNull Collection<? extends T> collection) {
            return this.orig.addAll(i, this.preventNullInCollection(collection));
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> collection) {
            return this.orig.removeAll(collection);
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> collection) {
            return this.orig.retainAll(collection);
        }

        @Override
        public void replaceAll(UnaryOperator<T> operator) {
            UnaryOperator wrappedOperator = t -> {
                Object tt = operator.apply(t);
                if (tt == null) {
                    throw new NullPointerException("null return not allowed for operator in this list");
                }
                return tt;
            };
            this.orig.replaceAll(wrappedOperator);
        }

        @Override
        public void sort(Comparator<? super T> c) {
            this.orig.sort(c);
        }

        @Override
        public void clear() {
            this.orig.clear();
        }

        @Override
        @Contract(value="null -> false", pure=true)
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            return this.orig.equals(o);
        }

        @Override
        public int hashCode() {
            return this.orig.hashCode();
        }

        @Override
        public T get(int i) {
            return this.orig.get(i);
        }

        @Override
        public T set(int i, T t) {
            if (this.checkNullInsert(t)) {
                return this.orig.set(i, t);
            }
            return this.orig.remove(i);
        }

        @Override
        public void add(int i, T t) {
            if (this.checkNullInsert(t)) {
                this.orig.add(i, t);
            }
        }

        @Override
        public T remove(int i) {
            return this.orig.remove(i);
        }

        @Override
        public int indexOf(Object o) {
            return this.orig.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.orig.lastIndexOf(o);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new NullForbiddingListIteratorWrapper<T>(this.throwOnNull, this.orig.listIterator());
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int i) {
            return new NullForbiddingListIteratorWrapper<T>(this.throwOnNull, this.orig.listIterator(i));
        }

        @Override
        @NotNull
        public List<T> subList(int i, int i1) {
            return new NullPreventingListWrapper<T>(this.throwOnNull, this.orig.subList(i, i1));
        }
    }

    public static class NullForbiddingListIteratorWrapper<T>
    implements ListIterator<T> {
        private final boolean throwOnNull;
        private final ListIterator<T> orig;

        public NullForbiddingListIteratorWrapper(boolean throwOnNull, ListIterator<T> orig) {
            this.throwOnNull = throwOnNull;
            this.orig = orig;
        }

        private boolean checkNullInsert(T t) {
            if (t == null) {
                if (this.throwOnNull) {
                    throw new NullPointerException("null not allowed in this list");
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.orig.hasNext();
        }

        @Override
        public T next() {
            return this.orig.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.orig.hasPrevious();
        }

        @Override
        public T previous() {
            return this.orig.previous();
        }

        @Override
        public int nextIndex() {
            return this.orig.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.orig.previousIndex();
        }

        @Override
        public void remove() {
            this.orig.remove();
        }

        @Override
        public void set(T t) {
            if (this.checkNullInsert(t)) {
                this.orig.set(t);
            }
        }

        @Override
        public void add(T t) {
            if (this.checkNullInsert(t)) {
                this.orig.add(t);
            }
        }
    }
}

