/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSDetector {
    private static final Logger LOG = LoggerFactory.getLogger(OSDetector.class);
    public static final OS os = OSDetector.findOS();

    public static OS findOS() {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("win")) {
            return OS.WIN;
        }
        if (osname.contains("mac")) {
            return OS.MAC;
        }
        if (osname.contains("nix") || osname.contains("nux") || osname.contains("aix") || osname.contains("bsd")) {
            return OS.UNIX;
        }
        LOG.warn("OSDetector could not detect os from os.name=\"" + osname + "\"");
        return null;
    }

    public static OSFilter getUnixLikeOsFilter() {
        ArrayList<OS> oses = new ArrayList<OS>();
        oses.add(OS.UNIX);
        oses.add(OS.MAC);
        return new MultiOsFilter(oses);
    }

    public static enum OS {
        WIN(false),
        UNIX(true),
        MAC(true);

        private boolean unixFilePermissions;

        private OS(boolean unixFilePermissions) {
            this.unixFilePermissions = unixFilePermissions;
        }

        public boolean hasUnixFilePermissions() {
            return this.unixFilePermissions;
        }
    }

    public static class MultiOsFilter
    implements OSFilter {
        private final Collection<OS> os;
        private final boolean invert;

        public MultiOsFilter(Collection<OS> o) {
            this.os = o;
            this.invert = false;
        }

        public MultiOsFilter(Collection<OS> o, boolean invert) {
            this.os = o;
            this.invert = invert;
        }

        @Override
        public boolean includedOs(OS o) {
            if (this.invert) {
                return !this.os.contains((Object)o);
            }
            return this.os.contains((Object)o);
        }
    }

    public static class OneOsFilter
    implements OSFilter {
        private final OS os;
        private final boolean invert;

        public OneOsFilter(OS os) {
            this.os = os;
            this.invert = false;
        }

        public OneOsFilter(OS os, boolean invert) {
            this.os = os;
            this.invert = invert;
        }

        @Override
        public boolean includedOs(OS o) {
            if (this.invert) {
                return !Objects.equals((Object)this.os, (Object)o);
            }
            return Objects.equals((Object)this.os, (Object)o);
        }
    }

    public static interface OSFilter {
        public boolean includedOs(OS var1);
    }
}

