/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshVersionFinder {
    private static final Logger LOG = LoggerFactory.getLogger(SshVersionFinder.class);
    private static Boolean cachedSupportsNc = null;

    private static Version parseOpenSshVersion(String versionLine) {
        if (versionLine == null) {
            return null;
        }
        Pattern patternVersion = Pattern.compile("OpenSSH.?([0-9]+)\\.([0-9]+).*");
        Matcher matcherVersion = patternVersion.matcher(versionLine);
        if (versionLine != null && matcherVersion.find()) {
            int bigVersion = Integer.parseInt(matcherVersion.group(1));
            int smallVersion = Integer.parseInt(matcherVersion.group(2));
            return new Version(bigVersion, smallVersion);
        }
        return null;
    }

    public static Boolean supportsNc(Version version) {
        if (version == null) {
            return null;
        }
        if (version.big > 5) {
            return true;
        }
        if (version.big == 5 && version.small >= 4) {
            return true;
        }
        return false;
    }

    public static Boolean checkIfVersionSupportsNc() {
        if (cachedSupportsNc != null) {
            LOG.debug("answering SshVersionFinder.checkIfVersionSupportsNc() from cache: " + cachedSupportsNc);
            return cachedSupportsNc;
        }
        Version version = SshVersionFinder.findOpenSshVersion();
        LOG.info("OpenSsh version: " + version);
        cachedSupportsNc = SshVersionFinder.supportsNc(version);
        return cachedSupportsNc;
    }

    public static Version findOpenSshVersion() {
        String versionLine = SshVersionFinder.findOpenSshVersion("-V");
        LOG.info("Read \"ssh -V\" output: \"" + versionLine + "\"");
        Version version = SshVersionFinder.parseOpenSshVersion(versionLine);
        if (version != null) {
            return version;
        }
        versionLine = SshVersionFinder.findOpenSshVersion("-v");
        LOG.info("Read \"ssh -v\" output: \"" + versionLine + "\"");
        version = SshVersionFinder.parseOpenSshVersion(versionLine);
        if (version != null) {
            return version;
        }
        LOG.info("OpenSSH version could not be determined");
        return null;
    }

    private static String findOpenSshVersion(String opt) {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add("ssh");
            command.add(opt);
            Process p = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            p.getOutputStream().close();
            String versionLine = input.readLine();
            input.close();
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return versionLine;
        }
        catch (AssertionError e) {
            LOG.error("AssertionError trying to call \"ssh " + opt + "\": " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            return null;
        }
        catch (Exception e) {
            LOG.error("Exception trying to call \"ssh " + opt + "\": " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static class Version {
        final int big;
        final int small;

        public Version(int big, int small) {
            this.big = big;
            this.small = small;
        }
    }
}

