/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Federation.class)
public class FederationBuilder
extends PrimaryIdObjectBuilder<String, Federation, FederationBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(FederationBuilder.class);
    private String longName;
    private List<URI> urls;
    private String description;
    private String notes;
    private List<Testbed> testbeds;
    private Federation federatedWith;

    public FederationBuilder() {
    }

    public FederationBuilder(Federation orig) {
        super((PrimaryIdObject)orig);
        this.longName = orig.getLongName();
        this.urls = orig.getUrls() == null ? null : new ArrayList<URI>(orig.getUrls());
        this.description = orig.getDescription();
        this.notes = orig.getNotes();
        this.federatedWith = orig.getFederatedWith();
        this.testbeds = orig.getTestbeds() == null ? null : new ArrayList<Testbed>(orig.getTestbeds());
    }

    public FederationBuilder(FederationBuilder orig) {
        this.id = orig.getId();
        this.uri = orig.getUri();
        this.longName = orig.getLongName();
        this.urls = orig.getUrls() == null ? null : new ArrayList<URI>(orig.getUrls());
        this.description = orig.getDescription();
        this.notes = orig.getNotes();
        this.federatedWith = orig.getFederatedWith();
        this.testbeds = orig.getTestbeds() == null ? null : new ArrayList<Testbed>(orig.getTestbeds());
    }

    public FederationBuilder setLongName(String longName) {
        this.longName = longName;
        return this;
    }

    public FederationBuilder addUrl(String url) throws URISyntaxException {
        if (this.urls == null) {
            this.urls = new ArrayList<URI>();
        }
        this.urls.add(new URI(url));
        return this;
    }

    public FederationBuilder addUrl(URI url) {
        if (this.urls == null) {
            this.urls = new ArrayList<URI>();
        }
        this.urls.add(url);
        return this;
    }

    public FederationBuilder setUrls(List<URI> urls) {
        this.urls = urls;
        return this;
    }

    public FederationBuilder setUrlsFromStrings(List<String> urls) throws URISyntaxException {
        if (urls == null) {
            this.urls = null;
            return this;
        }
        this.urls = new ArrayList<URI>();
        for (String u : urls) {
            this.urls.add(new URI(u));
        }
        return this;
    }

    public FederationBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public FederationBuilder setNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public FederationBuilder addTestbed(String name) {
        if (this.testbeds == null) {
            this.testbeds = new ArrayList<Testbed>();
        }
        Testbed testbed = ((TestbedBuilder)new TestbedBuilder().setId(name)).create();
        this.testbeds.add(testbed);
        return this;
    }

    public FederationBuilder addTestbed(Testbed testbed) {
        if (this.testbeds == null) {
            this.testbeds = new ArrayList<Testbed>();
        }
        this.testbeds.add(testbed);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Testbed.class)
    public FederationBuilder setTestbeds(Collection<Testbed> testbeds) {
        this.testbeds = TestbedBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, testbeds);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Federation.class, name="federatedWith")
    public FederationBuilder setFederatedWith(Federation parentFederation) {
        this.federatedWith = parentFederation;
        return this;
    }

    public FederationBuilder setFederatedWith(String parentFederationId) {
        this.federatedWith = parentFederationId == null ? null : ((FederationBuilder)new FederationBuilder().setId(parentFederationId)).create();
        return this;
    }

    public Federation create() {
        return new Federation((String)this.id, this.longName, this.urls, this.description, this.notes, this.testbeds, this.federatedWith, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    public Federation createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new Federation(minimization.includeId() ? (String)this.id : null, minimization.includeOtherProperties() ? this.longName : null, minimization.includeOtherProperties() ? this.urls : null, minimization.includeOtherProperties() ? this.description : null, minimization.includeOtherProperties() ? this.notes : null, this.testbeds == null || !minimization.includeChildren() ? null : TestbedBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.testbeds), this.federatedWith == null || !minimization.includeParent() ? null : FederationBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.federatedWith), minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<Federation> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<Federation> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Federation> res = new ArrayList<Federation>();
        for (Federation f : in) {
            res.add(new FederationBuilder(f).createMinimized(minimization));
        }
        return res;
    }

    public static List<Federation> minimizeBuilders(JsonLdObjectsMetaData.Minimization minimization, Collection<FederationBuilder> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Federation> res = new ArrayList<Federation>();
        for (FederationBuilder fb : in) {
            res.add(fb.createMinimized(minimization));
        }
        return res;
    }

    public static Federation minimize(JsonLdObjectsMetaData.Minimization minimization, Federation in) {
        if (in == null) {
            return null;
        }
        return new FederationBuilder(in).createMinimized(minimization);
    }

    public static Federation minimize(JsonLdObjectsMetaData.Minimization minimization, FederationBuilder in) {
        if (in == null) {
            return null;
        }
        return in.createMinimized(minimization);
    }

    public String getLongName() {
        return this.longName;
    }

    public List<URI> getUrls() {
        return this.urls;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotes() {
        return this.notes;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Testbed.class)
    public List<Testbed> getTestbeds() {
        return this.testbeds;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Federation.class, name="federatedWith")
    public Federation getFederatedWith() {
        return this.federatedWith;
    }
}

