/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="resource", builderClass=ResourceBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Resource
extends PrimaryIdObject<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(Resource.class);
    private static final ObjectMapper LINKINFO_MAPPER = Jackson.newObjectMapper();
    private final Server server;
    private final ResourceClass resourceClass;
    private final String rspecElementName;
    private final Boolean layer3;
    private final Boolean requireFixedNodeAssignment;
    private final Boolean requireDiskImage;
    private final Boolean requireHardwareType;
    private final Boolean allowFixedNodeAssignment;
    private final Boolean allowDiskImage;
    private final Boolean allowHardwareType;
    @Nullable
    private final Boolean autoFilterFixedNodesByHardwareType;
    @Nullable
    private final Boolean autoFilterFixedNodesBySliverType;
    @Nullable
    private final List<String> filterFixedNodesByHardwareType;
    @Nullable
    private final List<String> filterFixedNodesBySliverType;
    private final Boolean defaultExclusive;
    private final Boolean allowModifyExclusive;
    private final String sliverType;
    private final String hardwareType;
    private final String diskImage;
    private final String componentUrn;
    private final List<String> allowedSliverTypes;
    @Deprecated
    private final Boolean allowLinks;
    @Deprecated
    private final Boolean allowStitchedLinks;
    @Deprecated
    private final List<String> allowedLinkTypes;
    @Deprecated
    private final String defaultLinkType;
    private final List<LinkInfo> linkInfo;
    private final String overwriteServerName;
    private final Boolean allowSiteSelection;

    @JsonCreator
    Resource(@JsonProperty(value="id") Integer id, @JsonProperty(value="server") Server server, @JsonProperty(value="resourceClass") ResourceClass resourceClass, @JsonProperty(value="rspecElementName") String rspecElementName, @JsonProperty(value="layer3") Boolean layer3, @JsonProperty(value="requireFixedNodeAssignment") Boolean requireFixedNodeAssignment, @JsonProperty(value="requireDiskImage") Boolean requireDiskImage, @JsonProperty(value="requireHardwareType") Boolean requireHardwareType, @JsonProperty(value="allowFixedNodeAssignment") Boolean allowFixedNodeAssignment, @JsonProperty(value="allowDiskImage") Boolean allowDiskImage, @JsonProperty(value="allowHardwareType") Boolean allowHardwareType, @JsonProperty(value="defaultExclusive") Boolean defaultExclusive, @JsonProperty(value="allowModifyExclusive") Boolean allowModifyExclusive, @JsonProperty(value="sliverType") String sliverType, @JsonProperty(value="hardwareType") String hardwareType, @JsonProperty(value="diskImage") String diskImage, @JsonProperty(value="componentUrn") String componentUrn, @JsonProperty(value="allowedSliverTypes") List<String> allowedSliverTypes, @JsonProperty(value="allowLinks") Boolean allowLinks, @JsonProperty(value="allowStitchedLinks") Boolean allowStitchedLinks, @JsonProperty(value="allowedLinkTypes") List<String> allowedLinkTypes, @JsonProperty(value="defaultLinkType") String defaultLinkType, @Nullable @JsonProperty(value="autoFilterFixedNodesByHardwareType") Boolean autoFilterFixedNodesByHardwareType, @Nullable @JsonProperty(value="autoFilterFixedNodesBySliverType") Boolean autoFilterFixedNodesBySliverType, @Nullable @JsonProperty(value="filterFixedNodesByHardwareType") List<String> filterFixedNodesByHardwareType, @Nullable @JsonProperty(value="filterFixedNodesBySliverType") List<String> filterFixedNodesBySliverType, @Nullable @JsonProperty(value="linkInfo") List<LinkInfo> linkInfo, @Nullable @JsonProperty(value="overwriteServerName") String overwriteServerName, @Nullable @JsonProperty(value="allowSiteSelection") Boolean allowSiteSelection, @JsonProperty(value="@id") URI uri) {
        this(id, server, resourceClass, rspecElementName, layer3, requireFixedNodeAssignment, requireDiskImage, requireHardwareType, allowFixedNodeAssignment, allowDiskImage, allowHardwareType, defaultExclusive, allowModifyExclusive, sliverType, hardwareType, diskImage, componentUrn, allowedSliverTypes, allowLinks, allowStitchedLinks, allowedLinkTypes, defaultLinkType, autoFilterFixedNodesByHardwareType, autoFilterFixedNodesBySliverType, filterFixedNodesByHardwareType, filterFixedNodesBySliverType, linkInfo, overwriteServerName, allowSiteSelection, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Resource(@Nullable Integer id, @Nullable Server server, @Nullable ResourceClass resourceClass, @Nullable String rspecElementName, @Nullable Boolean layer3, @Nullable Boolean requireFixedNodeAssignment, @Nullable Boolean requireDiskImage, @Nullable Boolean requireHardwareType, @Nullable Boolean allowFixedNodeAssignment, @Nullable Boolean allowDiskImage, @Nullable Boolean allowHardwareType, @Nullable Boolean defaultExclusive, @Nullable Boolean allowModifyExclusive, @Nullable String sliverType, @Nullable String hardwareType, @Nullable String diskImage, @Nullable String componentUrn, @Nullable List<String> allowedSliverTypes, @Nullable Boolean allowLinks, @Nullable Boolean allowStitchedLinks, @Nullable List<String> allowedLinkTypes, @Nullable String defaultLinkType, @Nullable Boolean autoFilterFixedNodesByHardwareType, @Nullable Boolean autoFilterFixedNodesBySliverType, @Nullable List<String> filterFixedNodesByHardwareType, @Nullable List<String> filterFixedNodesBySliverType, @Nullable List<LinkInfo> linkInfo, @Nullable String overwriteServerName, @Nullable Boolean allowSiteSelection, @Nullable URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.server = server;
        this.resourceClass = resourceClass;
        this.rspecElementName = rspecElementName;
        this.layer3 = layer3;
        this.requireFixedNodeAssignment = requireFixedNodeAssignment;
        this.requireDiskImage = requireDiskImage;
        this.requireHardwareType = requireHardwareType;
        this.allowFixedNodeAssignment = allowFixedNodeAssignment;
        this.allowDiskImage = allowDiskImage;
        this.allowHardwareType = allowHardwareType;
        this.defaultExclusive = defaultExclusive;
        this.allowModifyExclusive = allowModifyExclusive;
        this.sliverType = sliverType;
        this.hardwareType = hardwareType;
        this.diskImage = diskImage;
        this.componentUrn = componentUrn;
        this.allowLinks = allowLinks;
        this.allowStitchedLinks = allowStitchedLinks;
        this.defaultLinkType = defaultLinkType;
        this.allowedLinkTypes = allowedLinkTypes == null ? null : Collections.unmodifiableList(new ArrayList<String>(allowedLinkTypes));
        this.allowedSliverTypes = allowedSliverTypes == null ? (sliverType == null ? null : Collections.singletonList(sliverType)) : Collections.unmodifiableList(new ArrayList<String>(allowedSliverTypes));
        this.autoFilterFixedNodesByHardwareType = autoFilterFixedNodesByHardwareType;
        this.autoFilterFixedNodesBySliverType = autoFilterFixedNodesBySliverType;
        this.filterFixedNodesByHardwareType = filterFixedNodesByHardwareType == null ? null : Collections.unmodifiableList(new ArrayList<String>(filterFixedNodesByHardwareType));
        this.filterFixedNodesBySliverType = filterFixedNodesBySliverType == null ? null : Collections.unmodifiableList(new ArrayList<String>(filterFixedNodesBySliverType));
        this.linkInfo = linkInfo == null ? null : Collections.unmodifiableList(new ArrayList<LinkInfo>(linkInfo));
        this.overwriteServerName = overwriteServerName;
        this.allowSiteSelection = allowSiteSelection;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    public Server getServer() {
        return this.server;
    }

    @JsonIgnore
    public Integer getServerId() {
        return this.server == null ? null : (Integer)this.server.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceClassDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    public ResourceClass getResourceClass() {
        return this.resourceClass;
    }

    @JsonIgnore
    public String getResourceClassId() {
        return this.resourceClass == null ? null : (String)this.resourceClass.getId();
    }

    @JsonProperty
    public String getRspecElementName() {
        return this.rspecElementName;
    }

    @JsonProperty
    public Boolean getLayer3() {
        return this.layer3;
    }

    @JsonProperty
    public Boolean getRequireFixedNodeAssignment() {
        return this.requireFixedNodeAssignment;
    }

    @JsonProperty
    public Boolean getRequireDiskImage() {
        return this.requireDiskImage;
    }

    @JsonProperty
    public Boolean getRequireHardwareType() {
        return this.requireHardwareType;
    }

    @JsonProperty
    public Boolean getAllowFixedNodeAssignment() {
        return this.allowFixedNodeAssignment;
    }

    @JsonProperty
    public Boolean getAllowDiskImage() {
        return this.allowDiskImage;
    }

    @JsonProperty
    public Boolean getAllowHardwareType() {
        return this.allowHardwareType;
    }

    @JsonProperty
    public Boolean getDefaultExclusive() {
        return this.defaultExclusive;
    }

    @JsonProperty
    public Boolean getAllowModifyExclusive() {
        return this.allowModifyExclusive;
    }

    @JsonProperty
    public String getSliverType() {
        return this.sliverType;
    }

    @Nullable
    @JsonProperty
    public List<String> getAllowedSliverTypes() {
        return this.allowedSliverTypes;
    }

    @Nonnull
    @JsonIgnore
    public List<String> getAllowedSliverTypesNonNull() {
        return this.allowedSliverTypes == null ? Collections.emptyList() : this.allowedSliverTypes;
    }

    @JsonIgnore
    public String getAllowedSliverTypesAsCsv() {
        return this.allowedSliverTypes == null ? null : String.join((CharSequence)",", this.allowedSliverTypes);
    }

    @Deprecated
    @Nullable
    @JsonProperty
    public Boolean getAllowLinks() {
        return this.allowLinks;
    }

    @Deprecated
    @JsonIgnore
    public boolean getAllowLinksOrDefault() {
        return this.allowLinks == null ? false : this.allowLinks;
    }

    @Deprecated
    @Nullable
    @JsonProperty
    public Boolean getAllowStitchedLinks() {
        return this.allowStitchedLinks;
    }

    @Deprecated
    @JsonIgnore
    public boolean getAllowStitchedLinksOrDefault() {
        return this.allowStitchedLinks == null ? false : this.allowStitchedLinks;
    }

    @Deprecated
    @Nullable
    @JsonProperty
    public List<String> getAllowedLinkTypes() {
        return this.allowedLinkTypes;
    }

    @Deprecated
    @Nullable
    @JsonProperty
    public String getDefaultLinkType() {
        return this.defaultLinkType;
    }

    @Deprecated
    @Nullable
    @JsonIgnore
    public String getAllowedLinkTypesAsCsv() {
        return this.allowedLinkTypes == null ? null : String.join((CharSequence)",", this.allowedLinkTypes);
    }

    @Deprecated
    @Nonnull
    @JsonIgnore
    public String getAllowedLinkTypesOrDefaultAsCsv() {
        return String.join((CharSequence)",", this.getAllowedLinkTypesOrDefault());
    }

    @Deprecated
    @Nonnull
    @JsonIgnore
    public String getDefaultLinkTypeOrDefault() {
        return this.defaultLinkType == null ? "lan" : this.defaultLinkType;
    }

    @Deprecated
    @Nonnull
    @JsonIgnore
    public List<String> getAllowedLinkTypesOrDefault() {
        return this.allowedLinkTypes == null ? Collections.singletonList("lan") : this.allowedLinkTypes;
    }

    @JsonProperty
    public String getHardwareType() {
        return this.hardwareType;
    }

    @JsonProperty
    public String getDiskImage() {
        return this.diskImage;
    }

    @JsonProperty
    public String getComponentUrn() {
        return this.componentUrn;
    }

    @Nullable
    @JsonProperty
    public Boolean getAutoFilterFixedNodesByHardwareType() {
        return this.autoFilterFixedNodesByHardwareType;
    }

    @JsonIgnore
    public boolean getAutoFilterFixedNodesByHardwareTypeOrDefault() {
        return this.autoFilterFixedNodesByHardwareType == null ? true : this.autoFilterFixedNodesByHardwareType;
    }

    @Nullable
    @JsonProperty
    public Boolean getAutoFilterFixedNodesBySliverType() {
        return this.autoFilterFixedNodesBySliverType;
    }

    @JsonIgnore
    public boolean getAutoFilterFixedNodesBySliverTypeOrDefault() {
        return this.autoFilterFixedNodesBySliverType == null ? true : this.autoFilterFixedNodesBySliverType;
    }

    @Nullable
    @JsonProperty
    public List<String> getFilterFixedNodesByHardwareType() {
        return this.filterFixedNodesByHardwareType;
    }

    @Nonnull
    @JsonIgnore
    public List<String> getFilterFixedNodesByHardwareTypeOrDefault() {
        return this.filterFixedNodesByHardwareType == null ? Collections.emptyList() : this.filterFixedNodesByHardwareType;
    }

    @Nullable
    @JsonIgnore
    public String getFilterFixedNodesByHardwareTypeAsCsv() {
        return this.filterFixedNodesByHardwareType == null ? null : this.filterFixedNodesByHardwareType.stream().collect(Collectors.joining(","));
    }

    @Nullable
    @JsonProperty
    public List<String> getFilterFixedNodesBySliverType() {
        return this.filterFixedNodesBySliverType;
    }

    @Nonnull
    @JsonIgnore
    public List<String> getFilterFixedNodesBySliverTypeOrDefault() {
        return this.filterFixedNodesBySliverType == null ? Collections.emptyList() : this.filterFixedNodesBySliverType;
    }

    @Nullable
    @JsonIgnore
    public String getFilterFixedNodesBySliverTypeAsCsv() {
        return this.filterFixedNodesBySliverType == null ? null : this.filterFixedNodesBySliverType.stream().collect(Collectors.joining(","));
    }

    @Nullable
    @JsonProperty
    public List<LinkInfo> getLinkInfo() {
        return this.linkInfo;
    }

    @Nullable
    @JsonIgnore
    public String getLinkInfoAsJson() {
        try {
            return this.linkInfo == null ? null : LINKINFO_MAPPER.writeValueAsString(this.linkInfo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unexpected LinkInfo serialization problem", e);
        }
    }

    @Nonnull
    @JsonIgnore
    public String getLinkInfoOrDefaultAsCsv() {
        try {
            return LINKINFO_MAPPER.writeValueAsString(this.getLinkInfoOrDefault());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unexpected LinkInfo serialization problem", e);
        }
    }

    @Nonnull
    @JsonIgnore
    public List<LinkInfo> getLinkInfoOrDefault() {
        return this.linkInfo == null ? Collections.emptyList() : this.linkInfo;
    }

    @Nullable
    @JsonProperty
    public String getOverwriteServerName() {
        return this.overwriteServerName;
    }

    @JsonIgnore
    public boolean hasOverwriteServerName() {
        return this.overwriteServerName != null;
    }

    @Nullable
    @JsonProperty
    public Boolean getAllowSiteSelection() {
        return this.allowSiteSelection;
    }

    @JsonIgnore
    public boolean isSiteSelectionAllowed() {
        return this.allowSiteSelection != Boolean.FALSE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Resource resource = (Resource)((Object)o);
        return Objects.equals((Object)this.server, (Object)resource.server) && Objects.equals((Object)this.resourceClass, (Object)resource.resourceClass) && Objects.equals(this.rspecElementName, resource.rspecElementName) && Objects.equals(this.layer3, resource.layer3) && Objects.equals(this.requireFixedNodeAssignment, resource.requireFixedNodeAssignment) && Objects.equals(this.requireDiskImage, resource.requireDiskImage) && Objects.equals(this.requireHardwareType, resource.requireHardwareType) && Objects.equals(this.allowFixedNodeAssignment, resource.allowFixedNodeAssignment) && Objects.equals(this.allowDiskImage, resource.allowDiskImage) && Objects.equals(this.allowHardwareType, resource.allowHardwareType) && Objects.equals(this.autoFilterFixedNodesByHardwareType, resource.autoFilterFixedNodesByHardwareType) && Objects.equals(this.autoFilterFixedNodesBySliverType, resource.autoFilterFixedNodesBySliverType) && Objects.equals(this.filterFixedNodesByHardwareType, resource.filterFixedNodesByHardwareType) && Objects.equals(this.filterFixedNodesBySliverType, resource.filterFixedNodesBySliverType) && Objects.equals(this.defaultExclusive, resource.defaultExclusive) && Objects.equals(this.allowModifyExclusive, resource.allowModifyExclusive) && Objects.equals(this.sliverType, resource.sliverType) && Objects.equals(this.hardwareType, resource.hardwareType) && Objects.equals(this.diskImage, resource.diskImage) && Objects.equals(this.componentUrn, resource.componentUrn) && Objects.equals(this.allowedSliverTypes, resource.allowedSliverTypes) && Objects.equals(this.allowLinks, resource.allowLinks) && Objects.equals(this.allowStitchedLinks, resource.allowStitchedLinks) && Objects.equals(this.allowedLinkTypes, resource.allowedLinkTypes) && Objects.equals(this.defaultLinkType, resource.defaultLinkType) && Objects.equals(this.linkInfo, resource.linkInfo) && Objects.equals(this.overwriteServerName, resource.overwriteServerName) && Objects.equals(this.allowSiteSelection, resource.allowSiteSelection);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.server, this.resourceClass, this.rspecElementName, this.layer3, this.requireFixedNodeAssignment, this.requireDiskImage, this.requireHardwareType, this.allowFixedNodeAssignment, this.allowDiskImage, this.allowHardwareType, this.autoFilterFixedNodesByHardwareType, this.autoFilterFixedNodesBySliverType, this.filterFixedNodesByHardwareType, this.filterFixedNodesBySliverType, this.defaultExclusive, this.allowModifyExclusive, this.sliverType, this.hardwareType, this.diskImage, this.componentUrn, this.allowedSliverTypes, this.allowLinks, this.allowStitchedLinks, this.allowedLinkTypes, this.defaultLinkType, this.linkInfo, this.overwriteServerName, this.allowSiteSelection});
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Resource " + this.id + " to JSON", (Throwable)e);
            return "Exception converting Resource " + this.id + " to JSON: " + e.getMessage();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class LinkInfo {
        @Nullable
        private final LinkInfoFilter filter;
        @Nonnull
        private final LinkInfoRules rules;

        @JsonCreator
        public LinkInfo(@JsonProperty(value="filter") @Nullable LinkInfoFilter filter, @JsonProperty(value="rules") @Nonnull LinkInfoRules rules) {
            this.filter = filter;
            this.rules = rules;
        }

        @JsonProperty
        @Nullable
        public LinkInfoFilter getFilter() {
            return this.filter;
        }

        @JsonProperty
        @Nonnull
        public LinkInfoRules getRules() {
            return this.rules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkInfo)) {
                return false;
            }
            LinkInfo linkInfo = (LinkInfo)o;
            return Objects.equals(this.filter, linkInfo.filter) && Objects.equals(this.rules, linkInfo.rules);
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.rules);
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting Resource.LinkInfo to JSON", (Throwable)e);
                return "Exception converting Resource.LinkInfo to JSON: " + e.getMessage();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class LinkInfoRules {
        @Nullable
        private final Boolean allowLink;
        @Nullable
        private final Boolean allowNoLinkType;
        @Nullable
        private final List<String> allowedLinkTypes;
        @Nullable
        private final String defaultLinkType;

        public LinkInfoRules(@JsonProperty(value="allowLink") @Nullable Boolean allowLink, @JsonProperty(value="allowNoLinkType") @Nullable Boolean allowNoLinkType, @JsonProperty(value="allowedLinkTypes") @Nullable List<String> allowedLinkTypes, @JsonProperty(value="defaultLinkType") @Nullable String defaultLinkType) {
            this.allowLink = allowLink;
            this.allowNoLinkType = allowNoLinkType;
            this.allowedLinkTypes = allowedLinkTypes;
            this.defaultLinkType = defaultLinkType;
        }

        @JsonProperty
        @Nullable
        public Boolean getAllowLink() {
            return this.allowLink;
        }

        @JsonProperty
        @Nullable
        public Boolean getAllowNoLinkType() {
            return this.allowNoLinkType;
        }

        @JsonProperty
        @Nullable
        public List<String> getAllowedLinkTypes() {
            return this.allowedLinkTypes;
        }

        @JsonProperty
        @Nullable
        public String getDefaultLinkType() {
            return this.defaultLinkType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkInfoRules)) {
                return false;
            }
            LinkInfoRules that = (LinkInfoRules)o;
            return Objects.equals(this.allowLink, that.allowLink) && Objects.equals(this.allowNoLinkType, that.allowNoLinkType) && Objects.equals(this.allowedLinkTypes, that.allowedLinkTypes) && Objects.equals(this.defaultLinkType, that.defaultLinkType);
        }

        public int hashCode() {
            return Objects.hash(this.allowLink, this.allowNoLinkType, this.allowedLinkTypes, this.defaultLinkType);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class LinkInfoFilter {
        @Nullable
        private final Boolean matchSameResource;
        @Nullable
        private final Boolean matchAnySameServer;
        @Nullable
        private final Boolean matchAnyInterServer;
        @Nullable
        private final List<Integer> matchResourceId;
        @Nullable
        private final List<Integer> matchServerId;
        @Nullable
        private final List<String> matchCategory;
        @Nullable
        private final List<String> matchFederation;
        @Nullable
        private final Integer maxNodeCount;

        public LinkInfoFilter(@JsonProperty(value="matchSameResource") @Nullable Boolean matchSameResource, @JsonProperty(value="matchAnySameServer") @Nullable Boolean matchAnySameServer, @JsonProperty(value="matchAnyInterServer") @Nullable Boolean matchAnyInterServer, @JsonProperty(value="matchResourceId") @Nullable List<Integer> matchResourceId, @JsonProperty(value="matchServerId") @Nullable List<Integer> matchServerId, @JsonProperty(value="matchCategory") @Nullable List<String> matchCategory, @JsonProperty(value="matchFederation") @Nullable List<String> matchFederation, @JsonProperty(value="maxNodeCount") @Nullable Integer maxNodeCount) {
            this.matchSameResource = matchSameResource;
            this.matchAnySameServer = matchAnySameServer;
            this.matchAnyInterServer = matchAnyInterServer;
            this.matchResourceId = matchResourceId;
            this.matchServerId = matchServerId;
            this.matchCategory = matchCategory;
            this.matchFederation = matchFederation;
            this.maxNodeCount = maxNodeCount;
        }

        @JsonProperty
        @Nullable
        public Boolean getMatchSameResource() {
            return this.matchSameResource;
        }

        @JsonProperty
        @Nullable
        public Boolean getMatchAnySameServer() {
            return this.matchAnySameServer;
        }

        @JsonProperty
        @Nullable
        public Boolean getMatchAnyInterServer() {
            return this.matchAnyInterServer;
        }

        @JsonProperty
        @Nullable
        public List<Integer> getMatchResourceId() {
            return this.matchResourceId;
        }

        @JsonProperty
        @Nullable
        public List<Integer> getMatchServerId() {
            return this.matchServerId;
        }

        @JsonProperty
        @Nullable
        public List<String> getMatchCategory() {
            return this.matchCategory;
        }

        @JsonProperty
        @Nullable
        public List<String> getMatchFederation() {
            return this.matchFederation;
        }

        @JsonProperty
        @Nullable
        public Integer getMaxNodeCount() {
            return this.maxNodeCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkInfoFilter)) {
                return false;
            }
            LinkInfoFilter that = (LinkInfoFilter)o;
            return Objects.equals(this.matchSameResource, that.matchSameResource) && Objects.equals(this.matchAnySameServer, that.matchAnySameServer) && Objects.equals(this.matchAnyInterServer, that.matchAnyInterServer) && Objects.equals(this.matchResourceId, that.matchResourceId) && Objects.equals(this.matchServerId, that.matchServerId) && Objects.equals(this.matchCategory, that.matchCategory) && Objects.equals(this.matchFederation, that.matchFederation) && Objects.equals(this.maxNodeCount, that.maxNodeCount);
        }

        public int hashCode() {
            return Objects.hash(this.matchSameResource, this.matchAnySameServer, this.matchAnyInterServer, this.matchResourceId, this.matchServerId, this.matchCategory, this.matchFederation, this.maxNodeCount);
        }
    }
}

