/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FrequencyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestInstance.class)
public class TestInstanceBuilder
extends PrimaryIdObjectBuilder<Integer, TestInstance, TestInstanceBuilder> {
    private String name;
    private TestDefinition testDefinition;
    private String testVersion;
    private Boolean enabled;
    private Frequency frequency;
    private Map<String, Object> parameters;
    private Boolean selfTestImmune;
    private URI resultsUri;
    private URI graphsUri;

    public TestInstanceBuilder() {
        this.parameters = new HashMap<String, Object>();
    }

    public TestInstanceBuilder(TestInstance orig) {
        super((PrimaryIdObject)orig);
        this.name = orig.getName();
        this.testDefinition = orig.getTestDefinition();
        this.testVersion = orig.getTestVersion();
        this.enabled = orig.getEnabled();
        this.selfTestImmune = orig.getSelfTestImmune();
        this.frequency = orig.getFrequency();
        this.parameters = orig.getParameters() == null ? null : new HashMap<String, Object>(orig.getParameters());
        this.resultsUri = orig.getResultsUri();
        this.graphsUri = orig.getGraphsUri();
    }

    public TestInstanceBuilder setResultsUri(URI resultsUri) {
        this.resultsUri = resultsUri;
        return this;
    }

    public TestInstanceBuilder setGraphsUri(URI graphsUri) {
        this.graphsUri = graphsUri;
        return this;
    }

    public TestInstanceBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public TestInstanceBuilder setTestDefinition(String testDefinitionId) {
        this.testDefinition = ((TestDefinitionBuilder)new TestDefinitionBuilder().setId(testDefinitionId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        return this;
    }

    public TestInstanceBuilder setTestDefinition(String testDefinitionId, URI testDefinitionUri) {
        this.testDefinition = ((TestDefinitionBuilder)((TestDefinitionBuilder)new TestDefinitionBuilder().setId(testDefinitionId)).setUri(testDefinitionUri)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=TestDefinition.class)
    public TestInstanceBuilder setTestDefinition(TestDefinition testDefinition) {
        this.testDefinition = testDefinition;
        return this;
    }

    public TestInstanceBuilder setTestVersion(String testVersion) {
        this.testVersion = testVersion;
        return this;
    }

    public TestInstanceBuilder setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TestInstanceBuilder setSelfTestImmune(Boolean selfTestImmune) {
        this.selfTestImmune = selfTestImmune;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Frequency.class)
    public TestInstanceBuilder setFrequency(Frequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public TestInstanceBuilder setParameters(Map<String, ?> parameters) {
        this.parameters = new HashMap(parameters);
        return this;
    }

    public TestInstanceBuilder addParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>(this.parameters);
        }
        this.parameters.put(key, value);
        return this;
    }

    public TestInstanceBuilder setParametersExceptServerAndUser(Map<String, Object> parameters) {
        HashMap<String, Object> copy = new HashMap<String, Object>(parameters);
        copy.remove("server");
        copy.remove("user");
        if (this.parameters != null && this.parameters.containsKey("server")) {
            copy.put("server", this.parameters.get("server"));
        }
        if (this.parameters != null && this.parameters.containsKey("user")) {
            copy.put("user", this.parameters.get("user"));
        }
        this.parameters = copy;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, name="serverParameter")
    public TestInstanceBuilder setServerParameter(Server server) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>(this.parameters);
        }
        if (server == null) {
            this.parameters.remove("server");
        } else {
            this.parameters.put("server", (Object)server);
        }
        return this;
    }

    public TestInstanceBuilder setEmailParameter(TestEmailConfig email) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>(this.parameters);
        }
        if (email == null) {
            this.parameters.remove("email");
        } else {
            this.parameters.put("email", (Object)email);
        }
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=User.class, name="userParameter")
    public TestInstanceBuilder setUserParameter(User user) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>(this.parameters);
        }
        if (user == null) {
            this.parameters.remove("user");
        } else {
            this.parameters.put("user", (Object)user);
        }
        return this;
    }

    public TestInstanceBuilder setServerParameter(Integer serverId, URI serverUri) {
        if (serverId == null) {
            this.parameters.remove("server");
        } else {
            this.parameters.put("server", (Object)((ServerBuilder)((ServerBuilder)new ServerBuilder().setId(serverId)).setUri(serverUri)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        }
        return this;
    }

    public TestInstanceBuilder setUserParameter(String userId, String username, URI userUri) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>(this.parameters);
        }
        if (userId == null) {
            this.parameters.remove("user");
        } else {
            this.parameters.put("user", (Object)((UserBuilder)((UserBuilder)new UserBuilder().setId(userId)).setUsername(username).setUri(userUri)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        }
        return this;
    }

    public TestInstance create() {
        return new TestInstance((Integer)this.id, this.name, this.testDefinition, this.testVersion, this.enabled, this.frequency, this.parameters, this.selfTestImmune, this.uri, this.resultsUri, this.graphsUri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    public TestInstance createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        HashMap<String, Object> parametersToInclude;
        if (minimization.includeOtherProperties()) {
            HashMap<String, Object> hashMap = parametersToInclude = this.parameters == null ? null : new HashMap<String, Object>(this.parameters);
            if (parametersToInclude != null && this.getServerParameter() != null) {
                parametersToInclude.put("server", (Object)new ServerBuilder(this.getServerParameter()).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
            }
            if (parametersToInclude != null && this.getUserParameter() != null) {
                parametersToInclude.put("user", (Object)new UserBuilder(this.getUserParameter()).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
            }
        } else {
            parametersToInclude = null;
        }
        return new TestInstance(minimization.includeId() ? (Integer)this.id : null, minimization.includeExtraIds() ? this.name : null, minimization.includeParent() ? (this.testDefinition == null ? null : new TestDefinitionBuilder(this.testDefinition).createMinimized(minimization.getParentMinimization())) : null, minimization.includeExtraIds() ? this.testVersion : null, minimization.includeExtraIds() ? this.enabled : null, minimization.includeOtherProperties() || minimization.includeChildren() ? (this.frequency == null ? null : new FrequencyBuilder(this.frequency).createMinimized(minimization.includeChildren() ? minimization.getChildrenMinimization() : JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)) : null, parametersToInclude, minimization.includeOtherProperties() ? this.selfTestImmune : null, minimization.includeId() ? this.uri : null, minimization.includeOtherProperties() ? this.resultsUri : null, minimization.includeOtherProperties() ? this.graphsUri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<TestInstance> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<TestInstance> in) {
        if (in == null) {
            return null;
        }
        ArrayList<TestInstance> res = new ArrayList<TestInstance>();
        for (TestInstance tb : in) {
            res.add(new TestInstanceBuilder(tb).createMinimized(minimization));
        }
        return res;
    }

    public static TestInstance minimize(JsonLdObjectsMetaData.Minimization minimization, TestInstance in) {
        if (in == null) {
            return null;
        }
        return new TestInstanceBuilder(in).createMinimized(minimization);
    }

    public String getName() {
        return this.name;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=TestDefinition.class)
    public TestDefinition getTestDefinition() {
        return this.testDefinition;
    }

    public String getTestVersion() {
        return this.testVersion;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getSelfTestImmune() {
        return this.selfTestImmune;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Frequency.class)
    public Frequency getFrequency() {
        return this.frequency;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public URI getResultsUri() {
        return this.resultsUri;
    }

    public URI getGraphsUri() {
        return this.graphsUri;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, name="serverParameter")
    public Server getServerParameter() {
        if (this.parameters == null || !this.parameters.containsKey("server")) {
            return null;
        }
        return (Server)((Object)this.parameters.get("server"));
    }

    public TestEmailConfig getEmailParameter() {
        if (this.parameters == null || !this.parameters.containsKey("email")) {
            return null;
        }
        return (TestEmailConfig)((Object)this.parameters.get("email"));
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=User.class, name="userParameter")
    public User getUserParameter() {
        if (this.parameters == null || !this.parameters.containsKey("user")) {
            return null;
        }
        return (User)((Object)this.parameters.get("user"));
    }
}

