/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=User.class)
public class UserBuilder
extends PrimaryIdObjectBuilder<String, User, UserBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(UserBuilder.class);
    private String username;
    private String authorityUrn;
    private String privateKeyAndCertPem;
    private Boolean selfTestFailed;

    public UserBuilder() {
    }

    public UserBuilder(User orig) {
        super((PrimaryIdObject)orig);
        this.username = orig.getUsername();
        this.authorityUrn = orig.getAuthorityUrn();
        this.privateKeyAndCertPem = orig.getPrivateKeyAndCertPem();
        this.selfTestFailed = orig.getSelfTestFailed();
    }

    public UserBuilder(Map jsonMap) {
        Object type = jsonMap.get("@type");
        Object uri = jsonMap.get("@id");
        Object id = jsonMap.get("id");
        Object username = jsonMap.get("username");
        Object pem = jsonMap.get("pem");
        Object authorityUrn = jsonMap.get("authorityUrn");
        Object selfTestFailed = jsonMap.get("selfTestFailed");
        if (type == null || !type.equals("User")) {
            throw new IllegalArgumentException("Illegal type, cannot build User from this: " + type);
        }
        if (id != null && id instanceof String) {
            this.id = (String)id;
        }
        if (username != null && username instanceof String) {
            this.username = (String)username;
        }
        if (authorityUrn != null && authorityUrn instanceof String) {
            this.authorityUrn = (String)authorityUrn;
        }
        if (pem != null && pem instanceof String) {
            this.privateKeyAndCertPem = (String)pem;
        }
        if (selfTestFailed != null && selfTestFailed instanceof Boolean) {
            this.selfTestFailed = (Boolean)selfTestFailed;
        }
        if (uri != null && uri instanceof String) {
            try {
                this.uri = new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.debug("invalid Testbed URI. will be ignored: \"" + uri + "\"");
            }
        }
    }

    public UserBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public UserBuilder setPrivateKeyAndCertPem(String privateKeyAndCertPem) {
        this.privateKeyAndCertPem = privateKeyAndCertPem;
        return this;
    }

    public UserBuilder setSelfTestFailed(Boolean selfTestFailed) {
        this.selfTestFailed = selfTestFailed;
        return this;
    }

    public UserBuilder setAuthorityUrn(String authorityUrn) {
        this.authorityUrn = authorityUrn;
        return this;
    }

    public User create() {
        return new User((String)this.id, this.username, this.privateKeyAndCertPem, this.authorityUrn, this.selfTestFailed, this.uri);
    }

    public User createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new User(minimization.includeId() ? (String)this.id : null, minimization.includeExtraIds() ? this.username : null, minimization.includeOtherProperties() ? this.privateKeyAndCertPem : null, minimization.includeOtherProperties() ? this.authorityUrn : null, minimization.includeOtherProperties() ? this.selfTestFailed : null, minimization.includeId() ? this.uri : null);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPrivateKeyAndCertPem() {
        return this.privateKeyAndCertPem;
    }

    public String getPem() {
        return this.privateKeyAndCertPem;
    }

    public String getAuthorityUrn() {
        return this.authorityUrn;
    }

    public Boolean getselfTestFailed() {
        return this.selfTestFailed;
    }
}

