/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config;

import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class TestbedSiteInfo {
    private final GeniUrn urn;
    private final String hrn;
    private final IntegerProperty availableComponents;
    private final IntegerProperty totalComponents;

    public TestbedSiteInfo(GeniUrn urn, String hrn) {
        this.urn = urn;
        this.hrn = hrn;
        this.availableComponents = new SimpleIntegerProperty(-1);
        this.totalComponents = new SimpleIntegerProperty(-1);
    }

    public TestbedSiteInfo(GeniUrn urn, String hrn, int availableComponents, int totalComponents) {
        this.urn = urn;
        this.hrn = hrn;
        this.availableComponents = new SimpleIntegerProperty(availableComponents);
        this.totalComponents = new SimpleIntegerProperty(totalComponents);
    }

    public GeniUrn getUrn() {
        return this.urn;
    }

    public String getHrn() {
        return this.hrn;
    }

    public int getAvailableComponents() {
        return this.availableComponents.get();
    }

    public IntegerProperty availableComponentsProperty() {
        return this.availableComponents;
    }

    public int getTotalComponents() {
        return this.totalComponents.get();
    }

    public IntegerProperty totalComponentsProperty() {
        return this.totalComponents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestbedSiteInfo that = (TestbedSiteInfo)o;
        return Objects.equals(this.urn, that.urn);
    }

    public int hashCode() {
        return Objects.hash(this.urn);
    }

    public String toString() {
        return "TestbedSiteInfo{urn=" + String.valueOf(this.urn) + ", hrn='" + this.hrn + "', availComps=" + this.availableComponents.intValue() + ", totalComps=" + this.totalComponents.intValue() + "}";
    }
}

