/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config.util;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGenerator;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiConfigRSpecGenerator
implements RSpecGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(GuiConfigRSpecGenerator.class);
    @Nonnull
    private final JFedGuiConfig jFedGuiConfig;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    private Server server = null;
    private Integer nodeCount = 1;
    private List<String> nodeNames = Collections.emptyList();
    private String resourceClassIdPrefix = null;
    private String nodeNamePrefix = "n";
    private List<String> nodeAnsibleGroup;
    @Nullable
    private String diskImage;
    @Nullable
    private Boolean link = null;
    @Nullable
    private String linkSubnet = null;
    @Nullable
    private Integer linkStartIpIndex = null;

    public GuiConfigRSpecGenerator(@Nonnull JFedGuiConfig jFedGuiConfig, @Nonnull AuthorityFinder authorityFinder, @Nonnull TestbedInfoSource testbedInfoSource) {
        this.jFedGuiConfig = jFedGuiConfig;
        this.authorityFinder = authorityFinder;
        this.testbedInfoSource = testbedInfoSource;
    }

    public void setAm(@Nonnull String am) {
        if (am.startsWith("urn:")) {
            this.server = this.authorityFinder.findByAnyUrn(am, AuthorityFinder.Purpose.REQUEST_RSPEC);
        } else if (am.matches("[0-9]*")) {
            this.server = this.testbedInfoSource.getServerById(Integer.valueOf(Integer.parseInt(am)));
        } else {
            Testbed testbed = this.testbedInfoSource.getTestbedById(am);
            Server server = this.server = testbed.getDefaultServerId() == null ? null : this.testbedInfoSource.getServerById(testbed.getDefaultServerId());
        }
        if (this.server == null) {
            throw new RuntimeException("Did not find Server for AM \"" + am + "\" (Only URN, Testbed ID (=string) and Server ID (=int) are supported)");
        }
    }

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public void setNodeNames(@Nonnull List<String> nodeNames) {
        this.nodeNames = nodeNames;
    }

    public void setNodePrefix(@Nullable String prefix) {
        this.nodeNamePrefix = prefix;
    }

    public void setResourceClassIdPrefix(@Nullable String rcIdPrefix) {
        this.resourceClassIdPrefix = rcIdPrefix;
    }

    public void setNodeAnsibleGroup(@Nonnull List<String> nodeAnsibleGroup) {
        this.nodeAnsibleGroup = nodeAnsibleGroup;
    }

    public void setDiskImage(@Nullable String diskImage) {
        this.diskImage = diskImage;
    }

    public void setLink(@Nullable Boolean link) {
        this.link = link;
    }

    public void setLinkSubnet(@Nullable String linkSubnet) {
        this.linkSubnet = linkSubnet;
    }

    public void setLinkStartIpIndex(@Nullable Integer linkStartIpIndex) {
        this.linkStartIpIndex = linkStartIpIndex;
    }

    @Nonnull
    public String generateRequest() {
        ResourceClass chosenResourceClass;
        if (this.server == null) {
            throw new IllegalStateException("generateRequest requires setAM(...) to set the server");
        }
        if (this.resourceClassIdPrefix == null) {
            resourceClassList = this.jFedGuiConfig.findAllPossibleResourceClasses(this.server);
            chosenResourceClass = null;
            for (ResourceClass resourceClass : resourceClassList) {
                if (chosenResourceClass != null && resourceClass.getWeightOrZero() <= chosenResourceClass.getWeightOrZero()) continue;
                chosenResourceClass = resourceClass;
            }
            if (chosenResourceClass == null) {
                throw new RuntimeException("There is no resourceClass for server " + String.valueOf(this.server.getId()) + " that can be used.");
            }
            LOG.debug("Chose ResourceClass " + (String)chosenResourceClass.getId() + " from server ResourceClasses: " + resourceClassList.stream().map(PrimaryIdObject::getId).collect(Collectors.joining(", ")));
        } else {
            resourceClassList = this.jFedGuiConfig.findAllPossibleResourceClasses(this.server);
            chosenResourceClass = null;
            for (ResourceClass resourceClass : resourceClassList) {
                if (chosenResourceClass == null && ((String)resourceClass.getId()).startsWith(this.resourceClassIdPrefix)) {
                    chosenResourceClass = resourceClass;
                }
                if (!((String)resourceClass.getId()).equalsIgnoreCase(this.resourceClassIdPrefix)) continue;
                chosenResourceClass = resourceClass;
            }
            if (chosenResourceClass == null) {
                throw new RuntimeException("No resourceClass \"" + this.resourceClassIdPrefix + "\" found. All resource classes: " + this.jFedGuiConfig.getResourceClasses().stream().map(PrimaryIdObject::getId).collect(Collectors.joining(", ")));
            }
            LOG.debug("Chose ResourceClass " + (String)chosenResourceClass.getId() + " from ResourceClasses with prefix " + this.resourceClassIdPrefix + ": " + resourceClassList.stream().map(PrimaryIdObject::getId).collect(Collectors.joining(", ")));
        }
        if (((String)chosenResourceClass.getId()).equals("other-servers")) {
            throw new RuntimeException("There is no resource for server " + String.valueOf(this.server.getId()) + " (\"" + this.server.getName() + "\"), cannot generate RSpec.");
        }
        Resource chosenResource = null;
        for (Resource aResource : chosenResourceClass.getResources()) {
            if (aResource.getServerId() == null || !aResource.getServerId().equals(this.server.getId())) continue;
            LOG.debug("Found Resource for server: " + String.valueOf(chosenResource));
            chosenResource = aResource;
        }
        if (chosenResource == null) {
            chosenResource = this.jFedGuiConfig.getDefaultResource(chosenResourceClass);
            LOG.debug("Chose default Resource: " + String.valueOf(chosenResource) + "  because none matched server out of " + chosenResourceClass.getResources().stream().map(PrimaryIdObject::getId).map(Object::toString).collect(Collectors.joining(", ")));
            throw new RuntimeException("No Resource found for ResourceClass \"" + this.resourceClassIdPrefix + "\" and server " + String.valueOf(this.server.getId()));
        }
        LOG.debug("Chose Resource: " + String.valueOf(chosenResource));
        if (chosenResource.getRspecElementName() != null && !chosenResource.getRspecElementName().equalsIgnoreCase("node")) {
            throw new RuntimeException("Resource for ResourceClass \"" + this.resourceClassIdPrefix + "\" and server " + String.valueOf(this.server.getId()) + " found, but has unsupported RSpec element name: \"" + chosenResource.getRspecElementName() + "\"");
        }
        RspecFactory factory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.BASIC);
        ModelRspec model = factory.createModelRspec("request");
        RspecLink rspecLink = null;
        int linkIdx = this.linkStartIpIndex == null ? 1 : this.linkStartIpIndex;
        Object linkSubnetPrefix = null;
        if (Objects.equals(this.link, Boolean.TRUE)) {
            rspecLink = factory.createLinkWithClientId(model, "link1", "lan");
            model.addLink(rspecLink);
            if (this.linkSubnet != null) {
                Pattern IP_ADDRESS_PATTERN = Pattern.compile("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})\\.(\\d{1,3})");
                Matcher matcher = IP_ADDRESS_PATTERN.matcher(this.linkSubnet);
                if (!matcher.matches()) {
                    throw new RuntimeException("Invalid subnet in RSpec generator config: \"" + this.linkSubnet + "\"");
                }
                if (!matcher.group(2).equals("0")) {
                    throw new RuntimeException("Invalid subnet in RSpec generator config: \"" + this.linkSubnet + "\" (expected to end in .0 as only subnet mask 255.255.255.0 is supported)");
                }
                linkSubnetPrefix = matcher.group(1) + ".";
            } else {
                linkSubnetPrefix = "192.168.1.";
            }
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            String ansibleGroup = this.nodeAnsibleGroup == null ? null : (i < this.nodeAnsibleGroup.size() ? this.nodeAnsibleGroup.get(i) : (this.nodeAnsibleGroup.isEmpty() ? null : this.nodeAnsibleGroup.get(this.nodeAnsibleGroup.size() - 1)));
            RspecNode node = factory.createNode(model);
            node.setComponentManagerId(this.server.getDefaultComponentManagerUrn());
            node.setExclusive(chosenResource.getDefaultExclusive());
            if (rspecLink != null) {
                RspecInterface iface = factory.createInterface(node, rspecLink, "n" + i + ":if0");
                if (i + linkIdx >= 255) {
                    throw new RuntimeException("Too many nodes generated: ran out of IP addresses in subnet.");
                }
                iface.getIpAddresses().add(new RspecInterface.IpAddress((String)linkSubnetPrefix + (i + linkIdx), "255.255.255.0", "ipv4"));
            }
            if (ansibleGroup != null) {
                node.getAnsibleGroups().add(ansibleGroup);
            }
            if (i < this.nodeNames.size()) {
                node.setClientId(this.nodeNames.get(i));
            } else {
                node.setClientId(this.nodeNamePrefix + i);
            }
            node.setSliverTypeName(chosenResource.getSliverType());
            if (chosenResource.getHardwareType() != null) {
                node.getHardwareTypes().add(new HardwareType(chosenResource.getHardwareType()));
            }
            if (this.diskImage != null) {
                node.setSliverTypeDiskImage(this.diskImage);
            } else if (chosenResource.getDiskImage() != null) {
                node.setSliverTypeDiskImage(chosenResource.getDiskImage());
            }
            if (chosenResource.getRequireFixedNodeAssignment().booleanValue() && chosenResource.getComponentUrn() != null) {
                node.setComponentId(chosenResource.getComponentUrn());
            }
            model.addNode(node);
        }
        return model.toGeni3Rspec();
    }
}

