/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2;

import be.iminds.ilabt.jfed.call_log_output.HtmlLogOutput;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsWriter;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupLogger;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.ui.cli2.ArgumentException;
import be.iminds.ilabt.jfed.ui.cli2.CliExitException;
import be.iminds.ilabt.jfed.ui.cli2.ExperimenterCommandLineParser;
import be.iminds.ilabt.jfed.ui.cli2.SolidLabPerftestUploadOutputStream;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DebugOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ESpecExecuteLogOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.EspecLoggingInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.OutputTarget;
import be.iminds.ilabt.jfed.ui.cli2.instruction.User;
import be.iminds.ilabt.jfed.ui.cli2.logging.ActionLogger;
import be.iminds.ilabt.jfed.ui.cli2.logging.ESpecExecuteOutputLogger;
import be.iminds.ilabt.jfed.ui.commandline.BaseCli;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.rendersnake.HtmlCanvas;
import org.slf4j.LoggerFactory;

public class Context {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(Context.class);
    @Nonnull
    public final String[] args;
    @Nonnull
    private final Instruction instruction;
    @Nonnull
    private final ExperimenterCommandLineParser.GenericCliArguments genericCliArguments;
    @Nonnull
    private final PrintStream out;
    @Nonnull
    private final PrintStream err;
    @Nonnull
    private final InputStream in;
    @Nonnull
    private final BaseCli baseCli;
    private final List<Closeable> toClose = new ArrayList<Closeable>();
    private Injector injector;
    private String sliceUrn;
    private String sliceName;
    private String projectName;
    @Nonnull
    private final ActionLogger actionLogger;
    @Nonnull
    private final ESpecExecuteOutputLogger eSpecExecuteOutputLogger;
    private ExitReason exitReason = null;

    public Context(@Nonnull String[] args, @Nonnull ExperimenterCommandLineParser.GenericCliArguments genericCliArguments, @Nonnull Instruction instruction, @Nonnull PrintStream out, @Nonnull PrintStream err, @Nonnull InputStream in, @Nonnull BaseCli baseCli) {
        this.args = args;
        this.instruction = instruction;
        this.genericCliArguments = genericCliArguments;
        this.out = out;
        this.err = err;
        this.in = in;
        this.baseCli = baseCli;
        this.actionLogger = new ActionLogger();
        this.eSpecExecuteOutputLogger = new ESpecExecuteOutputLogger();
    }

    @Nonnull
    public Instruction getInstruction() {
        return this.instruction;
    }

    @Nonnull
    public ExperimenterCommandLineParser.GenericCliArguments getGenericCliArguments() {
        return this.genericCliArguments;
    }

    @Nonnull
    public ActionLogger getActionLogger() {
        return this.actionLogger;
    }

    @Nonnull
    public ESpecExecuteOutputLogger geteSpecExecuteOutputLogger() {
        return this.eSpecExecuteOutputLogger;
    }

    @Nonnull
    public ExperimentSetupLogger getExperimentSetupLogger() {
        final org.slf4j.Logger debugLogger = LOG;
        return new ExperimentSetupLogger(){

            public void fatal(@Nullable String val, @Nullable Throwable t) {
                debugLogger.error(val, t);
                Context.this.exitWithCode(ExitReason.ERROR, val);
            }

            public void logExtraText(@Nonnull String name, @Nonnull Object value, boolean large) {
                debugLogger.info(name + ": " + String.valueOf(value));
            }

            public void logExtraXml(@Nonnull String name, @Nonnull Object value, boolean large) {
                debugLogger.info(name + ": " + String.valueOf(value));
            }

            public void logExtraHtml(@Nonnull String name, @Nonnull Object value, boolean large) {
                debugLogger.info(name + ": " + String.valueOf(value));
            }

            public void logExtraJson(@Nonnull String name, @Nonnull Object value, boolean large) {
                debugLogger.info(name + ": " + String.valueOf(value));
            }

            public void debug(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                debugLogger.debug(val, e);
            }

            public void info(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                debugLogger.info(val, e);
            }

            public void warn(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                debugLogger.warn(val, e);
            }

            public void error(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                debugLogger.error(val, e);
            }
        };
    }

    public void exitWithCode(ExitReason code, String message) {
        this.exitReason = code;
        this.actionLogger.errorPrintln(message);
    }

    public void throwIfExited() throws CliExitException {
        if (this.exitReason != null) {
            throw new CliExitException(this.exitReason);
        }
    }

    public void closeOutputs() {
        for (Closeable close : this.toClose) {
            try {
                close.close();
            }
            catch (IOException e) {
                LOG.warn("Error while closing", (Throwable)e);
            }
        }
        SolidLabPerftestUploadOutputStream.cleanup();
    }

    public void setupESpecExecuteLogOutput() throws CliExitException {
        if (!(this.instruction instanceof EspecLoggingInstruction)) {
            return;
        }
        EspecLoggingInstruction instruction = (EspecLoggingInstruction)((Object)this.instruction);
        if (instruction.getESpecExecuteLogOutputs().isEmpty()) {
            this.eSpecExecuteOutputLogger.addESpecExecuteOutputListenerFactory(new ESpecExecuteOutputLogger.LoggingESpecExecuteOutputListenerFactory());
            return;
        }
        block7: for (final ESpecExecuteLogOutput eSpecExecuteLogOutput : instruction.getESpecExecuteLogOutputs()) {
            switch (eSpecExecuteLogOutput.getTarget()) {
                case STDERR: {
                    this.eSpecExecuteOutputLogger.addESpecExecuteOutputListenerFactory(new ESpecExecuteOutputLogger.PrintStreamESpecExecuteOutputListenerFactory(this.err));
                    continue block7;
                }
                case STDOUT: {
                    this.eSpecExecuteOutputLogger.addESpecExecuteOutputListenerFactory(new ESpecExecuteOutputLogger.PrintStreamESpecExecuteOutputListenerFactory(this.out));
                    continue block7;
                }
                case DEBUG: {
                    this.eSpecExecuteOutputLogger.addESpecExecuteOutputListenerFactory(new ESpecExecuteOutputLogger.LoggingESpecExecuteOutputListenerFactory());
                    continue block7;
                }
                case FILE: {
                    if (eSpecExecuteLogOutput.getLocation() == null || !new File(eSpecExecuteLogOutput.getLocation()).isDirectory()) {
                        throw new CliExitException(ExitReason.BAD_ARGS, "Action output type FILE requires a directory name");
                    }
                    this.eSpecExecuteOutputLogger.addESpecExecuteOutputListenerFactory(new ESpecExecuteOutputLogger.FileBasedESpecExecuteOutputListenerFactory(){

                        @Override
                        public LimitedLiveLog.ChangeListener createWithFile(@NotNull String filename) {
                            File f = new File(eSpecExecuteLogOutput.getLocation(), filename);
                            LOG.debug("Will log ESpec Execute to file " + f.getPath());
                            try {
                                PrintStream fout = new PrintStream(new FileOutputStream(f));
                                return new ESpecExecuteOutputLogger.LimitedLiveLogPrintStreamChangeListener(fout, "", true);
                            }
                            catch (FileNotFoundException e) {
                                LOG.error("Error logging ESpec Execute output to " + String.valueOf(f), (Throwable)e);
                                return null;
                            }
                        }
                    });
                    continue block7;
                }
                case SOLIDLAB_UPLOAD: {
                    if (eSpecExecuteLogOutput.getLocation() == null || !eSpecExecuteLogOutput.getLocation().startsWith("http")) {
                        throw new CliExitException(ExitReason.BAD_ARGS, "Action output type SOLIDLAB_UPLOAD requires a URL");
                    }
                    this.eSpecExecuteOutputLogger.addESpecExecuteOutputListenerFactory(new ESpecExecuteOutputLogger.FileBasedESpecExecuteOutputListenerFactory(){

                        @Override
                        public LimitedLiveLog.ChangeListener createWithFile(@NotNull String filename) {
                            LOG.info("Will log Espec Execute for " + filename + " to " + eSpecExecuteLogOutput.getLocation());
                            SolidLabPerftestUploadOutputStream outputStream = new SolidLabPerftestUploadOutputStream(eSpecExecuteLogOutput.getLocation(), "LOG", filename, "The ESpec Execute step output for " + filename, "text/plain");
                            Context.this.toClose.add(outputStream);
                            PrintStream fout = new PrintStream(outputStream);
                            return new ESpecExecuteOutputLogger.LimitedLiveLogPrintStreamChangeListener(fout, "", true);
                        }
                    });
                    continue block7;
                }
            }
            throw new IllegalStateException("Should not be called for " + String.valueOf((Object)eSpecExecuteLogOutput.getTarget()));
        }
    }

    public void setupActionOutput() throws CliExitException {
        if (this.instruction.getActionOutputs().isEmpty()) {
            this.actionLogger.addESpecLogListener(new ActionLogger.StreamActionLogListener(this.out, this.err, true, false, false));
            return;
        }
        block10: for (ActionOutput actionOutput : this.instruction.getActionOutputs()) {
            boolean doTextOut = actionOutput.getFormat() == ActionOutput.Format.TXT;
            boolean doJsonOut = actionOutput.getFormat() == ActionOutput.Format.JSON;
            boolean doYamlOut = actionOutput.getFormat() == ActionOutput.Format.YAML;
            switch (actionOutput.getTarget()) {
                case STDERR: {
                    this.actionLogger.addESpecLogListener(new ActionLogger.StreamActionLogListener(this.err, this.err, doTextOut, doJsonOut, doYamlOut));
                    continue block10;
                }
                case STDOUT: {
                    this.actionLogger.addESpecLogListener(new ActionLogger.StreamActionLogListener(this.out, this.err, doTextOut, doJsonOut, doYamlOut));
                    continue block10;
                }
                case FILE: {
                    if (actionOutput.getLocation() == null) {
                        throw new CliExitException(ExitReason.BAD_ARGS, "Action output type FILE requires a filename");
                    }
                    try {
                        PrintStream fout = new PrintStream(new FileOutputStream(actionOutput.getLocation()));
                        this.toClose.add(fout);
                        this.actionLogger.addESpecLogListener(new ActionLogger.StreamActionLogListener(fout, fout, doTextOut, doJsonOut, doYamlOut));
                        continue block10;
                    }
                    catch (FileNotFoundException e) {
                        throw new CliExitException(ExitReason.BAD_ARGS, "Could not open action output file \"" + actionOutput.getLocation() + "\"");
                    }
                }
                case SOLIDLAB_UPLOAD: {
                    if (actionOutput.getLocation() == null) {
                        throw new CliExitException(ExitReason.BAD_ARGS, "Action output type SOLIDLAB_UPLOAD requires a URL");
                    }
                    try {
                        SolidLabPerftestUploadOutputStream outputStream = new SolidLabPerftestUploadOutputStream(actionOutput.getLocation(), "LOG", "jFed CLI2 action " + actionOutput.getFormat().name() + " output", "The action output log of jFed CLI2", actionOutput.getFormat().getContentType());
                        PrintStream fout = new PrintStream(outputStream);
                        this.toClose.add(fout);
                        this.actionLogger.addESpecLogListener(new ActionLogger.StreamActionLogListener(fout, fout, doTextOut, doJsonOut, doYamlOut));
                        continue block10;
                    }
                    catch (Exception e) {
                        throw new CliExitException(ExitReason.BAD_ARGS, "Could not init SOLIDLAB_UPLOAD at \"" + actionOutput.getLocation() + "\"");
                    }
                }
            }
            throw new IllegalStateException("Should not be called for " + String.valueOf((Object)actionOutput.getTarget()));
        }
    }

    public static void setupDebugOutputToStdout() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        assert (loggerContext != null);
        loggerContext.reset();
        Logger rootLogger = loggerContext.getLogger("ROOT");
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((ch.qos.logback.core.Context)loggerContext);
        encoder.setPattern("%-4relative %-5level %logger{30} - %msg%n");
        encoder.start();
        OutputStreamAppender osAppender = new OutputStreamAppender();
        osAppender.setContext((ch.qos.logback.core.Context)loggerContext);
        osAppender.setEncoder((Encoder)encoder);
        osAppender.setName("stdout appender");
        osAppender.setOutputStream((OutputStream)System.out);
        OutputStreamAppender appender = osAppender;
        assert (appender.getEncoder() != null);
        assert (appender.getContext() != null);
        ThresholdFilter thresholdFilter = new ThresholdFilter();
        thresholdFilter.setContext((ch.qos.logback.core.Context)loggerContext);
        thresholdFilter.setLevel("DEBUG");
        thresholdFilter.start();
        appender.addFilter((Filter)thresholdFilter);
        appender.start();
        rootLogger.addAppender((Appender)appender);
        loggerContext.getLogger("org.apache.http").setLevel(Level.WARN);
        loggerContext.getLogger("be.iminds.ilabt.jfed.highlevel.controller").setLevel(Level.INFO);
        loggerContext.getLogger("be.iminds.ilabt.jfed.lowlevel.connection").setLevel(Level.ERROR);
        rootLogger.setLevel(Level.DEBUG);
        StatusPrinter.printInCaseOfErrorsOrWarnings((ch.qos.logback.core.Context)loggerContext);
    }

    @Nonnull
    public List<SolidLabPerftestUploadOutputStream> setupDebugOutput(@Nonnull List<SolidLabPerftestUploadOutputStream> existingSolidLabPerftestUploadOutputStreams) {
        if (this.instruction.getDebugOutputs().isEmpty()) {
            LOG.info("setupDebugOutput() when no debug output is configured. \nThis will fall back to NOT re-configuring logback-classic. \nIn case of calling using CLI directly, this defaults to the logback.xml file, which does no logging. \nIn case the CLI code was called from another java program, the logging of that program will be used.");
            return Collections.emptyList();
        }
        ArrayList<SolidLabPerftestUploadOutputStream> outSolidLabPerftestUploadOutputStreams = new ArrayList<SolidLabPerftestUploadOutputStream>();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        assert (loggerContext != null);
        loggerContext.reset();
        assert (Objects.equals("ROOT", "ROOT"));
        Logger rootLogger = loggerContext.getLogger("ROOT");
        int i = 0;
        DebugOutput.Level minLevel = DebugOutput.Level.ERROR;
        for (DebugOutput debugOutput : this.instruction.getDebugOutputs()) {
            outSolidLabPerftestUploadOutputStreams.add(null);
            if (debugOutput.getLevel().getRank() < minLevel.getRank()) {
                minLevel = debugOutput.getLevel();
            }
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((ch.qos.logback.core.Context)loggerContext);
            switch (debugOutput.getFormat()) {
                case TXT: {
                    encoder.setPattern("%-4relative %-5level %logger{30} - %msg%n");
                    break;
                }
                case TXT_FULL: {
                    encoder.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{40} - %msg%n");
                }
            }
            encoder.start();
            FileAppender appender = switch (debugOutput.getTarget()) {
                case OutputTarget.STDERR, OutputTarget.STDOUT -> {
                    OutputStreamAppender osAppender = new OutputStreamAppender();
                    osAppender.setContext((ch.qos.logback.core.Context)loggerContext);
                    osAppender.setEncoder((Encoder)encoder);
                    switch (debugOutput.getTarget()) {
                        case STDERR: {
                            osAppender.setName("stderr " + String.valueOf((Object)debugOutput.getFormat()) + " appender");
                            osAppender.setOutputStream((OutputStream)this.err);
                            break;
                        }
                        case STDOUT: {
                            osAppender.setName("stdout " + String.valueOf((Object)debugOutput.getFormat()) + " appender");
                            osAppender.setOutputStream((OutputStream)this.out);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Should not be called for " + String.valueOf((Object)debugOutput.getTarget()));
                        }
                    }
                    yield osAppender;
                }
                case OutputTarget.FILE -> {
                    FileAppender fileAppender = new FileAppender();
                    fileAppender.setContext((ch.qos.logback.core.Context)loggerContext);
                    fileAppender.setEncoder((Encoder)encoder);
                    if (debugOutput.getLocation() == null) {
                        throw new IllegalStateException("if target debug output is FILE, you must specify a filename");
                    }
                    fileAppender.setFile(debugOutput.getLocation());
                    yield fileAppender;
                }
                case OutputTarget.SOLIDLAB_UPLOAD -> {
                    if (debugOutput.getLocation() == null) {
                        throw new IllegalStateException("if target debug output is SOLIDLAB_UPLOAD, you must specify an URL (as filename)");
                    }
                    SolidLabPerftestUploadOutputStream existingSolidLabPerftestUploadOutputStream = i < existingSolidLabPerftestUploadOutputStreams.size() ? existingSolidLabPerftestUploadOutputStreams.get(i) : null;
                    SolidLabPerftestUploadOutputStream solidLabOutputStream = existingSolidLabPerftestUploadOutputStream != null ? existingSolidLabPerftestUploadOutputStream : new SolidLabPerftestUploadOutputStream(debugOutput.getLocation(), "LOG", "jFed " + debugOutput.getLevel().name() + " logs", "Debug output of jFed CLI2 logLevel " + debugOutput.getLevel().name(), "text/plain");
                    this.toClose.add(solidLabOutputStream);
                    outSolidLabPerftestUploadOutputStreams.set(i, solidLabOutputStream);
                    OutputStreamAppender osAppender = new OutputStreamAppender();
                    osAppender.setContext((ch.qos.logback.core.Context)loggerContext);
                    osAppender.setEncoder((Encoder)encoder);
                    osAppender.setName("SolidLab Upload " + debugOutput.getLocation() + " " + String.valueOf((Object)debugOutput.getFormat()) + " appender");
                    osAppender.setOutputStream((OutputStream)solidLabOutputStream);
                    yield osAppender;
                }
                default -> throw new IllegalStateException("Unsupported OutputTarget " + String.valueOf((Object)debugOutput.getTarget()));
            };
            ++i;
            assert (appender.getEncoder() != null);
            assert (appender.getContext() != null);
            ThresholdFilter thresholdFilter = new ThresholdFilter();
            thresholdFilter.setContext((ch.qos.logback.core.Context)loggerContext);
            thresholdFilter.setLevel(debugOutput.getLevel().getLogbackLevel().toString());
            thresholdFilter.start();
            appender.addFilter((Filter)thresholdFilter);
            appender.start();
            rootLogger.addAppender((Appender)appender);
        }
        loggerContext.getLogger("org.apache.http").setLevel(Level.WARN);
        loggerContext.getLogger("be.iminds.ilabt.jfed.highlevel.controller").setLevel(Level.INFO);
        loggerContext.getLogger("be.iminds.ilabt.jfed.lowlevel.connection").setLevel(Level.ERROR);
        loggerContext.getLogger("net.schmizz").setLevel(Level.ERROR);
        rootLogger.setLevel(minLevel.getLogbackLevel());
        StatusPrinter.printInCaseOfErrorsOrWarnings((ch.qos.logback.core.Context)loggerContext);
        return outSolidLabPerftestUploadOutputStreams;
    }

    public void setupInjector() throws CliExitException {
        this.baseCli.initAuthoritiesModule(null);
        try {
            String password = switch (this.instruction.getUser().getPasswordMethod()) {
                case User.PasswordMethod.FILE -> {
                    if (!$assertionsDisabled && this.instruction.getUser().getPassword() == null) {
                        throw new AssertionError();
                    }
                    yield IOUtils.fileToString((String)this.instruction.getUser().getPassword()).replaceAll("[\r\n]", "");
                }
                case User.PasswordMethod.INTERACTIVE -> {
                    boolean isPemFileEncrypted = this.instruction.getUser().getPem().stream().anyMatch(pemFile -> {
                        try {
                            String pem = IOUtils.fileToString((String)pemFile);
                            return KeyUtil.isPemPrivateKeyEncrypted((String)pem);
                        }
                        catch (Exception e) {
                            return true;
                        }
                    });
                    if (isPemFileEncrypted) {
                        char[] pass = IOUtils.askCommandLinePassword((String)"Enter login file password");
                        yield new String(pass);
                    }
                    yield null;
                }
                default -> this.instruction.getUser().getPassword();
            };
            this.baseCli.initUserModule(this.instruction.getUser().getPem(), this.genericCliArguments.getContextFilename(), password, password == null && this.instruction.getUser().getPasswordMethod() == User.PasswordMethod.INTERACTIVE, this.in);
        }
        catch (IOException e) {
            LOG.debug("Error initialising user module", (Throwable)e);
            throw new CliExitException(ExitReason.ERROR, "Error initialising user module", e);
        }
        catch (BaseCli.CliArgumentException e) {
            LOG.debug("CliArgumentException initialising user module", (Throwable)e);
            throw new ArgumentException(e.getMessage(), (Throwable)e);
        }
        this.injector = this.baseCli.getInjector(this.actionLogger::errorPrintln, new AbstractModule[0]);
        GeniUser user = (GeniUser)this.injector.getInstance(GeniUser.class);
        if (!BaseCli.checkUser(user, this.actionLogger::errorPrintln)) {
            this.exitWithCode(ExitReason.BAD_ARGS, "Problem with user certificate.");
            this.throwIfExited();
        }
    }

    public void setupProxy() {
        assert (this.instruction.getProxy() != null);
        if (this.instruction.getProxy().getUseForCalls() == null && this.instruction.getProxy().getUseForSsh() == null) {
            return;
        }
        ProxyPreferencesManager proxyPreferencesManager = (ProxyPreferencesManager)this.injector.getInstance(ProxyPreferencesManager.class);
        JFedPreferences jFedPreferences = (JFedPreferences)this.injector.getInstance(JFedPreferences.class);
        if (this.instruction.getProxy().getUseForCalls() != null) {
            if (this.instruction.getProxy().getUseForCalls().booleanValue()) {
                jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "ALWAYS");
            } else {
                jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "NEVER");
            }
            proxyPreferencesManager.updateProxySettings();
        }
        if (this.instruction.getProxy().getUseForSsh() != null) {
            if (this.instruction.getProxy().getUseForSsh().booleanValue()) {
                jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "ALWAYS");
            } else {
                jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "NEVER");
            }
        }
    }

    public Injector getInjector() {
        return this.injector;
    }

    @Nonnull
    public GeniUser getUser() {
        GeniUser user = (GeniUser)this.injector.getInstance(GeniUser.class);
        if (user == null) {
            this.exitWithCode(ExitReason.ERROR, "Problem with GeniUser.");
            throw new RuntimeException("GeniUser should never be null at this point");
        }
        return user;
    }

    @Nonnull
    public GeniUserProvider getUserProvider() {
        GeniUserProvider res = (GeniUserProvider)this.injector.getInstance(GeniUserProvider.class);
        if (res == null) {
            this.exitWithCode(ExitReason.ERROR, "Problem with GeniUserProvider.");
            throw new RuntimeException("GeniUserProvider should never be null at this point");
        }
        return res;
    }

    public void setupCallOutput() throws CliExitException {
        be.iminds.ilabt.jfed.log.Logger logger = (be.iminds.ilabt.jfed.log.Logger)this.injector.getInstance(be.iminds.ilabt.jfed.log.Logger.class);
        for (CallOutput callOutput : this.instruction.getCallOutputs()) {
            CallOutputHandler callOutputHandler = switch (callOutput.getFormat()) {
                case CallOutput.Format.XML -> new CallOutputXmlHandler(callOutput);
                case CallOutput.Format.TEXT -> new CallOutputPlainTextHandler(callOutput);
                case CallOutput.Format.HTML -> new CallOutputHtmlHandler(callOutput);
                default -> throw new RuntimeException("call log output \"" + String.valueOf((Object)callOutput.getFormat()) + "\" is not supported");
            };
            this.toClose.add(callOutputHandler);
            logger.addResultListener((ResultListener)callOutputHandler);
        }
    }

    @Nonnull
    public BaseCli getBaseCli() {
        return this.baseCli;
    }

    public String getSliceUrn() {
        return this.sliceUrn;
    }

    public void setSliceUrn(String sliceUrn) {
        this.sliceUrn = sliceUrn;
    }

    public String getSliceName() {
        return this.sliceName;
    }

    public void setSliceName(String sliceName) {
        this.sliceName = sliceName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public static enum ExitReason {
        SUCCESS(0),
        ERROR(1),
        NOT_ENOUGH_RESOURCES(2),
        BAD_ARGS(3),
        SERVER_ERROR(4),
        INTERRUPTED(10);

        private final int exitVal;

        private ExitReason(int exitVal) {
            this.exitVal = exitVal;
        }

        public int getExitVal() {
            return this.exitVal;
        }
    }

    private class CallOutputXmlHandler
    extends CallOutputHandler {
        protected final XMLEventWriter xtw;
        protected final XMLEventFactory eventFactory;

        private CallOutputXmlHandler(CallOutput callOutput) throws CliExitException {
            super(callOutput);
            try {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                this.xtw = new IndentingXMLEventWriter(xof.createXMLEventWriter(this.outputStream, "UTF-8"));
                this.eventFactory = XMLEventFactory.newInstance();
                this.xtw.add(this.eventFactory.createStartDocument());
                this.xtw.add(this.eventFactory.createStartElement(new QName("calls"), null, null));
            }
            catch (XMLStreamException e) {
                LOG.error("Exception generating XML for call output", (Throwable)e);
                this.close();
                throw new ArgumentException("Failed to initialise call output " + String.valueOf(callOutput), (Throwable)e);
            }
        }

        @Override
        public void flush() {
            try {
                this.xtw.flush();
                this.outputStream.flush();
            }
            catch (Exception e) {
                LOG.warn("Unexpected error flusing", (Throwable)e);
            }
        }

        @Override
        public void close() {
            if (this.xtw != null && this.eventFactory != null) {
                try {
                    this.xtw.add(this.eventFactory.createEndElement(new QName("calls"), null));
                    this.xtw.add(this.eventFactory.createEndDocument());
                    this.xtw.flush();
                }
                catch (XMLStreamException e) {
                    LOG.error("Exception while closing call output", (Throwable)e);
                }
            }
            if (this.outputStream != Context.this.out && this.outputStream != Context.this.err) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    LOG.error("Exception while closing call output file", (Throwable)e);
                }
            }
        }

        public void onResult(ApiCallDetails result) {
            SerializableApiCallDetails serializableApiCallDetails = new SerializableApiCallDetailsFactory().createFromApiCallDetails(result);
            try {
                if (result.getServerUrnString() != null) {
                    this.xtw.add(this.eventFactory.createComment(result.getGeniMethodName() + " on " + result.getServerUrnString()));
                }
                SerializableApiCallDetailsWriter.writeApiCallDetails((SerializableApiCallDetails)serializableApiCallDetails, (XMLEventWriter)this.xtw, (XMLEventFactory)this.eventFactory);
                this.xtw.add(this.eventFactory.createCharacters(System.getProperty("line.separator") + System.getProperty("line.separator")));
                this.xtw.flush();
                this.outputStream.flush();
            }
            catch (IOException e) {
                LOG.error("Error flushing", (Throwable)e);
            }
            catch (XMLStreamException e) {
                LOG.error("Error writing call to stream", (Throwable)e);
                this.close();
            }
        }
    }

    private class CallOutputPlainTextHandler
    extends CallOutputHandler {
        @Nonnull
        private final PrintStream printCallsOut;
        private static final String printCallsPrefix = "CALL: ";

        public CallOutputPlainTextHandler(CallOutput callOutput) throws CliExitException {
            super(callOutput);
            this.printCallsOut = new PrintStream(this.outputStream);
        }

        @Override
        public void flush() {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                LOG.warn("Error flushing output stream", (Throwable)e);
            }
        }

        @Override
        public void close() {
            if (this.outputStream != Context.this.out && this.outputStream != Context.this.err) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    LOG.error("Exception while closing call output file", (Throwable)e);
                }
            }
        }

        public void onResult(ApiCallDetails result) {
            this.printCallsOut.println();
            this.printCallsOut.println(TextUtil.indent((int)(printCallsPrefix.length() + 1), (String)(printCallsPrefix + result.getGeniMethodName() + " on " + result.getServerUrnString() + " at " + result.getConnectionConfig().getServerUrlString())));
            String req = result.getXmlRpcRequestJsonString();
            String res = result.getXmlRpcResponseJsonString();
            if (req != null) {
                this.printCallsOut.println("CALL: Request: " + req);
            }
            if (res != null) {
                this.printCallsOut.println("CALL: Reply: " + res);
            }
            this.printCallsOut.println();
            this.printCallsOut.println();
            this.printCallsOut.flush();
        }
    }

    private class CallOutputHtmlHandler
    extends CallOutputHandler {
        private final PrintWriter pwOut;
        private final HtmlCanvas html;
        private final SerializableApiCallDetailsFactory sacdFact;
        private int callIndex;

        private CallOutputHtmlHandler(CallOutput callOutput) throws CliExitException {
            super(callOutput);
            this.callIndex = 0;
            this.sacdFact = new SerializableApiCallDetailsFactory();
            this.pwOut = new PrintWriter(this.outputStream);
            this.html = new HtmlCanvas((Writer)this.pwOut);
            try {
                HtmlLogOutput.writeStart((HtmlCanvas)this.html, (boolean)true, (String)"CLI calls");
            }
            catch (IOException e) {
                throw new CliExitException(ExitReason.ERROR, "failed to write call log HTML start", e);
            }
        }

        @Override
        public void flush() {
            this.pwOut.flush();
        }

        public void onResult(ApiCallDetails result) {
            try {
                HtmlLogOutput.writeCall((HtmlCanvas)this.html, (int)0, (int)this.callIndex++, (SerializableApiCallDetails)this.sacdFact.createFromApiCallDetails(result));
            }
            catch (IOException e) {
                throw new RuntimeException("failed to write call to HTML", e);
            }
        }

        @Override
        public void close() throws IOException {
            HtmlLogOutput.writeEnd((HtmlCanvas)this.html);
            this.pwOut.close();
        }
    }

    private abstract class CallOutputHandler
    implements ResultListener,
    Closeable {
        @Nonnull
        protected final OutputStream outputStream;

        public CallOutputHandler(CallOutput callOutput) throws CliExitException {
            switch (callOutput.getTarget()) {
                case FILE: {
                    if (callOutput.getLocation() == null) {
                        throw new IllegalArgumentException("callOutput.getFilename() may not be null when callOutput.getTarget()=" + String.valueOf((Object)callOutput.getTarget()));
                    }
                    try {
                        this.outputStream = new FileOutputStream(callOutput.getLocation());
                        break;
                    }
                    catch (FileNotFoundException e) {
                        LOG.error("Could not open call output file", (Throwable)e);
                        throw new ArgumentException("Could not open call output file \"" + callOutput.getLocation() + "\" for writing: " + e.getMessage());
                    }
                }
                case SOLIDLAB_UPLOAD: {
                    if (callOutput.getLocation() == null) {
                        throw new IllegalArgumentException("callOutput.getLocation() may not be null when callOutput.getTarget()=" + String.valueOf((Object)callOutput.getTarget()));
                    }
                    this.outputStream = new SolidLabPerftestUploadOutputStream(callOutput.getLocation(), "LOG", "jFed call logs", "Log of API calls by jFed CLI", "text/html");
                    Context.this.toClose.add(this.outputStream);
                    break;
                }
                case STDOUT: {
                    this.outputStream = Context.this.out;
                    break;
                }
                case STDERR: {
                    this.outputStream = Context.this.err;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("callOutput.target=" + String.valueOf((Object)callOutput.getTarget()) + " is not supported");
                }
            }
        }

        public abstract void flush();
    }
}

