/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2;

import be.iminds.ilabt.jfed.ui.cli2.CliExitException;
import be.iminds.ilabt.jfed.ui.cli2.Context;
import be.iminds.ilabt.jfed.ui.cli2.ExperimenterCommandLineParser;
import be.iminds.ilabt.jfed.ui.cli2.InstructionExecutor;
import be.iminds.ilabt.jfed.ui.cli2.SolidLabPerftestUploadOutputStream;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.InstructionTypeIdResolver;
import be.iminds.ilabt.jfed.ui.cli2.wizard.ActionWizard;
import be.iminds.ilabt.jfed.ui.commandline.BaseCli;
import be.iminds.ilabt.jfed.util.common.DefaultOmittingSerializationUtil;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.embed.swing.JFXPanel;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterCli {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimenterCli.class);
    private static final String KEY_EXPIRATION_TIME = "expiration-time";
    private static final String KEY_REQUEST_RSPEC = "request-rspec";

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int retval = ExperimenterCli.main_helper(args, System.out, System.err, System.in, new BaseCli(System.err), true);
        System.exit(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main_helper(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli, boolean temporarilyRedirectSystemStreams) throws IOException, ClassNotFoundException {
        PrintStream orig_out = System.out;
        PrintStream orig_err = System.err;
        InputStream orig_in = System.in;
        if (temporarilyRedirectSystemStreams) {
            System.setOut(out);
            System.setErr(err);
            System.setIn(in);
        }
        int retval = -1;
        try {
            retval = ExperimenterCli.main_internal(args, out, err, in, baseCli);
        }
        catch (CliExitException e) {
            System.err.println((Object)e.getExitReason());
            int n = e.getExitCode();
            return n;
        }
        finally {
            if (temporarilyRedirectSystemStreams) {
                System.setOut(orig_out);
                System.setErr(orig_err);
                System.setIn(orig_in);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main_internal(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli) throws CliExitException {
        List<SolidLabPerftestUploadOutputStream> existingSolidLabPerftestUploadOutputStreams;
        ExperimenterCommandLineParser.ProcessInstructionResult processInstructionResult;
        ExperimenterCommandLineParser.GenericCliArguments genCliArgs;
        block60: {
            new JFXPanel();
            ExperimenterCommandLineParser experimenterCommandLineParser = new ExperimenterCommandLineParser(args, out, err, in, baseCli);
            genCliArgs = experimenterCommandLineParser.getGenericCliArguments();
            if (args.length == 0) {
                err.println("Invalid syntax: No argument.\nTry:\n   --help     ->  generic help\n   --wizard   ->  generate an instruction  (recommended to get started)");
            }
            if (genCliArgs.isWizard()) {
                ActionWizard wizard = new ActionWizard(out, err, in);
                try {
                    PrintStream outStream;
                    String filename;
                    ObjectMapper mapper;
                    Map generatedInstructionMap;
                    Instruction instr = wizard.generate();
                    try {
                        ObjectMapper om = new ObjectMapper();
                        generatedInstructionMap = (Map)om.convertValue((Object)instr, Map.class);
                        out.println("\n*** Action file generation DONE ***\n");
                        boolean minimizeInstruction = wizard.askBool("Minimize the generated yml by skipping defaults", true);
                        if (minimizeInstruction) {
                            Instruction defaultInstruction = ExperimenterCli.getDefaultInstruction(instr.getAction());
                            Map defaultInstructionMap = (Map)om.convertValue((Object)defaultInstruction, Map.class);
                            defaultInstructionMap.remove("action");
                            generatedInstructionMap = DefaultOmittingSerializationUtil.omitDefault((Map)generatedInstructionMap, (Map)defaultInstructionMap);
                        }
                        YAMLFactory yf = new YAMLFactory();
                        yf.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
                        mapper = new ObjectMapper((JsonFactory)yf);
                    }
                    catch (Exception e) {
                        throw new CliExitException(Context.ExitReason.ERROR, "Error while converting generated config to yml: " + e.getMessage(), e);
                    }
                    out.println("What to do with the generated action file?");
                    boolean saveToFile = wizard.askBoolChoice("Save to a file", "Print", true);
                    if (saveToFile) {
                        filename = wizard.askString("Filename to save to", "action.yml", false);
                        outStream = new PrintStream(new FileOutputStream(filename));
                    } else {
                        filename = "<my_generated_action.yml>";
                        outStream = out;
                    }
                    try (SequenceWriter sw = mapper.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS}).writeValues((OutputStream)outStream);){
                        if (!saveToFile) {
                            out.println("\nGenerated Action yml:");
                        }
                        sw.write((Object)generatedInstructionMap);
                        if (!saveToFile) {
                            out.println("\n\nWrite it to a file and execute it with:\n");
                        } else {
                            out.println("\n\nYou can run the saved action with:\n");
                        }
                        out.println("    java -jar experimenter-cli2.jar -a " + filename);
                    }
                    catch (IOException e) {
                        throw new CliExitException(Context.ExitReason.ERROR, "Error while converting generated config to yml: " + e.getMessage(), e);
                    }
                    return 0;
                }
                catch (IOException e) {
                    err.println("Exception while running wizard:");
                    e.printStackTrace();
                    return -1;
                }
            }
            if (genCliArgs.isHelp() && !genCliArgs.hasAction()) {
                ExperimenterCommandLineParser.generalHelp(err);
                return 0;
            }
            if (genCliArgs.isVersion()) {
                ExperimenterCommandLineParser.showVersion(out);
                return 0;
            }
            if (genCliArgs.isDebug()) {
                Context.setupDebugOutputToStdout();
            }
            processInstructionResult = new ExperimenterCommandLineParser.ProcessInstructionResult();
            try {
                experimenterCommandLineParser.processInstruction(processInstructionResult);
            }
            catch (Exception e) {
                if (genCliArgs.isHelp() && processInstructionResult.action != null) break block60;
                err.println(e.getMessage());
                throw e;
            }
        }
        Instruction.Action action = processInstructionResult.action;
        Instruction instruction = processInstructionResult.instruction;
        Options options = processInstructionResult.options;
        assert (action != null);
        if (genCliArgs.isHelp()) {
            ObjectMapper mapper;
            Map demoInstructionMap;
            if (options != null) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.setWidth(IOUtils.getTermWidth((int)80));
                formatter.printHelp("experimenter-cli --action " + action.getNiceName(), options);
            } else {
                err.println("Error getting option info for \"experimenter-cli --action " + action.getNiceName() + "\"");
            }
            out.flush();
            err.flush();
            try {
                Class<? extends Instruction> instructionClass = InstructionTypeIdResolver.classFromAction(action);
                assert (instructionClass != null);
                ObjectMapper om = new ObjectMapper();
                Instruction demoInstruction = ExperimenterCli.getDemoInstruction(action);
                demoInstructionMap = (Map)om.convertValue((Object)demoInstruction, Map.class);
                YAMLFactory yf = new YAMLFactory();
                yf.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
                mapper = new ObjectMapper((JsonFactory)yf);
            }
            catch (CliExitException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CliExitException(Context.ExitReason.ERROR, "Error while converting default config to yml: " + e.getMessage(), e);
            }
            try (SequenceWriter sw = mapper.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS}).writeValues((OutputStream)out);){
                out.println("\nExample yml for \"" + action.getNiceName() + "\":");
                sw.write((Object)demoInstructionMap);
            }
            catch (IOException e) {
                throw new CliExitException(Context.ExitReason.ERROR, "Error while converting default config to yml: " + e.getMessage(), e);
            }
            return 0;
        }
        if (genCliArgs.isPrintAction()) {
            ObjectMapper om = new ObjectMapper();
            Instruction defaultInstruction = ExperimenterCli.getDefaultInstruction(action);
            Map defaultInstructionMap = (Map)om.convertValue((Object)defaultInstruction, Map.class);
            defaultInstructionMap.remove("action");
            Map prunedInstructions = DefaultOmittingSerializationUtil.omitDefault((Map)((Map)om.convertValue((Object)instruction, Map.class)), (Map)defaultInstructionMap);
            YAMLFactory yf = new YAMLFactory();
            yf.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
            ObjectMapper mapper = new ObjectMapper((JsonFactory)yf);
            try (SequenceWriter sw = mapper.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS}).writeValues((OutputStream)out);){
                sw.write((Object)prunedInstructions);
            }
            catch (IOException e) {
                throw new CliExitException(Context.ExitReason.ERROR, "Error while converting config to yml: " + e.getMessage(), e);
            }
            return 0;
        }
        Context context = new Context(args, genCliArgs, instruction, out, err, in, baseCli);
        try {
            existingSolidLabPerftestUploadOutputStreams = context.setupDebugOutput(Collections.emptyList());
            context.setupActionOutput();
        }
        catch (CliExitException e) {
            err.println(e.getMessage());
            throw e;
        }
        try {
            LOG.debug("Final Instruction: " + String.valueOf(context.getInstruction()));
            context.setupInjector();
            context.setupProxy();
            context.setupCallOutput();
            context.setupESpecExecuteLogOutput();
            context.setupDebugOutput(existingSolidLabPerftestUploadOutputStreams);
            InstructionExecutor instructionExecutor = new InstructionExecutor(context);
            LOG.debug("Setup complete, calling instructionExecutor.run");
            instructionExecutor.run(context, instruction);
            int n = 0;
            return n;
        }
        catch (CliExitException e) {
            assert (e.getExitReason() != Context.ExitReason.SUCCESS);
            if (e.getExitReason() != Context.ExitReason.SUCCESS && e.getMessage() != null) {
                context.getActionLogger().errorPrintln(e.getMessage());
            }
            int n = e.getExitCode();
            return n;
        }
        finally {
            context.closeOutputs();
        }
    }

    private static Instruction getDemoInstruction(Instruction.Action action) throws CliExitException {
        Class<? extends Instruction> instructionClass = InstructionTypeIdResolver.classFromAction(action);
        assert (instructionClass != null);
        ObjectMapper om = new ObjectMapper();
        Object defaultInstruction = null;
        try {
            Constructor<? extends Instruction> constructor = instructionClass.getDeclaredConstructor(Boolean.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(true);
        }
        catch (Exception e) {
            throw new CliExitException(Context.ExitReason.ERROR, "Implementation exception for " + instructionClass.getName() + " (demo constructor missing?)", e);
        }
    }

    private static Instruction getDefaultInstruction(Instruction.Action action) throws CliExitException {
        Class<? extends Instruction> instructionClass = InstructionTypeIdResolver.classFromAction(action);
        assert (instructionClass != null);
        ObjectMapper om = new ObjectMapper();
        Object defaultInstruction = null;
        try {
            Constructor<? extends Instruction> constructor = instructionClass.getDeclaredConstructor(Boolean.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(false);
        }
        catch (Exception e) {
            throw new CliExitException(Context.ExitReason.ERROR, "Implementation exception for " + instructionClass.getName() + " (default constructor missing?)", e);
        }
    }

    static {
        Security.setProperty("jdk.tls.disabledAlgorithms", "SSLv3, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL");
    }
}

