/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2;

import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.ui.cli2.ArgumentException;
import be.iminds.ilabt.jfed.ui.cli2.CliExitException;
import be.iminds.ilabt.jfed.ui.cli2.Context;
import be.iminds.ilabt.jfed.ui.cli2.InstructionParser;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CreateSliceInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DeleteInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.InstructionWithSlice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ManifestInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.OutputTarget;
import be.iminds.ilabt.jfed.ui.cli2.instruction.PoaInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RenewInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RunInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceInfoInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.UserInfoInstruction;
import be.iminds.ilabt.jfed.ui.commandline.BaseCli;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.JFedVersionInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterCommandLineParser {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimenterCommandLineParser.class);
    private GenericCliArguments genericCliArguments;
    private Instruction instruction;
    private final String[] args;
    private final PrintStream out;
    private final PrintStream err;
    private final InputStream in;
    private final BaseCli baseCli;
    public static final String CHOOSE_PROJECT_AUTOMATICALLY_OPTION = "CHOOSE_AUTOMATICALLY";
    public static final List<String> actionOptions = Arrays.asList("ReloadOS", "Restart", "ConsoleUrl");

    @Nullable
    private <R> R getInYml(@Nonnull Class<R> resultClass, @Nonnull Map instructionMap, String ... keys) throws ArgumentException {
        return this.getInYml(null, resultClass, instructionMap, keys);
    }

    @Nonnull
    private <R> R getInYml(@Nonnull R defaultVal, @Nonnull Map instructionMap, String ... keys) throws ArgumentException {
        return this.getInYml(defaultVal, defaultVal.getClass(), instructionMap, keys);
    }

    @Nullable
    @Contract(value="!null,_,_,_ -> !null")
    private <R> R getInYml(@Nullable R defaultVal, @Nonnull Class<R> resultClass, @Nonnull Map instructionMap, String ... keys) throws ArgumentException {
        Map cur = instructionMap;
        ArrayList<String> seenKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!(cur instanceof Map)) {
                throw new ArgumentException("Unexpected branch type (" + cur.getClass().getName() + ") at " + String.valueOf(seenKeys) + "  (expected Map)");
            }
            if ((cur = cur.get(key)) == null) {
                return defaultVal;
            }
            seenKeys.add(key);
        }
        if (!resultClass.isInstance(cur)) {
            throw new ArgumentException("Unexpected leaf type (" + cur.getClass().getName() + ") at " + String.valueOf(Arrays.asList(keys)) + "  (expected " + resultClass.getName() + ")");
        }
        return (R)cur;
    }

    @Nonnull
    private <R> List<R> getListInYml(@Nonnull Class<R> resultClass, @Nonnull Map instructionMap, String ... keys) throws ArgumentException {
        return this.getListInYml(Collections.emptyList(), resultClass, instructionMap, keys);
    }

    @Nonnull
    private <R> List<R> getListInYml(@Nonnull List<R> defaultVal, @Nonnull Map instructionMap, String ... keys) throws ArgumentException {
        return this.getListInYml(defaultVal, defaultVal.getClass(), instructionMap, keys);
    }

    @Nonnull
    private <R> List<R> getListInYml(@Nonnull List<R> defaultVal, @Nonnull Class<R> resultClass, @Nonnull Map instructionMap, String ... keys) throws ArgumentException {
        Map cur = instructionMap;
        ArrayList<String> seenKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!(cur instanceof Map)) {
                throw new ArgumentException("Unexpected branch type (" + cur.getClass().getName() + ") at " + String.valueOf(seenKeys) + "  (expected Map)");
            }
            if ((cur = cur.get(key)) == null) {
                return defaultVal;
            }
            seenKeys.add(key);
        }
        if (!resultClass.isInstance(cur)) {
            throw new ArgumentException("Unexpected leaf type (" + cur.getClass().getName() + ") at " + String.valueOf(Arrays.asList(keys)) + "  (expected " + resultClass.getName() + ")");
        }
        return (List)((Object)cur);
    }

    @Nullable
    private <E extends Enum> E getEnumInYml(@Nonnull Map instructionMap, @Nonnull Class<E> enumClass, String ... keys) throws ArgumentException {
        String val = (String)((Object)this.getInYml((Object)String.class, instructionMap, keys));
        if (val == null) {
            return null;
        }
        try {
            Method valueOfMethod = enumClass.getMethod("valueOf", String.class);
            return (E)((Enum)valueOfMethod.invoke(null, val));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Should never happen for an enum!", e);
        }
    }

    @Nonnull
    private <E extends Enum> E getEnumInYml(@Nonnull Map instructionMap, @Nonnull E defaultVal, String ... keys) throws ArgumentException {
        String val = (String)((Object)this.getInYml((Object)String.class, instructionMap, keys));
        if (val == null) {
            return defaultVal;
        }
        try {
            Method valueOfMethod = defaultVal.getClass().getMethod("valueOf", String.class);
            return (E)((Enum)valueOfMethod.invoke(null, val));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Should never happen for an enum!", e);
        }
    }

    @Nullable
    private static String findSimpleOptionValue(@Nonnull String[] args, @Nonnull String shortKey, @Nonnull String longKey) {
        assert (shortKey.length() < longKey.length());
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-" + shortKey) && !arg.equals("--" + longKey)) continue;
            if (i < args.length - 1) {
                return args[i + 1];
            }
            return null;
        }
        return null;
    }

    private static boolean findSimpleOptionPresent(@Nonnull String[] args, @Nonnull String shortKey, @Nonnull String longKey) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-" + shortKey) && !arg.equals("--" + longKey)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String findSimpleOptionValueAndRemove(@Nonnull List<String> args, @Nonnull String shortKey, @Nonnull String longKey) {
        assert (shortKey.length() < longKey.length());
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!arg.equals("-" + shortKey) && !arg.equals("--" + longKey)) continue;
            if (i < args.size() - 1) {
                String res = args.get(i + 1);
                args.remove(i + 1);
                args.remove(i);
                return res;
            }
            return null;
        }
        return null;
    }

    private static boolean findSimpleOptionPresentAndRemove(@Nonnull List<String> args, @Nonnull String shortKey, @Nonnull String longKey) {
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!arg.equals("-" + shortKey) && !arg.equals("--" + longKey)) continue;
            args.remove(i);
            return true;
        }
        return false;
    }

    @Nonnull
    private String loadContent(@Nonnull PrintStream out, @Nonnull PrintStream err, @Nonnull InputStream in, @Nonnull String contentSource) throws ArgumentException {
        InputStream is = null;
        try {
            if (contentSource.equals("stream:stdin") || contentSource.equals("-")) {
                is = in;
            }
            if (contentSource.equals("stream:stderr") || contentSource.equals("stream:stdout")) {
                throw new ArgumentException("Input stream cannot be " + contentSource);
            }
            if (is == null && contentSource.matches("^http[s]?://")) {
                URL url;
                try {
                    url = new URL(contentSource);
                }
                catch (MalformedURLException e) {
                    throw new ArgumentException("Invalid URL \"" + contentSource + "\"", (Throwable)e);
                }
                URLConnection urlConn = url.openConnection();
                urlConn.setReadTimeout(10000);
                is = urlConn.getInputStream();
            }
            if (is == null && contentSource.startsWith("file:")) {
                String filename = contentSource.substring(5);
                try {
                    is = new FileInputStream(filename);
                }
                catch (FileNotFoundException e) {
                    throw new ArgumentException("Input file \"" + filename + "\" not found");
                }
            }
            if (is == null) {
                try {
                    is = new FileInputStream(contentSource);
                }
                catch (FileNotFoundException e) {
                    throw new ArgumentException("Input file \"" + contentSource + "\" not found");
                }
            }
            if (is == null) {
                throw new ArgumentException("Unsupported content source \"" + contentSource + "\"");
            }
            String e = IOUtils.streamToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return e;
        }
        catch (IOException e) {
            throw new ArgumentException("IOException while reading \"" + contentSource + "\"", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Map parseYml(String ymlContent) throws ArgumentException {
        Map root;
        YAMLFactory yf = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yf);
        try {
            root = (Map)mapper.readValue(ymlContent, Map.class);
        }
        catch (IOException e) {
            throw new ArgumentException("Failed to parse instruction yaml: " + e.getMessage(), (Throwable)e);
        }
        return root;
    }

    public ExperimenterCommandLineParser(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli) {
        this.args = args;
        this.out = out;
        this.err = err;
        this.in = in;
        this.baseCli = baseCli;
    }

    public void processInstruction(ProcessInstructionResult res) throws CliExitException {
        Map instructionMap;
        String ymlInstructionFile;
        String actionCliArg;
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(this.args));
        if (argList.isEmpty()) {
            ExperimenterCommandLineParser.generalHelp(this.err);
            throw new RuntimeException("process() should not have been called for no arguments");
        }
        String actionArg = ExperimenterCommandLineParser.findSimpleOptionValueAndRemove(argList, "a", "action");
        if (actionArg == null) {
            throw new ArgumentException("--action is mandatory");
        }
        Instruction.Action actionArgAction = Instruction.Action.parse(actionArg);
        if (actionArgAction != null) {
            actionCliArg = actionArgAction.name();
            ymlInstructionFile = null;
        } else {
            actionCliArg = null;
            ymlInstructionFile = actionArg;
        }
        if (ymlInstructionFile == null) {
            instructionMap = new HashMap<String, String>();
        } else {
            if (ymlInstructionFile.equals("stream:stdin") || ymlInstructionFile.equals("-")) {
                // empty if block
            }
            String ymlInstructionContent = this.loadContent(this.out, this.err, this.in, ymlInstructionFile);
            instructionMap = this.parseYml(ymlInstructionContent);
        }
        if (actionCliArg == null) {
            if (ymlInstructionFile == null || !instructionMap.containsKey("action")) {
                if (actionCliArg == null) {
                    this.err.println("ERROR: no action provided. (not in argument list, nor in action file)");
                    ExperimenterCommandLineParser.generalHelp(this.err);
                    throw new ArgumentException("no action provided");
                }
                instructionMap.put("action", actionCliArg);
            } else {
                actionCliArg = (String)instructionMap.get("action");
            }
        } else {
            Object ymlActionString;
            if (ymlInstructionFile != null && instructionMap.containsKey("action") && !Instruction.Action.canonize((String)(ymlActionString = (String)instructionMap.get("action"))).equals(Instruction.Action.canonize(actionCliArg))) {
                throw new ArgumentException("action mismatch between command line argument and action file: \"" + (String)ymlActionString + "\" != \"" + actionCliArg + "\"");
            }
            instructionMap.put("action", actionCliArg);
        }
        assert (instructionMap.containsKey("action"));
        assert (actionCliArg != null);
        res.action = Instruction.Action.parse(actionCliArg);
        if (res.action == null) {
            this.err.println("ERROR: unknown action \"" + actionCliArg + "\"");
            ExperimenterCommandLineParser.generalHelp(this.err);
            throw new ArgumentException("Unknown action \"" + actionCliArg + "\"");
        }
        res.options = this.initOptions(res.action);
        for (String outputKey : Arrays.asList("actionOutputs", "debugOutputs", "callOutputs")) {
            Object out;
            if (!instructionMap.containsKey(outputKey) || (out = instructionMap.get(outputKey)) instanceof List) continue;
            instructionMap.put(outputKey, Collections.singletonList(out));
        }
        boolean changed = this.argumentsToInstruction(res.action, res.options, this.genericCliArguments, argList.toArray(new String[0]), instructionMap);
        try {
            res.instruction = new InstructionParser().parse(res.action, instructionMap);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error in action YML", (Throwable)e);
            throw new CliExitException(Context.ExitReason.BAD_ARGS, "Error in action YML: " + e.getMessage());
        }
        assert (res.instruction != null);
        this.checkMandatory(res.instruction);
    }

    private void checkMandatory(@Nonnull Instruction checkedInstruction) throws ArgumentException {
        assert (checkedInstruction != null);
        try {
            InstructionWithSlice sliceInstruction;
            if (checkedInstruction instanceof InstructionWithSlice && !(sliceInstruction = (InstructionWithSlice)checkedInstruction).getSlice().isValid()) {
                throw new ArgumentException("Bad info about slice");
            }
            if (checkedInstruction.getUser() == null) {
                throw new ArgumentException("No user info");
            }
            if (checkedInstruction.getUser().getPem() == null) {
                throw new ArgumentException("No user PEM argument");
            }
            if (checkedInstruction.getUser().getPem().isEmpty()) {
                throw new ArgumentException("Missing user PEM argument");
            }
            switch (checkedInstruction.getAction()) {
                case RUN: {
                    RunInstruction runInstruction = (RunInstruction)checkedInstruction;
                    if (runInstruction.getExperiment().isValid()) break;
                    throw new ArgumentException("Bad info about experiment");
                }
                case CREATESLICE: {
                    CreateSliceInstruction createSliceInstruction = (CreateSliceInstruction)checkedInstruction;
                    break;
                }
                case DELETE: {
                    DeleteInstruction deleteInstruction = (DeleteInstruction)checkedInstruction;
                    break;
                }
                case MANIFEST: {
                    ManifestInstruction manifestInstruction = (ManifestInstruction)checkedInstruction;
                    break;
                }
                case DECRYPTPEM: {
                    break;
                }
                case SLICECREDENTIAL: {
                    break;
                }
                case SLICEINFO: {
                    SliceInfoInstruction sliceInfoInstruction = (SliceInfoInstruction)checkedInstruction;
                    break;
                }
                case USERINFO: {
                    UserInfoInstruction userInfoInstruction = (UserInfoInstruction)checkedInstruction;
                    break;
                }
                case RENEW: {
                    RenewInstruction renewInstruction = (RenewInstruction)checkedInstruction;
                    break;
                }
                case POA: {
                    PoaInstruction poaInstruction = (PoaInstruction)checkedInstruction;
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    private void addGenericOptions(@Nonnull Options options) {
        options.addOption(Option.builder("pa").longOpt("print-action").desc("Take no action, but instead output the action file matching the current instructions (which are made up out of cli argument and/or the content of the action file)").build());
        BaseCli.addUserConfig(options, "Specify the \"context\" file. This old format contains info about the actual login file(s).It is advised to use the -p option instead of this one.", true);
        options.addOption(Option.builder("C").longOpt("cert-file").desc("Specify the file containing the \"login\" X509 certificate, in PEM format").hasArg().argName("FILE").build());
        options.addOption("q", "quiet", false, "less output");
        options.addOption(null, "silent", false, "less output (same as --quiet)");
        options.addOption("d", "debug", false, "extra debugging output");
        options.addOption("v", "version", false, "show version and exit");
        options.addOption("h", "help", false, "show help and exit");
    }

    @Nonnull
    private Options initOptions(@Nonnull Instruction.Action action) {
        Options res = new Options();
        this.addGenericOptions(res);
        if (action.isSliceArgSupported()) {
            res.addOption(Option.builder("s").longOpt("slice").desc("The URN or name of the slice to use. (auto detected)").hasArg().argName("SLICE URN/NAME").build());
        }
        if (action.isSliceArgSupported()) {
            res.addOption(Option.builder("S").longOpt("project-name").desc("The name of the project (= sub authority) of the slice. This is an optional argument (however some authorities might require a project!). You can also use \"CHOOSE_AUTOMATICALLY\" as project name, in that case, the last (determined by your SA) project you are a member of will be used.").hasArg().argName("NAME").build());
        }
        if (action == Instruction.Action.RUN || action == Instruction.Action.RENEW || action == Instruction.Action.CREATESLICE) {
            res.addOption(Option.builder().longOpt("expiration-date").desc("The date and time at which this slice expires. In RFC3339 format. This is an optional argument. default: 2 hours in the future").hasArg().argName("RFC3339 DATE").build());
            res.addOption(Option.builder("e").longOpt("expiration-hours").desc("The number of hours after which this slice expires. This is an optional argument. default: 2 hours in the future").hasArg().argName("INTEGER").build());
        }
        if (action == Instruction.Action.RUN || action == Instruction.Action.CREATESLICE) {
            res.addOption(Option.builder().longOpt("share-slice").desc("List of users to share slice with. Either use the URN of each user, or the short username. You can also specify the special value \"PROJECTUSERS\", which will automatically share the slice with all users in the project. Multiple users can be specified by separating them with a comma.").hasArg().argName("USERNAME(S)").build());
        }
        if (action == Instruction.Action.SLICEINFO || action == Instruction.Action.USERINFO || action == Instruction.Action.CREATESLICE || action == Instruction.Action.MANIFEST || action == Instruction.Action.SLICECREDENTIAL) {
            res.addOption(Option.builder().longOpt("output-format").desc("The output format to use (for user information). Choices: \"text\" or \"json\". Default:json").hasArg().argName("FORMAT").build());
        }
        if (action == Instruction.Action.POA) {
            String actionOptionsString = actionOptions.stream().collect(Collectors.joining(", "));
            res.addOption(Option.builder("poa").longOpt("poa-action").desc("The operational action to perform. (Options: " + actionOptionsString + ")").hasArg().argName("ACTION").build());
            res.addOption(Option.builder("t").longOpt("target-sliver").desc("The URN of the sliver to perform the action on.").hasArg().argName("SLIVER URN").build());
        }
        if (action == Instruction.Action.RUN) {
            res.addOption(Option.builder("r").longOpt("rspec").desc("The rspec file to use for creating a sliver").hasArg().argName("RSPEC XML FILE").build());
        }
        res.addOption(Option.builder().longOpt("manifest").desc("The file in which the manifest must be stored. (default: manifest-<SLICENAME>.rspec)").hasArg().argName("FILE").build());
        if (action == Instruction.Action.DELETE) {
            res.addOption(Option.builder("r").longOpt("rspec").desc("The rspec file to get the needed authority information from (manifest or request) (not mandatory, but might not work without)").hasArg().argName("RSPEC XML FILE").build());
        }
        if (action == Instruction.Action.RUN) {
            res.addOption(Option.builder().longOpt("delete-on-create-failure").desc("If there is a failure in a call made to create the sliver(s), delete all resources everywhere before exiting.").build());
            res.addOption(Option.builder().longOpt("delete-on-become-ready-failure").desc("If there is a failure in a call while waiting for the sliver(s) to become ready, delete all resources everywhere before exiting.").build());
            res.addOption(Option.builder().longOpt("abort-if-slivers-exist").desc("Do not create any slivers if any sliver already exists on any of the authorities.").build());
            res.addOption(Option.builder().longOpt("create-slice").desc("Create the slice if it doesn't exist. (if it exists, this option is ignored)").build());
            res.addOption(Option.builder().longOpt("rewrite-rspec").desc("Parse the provided RSpec, and reconstruct it again, before sending it to the server. This can help prevent some server sides bug caused by valid but atypical RSpecs.").build());
            res.addOption(Option.builder().longOpt("bind-rspec").desc("Bind any unbound nodes in the RSpec to a specified authority. This leaves bound nodes as they are. (this imples --rewrite-rspec)").hasArg().argName("COMPONENT MANAGER URN").build());
            res.addOption(Option.builder("k").longOpt("ssh-keys").desc("Specify which ssh keys to add. The argument is a (comma separated) list of res.\nAvailable res: usercert,userkeys,rspec,shareduserallkeys\n   usercert: add the user making the calls, with the ssh key from the certificate in the login PEM file.\n   userkeys: add the user making the calls, with the ssh keys that are stored on the user authority MA server. (usercert and userkeys can be combined to add all keys)\n   shareduserallkeys: add the ssh keys that are stored on the user authority MA server for the users the slice is shared with AND the ssh keys from that user's login certificate.\n   rspec: add the users and keys specified in the RSpec itself.\nThis option is optional, default: usercert,rspec,shareduserallkeys").hasArg().argName("OPTION LIST").build());
            res.addOption(Option.builder().longOpt("nowait").desc("Do not wait until sliver is ready (default: wait until ready)").build());
        }
        res.addOption(Option.builder().longOpt("call-log").desc("A file into which all call details will be stored").hasArg().argName("FILE").build());
        res.addOption(Option.builder().longOpt("print-calls").desc("Print all calls to stdout").build());
        return res;
    }

    private static void deepMapHelper(Map target, Object newVal, String ... keys) {
        assert (keys.length > 0);
        for (int i = 0; i < keys.length - 1; ++i) {
            String key = keys[i];
            target = (Map)target.computeIfAbsent(key, k -> new HashMap());
        }
        target.put(keys[keys.length - 1], newVal);
    }

    private static List<Object> deepMapListHelper(Map target, String ... keys) {
        assert (keys.length > 0);
        for (int i = 0; i < keys.length - 1; ++i) {
            String key = keys[i];
            target = (Map)target.computeIfAbsent(key, k -> new HashMap());
        }
        return (List)target.computeIfAbsent(keys[keys.length - 1], k -> new ArrayList());
    }

    private boolean argumentsToInstruction(@Nonnull Instruction.Action action, @Nonnull Options options, @Nonnull GenericCliArguments genericCliArguments, @Nonnull String[] args, @Nonnull Map instructionMap) throws ArgumentException {
        ActionOutput actionOutput;
        CommandLine line;
        boolean changed = false;
        BasicParser parser = new BasicParser();
        try {
            line = parser.parse(options, args);
        }
        catch (org.apache.commons.cli.ParseException e) {
            throw new ArgumentException("Argument error: " + e.getMessage(), (Throwable)e);
        }
        String pemArg = line.getOptionValue("cert-and-key-file");
        String keyArg = line.getOptionValue("key-file");
        String certArg = line.getOptionValue("cert-file");
        String contextArg = line.getOptionValue("context-file");
        String passArg = line.getOptionValue("private-key-password");
        if (pemArg != null) {
            ExperimenterCommandLineParser.deepMapListHelper(instructionMap, "user", "pem").add(pemArg);
            changed = true;
        }
        if (keyArg != null) {
            ExperimenterCommandLineParser.deepMapListHelper(instructionMap, "user", "pem").add(keyArg);
            changed = true;
        }
        if (certArg != null) {
            ExperimenterCommandLineParser.deepMapListHelper(instructionMap, "user", "pem").add(certArg);
            changed = true;
        }
        if (passArg != null) {
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, "DIRECT", "user", "passwordMethod");
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, passArg, "user", "password");
            changed = true;
        }
        if (contextArg != null) {
            this.err.println("--context-file is deprecated, but will still work for now.");
        }
        String sliceIdArg = line.getOptionValue("slice");
        String projectNameArg = line.getOptionValue("project-name");
        String sliceExpirationDateArg = line.getOptionValue("expiration-date");
        String sliceExpirationHoursArg = line.getOptionValue("expiration-hours");
        String rspecArg = line.getOptionValue("rspec");
        String bindRspecArg = line.getOptionValue("bind-rspec");
        String shareSliceUsersArg = line.getOptionValue("share-slice");
        String outputFormatArg = line.getOptionValue("output-format") == null ? null : line.getOptionValue("output-format");
        String amApiVersionArg = line.getOptionValue("am-api");
        String sshKeysArg = line.getOptionValue("ssh-keys");
        String manifestArg = line.getOptionValue("manifest");
        String callLogArg = line.getOptionValue("call-log");
        String sliceRecoverInfoArg = line.getOptionValue("slice-recover-info");
        boolean createSliceArg = line.hasOption("create-slice");
        boolean printCalls = line.hasOption("print-calls");
        boolean fake = line.hasOption("fake");
        boolean waitUntilReady = !line.hasOption("nowait");
        boolean abortIfSliversExist = line.hasOption("abort-if-slivers-exist");
        boolean deleteOnCreateFailure = line.hasOption("--delete-on-create-failure");
        boolean deleteOnBecomeReadyFailure = line.hasOption("--delete-on-become-ready-failure");
        String[] speaksForArgs = line.getOptionValues("speaks-for");
        String poaActionArg = line.getOptionValue("poa-action");
        String poaTargetSliverUrnArg = line.getOptionValue("target-sliver");
        String ansibleDirName = line.getOptionValue("ansible-dir");
        String ansiblePlayBookExe = line.getOptionValue("ansible-playbook-exe", "ansible-playbook");
        boolean ansibleExecuteRspecPlaybooks = line.hasOption("ansible-execute-rspec-playbooks");
        String[] ansibleExtraPlaybooks = line.getOptionValues("ansible-add-playbook");
        boolean noPlaybookToExecute = !ansibleExecuteRspecPlaybooks && (ansibleExtraPlaybooks == null || ansibleExtraPlaybooks.length == 0);
        boolean ansibleAllowPlaybookInputfile = line.hasOption("ansible-allow-playbook-inputfile");
        boolean ansibleAllowAnyPlaybookOutputFile = line.hasOption("ansible-allow-any-playbook-outputfile");
        boolean ansibleDebug = line.hasOption("ansible-debug");
        if (sliceIdArg != null) {
            if (sliceIdArg.startsWith("urn:publicid:IDN")) {
                sliceIdArg = GeniUrn.parse((String)sliceIdArg).getResourceName();
            }
            if (action == Instruction.Action.RUN) {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, sliceIdArg, "experiment", "slice", "sliceName");
            } else {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, sliceIdArg, "slice", "sliceName");
            }
            changed = true;
        }
        if (projectNameArg != null) {
            if (projectNameArg.equalsIgnoreCase(CHOOSE_PROJECT_AUTOMATICALLY_OPTION)) {
                if (action == Instruction.Action.RUN) {
                    ExperimenterCommandLineParser.deepMapHelper(instructionMap, Slice.ProjectSource.AUTO.name(), "experiment", "slice", "projectSource");
                } else {
                    ExperimenterCommandLineParser.deepMapHelper(instructionMap, Slice.ProjectSource.AUTO.name(), "slice", "projectSource");
                }
            } else if (action == Instruction.Action.RUN) {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, Slice.ProjectSource.PROVIDED.name(), "experiment", "slice", "projectSource");
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, projectNameArg, "experiment", "slice", "project");
            } else {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, Slice.ProjectSource.PROVIDED.name(), "slice", "projectSource");
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, projectNameArg, "slice", "project");
            }
            changed = true;
        }
        if (sliceExpirationDateArg != null) {
            Instant requestedExpirationDate;
            try {
                requestedExpirationDate = RFC3339Util.rfc3339StringToInstant((String)sliceExpirationDateArg);
            }
            catch (ParseException e) {
                throw new ArgumentException("Specified slice expiration date (\"" + sliceExpirationDateArg + "\") is not in RFC3339 format. The current date in RFC3339 format is: " + RFC3339Util.dateToRFC3339String((Date)new Date()));
            }
            Instant now = Instant.now();
            long expireTimeMin = Duration.between(requestedExpirationDate, now).toMinutes();
            if (action == Instruction.Action.RUN) {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, expireTimeMin, "experiment", "slice", "expireTimeMin");
            } else {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, expireTimeMin, "slice", "expireTimeMin");
            }
            changed = true;
        }
        if (sliceExpirationHoursArg != null) {
            long expireTimeMin;
            try {
                int hours = Integer.parseInt(sliceExpirationHoursArg);
                expireTimeMin = 60 * hours;
            }
            catch (NumberFormatException e) {
                throw new ArgumentException("Specified slice expiration hours (\"" + sliceExpirationHoursArg + "\") is not a valid number.");
            }
            if (action == Instruction.Action.RUN) {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, expireTimeMin, "experiment", "slice", "expireTimeMin");
            } else {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, expireTimeMin, "slice", "expireTimeMin");
            }
            changed = true;
        }
        if (rspecArg != null) {
            if (rspecArg.startsWith("http")) {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, "PROVIDE_URL", "experiment", "requestRSpec", "source");
            } else {
                if (rspecArg.startsWith("file:")) {
                    rspecArg = rspecArg.substring(5);
                }
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, "PROVIDE_FILE", "experiment", "requestRSpec", "source");
            }
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, rspecArg, "experiment", "requestRSpec", "providedContentSource");
        }
        if (bindRspecArg != null) {
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, true, "experiment", "requestRSpec", "bindTestedServerToUnboundNodes");
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, bindRspecArg, "experiment", "requestRSpec", "bindUnboundNodesUrn");
        }
        if (line.hasOption("rewrite-rspec")) {
            this.err.println("The --rewrite-rspec option is deprecated and will be ignored");
        }
        if (line.hasOption("am-api")) {
            this.err.println("The --am-api option is deprecated and will be ignored");
        }
        if (shareSliceUsersArg != null) {
            String[] users;
            ArrayList<String> shareWithUsers = new ArrayList<String>();
            boolean shareSliceWithProjectMembers = false;
            for (String opt : users = shareSliceUsersArg.split(",")) {
                boolean validOpt = false;
                if (Objects.equals(opt, "PROJECTUSERS")) {
                    shareSliceWithProjectMembers = true;
                    validOpt = true;
                }
                if (!validOpt && GeniUrn.valid((String)opt)) {
                    GeniUrn userUrn = GeniUrn.parse((String)opt);
                    assert (userUrn != null);
                    shareWithUsers.add(opt);
                    validOpt = true;
                }
                if (!validOpt && opt.matches("[a-zA-Z][a-zA-Z0-9]*") && opt.length() <= 8) {
                    shareWithUsers.add(opt);
                    validOpt = true;
                }
                if (validOpt) continue;
                throw new ArgumentException("The share-slice option you have specified (" + opt + ") is not valid a valid URN or username");
            }
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, shareSliceWithProjectMembers, "shareWith", "projectMembers");
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, shareWithUsers, "shareWith", "users");
        }
        if (outputFormatArg != null) {
            actionOutput = new ActionOutput(ActionOutput.Format.parse(outputFormatArg), OutputTarget.STDOUT, null);
            ExperimenterCommandLineParser.deepMapListHelper(instructionMap, "actionOutputs").add(actionOutput);
        }
        if (sshKeysArg != null) {
            String[] opts = sshKeysArg.split(",");
            boolean sshKeysUserCert = false;
            boolean sshKeysUserServerKeys = false;
            boolean sshKeysSharedUserKeys = false;
            boolean sshKeysRspec = false;
            for (String opt : opts) {
                boolean validOpt = false;
                if (opt.equalsIgnoreCase("usercert")) {
                    sshKeysUserCert = true;
                    validOpt = true;
                }
                if (opt.equalsIgnoreCase("userkeys")) {
                    sshKeysUserServerKeys = true;
                    validOpt = true;
                }
                if (opt.equalsIgnoreCase("shareduserallkeys")) {
                    sshKeysSharedUserKeys = true;
                    validOpt = true;
                }
                if (opt.equalsIgnoreCase("rspec")) {
                    sshKeysRspec = true;
                    validOpt = true;
                }
                if (validOpt) continue;
                throw new ArgumentException("The ssh-keys option you have specified (" + opt + ") is not valid");
            }
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, sshKeysUserCert, "shareWith", "userCert");
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, sshKeysUserServerKeys, "shareWith", "userKeys");
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, sshKeysSharedUserKeys, "shareWith", "shareWith");
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, sshKeysRspec, "shareWith", "rspec");
        }
        if (manifestArg != null) {
            actionOutput = new ActionOutput(ActionOutput.Format.TXT, OutputTarget.FILE, manifestArg);
            ExperimenterCommandLineParser.deepMapListHelper(instructionMap, "actionOutputs").add(actionOutput);
        }
        if (callLogArg != null && outputFormatArg != null) {
            ExperimenterCommandLineParser.deepMapListHelper(instructionMap, "callOutputs").add(new CallOutput(CallOutput.Format.valueOf(outputFormatArg.toUpperCase()), OutputTarget.FILE, callLogArg));
        }
        if (line.hasOption("slice-recover-info")) {
            this.err.println("The --slice-recover-info option is deprecated and will be ignored");
        }
        if (line.hasOption("fake")) {
            throw new ArgumentException("The --fake option is deprecated. Will not continue.");
        }
        if (createSliceArg) {
            if (action == Instruction.Action.RUN) {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, false, "experiment", "slice", "failOnNonExistingSlice");
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, true, "experiment", "slice", "failOnExistingSlice");
            } else {
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, false, "slice", "failOnNonExistingSlice");
                ExperimenterCommandLineParser.deepMapHelper(instructionMap, true, "slice", "failOnExistingSlice");
            }
        }
        if (printCalls) {
            ExperimenterCommandLineParser.deepMapListHelper(instructionMap, "callOutputs").add(new CallOutput(CallOutput.Format.TEXT, OutputTarget.STDOUT, callLogArg));
        }
        if (line.hasOption("logging")) {
            this.err.println("The --logging option is deprecated and will be ignored");
        }
        if (line.hasOption("fake-sliver")) {
            this.err.println("The --fake-sliver option is deprecated and will be ignored");
        }
        if (line.hasOption("nowait")) {
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, false, "experiment", "waitForReady", "enabled");
        }
        if (abortIfSliversExist) {
            this.err.println("The --abort-if-slivers-exist option is deprecated and will be ignored");
        }
        if (deleteOnCreateFailure) {
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, true, "deleteOn", "failCreate");
        }
        if (deleteOnBecomeReadyFailure) {
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, true, "deleteOn", "failBecomeReady");
        }
        if (line.hasOption("speaks-for")) {
            throw new ArgumentException("The --speaks-for option is deprecated. Will not continue.");
        }
        if (poaActionArg != null) {
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, (Object)PoaInstruction.PoaAction.parse(poaActionArg), "poaAction");
        }
        if (poaTargetSliverUrnArg != null) {
            ExperimenterCommandLineParser.deepMapHelper(instructionMap, poaTargetSliverUrnArg, "sliverUrn");
        }
        return changed;
    }

    public Instruction.Action getCommand() {
        return this.instruction.getAction();
    }

    public boolean isAction(Instruction.Action ... anyActions) {
        for (Instruction.Action a : anyActions) {
            if (!Objects.equals((Object)this.instruction.getAction(), (Object)a)) continue;
            return true;
        }
        return false;
    }

    public void showVersion() {
        ExperimenterCommandLineParser.showVersion(this.out);
    }

    public static void showVersion(PrintStream out) {
        out.println("jFed Experimenter CLI 2 -- http://jfed.iminds.be/");
        out.println("Send bugreports to: jfed-bugreports@atlantis.ugent.be");
        JFedVersionInfo jFedVersionInfo = new JFedVersionInfo();
        out.println("Version: " + jFedVersionInfo.getFullVersionString());
        out.println("Environment: " + jFedVersionInfo.getEnvironmentString());
    }

    @Nonnull
    public static String getAllActions() {
        return Arrays.stream(Instruction.Action.values()).map(Instruction.Action::getNiceName).collect(Collectors.joining(" "));
    }

    public static void generalHelp(PrintStream err) {
        err.println("Syntax: jfed-experimenter-cli [-a|--action <ACTION NAME | ACTION FILE>] [action_options ... ]\nAvailable Actions: " + ExperimenterCommandLineParser.getAllActions() + "\n\nMore help:\n   Specific help: jfed-experimenter-cli --action <ACTION NAME> --help\n   Documentation: https://doc.ilabt.imec.be/jfed-documentation-5.9/otherjfedtools.html#experimenter-cli-2\n");
    }

    @Nonnull
    private GenericCliArguments processGenericCliArguments() {
        return new GenericCliArguments(ExperimenterCommandLineParser.findSimpleOptionValue(this.args, "c", "context-file"), ExperimenterCommandLineParser.findSimpleOptionPresent(this.args, "s", "silent"), ExperimenterCommandLineParser.findSimpleOptionPresent(this.args, "d", "debug"), ExperimenterCommandLineParser.findSimpleOptionPresent(this.args, "h", "help"), ExperimenterCommandLineParser.findSimpleOptionPresent(this.args, "w", "wizard"), ExperimenterCommandLineParser.findSimpleOptionPresent(this.args, "v", "version"), ExperimenterCommandLineParser.findSimpleOptionPresent(this.args, "pa", "print-action"), ExperimenterCommandLineParser.findSimpleOptionPresent(this.args, "a", "action"));
    }

    @Nonnull
    public GenericCliArguments getGenericCliArguments() {
        if (this.genericCliArguments == null) {
            this.genericCliArguments = this.processGenericCliArguments();
        }
        return this.genericCliArguments;
    }

    public static class ProcessInstructionResult {
        public Instruction.Action action;
        public Options options;
        public Instruction instruction;
    }

    public static class GenericCliArguments {
        @Nullable
        private final String contextFilename;
        private final boolean silent;
        private final boolean debug;
        private final boolean help;
        private final boolean version;
        private final boolean wizard;
        private final boolean printAction;
        private final boolean hasActionArg;

        public GenericCliArguments(@Nullable String contextFilename, boolean silent, boolean debug, boolean help, boolean wizard, boolean version, boolean printAction, boolean hasActionArg) {
            this.contextFilename = contextFilename;
            this.silent = silent;
            this.debug = debug;
            this.help = help;
            this.wizard = wizard;
            this.version = version;
            this.printAction = printAction;
            this.hasActionArg = hasActionArg;
        }

        @Nullable
        public String getContextFilename() {
            return this.contextFilename;
        }

        public boolean isSilent() {
            return this.silent;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public boolean isHelp() {
            return this.help;
        }

        public boolean isVersion() {
            return this.version;
        }

        public boolean isWizard() {
            return this.wizard;
        }

        public boolean isPrintAction() {
            return this.printAction;
        }

        public boolean hasAction() {
            return this.hasActionArg;
        }
    }
}

