/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import be.iminds.ilabt.jfed.espec.util.ESpecLogListener;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentChangeListener;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerImpl;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.SshConnectionPool;
import be.iminds.ilabt.jfed.experiment.SshConnectionPoolFactory;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupHelper;
import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedExperimenterGuiConfigProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfigImpl;
import be.iminds.ilabt.jfed.experimenter_gui.config.UserInfoProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigStitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapsFetcher;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.SingleSshGitAuthPreferences;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.TestConnectivityJob;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.jobs.link_test.LinkTestListener;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobReport;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.DeleteSliversAtAuthorityTask;
import be.iminds.ilabt.jfed.highlevel.tasks.GetAdvertisementTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSlicesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSubAuthoritiesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTaskInteraction;
import be.iminds.ilabt.jfed.highlevel.tasks.ReloadOSTask;
import be.iminds.ilabt.jfed.highlevel.util.ExpirationChecker;
import be.iminds.ilabt.jfed.highlevel.util.InputStreamToLogsThread;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.highlevel.util.SshCommandBuilder;
import be.iminds.ilabt.jfed.highlevel.util.SshCommandBuilderFactory;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGenerator;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.generator.StitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.cli2.ArgumentException;
import be.iminds.ilabt.jfed.ui.cli2.CliExitException;
import be.iminds.ilabt.jfed.ui.cli2.Context;
import be.iminds.ilabt.jfed.ui.cli2.RecoverSliceTaskCliInteraction;
import be.iminds.ilabt.jfed.ui.cli2.SolidLabPerftestUploadOutputStream;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CreateSliceInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.InstructionWithSlice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ListResourcesInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ManifestInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.PoaInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RenewInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RunInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceActionInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceInfoInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshExecInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshFetchInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshShellInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.UserInfoInstruction;
import be.iminds.ilabt.jfed.ui.cli2.logging.ActionLogger;
import be.iminds.ilabt.jfed.ui.cli2.logging.ESpecExecuteOutputLogger;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.Pair;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.lib.AnsibleFileWriter;
import be.iminds.ilabt.jfed.util.lib.BestNodeLoginFinder;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.SCPFileTransfer;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class InstructionExecutor {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(InstructionExecutor.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    @Nonnull
    private final Context context;
    @Nonnull
    private final TaskThread taskThread;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;
    @Nonnull
    private final Injector injector;

    public InstructionExecutor(@Nonnull Context context) {
        this.context = context;
        this.injector = context.getInjector();
        this.taskThread = (TaskThread)this.injector.getInstance(TaskThread.class);
        this.highLevelTaskFactory = (HighLevelTaskFactory)this.injector.getInstance(HighLevelTaskFactory.class);
    }

    public void run(@Nonnull Context context, @Nonnull Instruction instruction) throws CliExitException {
        LOG.debug("Executing " + String.valueOf((Object)instruction.getAction()) + " instruction");
        if (instruction instanceof InstructionWithSlice && instruction.getAction() != Instruction.Action.CREATESLICE) {
            InstructionWithSlice instructionWithSlice = (InstructionWithSlice)instruction;
            this.logUserInfo();
            LOG.debug("Getting Slice name and URN");
            String sliceName = instructionWithSlice.getSlice().getSliceName();
            if (sliceName == null) {
                throw new ArgumentException("Slice name is not allowed to be null");
            }
            GeniUrn sliceUrn = this.getSliceUrn(sliceName, instructionWithSlice.getSlice().getProjectSource() == Slice.ProjectSource.PROVIDED ? instructionWithSlice.getSlice().getProject() : null);
            Experiment experiment = this.recoverExperiment(sliceUrn);
            Slice slice = experiment.getSlice();
            LOG.info("Recovered experiment, will now start it to finish recover. Experiment is now in state: " + String.valueOf(experiment.getExperimentState()));
            ExperimentControllerFactory experimentControllerFactory = (ExperimentControllerFactory)this.injector.getInstance(ExperimentControllerFactory.class);
            ExperimentController experimentController = experimentControllerFactory.createExperimentController(experiment);
            final CountDownLatch waitForExperimentRecovered = new CountDownLatch(1);
            experiment.addExperimentChangeListener(new ExperimentChangeListener(){

                public void onExperimentStateChange(ExperimentState newExperimentState) {
                    if (newExperimentState != ExperimentState.RESTORING && newExperimentState != ExperimentState.PENDING) {
                        waitForExperimentRecovered.countDown();
                    }
                }

                public void onExperimentPartAdded(ExperimentPart experimentPart) {
                }
            });
            experimentController.start();
            try {
                if (!waitForExperimentRecovered.await(instructionWithSlice.getSlice().getMaxWaitForExperimentRecoveredSeconds(), TimeUnit.SECONDS)) {
                    if (!instructionWithSlice.isIgnoreSliceRecoverTimeout()) {
                        throw new CliExitException(Context.ExitReason.ERROR, "Wait for experiment recover took too long. (max wait is configured to " + instructionWithSlice.getSlice().getMaxWaitForExperimentRecoveredSeconds() + "s)");
                    }
                    LOG.warn("Wait for experiment recover took too long. Will IGNORE and continue, as instructed. (max wait is configured to " + instructionWithSlice.getSlice().getMaxWaitForExperimentRecoveredSeconds() + "s)");
                }
            }
            catch (InterruptedException e) {
                throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for experiment recover interrupted.");
            }
            LOG.info("Experiment is now in state: " + String.valueOf(experiment.getExperimentState()));
            assert (experiment.getPartsSize() > 0);
            switch (instructionWithSlice.getAction()) {
                case DELETE: {
                    this.executeDelete(slice);
                    return;
                }
                case POA: {
                    this.executePoa((PoaInstruction)instruction, slice);
                    return;
                }
                case SSHLOGIN: {
                    this.executeSshLogin((SshShellInstruction)instruction, slice);
                    return;
                }
                case SSHEXEC: {
                    this.executeSshExec((SshExecInstruction)instruction, slice, experiment);
                    return;
                }
                case SSHFETCH: {
                    this.executeSshFetch((SshFetchInstruction)instruction, slice, experiment);
                    return;
                }
                case SLICEINFO: {
                    this.executeSliceInfo((SliceInfoInstruction)instruction, slice);
                    return;
                }
                case SLICEACTION: {
                    this.executeSliceAction((SliceActionInstruction)instruction, slice, experiment, experimentController);
                    return;
                }
                case MANIFEST: {
                    this.executeManifest((ManifestInstruction)instruction, slice);
                    return;
                }
                case SLICECREDENTIAL: {
                    this.executeSliceCredential(slice);
                    return;
                }
                case RENEW: {
                    this.executeRenew((RenewInstruction)instruction, slice, experiment);
                    return;
                }
            }
            throw new CliExitException(Context.ExitReason.ERROR, "Action " + String.valueOf((Object)instruction.getAction()) + " not implemented");
        }
        switch (instruction.getAction()) {
            case LISTRESOURCES: {
                this.executeListResources((ListResourcesInstruction)instruction);
                return;
            }
            case USERINFO: {
                this.executeUserInfo((UserInfoInstruction)instruction);
                return;
            }
            case CREATESLICE: {
                this.logUserInfo();
                CreateSliceInstruction createSliceInstruction = (CreateSliceInstruction)instruction;
                this.executeCreateSlice(createSliceInstruction);
                return;
            }
            case RUN: {
                assert (instruction instanceof RunInstruction);
                this.executeRun(context, (RunInstruction)instruction);
                return;
            }
        }
        throw new CliExitException(Context.ExitReason.ERROR, "Action " + String.valueOf((Object)instruction.getAction()) + " not implemented");
    }

    private void logUserInfo() {
        GeniUser user = (GeniUser)this.injector.getInstance(GeniUser.class);
        LOG.info("User " + user.getUserUrnString() + " will be used.");
        LOG.debug("User Authority: " + (user.getUserAuthorityServer() == null ? null : user.getUserAuthorityServer().getName()));
        LOG.debug("User Authority URN: " + user.getUserAuthorityServer().getDefaultComponentManagerUrn());
    }

    @Nonnull
    private GeniUrn getSliceUrn(@Nonnull String sliceName, @Nullable String projectName) throws CliExitException {
        ListSlicesTask listSlicesTask = this.highLevelTaskFactory.listSlices();
        TaskExecution listSlicesTaskExecution = this.taskThread.addTask((Task)listSlicesTask);
        while (!listSlicesTaskExecution.isCompleted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for list slices interrupted.");
            }
        }
        if (listSlicesTaskExecution.getState() != TaskExecution.TaskState.SUCCESS) {
            LOG.error("List Slices failed -> listSlicesTaskExecution.getState()=" + String.valueOf(listSlicesTaskExecution.getState()), listSlicesTaskExecution.getException());
            throw new CliExitException(Context.ExitReason.BAD_ARGS, "List Slices failed");
        }
        GeniUrn sliceUrn = listSlicesTask.getSlices().stream().filter(curSliceUrn -> curSliceUrn.getEncodedResourceName().equalsIgnoreCase(sliceName)).filter(curSliceUrn -> projectName == null || curSliceUrn.getEncodedTopLevelAuthority().toLowerCase().endsWith(":" + projectName.toLowerCase())).findAny().orElseThrow(() -> {
            LOG.error("slice '" + sliceName + "' not found in " + String.valueOf(listSlicesTask.getSlices()));
            return new CliExitException(Context.ExitReason.BAD_ARGS, "slice '" + sliceName + "' not found");
        });
        return sliceUrn;
    }

    @Nonnull
    private Experiment recoverExperiment(@Nonnull GeniUrn sliceUrn) throws CliExitException {
        RecoverSliceTaskCliInteraction recoverSliceTaskInteraction = new RecoverSliceTaskCliInteraction(this.context);
        RecoverSliceTask recoverSliceTask = this.highLevelTaskFactory.createRecoverSliceTask(sliceUrn, (RecoverSliceTaskInteraction)recoverSliceTaskInteraction);
        recoverSliceTask.run();
        try {
            Slice slice = (Slice)recoverSliceTask.get();
            if (slice == null) {
                LOG.error("Failed to recover slice -> recoverSliceTask.get() == null");
                throw new CliExitException(Context.ExitReason.ERROR, "Failed to recover slice");
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failed to recover slice -> InterruptedException where there shouldn't be one", (Throwable)e);
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to recover slice");
        }
        catch (ExecutionException e) {
            LOG.error("Failed to recover slice -> Error in RecoverSliceTask", (Throwable)e);
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to recover slice");
        }
        Experiment experiment = recoverSliceTask.getExperiment();
        if (experiment == null) {
            LOG.error("Failed to recover slice -> recoverSliceTaskInteraction.getExperiment() == null");
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to recover slice");
        }
        return experiment;
    }

    private void executeDelete(@Nonnull Slice slice) throws CliExitException {
        LOG.debug("executeDelete " + slice.getUrnString());
        ArrayList<TaskExecution> taskExecutions = new ArrayList<TaskExecution>();
        for (Server server : slice.getConnectAuthorities()) {
            DeleteSliversAtAuthorityTask deleteTask = this.highLevelTaskFactory.deleteSliversAtAuthority(slice, server);
            taskExecutions.add(this.taskThread.addTask((Task)deleteTask));
        }
        for (TaskExecution taskExecution : taskExecutions) {
            while (!taskExecution.isCompleted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for delete interrupted.");
                }
            }
            if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) continue;
            LOG.error("A Delete failed", taskExecution.getException());
            throw new CliExitException(Context.ExitReason.ERROR, "A Delete failed.");
        }
        LOG.debug("Delete finished.");
        this.context.getActionLogger().actionPrintln("Deleted: " + slice.getUrnString());
        this.context.getActionLogger().actionYamlOut("deleted slice", slice.getUrnString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSshLogin(@Nonnull SshShellInstruction instruction, @Nonnull Slice slice) throws CliExitException {
        LOG.debug("executeSshLogin " + slice.getUrnString());
        GeniUser user = (GeniUser)this.injector.getInstance(GeniUser.class);
        SshCommandBuilderFactory sshCommandBuilderFactory = (SshCommandBuilderFactory)this.injector.getInstance(SshCommandBuilderFactory.class);
        ManifestRspecSource manifestRspecSource = slice.getManifestRspec();
        StringRspec basicStringRspec = manifestRspecSource.getStringRspec();
        if (basicStringRspec != null && manifestRspecSource != null) {
            BestNodeLoginFinder bestNodeLoginFinder = new BestNodeLoginFinder((BasicStringRspec)basicStringRspec, null, user, new BestNodeLoginFinder.Feedback(){

                public void info(String s) {
                    LOG.info("executeSshLogin: " + s);
                }

                public void error(String s) {
                    LOG.error("executeSshLogin: " + s);
                }

                public void debug(String s) {
                    LOG.debug("executeSshLogin: " + s);
                }
            });
            for (RspecNode rspecNode : manifestRspecSource.getImmutableModelRspec().getNodes()) {
                Optional<BasicStringRspec.LoginService> best;
                if (instruction.getNodeClientId() != null && (rspecNode.getClientId() == null || !rspecNode.getClientId().trim().equals(instruction.getNodeClientId().trim())) || !(best = Optional.ofNullable(bestNodeLoginFinder.findBestLogin(rspecNode.getUniqueId()))).isPresent()) continue;
                LOG.debug("executeSshLogin: found login service for user " + best.get().getUsername());
                BasicStringRspec.LoginService bestLoginService = best.get();
                if (bestLoginService.getSshProxy() != null && bestLoginService.getSshProxy().getSshKeyInfo() == null) {
                    LOG.warn("Found proxy info with empty SshKeyInfo. Replacing with logged-in user SshKeyInfo");
                    JFedConnection.SshProxyInfo newSshProxyInfo = new JFedConnection.SshProxyInfo(bestLoginService.getSshProxy(), (SshKeyInfo)SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)user));
                    bestLoginService = new BasicStringRspec.LoginService(bestLoginService.getAuthentication(), bestLoginService.getHostname(), bestLoginService.getPort(), bestLoginService.getUsername(), newSshProxyInfo);
                }
                SshCommandBuilder sshCommandBuilder = sshCommandBuilderFactory.create();
                sshCommandBuilder.setTargetServerUserName(bestLoginService.getUsername());
                sshCommandBuilder.setHostName(bestLoginService.getHostname());
                sshCommandBuilder.setPort(bestLoginService.getPort());
                sshCommandBuilder.setProxyInfo((JFedConnection.ProxyInfo)bestLoginService.getSshProxy());
                sshCommandBuilder.setUseSshAgent(false);
                sshCommandBuilder.setForcePseudoTerminal(true);
                if (instruction.isShowCommand()) {
                    String sshCommand = (String)sshCommandBuilder.build(true).getKey();
                    this.context.getActionLogger().actionJsonOut(Collections.singletonMap("command", sshCommand));
                    this.context.getActionLogger().actionYamlOut("command", sshCommand);
                    this.context.getActionLogger().errorPrintln(sshCommand);
                    continue;
                }
                Pair sshComPair = sshCommandBuilder.build(false);
                try {
                    ((List)sshComPair.getValue()).forEach(TmpFile::store);
                    LOG.debug("Starting terminal with command: " + (String)sshComPair.getKey());
                    ProcessBuilder pb = new ProcessBuilder("bash", "-c", (String)sshComPair.getKey());
                    pb.inheritIO();
                    try {
                        Process p = pb.start();
                        p.waitFor();
                    }
                    catch (IOException e) {
                        LOG.error("Error executing SSH command", (Throwable)e);
                        throw new CliExitException(Context.ExitReason.ERROR, (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted", (Throwable)e);
                        throw new CliExitException(Context.ExitReason.INTERRUPTED, (Throwable)e);
                    }
                }
                finally {
                    ((List)sshComPair.getValue()).forEach(TmpFile::delete);
                }
                return;
            }
        }
        this.context.getActionLogger().actionJsonOut("No node login info found");
        this.context.getActionLogger().actionYamlOut("error", "No node login info found");
        this.context.getActionLogger().errorPrintln("No node login info found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSshExec(@Nonnull SshExecInstruction instruction, @Nonnull Slice slice, @Nonnull Experiment experiment) throws CliExitException {
        LOG.debug("executeSshExec " + slice.getUrnString());
        ManifestRspecSource manifestRspecSource = slice.getManifestRspec();
        if (manifestRspecSource != null && manifestRspecSource.getImmutableModelRspec() != null && manifestRspecSource.getStringRspec() != null) {
            ArrayList<RspecNode> rspecNodes = new ArrayList<RspecNode>();
            for (RspecNode rspecNode : manifestRspecSource.getImmutableModelRspec().getNodes()) {
                if (instruction.getNodeClientId() != null && (rspecNode.getClientId() == null || !rspecNode.getClientId().trim().equals(instruction.getNodeClientId().trim()))) continue;
                rspecNodes.add(rspecNode);
            }
            for (RspecNode node : rspecNodes) {
                try {
                    int exitStatus;
                    SshConnectionPoolFactory sshConnectionPoolFactory = (SshConnectionPoolFactory)this.injector.getInstance(SshConnectionPoolFactory.class);
                    SshConnectionPool sshConnectionPool = sshConnectionPoolFactory.getSshConnectionPool(experiment);
                    SSHClient ssh = sshConnectionPool.getConnection(node.getUniqueId(), SshConnectionPool.BlockingMode.WAIT_FOR_SINGLE);
                    if (ssh == null) {
                        LOG.error("SSH connection setup failed on " + node.getClientId());
                        this.context.getActionLogger().actionJsonOut("SSH connection setup failed on " + node.getClientId());
                        this.context.getActionLogger().actionYamlOut("error", "SSH connection setup failed on " + node.getClientId());
                        this.context.getActionLogger().errorPrintln("SSH connection setup failed on " + node.getClientId());
                        continue;
                    }
                    try {
                        Session.Command c = ssh.startSession().exec(instruction.getCommand());
                        new InputStreamToLogsThread(c.getInputStream(), LOG, Level.DEBUG, "ssh-exec-OUTPUT-" + node.getClientId() + ": ", null).start();
                        new InputStreamToLogsThread(c.getErrorStream(), LOG, Level.ERROR, "ssh-exec-ERROR-" + node.getClientId() + ": ", null).start();
                        c.join();
                        exitStatus = c.getExitStatus();
                    }
                    finally {
                        ssh.close();
                    }
                    this.context.getActionLogger().actionPrintln("Command executed on " + node.getClientId() + " exited with status " + exitStatus);
                    this.context.getActionLogger().actionJsonOut("Command executed on " + node.getClientId() + " exited with status " + exitStatus);
                    this.context.getActionLogger().actionYamlOut("ssh-exec", "Command executed on " + node.getClientId() + " exited with status " + exitStatus);
                }
                catch (IOException e) {
                    LOG.error("problem executing command on " + node.getClientId() + ": " + instruction.getCommand(), (Throwable)e);
                    this.context.getActionLogger().actionJsonOut("Command execution failed on " + node.getClientId());
                    this.context.getActionLogger().actionYamlOut("error", "Command execution failed on " + node.getClientId());
                    this.context.getActionLogger().errorPrintln("Command execution failed on " + node.getClientId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSshFetch(@Nonnull SshFetchInstruction instruction, @Nonnull Slice slice, @Nonnull Experiment experiment) throws CliExitException {
        LOG.debug("executeSshFetch " + slice.getUrnString());
        StringBuffer mergedFileContent = new StringBuffer();
        File mergeTargetFile = null;
        ManifestRspecSource manifestRspecSource = slice.getManifestRspec();
        if (manifestRspecSource != null && manifestRspecSource.getImmutableModelRspec() != null) {
            ArrayList<RspecNode> rspecNodes = new ArrayList<RspecNode>();
            for (RspecNode rspecNode : manifestRspecSource.getImmutableModelRspec().getNodes()) {
                if (instruction.getNodeClientId() != null && (rspecNode.getClientId() == null || !rspecNode.getClientId().trim().equals(instruction.getNodeClientId().trim()))) continue;
                rspecNodes.add(rspecNode);
            }
            for (RspecNode node : rspecNodes) {
                try {
                    block18: {
                        SshConnectionPoolFactory sshConnectionPoolFactory = (SshConnectionPoolFactory)this.injector.getInstance(SshConnectionPoolFactory.class);
                        SshConnectionPool sshConnectionPool = sshConnectionPoolFactory.getSshConnectionPool(experiment);
                        SSHClient ssh = sshConnectionPool.getConnection(node.getUniqueId(), SshConnectionPool.BlockingMode.WAIT_FOR_SINGLE);
                        if (ssh == null) {
                            LOG.error("SSH connection setup failed on " + node.getClientId());
                            this.context.getActionLogger().actionJsonOut("SSH connection setup failed on " + node.getClientId());
                            this.context.getActionLogger().actionYamlOut("error", "SSH connection setup failed on " + node.getClientId());
                            this.context.getActionLogger().errorPrintln("SSH connection setup failed on " + node.getClientId());
                            continue;
                        }
                        SCPFileTransfer fileTransfer = ssh.newSCPFileTransfer();
                        fileTransfer.setTransferListener(new TransferListener(){

                            public TransferListener directory(String name) {
                                LOG.debug("Downloading directory '" + name + "'");
                                return this;
                            }

                            public StreamCopier.Listener file(String name, long size) {
                                LOG.debug("Downloading '" + name + "' (" + size + " bytes)");
                                return transferred -> LOG.debug(String.format("Transferred %d%% of " + name, transferred * 100L / size));
                            }
                        });
                        try {
                            File targetFile;
                            String remoteFileBasename = instruction.getRemoteFile().replaceAll("^.*/", "");
                            if (instruction.isMerge()) {
                                targetFile = File.createTempFile("tmp-jfed-cli2-sshfetch-merge", node.getClientId() + " " + remoteFileBasename);
                                targetFile.deleteOnExit();
                                mergeTargetFile = new File(instruction.getLocalTargetDir(), remoteFileBasename);
                            } else if (instruction.isFlat()) {
                                targetFile = new File(instruction.getLocalTargetDir(), remoteFileBasename);
                            } else {
                                boolean created;
                                File targetSubdir = new File(instruction.getLocalTargetDir(), node.getClientId());
                                if (!targetSubdir.exists() && !(created = targetSubdir.mkdir())) {
                                    LOG.error("Failed to create target dir: " + targetSubdir.getAbsolutePath());
                                    this.context.getActionLogger().actionJsonOut("Failed to create target dir: " + targetSubdir.getAbsolutePath());
                                    this.context.getActionLogger().actionYamlOut("error", "Failed to create target dir: " + targetSubdir.getAbsolutePath());
                                    this.context.getActionLogger().errorPrintln("Failed to create target dir: " + targetSubdir.getAbsolutePath());
                                    continue;
                                }
                                targetFile = new File(targetSubdir, remoteFileBasename);
                            }
                            fileTransfer.download(instruction.getRemoteFile(), targetFile.getAbsolutePath());
                            if (!instruction.isMerge()) break block18;
                            mergedFileContent.append(IOUtils.fileToString((File)targetFile));
                            targetFile.delete();
                        }
                        finally {
                            ssh.close();
                            continue;
                        }
                    }
                    this.context.getActionLogger().actionPrintln("SSH fetch on " + node.getClientId() + " succeeded");
                    this.context.getActionLogger().actionJsonOut("SSH fetch on " + node.getClientId() + " succeeded");
                    this.context.getActionLogger().actionYamlOut("ssh-fetch", "SSH fetch on " + node.getClientId() + " succeeded");
                }
                catch (IOException e) {
                    LOG.error("problem executing ssh fetch on " + node.getClientId(), (Throwable)e);
                    this.context.getActionLogger().actionJsonOut("SSH fetch failed on " + node.getClientId() + ": " + e.getMessage());
                    this.context.getActionLogger().actionYamlOut("error", "SSH fetch failed on " + node.getClientId() + ": " + e.getMessage());
                    this.context.getActionLogger().errorPrintln("SSH fetch failed on " + node.getClientId() + ": " + e.getMessage());
                }
            }
            if (instruction.isMerge() && mergeTargetFile != null) {
                if (mergedFileContent.length() > 0) {
                    IOUtils.stringToFile((File)mergeTargetFile, (String)mergedFileContent.toString());
                    this.context.getActionLogger().actionPrintln("Wrote merged file: " + mergeTargetFile.getAbsolutePath());
                    this.context.getActionLogger().actionJsonOut("Wrote merged file: " + mergeTargetFile.getAbsolutePath());
                    this.context.getActionLogger().actionYamlOut("ssh-fetch", "Wrote merged file: " + mergeTargetFile.getAbsolutePath());
                } else {
                    LOG.error("No data fetched to write to: " + mergeTargetFile.getAbsolutePath());
                    this.context.getActionLogger().actionJsonOut("Nothing to write to: " + mergeTargetFile.getAbsolutePath());
                    this.context.getActionLogger().actionYamlOut("error", "Nothing to write to: " + mergeTargetFile.getAbsolutePath());
                    this.context.getActionLogger().errorPrintln("Nothing to write to: " + mergeTargetFile.getAbsolutePath());
                }
            }
        }
    }

    private void executePoa(@Nonnull PoaInstruction instruction, @Nonnull Slice slice) throws CliExitException {
        Sliver sliver;
        GeniUrn sliverUrn;
        LOG.debug("executePoa " + slice.getUrnString());
        PoaInstruction.PoaAction poaAction = instruction.getPoaAction();
        try {
            if (instruction.getSliverUrn() != null) {
                sliverUrn = new GeniUrn(instruction.getSliverUrn());
                sliver = slice.findSliver(sliverUrn);
                if (sliver == null) {
                    throw new CliExitException(Context.ExitReason.ERROR, "Sliver not found: " + String.valueOf(sliverUrn));
                }
            } else {
                sliverUrn = null;
                sliver = null;
            }
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new ArgumentException("POA sliver URN is invalid: '" + instruction.getSliverUrn() + "'", (Throwable)e);
        }
        ArrayList<TaskExecution> taskExecutions = new ArrayList<TaskExecution>();
        if (sliver != null) {
            taskExecutions.add(this.taskThread.addTask((Task)(switch (poaAction) {
                case PoaInstruction.PoaAction.Restart -> this.highLevelTaskFactory.restart(slice, sliverUrn, sliver.getServer());
                case PoaInstruction.PoaAction.ReloadOs -> this.highLevelTaskFactory.reloadOS(slice, sliverUrn, sliver.getServer());
                case PoaInstruction.PoaAction.ConsoleUrl -> this.highLevelTaskFactory.openConsole(sliver);
                default -> throw new ArgumentException("Unknown POA Action: '" + String.valueOf((Object)poaAction) + "'");
            })));
        } else {
            switch (poaAction) {
                case Restart: {
                    ReloadOSTask poaTask;
                    for (Server server : slice.getConnectAuthorities()) {
                        poaTask = this.highLevelTaskFactory.restartSlice(slice, server);
                        taskExecutions.add(this.taskThread.addTask((Task)poaTask));
                    }
                    break;
                }
                case ReloadOs: {
                    ReloadOSTask poaTask;
                    for (Sliver s : slice.getSliversCopy()) {
                        poaTask = this.highLevelTaskFactory.reloadOS(s);
                        taskExecutions.add(this.taskThread.addTask((Task)poaTask));
                    }
                    break;
                }
                case ConsoleUrl: {
                    throw new ArgumentException("geni_console_url requires a sliver URN");
                }
                default: {
                    throw new ArgumentException("Unknown POA Action: '" + String.valueOf((Object)poaAction) + "'");
                }
            }
        }
        for (TaskExecution taskExecution : taskExecutions) {
            while (!taskExecution.isCompleted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for POA interrupted.");
                }
            }
            if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) continue;
            LOG.error("One POA failed", taskExecution.getException());
            throw new CliExitException(Context.ExitReason.ERROR, "One POA failed.");
        }
        LOG.debug("POA finished.");
        this.context.getActionLogger().actionPrintln("POA " + String.valueOf((Object)poaAction) + ": " + slice.getUrnString());
        this.context.getActionLogger().actionYamlOut("executePOA", Map.of("POA", poaAction, "slice", slice.getUrnString()));
    }

    private void executeSliceAction(@Nonnull SliceActionInstruction instruction, @Nonnull Slice slice, @Nonnull Experiment experiment, @Nonnull ExperimentController experimentController) throws CliExitException {
        LOG.debug("executeSliceAction " + slice.getUrnString());
        SliceActionInstruction.SliceAction sliceAction = instruction.getSliceAction();
        if (sliceAction == SliceActionInstruction.SliceAction.RerunESpec && instruction.getEspec() == null) {
            throw new ArgumentException("SliceAction " + String.valueOf((Object)sliceAction) + " requires espec argument");
        }
        if (sliceAction != SliceActionInstruction.SliceAction.RerunESpec && instruction.getEspec() != null) {
            throw new ArgumentException("SliceAction " + String.valueOf((Object)sliceAction) + " makes no sense with espec argument");
        }
        switch (sliceAction) {
            case LinkTest: {
                experimentController.setExperimentLinkTesterFactory(exp -> {
                    assert (exp == experiment);
                    return new TestLinksJob(exp, (HighLevelTaskFactory)this.injector.getInstance(HighLevelTaskFactory.class), (TaskThread)this.injector.getInstance(TaskThread.class), (GeniUserProvider)this.injector.getInstance(GeniUserProvider.class), (JFedPreferences)this.injector.getInstance(JFedPreferences.class), (ProxyPreferencesManager)this.injector.getInstance(ProxyPreferencesManager.class), (ProxyServiceUtil)this.injector.getInstance(ProxyServiceUtil.class), (JobStateFactory)this.injector.getInstance(JobStateFactory.class), (ProxySocketFactoryProvider)this.injector.getInstance(ProxySocketFactoryProvider.class));
                });
                LinkTestResultToOutput linkTestLogger = new LinkTestResultToOutput(this.context.getActionLogger());
                experiment.addLinkTestListener((LinkTestListener)linkTestLogger);
                assert (experiment.getPartsSize() > 0);
                CompletableFuture future = experimentController.testLinks();
                try {
                    Boolean testSuccess = (Boolean)future.get();
                    boolean linksOk = linkTestLogger.getWorstResult() != null && linkTestLogger.getWorstResult() == TestLinksJob.LinkTestResult.SUCCESS;
                    LOG.debug("Link Test finished.");
                    HashMap<String, Serializable> jsonRes = new HashMap<String, Serializable>();
                    jsonRes.put("All Links OK", Boolean.valueOf(linksOk));
                    ArrayList jsonReports = new ArrayList();
                    if (linkTestLogger.reports != null) {
                        for (TestLinksJob.LinkTestReport linkTestReport : linkTestLogger.reports) {
                            HashMap<String, Object> jsonReport = new HashMap<String, Object>();
                            jsonReport.put("from", linkTestReport.getFrom().getClientId());
                            jsonReport.put("to", linkTestReport.getTo().getClientId());
                            jsonReport.put("summary", linkTestReport.getSummary());
                            jsonReport.put("expected_mbps", linkTestReport.getExpectedLinkSpeed_mbps());
                            jsonReport.put("actual_throughput_mbps", linkTestReport.getActualThroughput_mbps());
                            jsonReport.put("actual_linkspeedsetting_mbps", linkTestReport.getActualLinkSpeedSetting_mbps());
                            jsonReport.put("loss_percent", linkTestReport.getActualLoss_percent());
                            jsonReports.add(jsonReport);
                        }
                    }
                    if (!jsonReports.isEmpty()) {
                        jsonRes.put("reports", jsonReports);
                    }
                    this.context.getActionLogger().actionJsonOut(jsonRes);
                    this.context.getActionLogger().actionPrintln("All Links OK: " + linksOk);
                    this.context.getActionLogger().actionYamlOut("LinkTest", jsonRes);
                    break;
                }
                catch (InterruptedException e) {
                    throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for test links interrupted.");
                }
                catch (ExecutionException e) {
                    LOG.error("Failed to test links -> Error in experimentController.testLinks", (Throwable)e);
                    throw new CliExitException(Context.ExitReason.ERROR, "Failed to test links");
                }
            }
            case RerunESpec: {
                ESpecLoggingToOutput especListener = new ESpecLoggingToOutput(this.context.getActionLogger(), this.context.geteSpecExecuteOutputLogger());
                experiment.addESpecLogListener((ESpecLogListener)especListener);
                ESpecLoggingCounter eSpecLoggingCounter = new ESpecLoggingCounter();
                experiment.addESpecLogListener((ESpecLogListener)eSpecLoggingCounter);
                try {
                    GeniUser user = (GeniUser)this.injector.getInstance(GeniUser.class);
                    ESpecBundle experimentSpecificationBundle = ExperimentSetupHelper.createESpecBundle((ESpec)instruction.getEspec(), (GeniUser)user);
                    ExperimentSpecificationParser parser = new ExperimentSpecificationParser();
                    ExperimentSpecification experimentSpecification = parser.parse(experimentSpecificationBundle.getExperimentSpecificationYml());
                    experiment.resetExperimentSpecification(experimentSpecification, experimentSpecificationBundle, this.getRSpecGeneratorFactory(this.injector), (GitAuthPreferences)new SingleSshGitAuthPreferences(user.getPrivateKey()));
                }
                catch (ESpecBundle.ESpecBundleInitException | ExperimentSpecificationParser.ExperimentSpecificationParseException | IOException e) {
                    LOG.error("ESpec Fetch failed", e);
                    throw new CliExitException(Context.ExitReason.ERROR, "ESpec Fetch failed", e);
                }
                catch (InterruptedException e) {
                    throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for ESpec Fetch interrupted.");
                }
                if (experiment.getExperimentSpecificationFileManager() == null) {
                    throw new CliExitException(Context.ExitReason.ERROR, "ESpec setup failed: experiment.experimentSpecificationFileManager == null");
                }
                experiment.getExperimentSpecificationFileManager().fetchAll();
                if (experiment.getExperimentSpecificationFileManager().getErrorOccured()) {
                    throw new CliExitException(Context.ExitReason.ERROR, "Error fetching ESpec resources");
                }
                CompletableFuture future = experimentController.rerunESpec(null, null);
                try {
                    Boolean success = (Boolean)future.get();
                    LOG.debug("Rerun ESpec finished. success=" + success);
                    Map<String, Boolean> jsonRes = Map.of("Overview Counts", eSpecLoggingCounter.getCounts(), "Rerun ESpec Success", success);
                    this.context.getActionLogger().actionJsonOut(jsonRes);
                    this.context.getActionLogger().actionYamlOut("rerunESpec", jsonRes);
                    if (!success.booleanValue()) {
                        throw new CliExitException(Context.ExitReason.ERROR, "Rerun ESpec failed");
                    }
                    this.context.getActionLogger().actionPrintln("Reran ESpec");
                    break;
                }
                catch (InterruptedException e) {
                    throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for ESpec Rerun interrupted.");
                }
                catch (ExecutionException e) {
                    LOG.error("Failed to Rerun ESpec -> Error in experimentController.rerunESpec", (Throwable)e);
                    throw new CliExitException(Context.ExitReason.ERROR, "Failed to Rerun ESpec");
                }
            }
            case ConnectivityTest: {
                experimentController.setExperimentConnectivityTesterFactory(exp -> new TestConnectivityJob(exp, (HighLevelTaskFactory)this.injector.getInstance(HighLevelTaskFactory.class), (TaskThread)this.injector.getInstance(TaskThread.class), (GeniUserProvider)this.injector.getInstance(GeniUserProvider.class), (JFedPreferences)this.injector.getInstance(JFedPreferences.class), (ProxyPreferencesManager)this.injector.getInstance(ProxyPreferencesManager.class), (ProxyServiceUtil)this.injector.getInstance(ProxyServiceUtil.class)));
                ExperimentControllerImpl experimentControllerImpl = (ExperimentControllerImpl)experimentController;
                CompletableFuture future = experimentControllerImpl.testConnectivity();
                try {
                    TestConnectivityJob.TestConnectivityJobResult jobres = (TestConnectivityJob.TestConnectivityJobResult)future.get();
                    LOG.debug("Connectivity Test finished.");
                    HashMap<String, Object> connectivityTestResult = new HashMap<String, Object>();
                    connectivityTestResult.put("All Connectivity OK", jobres.isAllSuccessFull());
                    connectivityTestResult.put("Failed Nodes", jobres.getFailedNodes().stream().map(FXRspecNode::getClientId).collect(Collectors.toList()));
                    connectivityTestResult.put("Successful Nodes", jobres.getSuccessfulNodes().stream().map(FXRspecNode::getClientId).collect(Collectors.toList()));
                    this.context.getActionLogger().actionJsonOut(connectivityTestResult);
                    this.context.getActionLogger().actionYamlOut("ConnectivityTest", connectivityTestResult);
                    this.context.getActionLogger().actionPrintln("Connectivity Test success: " + jobres.isAllSuccessFull());
                    break;
                }
                catch (InterruptedException e) {
                    throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for Connectivity test interrupted.");
                }
                catch (ExecutionException e) {
                    LOG.error("Failed to test connectivity -> Error in experimentController.testConnectivity", (Throwable)e);
                    throw new CliExitException(Context.ExitReason.ERROR, "Failed to test connectivity");
                }
            }
            default: {
                throw new ArgumentException("Unhandled Slice Action: '" + String.valueOf((Object)sliceAction) + "'");
            }
        }
    }

    private void executeManifest(@Nonnull ManifestInstruction instruction, @Nonnull Slice slice) throws CliExitException {
        String manifestRspec;
        LOG.debug("executeManifest " + slice.getUrnString());
        ManifestRspecSource manifestRspecSource = slice.getManifestRspec();
        String string = manifestRspec = manifestRspecSource == null ? null : manifestRspecSource.getRspecXmlString();
        if (manifestRspec != null) {
            this.context.getActionLogger().actionPrint(manifestRspec);
            this.context.getActionLogger().actionYamlOut("manifestRspec", manifestRspec);
        } else {
            this.context.getActionLogger().errorPrintln("No manifest found");
            this.context.getActionLogger().actionYamlOut("error", "No manifest found");
        }
        LOG.debug("Manifest returned");
        this.writeExperimentOutput(instruction.getOutput(), manifestRspecSource);
    }

    private void executeSliceInfo(@Nonnull SliceInfoInstruction instruction, @Nonnull Slice slice) throws CliExitException {
        LOG.debug("executeSliceInfo " + slice.getUrnString());
        HashMap<String, Object> sliceInfoMap = new HashMap<String, Object>();
        sliceInfoMap.put("sliceUrn", slice.getUrnString());
        if (instruction.isShowMetaInfo()) {
            GeniUser user = (GeniUser)this.injector.getInstance(GeniUser.class);
            sliceInfoMap.put("userUrn", user.getUserUrnString());
            sliceInfoMap.put("usedSpeaksfor", false);
            sliceInfoMap.put("sliceAggregates", slice.getAuthorities().stream().map(Server::getDefaultComponentManagerUrn).collect(Collectors.toList()));
            Instant sliceExpire = slice.getExpirationDate();
            sliceInfoMap.put("sliceExpiration", sliceExpire == null ? null : RFC3339Util.instantToRFC3339String((Instant)sliceExpire));
        }
        if (instruction.isShowUsers()) {
            sliceInfoMap.put("sliceUsers", slice.getUsers().stream().map(GeniUrn::toString).collect(Collectors.toList()));
        }
        if (instruction.isShowCredentials()) {
            sliceInfoMap.put("sliceCredentials", slice.getCredentials().stream().map(AnyCredential::getCredentialXml).collect(Collectors.toList()));
        }
        this.context.getActionLogger().actionPrintln("Slice URN: " + String.valueOf(sliceInfoMap.get("sliceUrn")));
        if (sliceInfoMap.get("userUrn") != null) {
            this.context.getActionLogger().actionPrintln("User URN: " + String.valueOf(sliceInfoMap.get("userUrn")));
        }
        if (sliceInfoMap.get("sliceExpiration") != null) {
            this.context.getActionLogger().actionPrintln("Slice Expiration: " + String.valueOf(sliceInfoMap.get("sliceExpiration")));
        }
        if (instruction.isShowStatus()) {
            Date earliestSliverExpireDate;
            HashMap<String, Object> outerStatusMap = new HashMap<String, Object>();
            HashMap outerStatusAmDetailMap = new HashMap();
            outerStatusMap.put("AMs", outerStatusAmDetailMap);
            sliceInfoMap.put("status", outerStatusMap);
            for (Server amServer : slice.getConnectAuthorities()) {
                HashMap<String, Object> detailHt;
                StatusDetails statusDetailsForAM = slice.getSliversStream().filter(s -> s.getServer().equals((Object)amServer)).map(Sliver::getStatus).filter(Objects::nonNull).reduce(StatusDetails.identityStatus, StatusDetails.merge);
                this.context.getActionLogger().actionPrintln("Sliver at  " + amServer.getDefaultComponentManagerUrn() + " has status " + String.valueOf(statusDetailsForAM.getGlobalStatus()));
                HashMap<String, Object> outerAMHt = new HashMap<String, Object>();
                outerAMHt.put("amUrn", amServer.getDefaultComponentManagerUrn());
                outerAMHt.put("amGlobalSliverStatus", statusDetailsForAM.getGlobalStatus());
                Date earliestAMSliverExpireDate = statusDetailsForAM.getEarliestKnownExpires();
                if (earliestAMSliverExpireDate != null) {
                    outerAMHt.put("earliestSliverExpireDate", RFC3339Util.dateToRFC3339String((Date)earliestAMSliverExpireDate));
                }
                ArrayList detailStatus = new ArrayList();
                for (Map.Entry detail : statusDetailsForAM.getStatusBySliverUrn().entrySet()) {
                    detailHt = new HashMap<String, Object>();
                    detailHt.put("urn", String.valueOf(detail.getKey()));
                    detailHt.put("type", "sliver");
                    detailHt.put("status", String.valueOf(detail.getValue()));
                    detailStatus.add(detailHt);
                }
                for (Map.Entry detail : statusDetailsForAM.getStatusByComponentUrn().entrySet()) {
                    detailHt = new HashMap();
                    detailHt.put("urn", String.valueOf(detail.getKey()));
                    detailHt.put("type", "component");
                    detailHt.put("status", String.valueOf(detail.getValue()));
                    detailStatus.add(detailHt);
                }
                outerAMHt.put("details", detailStatus);
                outerStatusAmDetailMap.put(amServer.getDefaultComponentManagerUrn(), outerAMHt);
            }
            Date date = earliestSliverExpireDate = slice.getStatus() == null ? null : slice.getStatus().getEarliestKnownExpires();
            if (earliestSliverExpireDate != null) {
                outerStatusMap.put("earliestSliverExpireDate", RFC3339Util.dateToRFC3339String((Date)earliestSliverExpireDate));
            }
            this.context.getActionLogger().actionPrintln("Status Info:");
            if (outerStatusMap.get("earliestSliverExpireDate") != null) {
                this.context.getActionLogger().actionPrintln("   Earliest sliver expire date: " + String.valueOf(outerStatusMap.get("earliestSliverExpireDate")));
            } else {
                this.context.getActionLogger().actionPrintln("   Earliest sliver expire date: no slivers");
            }
            Map amsHt = (Map)outerStatusMap.get("AMs");
            Set entries = amsHt.entrySet();
            for (Map.Entry e : entries) {
                String key = (String)e.getKey();
                Map amHt = (Map)e.getValue();
                String amUrn = String.valueOf(amHt.get("amUrn"));
                String amGlobalSliverStatus = String.valueOf(amHt.get("amGlobalSliverStatus"));
                String earliestAMSliverExpireDateStr = amHt.get("earliestSliverExpireDate") == null ? null : String.valueOf(amHt.get("earliestSliverExpireDate"));
                this.context.getActionLogger().actionPrintln("   AM: " + amUrn + " " + amGlobalSliverStatus + (String)(earliestAMSliverExpireDateStr == null ? "" : " " + earliestAMSliverExpireDateStr));
                List details = (List)amHt.get("details");
                for (Object detail : details) {
                    Map detailHt = (Map)detail;
                    String urn = String.valueOf(detailHt.get("urn"));
                    String type = (String)detailHt.get("type");
                    String status = String.valueOf(detailHt.get("status"));
                    this.context.getActionLogger().actionPrintln("      " + type + ": " + urn + " " + status);
                }
            }
        }
        if (sliceInfoMap.get("sliceCredentials") != null) {
            List sliceCreds = (List)sliceInfoMap.get("sliceCredentials");
            int i = 0;
            if (sliceCreds != null) {
                for (Object c : sliceCreds) {
                    if (!(c instanceof AnyCredential)) continue;
                    AnyCredential ac = (AnyCredential)c;
                    this.context.getActionLogger().actionPrintln("Slice Credential " + ++i + ":\n" + ac.getCredentialXml() + "\n\nEND SLICE CREDENTIAL\n");
                }
            }
        }
        this.context.getActionLogger().actionJsonOut(sliceInfoMap);
        this.context.getActionLogger().actionYamlOut("SliceInfo", sliceInfoMap);
        LOG.debug("Slice Info returned");
    }

    private void checkRenew(@Nonnull RenewInstruction instruction, @Nonnull Slice slice, @Nonnull Experiment experiment, @Nonnull ExperimentController experimentController, @Nonnull Instant requestedRenewInstant) throws CliExitException, InterruptedException, ExecutionException {
        experimentController.requestUpdate().join();
        boolean renewFailed = false;
        if (ExpirationChecker.isEarlyExpire((Instant)requestedRenewInstant, (Instant)slice.getExpirationDate())) {
            renewFailed = true;
            LOG.error("Renew check failed: slice expires at {} (urn={})", (Object)slice.getExpirationDate(), (Object)slice.getUrnString());
        }
        for (Sliver sliver : slice.getSliversCopy()) {
            if (sliver.isFake() || !ExpirationChecker.isEarlyExpire((Instant)requestedRenewInstant, (Instant)sliver.getExpirationDate())) continue;
            renewFailed = true;
            LOG.error("Renew check failed: sliver on {} expires at {} (urn={})", new Object[]{sliver.getServer().getName(), sliver.getExpirationDate(), sliver.getUrnString()});
        }
        if (renewFailed) {
            LOG.error("Renew check failed. (Sliver does not expire at requested {})", (Object)requestedRenewInstant);
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to Renew slice: When checking after successful renew, the slice is found to be not completely renewed.");
        }
        LOG.info("Renew check success. Expiration is now at {}.", (Object)requestedRenewInstant);
    }

    private void executeRenew(@Nonnull RenewInstruction instruction, @Nonnull Slice slice, @Nonnull Experiment experiment) throws CliExitException {
        LOG.debug("executeRenew " + slice.getUrnString());
        ExperimentControllerFactory experimentControllerFactory = (ExperimentControllerFactory)this.injector.getInstance(ExperimentControllerFactory.class);
        ExperimentController experimentController = experimentControllerFactory.createExperimentController(experiment);
        Instant requestedRenewInstant = Instant.now().plus(instruction.getSlice().getExpireTimeMin(), ChronoUnit.MINUTES);
        CompletableFuture future = experimentController.renew(requestedRenewInstant);
        try {
            ExperimentTaskStatus renewStatus = (ExperimentTaskStatus)future.get();
            HashMap<String, Object> jsonOut = new HashMap<String, Object>();
            jsonOut.put("SliceUrn", slice.getUrnString());
            jsonOut.put("Renew Status", renewStatus.name());
            jsonOut.put("Renew Success", renewStatus == ExperimentTaskStatus.SUCCESS);
            this.context.getActionLogger().actionJsonOut(jsonOut);
            this.context.getActionLogger().actionYamlOut("Renew", jsonOut);
            if (renewStatus != ExperimentTaskStatus.SUCCESS) {
                LOG.error("Renew failed: " + String.valueOf(renewStatus));
                throw new CliExitException(Context.ExitReason.ERROR, "Failed to Renew slice");
            }
            LOG.debug("Renew finished.");
            this.context.getActionLogger().actionPrintln("Renewed: " + slice.getUrnString());
            this.checkRenew(instruction, slice, experiment, experimentController, requestedRenewInstant);
        }
        catch (InterruptedException e) {
            throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for Renew interrupted.");
        }
        catch (ExecutionException e) {
            LOG.error("Failed to renew slice -> Error in experimentController.renew", (Throwable)e);
            HashMap<String, Object> jsonOut = new HashMap<String, Object>();
            jsonOut.put("SliceUrn", slice.getUrnString());
            jsonOut.put("Renew Error", e.getMessage());
            jsonOut.put("Renew Success", false);
            this.context.getActionLogger().actionJsonOut(jsonOut);
            this.context.getActionLogger().actionYamlOut("Renew", jsonOut);
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to Renew slice");
        }
    }

    @Nonnull
    private List<String> getUserProjects(String taskDesc) throws CliExitException {
        ListSubAuthoritiesTask listSubAuthoritiesTask = this.highLevelTaskFactory.listSubAuthorities();
        TaskExecution taskExecution = this.taskThread.addTask((Task)listSubAuthoritiesTask);
        while (!taskExecution.isCompleted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for " + taskDesc + " interrupted.");
            }
        }
        if (taskExecution.getState() != TaskExecution.TaskState.SUCCESS) {
            LOG.error("Failed to " + taskDesc, taskExecution.getException());
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to " + taskDesc);
        }
        if (listSubAuthoritiesTask.getSubAuthNames() == null) {
            return Collections.emptyList();
        }
        return listSubAuthoritiesTask.getSubAuthNames();
    }

    @Nonnull
    private List<GeniUrn> getUserSlices(String taskDesc) throws CliExitException {
        ListSlicesTask listSlicesTask = this.highLevelTaskFactory.listSlices();
        TaskExecution taskExecution = this.taskThread.addTask((Task)listSlicesTask);
        while (!taskExecution.isCompleted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for " + taskDesc + " interrupted.");
            }
        }
        if (taskExecution.getState() != TaskExecution.TaskState.SUCCESS) {
            LOG.error("Failed to " + taskDesc, taskExecution.getException());
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to " + taskDesc);
        }
        if (listSlicesTask.getSlices() == null) {
            return Collections.emptyList();
        }
        return listSlicesTask.getSlices();
    }

    private void executeCreateSlice(@Nonnull CreateSliceInstruction instruction) throws CliExitException {
        String projectName;
        LOG.debug("executeCreateSlice");
        LOG.debug("Getting Slice name and Project");
        String sliceName = instruction.getSlice().getSliceName();
        if (sliceName == null) {
            throw new ArgumentException("Slice name is not allowed to be null");
        }
        switch (instruction.getSlice().getProjectSource()) {
            case AUTO: {
                List<String> projectNames = this.getUserProjects("Create Slice");
                if (projectNames.isEmpty()) {
                    LOG.error("Failed to get a list of user projects");
                    throw new CliExitException(Context.ExitReason.ERROR, "Failed to get a list of projects");
                }
                projectName = projectNames.get(0);
                LOG.debug("Choosing Project " + projectName + " from " + String.valueOf(projectNames));
                break;
            }
            case PROVIDED: {
                projectName = instruction.getSlice().getProject();
                if (projectName != null) break;
                throw new ArgumentException("No project provided to create slice in");
            }
            case NONE: {
                projectName = null;
                break;
            }
            default: {
                throw new CliExitException(Context.ExitReason.ERROR, "unsupported project source: " + String.valueOf(instruction.getSlice().getProjectSource()));
            }
        }
        Instant requestedEndTime = Instant.now().plus(instruction.getSlice().getExpireTimeMin(), ChronoUnit.MINUTES);
        List initialShareWithUsers = Collections.emptyList();
        CreateSliceTask createSliceTask = this.highLevelTaskFactory.createSlice(sliceName, projectName, initialShareWithUsers, requestedEndTime);
        LOG.debug("Creating slice " + sliceName + " in project " + projectName);
        TaskExecution taskExecution = this.taskThread.addTask((Task)createSliceTask);
        while (!taskExecution.isCompleted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for create slice interrupted.");
            }
        }
        if (taskExecution.getState() != TaskExecution.TaskState.SUCCESS) {
            LOG.error("Failed to Create slice", taskExecution.getException());
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to Create slice");
        }
    }

    private void executeSliceCredential(@Nonnull Slice slice) throws CliExitException {
        LOG.debug("executeSliceCredential " + slice.getUrnString());
        List credList = slice.getCredentials().stream().map(AnyCredential::getCredentialXml).collect(Collectors.toList());
        this.context.getActionLogger().actionJsonOut(credList);
        this.context.getActionLogger().actionYamlOut("SliceCredential", credList);
        this.context.getActionLogger().actionPrintln(slice.getCredentials().stream().map(AnyCredential::getCredentialXml).collect(Collectors.joining("\n\n")));
    }

    @Nonnull
    private Server getServerFromAnyId(@Nonnull String anyId) throws CliExitException {
        TestbedInfoSource testbedInfoSource = (TestbedInfoSource)this.injector.getInstance(TestbedInfoSource.class);
        if (anyId.startsWith("urn:publicid")) {
            Server server = testbedInfoSource.getByUrn(anyId, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
            if (server == null) {
                LOG.error("Could not find server with URN \"" + anyId + "\"");
                throw new CliExitException(Context.ExitReason.BAD_ARGS, "Could not find server with URN \"" + anyId + "\"");
            }
            return server;
        }
        Testbed testbed = testbedInfoSource.getTestbedById(anyId);
        if (testbed != null) {
            return testbed.getDefaultServer();
        }
        try {
            int serverId = Integer.parseInt(anyId);
            Server server = testbedInfoSource.getServerById(Integer.valueOf(serverId));
            if (server != null) {
                return server;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOG.error("Could not find server with ID \"" + anyId + "\"");
        throw new CliExitException(Context.ExitReason.BAD_ARGS, "Could not find server with ID \"" + anyId + "\"");
    }

    private void executeListResources(@Nonnull ListResourcesInstruction instruction) throws CliExitException {
        Server server = this.getServerFromAnyId(instruction.getTestbedId());
        GetAdvertisementTask fetchAdvTask = instruction.getAvailable() == Boolean.TRUE ? this.highLevelTaskFactory.getAvailableAdvertisement(server) : this.highLevelTaskFactory.getAllAdvertisement(server);
        TaskExecution taskExecution = this.taskThread.addTask((Task)fetchAdvTask);
        while (!taskExecution.isCompleted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CliExitException(Context.ExitReason.INTERRUPTED, "Wait for " + fetchAdvTask.getName() + " interrupted.");
            }
        }
        if (taskExecution.getState() != TaskExecution.TaskState.SUCCESS) {
            LOG.error("Failed to " + fetchAdvTask.getName(), taskExecution.getException());
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to " + fetchAdvTask.getName());
        }
        String res = fetchAdvTask.getAdvertisementRspecString();
        this.context.getActionLogger().actionJsonOut(res);
        this.context.getActionLogger().actionYamlOut("AdvertisementRSpec", res);
        this.context.getActionLogger().actionPrintln(res);
    }

    private void executeUserInfo(@Nonnull UserInfoInstruction instruction) throws CliExitException {
        LOG.debug("executeUserInfo");
        GeniUser user = (GeniUser)this.injector.getInstance(GeniUser.class);
        String authUrn = user.getUserAuthorityServer() == null ? null : user.getUserAuthorityServer().getDefaultComponentManagerUrn();
        String authName = user.getUserAuthorityServer() == null ? null : user.getUserAuthorityServer().getName();
        List<String> projectNames = this.getUserProjects("fetch user project info");
        if (projectNames.isEmpty()) {
            LOG.error("Failed to get a list of user projects");
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to get a list of projects");
        }
        List<GeniUrn> sliceUrns = this.getUserSlices("fetch user slice info");
        if (sliceUrns.isEmpty()) {
            LOG.error("Failed to get a list of user slices");
            throw new CliExitException(Context.ExitReason.ERROR, "Failed to get a list of slices");
        }
        HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
        userInfoMap.put("urn", user.getUserUrnString());
        userInfoMap.put("auth_urn", authUrn);
        userInfoMap.put("auth_name", authName);
        userInfoMap.put("slices", sliceUrns.stream().map(GeniUrn::toString).collect(Collectors.toList()));
        userInfoMap.put("projects", projectNames);
        this.context.getActionLogger().actionJsonOut(userInfoMap);
        this.context.getActionLogger().actionYamlOut("UserInfo", userInfoMap);
        this.context.getActionLogger().actionPrintln("User Info: ");
        this.context.getActionLogger().actionPrintln("   Urn: " + user.getUserUrnString());
        this.context.getActionLogger().actionPrintln("   Auth Urn: " + authUrn);
        this.context.getActionLogger().actionPrintln("   Auth Name: " + authName);
        this.context.getActionLogger().actionPrintln("   Projects: " + projectNames.stream().collect(Collectors.joining(",")));
        this.context.getActionLogger().actionPrintln("   Slices: " + sliceUrns.stream().map(GeniUrn::toString).collect(Collectors.joining(",")));
    }

    private void executeRun(@Nonnull Context context, @Nonnull RunInstruction instruction) throws CliExitException {
        GeniUrn bindRspecUrn;
        LOG.debug("Executing RunInstruction");
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Preparing Experiment", "position", "pre"));
        Injector injector = context.getInjector();
        AdvertisementRspecSource advertisementRspecSource = null;
        if (instruction.getExperiment().getRequestRSpec() != null && instruction.getExperiment().getRequestRSpec().getSource().isProvide()) {
            ProvidedRequestRSpec pReqRspec = (ProvidedRequestRSpec)instruction.getExperiment().getRequestRSpec();
            if (pReqRspec.getBindUnboundNodesUrn() != null) {
                bindRspecUrn = InstructionExecutor.verifyBindRspecUrn(context, pReqRspec.getBindUnboundNodesUrn(), (AuthorityFinder)injector.getInstance(AuthorityFinder.class));
                context.throwIfExited();
            } else {
                bindRspecUrn = null;
            }
        } else {
            bindRspecUrn = null;
        }
        LOG.debug("Setting up ExperimentSetupHelper");
        ExperimentSetupHelper experimentSetupHelper = new ExperimentSetupHelper("cli", context.getExperimentSetupLogger(), instruction.getExperiment(), null, () -> this.getRSpecGeneratorFactory(injector), advertisementRspecSource, injector);
        try {
            LOG.debug("Fetching RSpec");
            experimentSetupHelper.getRspec(bindRspecUrn == null ? null : bindRspecUrn.toString());
        }
        catch (Exception e) {
            LOG.error("Exception while retrieving request RSpec", (Throwable)e);
            context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Preparing Experiment", "position", "post", "success", false, "exception", IOUtils.exceptionToStacktraceString((Throwable)e)));
            context.exitWithCode(Context.ExitReason.ERROR, "Exception while retrieving request RSpec: " + e.getMessage());
        }
        context.throwIfExited();
        this.logUserInfo();
        LOG.debug("Finding Project");
        experimentSetupHelper.findProject();
        LOG.debug("Getting slice name and SSH Keys");
        String sliceName = instruction.getExperiment().getSlice().getSliceName();
        if (sliceName == null) {
            throw new ArgumentException("Slice name is not allowed to be null");
        }
        List<UserSpec> userSpecs = this.getUserSpecs(instruction.getSshKeys());
        LOG.debug("Creating Experiment");
        experimentSetupHelper.createExperiment(sliceName, userSpecs, !instruction.getSlice().getFailOnNonExistingSlice(), !instruction.getSlice().getFailOnExistingSlice());
        if (instruction.getExperiment().getESpec() != null) {
            ESpecLoggingToOutput especListener = new ESpecLoggingToOutput(context.getActionLogger(), context.geteSpecExecuteOutputLogger());
            experimentSetupHelper.getContext().experiment.addESpecLogListener((ESpecLogListener)especListener);
        }
        if (instruction.getExperiment().getRunLinkTest()) {
            LinkTestResultToOutput linkTestListener = new LinkTestResultToOutput(context.getActionLogger());
            experimentSetupHelper.getContext().experiment.addLinkTestListener((LinkTestListener)linkTestListener);
        }
        experimentSetupHelper.getContext().experiment.getJobReports().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                for (JobReport jobReport : c.getAddedSubList()) {
                    this.writeLiveTextJobReport(jobReport, context.getActionLogger(), LOG);
                }
            }
        });
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Preparing Experiment", "position", "post", "success", true));
        LOG.info("Starting Experiment");
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Start Experiment", "position", "pre"));
        experimentSetupHelper.startExperiment(injector);
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Start Experiment", "position", "post", "success", true));
        LOG.info("Waiting for Experiment readiness");
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Wait For Ready", "position", "pre"));
        while (experimentSetupHelper.mustWaitForExperiment()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new CliExitException(Context.ExitReason.ERROR, "Interrupted");
            }
        }
        LOG.info("Experiment ready wait completed");
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Wait For Ready", "position", "post", "success", true));
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Write Output", "position", "pre"));
        this.writeExperimentOutput(instruction.getOutput(), experimentSetupHelper.getContext().experiment.getSliceOrNull() != null ? experimentSetupHelper.getContext().experiment.getSlice().getManifestRspec() : null);
        context.getActionLogger().actionYamlOut("Run-Step", Map.of("name", "Write Output", "position", "post", "success", true));
        LOG.debug("All done, exiting.");
    }

    private void writeLiveTextJobReport(@Nonnull JobReport jobReport, @Nonnull ActionLogger actionLogger, @Nonnull org.slf4j.Logger LOG) {
        jobReport.getStatelessLogLines().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                for (LogOutput.LogEntry logLine : c.getAddedSubList()) {
                    switch (logLine.getType()) {
                        case TRACE: 
                        case DEBUG: {
                            LOG.debug(logLine.getText());
                            break;
                        }
                        case NOTE: {
                            LOG.info(logLine.getText());
                            break;
                        }
                        case WARN: {
                            LOG.warn(logLine.getText());
                            break;
                        }
                        default: {
                            LOG.error(logLine.getText());
                        }
                    }
                    if (logLine.getExceptionStackTrace() == null) continue;
                    LOG.error(logLine.getExceptionStackTrace());
                }
            }
        });
    }

    private void writeExperimentOutput(@Nonnull RunInstruction.ExperimentOutput output, @Nullable ManifestRspecSource manifestRspecSource) {
        block28: {
            String combinedManifestXmlString = null;
            if (output.getManifestTarget() != null) {
                try {
                    if (manifestRspecSource != null) {
                        combinedManifestXmlString = manifestRspecSource.getRspecXmlString();
                        if (combinedManifestXmlString != null) {
                            if (output.getManifestTarget() != null) {
                                switch (output.getManifestTarget()) {
                                    case FILE: {
                                        LOG.debug("Writing combined manifest to " + output.getManifestLocation());
                                        IOUtils.stringToFile((File)new File(output.getManifestLocation()), (String)combinedManifestXmlString);
                                        break;
                                    }
                                    case STDOUT: {
                                        System.out.println(combinedManifestXmlString);
                                        break;
                                    }
                                    case STDERR: {
                                        System.err.println(combinedManifestXmlString);
                                        break;
                                    }
                                    case DEBUG: {
                                        LOG.info(combinedManifestXmlString);
                                        break;
                                    }
                                    case SOLIDLAB_UPLOAD: {
                                        SolidLabPerftestUploadOutputStream outputStream = new SolidLabPerftestUploadOutputStream(output.getManifestLocation(), "LOG", "manifest RSpec", "Description of which nodes have been used for his test.", "application/xml");
                                        PrintStream ps = new PrintStream(outputStream);
                                        ps.println(combinedManifestXmlString);
                                        ps.close();
                                    }
                                }
                            } else {
                                LOG.debug("Manifest RSpec successfully fetched (not requested to write it)");
                            }
                        } else {
                            LOG.debug("No manifest string RSpec available: not writing manifest RSpec");
                        }
                    } else {
                        LOG.debug("No manifest RSpec available: not writing manifest RSpec");
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception while writing manifest", (Throwable)e);
                }
            }
            if (output.getAnsibleDir() != null) {
                if (combinedManifestXmlString == null) {
                    LOG.warn("Could not write ansible files: manifest RSpec not available");
                } else {
                    try {
                        File ansibleDir = new File(output.getAnsibleDir());
                        if (!ansibleDir.exists()) {
                            boolean created = ansibleDir.mkdir();
                            if (!ansibleDir.exists()) {
                                LOG.error("Could not create ansible dir: \"" + output.getAnsibleDir() + "\"");
                            }
                        }
                        if (!ansibleDir.exists()) break block28;
                        AnsibleFileWriter writer = null;
                        GeniUserProvider geniUserProvider = (GeniUserProvider)this.injector.getInstance(GeniUserProvider.class);
                        GeniUser geniUser = geniUserProvider.getLoggedInGeniUser();
                        if (geniUser.getPrivateKeyFile() != null) {
                            try {
                                String privKey = IOUtils.fileToString((File)geniUser.getPrivateKeyFile());
                                if (!KeyUtil.isPemPrivateKeyEncrypted((String)privKey)) {
                                    writer = AnsibleFileWriter.createWithLinkedPrivateKey((BasicStringRspec)new BasicStringRspec(combinedManifestXmlString), (File)geniUser.getPrivateKeyFile(), (PublicKey)geniUser.getPublicKey(), (GeniUser)geniUser, null, null);
                                }
                            }
                            catch (Exception e) {
                                LOG.error("Exception trying to determine if private key file is encrypted. Safe fallback: Will assume it is.", (Throwable)e);
                                writer = null;
                            }
                        }
                        if (writer == null) {
                            writer = AnsibleFileWriter.createWithCopiedPrivateKey((BasicStringRspec)new BasicStringRspec(combinedManifestXmlString), (PrivateKey)geniUser.getPrivateKey(), (PublicKey)geniUser.getPublicKey(), (GeniUser)geniUser, null, null);
                        }
                        writer.writeFilesToDir(ansibleDir);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while writing ansible dir", (Throwable)e);
                    }
                }
            }
        }
    }

    @Nonnull
    private JFedGuiConfig getGuiConfig(@Nonnull Injector injector) {
        GeniUserProvider geniUserProvider = (GeniUserProvider)injector.getInstance(GeniUserProvider.class);
        Logger logger = (Logger)injector.getInstance(Logger.class);
        TestbedInfoSource testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
        AuthorityFinder authorityFinder = (AuthorityFinder)injector.getInstance(AuthorityFinder.class);
        JFedPreferences jFedPreferences = (JFedPreferences)injector.getInstance(JFedPreferences.class);
        ConnectivityDetector connectivityDetector = (ConnectivityDetector)injector.getInstance(ConnectivityDetector.class);
        UserInfoProvider userInfoProvider = (UserInfoProvider)injector.getInstance(UserInfoProvider.class);
        URL webApiUrl = (URL)injector.getInstance(Key.get(URL.class, (Annotation)Names.named((String)"noClientAuthWebApiUrl")));
        FedmonWebApiClient fedmonWebApiClient = (FedmonWebApiClient)injector.getInstance(FedmonWebApiClient.class);
        if (geniUserProvider == null) {
            throw new NullPointerException("geniUserProvider may not be null");
        }
        JFedExperimenterGuiConfigProvider jFedExperimenterGuiConfigProvider = new JFedExperimenterGuiConfigProvider(geniUserProvider, jFedPreferences, connectivityDetector, userInfoProvider, webApiUrl, logger, false);
        TestbedNodesMapsFetcher testbedNodesMapFetcher = new TestbedNodesMapsFetcher(connectivityDetector);
        JFedGuiConfigImpl res = new JFedGuiConfigImpl(testbedInfoSource, authorityFinder, jFedExperimenterGuiConfigProvider, testbedNodesMapFetcher, fedmonWebApiClient);
        return res;
    }

    @Nonnull
    private RSpecGeneratorFactory getRSpecGeneratorFactory(final @Nonnull Injector injector) {
        final TestbedInfoSource testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
        final AuthorityFinder authorityFinder = (AuthorityFinder)injector.getInstance(AuthorityFinder.class);
        return new RSpecGeneratorFactory(){

            @Nonnull
            public RSpecGenerator createRSpecGenerator() {
                return new GuiConfigRSpecGenerator(InstructionExecutor.this.getGuiConfig(injector), authorityFinder, testbedInfoSource);
            }

            @Nonnull
            public StitchingTestRSpecGenerator createStitchingTestRSpecGenerator() {
                return new GuiConfigStitchingTestRSpecGenerator(InstructionExecutor.this.getGuiConfig(injector), authorityFinder, testbedInfoSource);
            }
        };
    }

    private List<UserSpec> getUserSpecs(RunInstruction.SshKeySource sshKeySource) {
        ArrayList<UserSpec> res = new ArrayList<UserSpec>();
        if (sshKeySource.isUserCert()) {
            List<String> sshKeys = Collections.singletonList(KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)this.context.getUser().getPublicKey()));
            UserSpec userSpec = new UserSpec(this.context.getUser().getUserUrnString(), sshKeys);
            res.add(userSpec);
        }
        if (sshKeySource.isUserKeys()) {
            // empty if block
        }
        if (sshKeySource.isShareWith()) {
            // empty if block
        }
        if (sshKeySource.isRspec()) {
            // empty if block
        }
        if (!sshKeySource.getExtraKeys().isEmpty()) {
            // empty if block
        }
        if (!sshKeySource.getExtraUsernames().isEmpty()) {
            // empty if block
        }
        return res;
    }

    private static GeniUrn verifyBindRspecUrn(@Nonnull Context context, @Nonnull String bindRspecArg, @Nonnull AuthorityFinder authorityFinder) throws CliExitException {
        GeniUrn bindRspecUrn = GeniUrn.parse((String)bindRspecArg);
        if (bindRspecUrn == null) {
            context.exitWithCode(Context.ExitReason.BAD_ARGS, "Error parsing provided component_manager_id URN: " + bindRspecArg);
            return null;
        }
        Server bindRspecAuth = authorityFinder.findByUrn(bindRspecUrn, AuthorityFinder.Purpose.REQUEST_RSPEC);
        if (bindRspecAuth == null) {
            context.exitWithCode(Context.ExitReason.BAD_ARGS, "Error: could not find server matching component_manager_id URN provided by --bind-rspec: " + bindRspecArg);
            return null;
        }
        return bindRspecUrn;
    }

    private static Map<String, Object> addStatusToMap(@Nonnull Map<String, Object> orig, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        HashMap<String, Object> res = new HashMap<String, Object>(orig);
        res.put("status", status.getStatus().name());
        if (status.getMessage() != null) {
            res.put("message", status.getMessage());
        }
        if (status.getThrowable() != null) {
            res.put("exception", IOUtils.exceptionToStacktraceString((Throwable)status.getThrowable()));
        }
        return res;
    }

    private static class LinkTestResultToOutput
    implements LinkTestListener {
        @Nonnull
        private final ActionLogger actionLogger;
        @Nullable
        private List<TestLinksJob.LinkTestReport> reports;
        @Nullable
        private TestLinksJob.LinkTestResult worstResult;

        public LinkTestResultToOutput(@Nonnull ActionLogger actionLogger) {
            this.actionLogger = actionLogger;
        }

        public void onReport(@Nonnull TestLinksJob.LinkTestReport report) {
        }

        public void onAllReports(@Nonnull List<TestLinksJob.LinkTestReport> reports, @Nonnull TestLinksJob.LinkTestResult worstResult) {
            this.reports = reports;
            this.worstResult = worstResult;
            String reportSummaryString = reports.stream().map(TestLinksJob.LinkTestReport::toStringNoSuccessDebug).collect(Collectors.joining("\n"));
            if (worstResult == TestLinksJob.LinkTestResult.SUCCESS) {
                this.actionLogger.actionPrintln("Link Test Result: " + String.valueOf(worstResult));
                LOG.debug("Link Test Reports:\n" + reportSummaryString);
                this.actionLogger.actionYamlOut("LinkTestReport", Map.of("worstResult", worstResult.name(), "reports", reports.stream().map(Object::toString).collect(Collectors.toList())));
            } else {
                this.actionLogger.errorPrintln("Link Test Result: " + String.valueOf(worstResult));
                this.actionLogger.actionPrintln("Link Test Reports:\n" + reportSummaryString);
            }
        }

        @Nullable
        public List<TestLinksJob.LinkTestReport> getReports() {
            return this.reports;
        }

        @Nullable
        public TestLinksJob.LinkTestResult getWorstResult() {
            return this.worstResult;
        }
    }

    private static class ESpecLoggingToOutput
    implements ESpecLogListener {
        @Nonnull
        private final ActionLogger actionLogger;
        @Nonnull
        private final ESpecExecuteOutputLogger eSpecExecuteOutputLogger;

        public ESpecLoggingToOutput(@Nonnull ActionLogger actionLogger, @Nonnull ESpecExecuteOutputLogger eSpecExecuteOutputLogger) {
            this.actionLogger = actionLogger;
            this.eSpecExecuteOutputLogger = eSpecExecuteOutputLogger;
        }

        public void onPreFileLoad() {
            this.actionLogger.actionPrintln("ExperimentSpecification : Start loading files.");
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "FileLoad", "position", "pre"));
        }

        public void onPostFileLoad(@Nonnull FileSource fileSource, boolean isFast, long byteSize, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                this.actionLogger.errorPrintln("ExperimentSpecification : Failed to load file \"" + fileSource.getBasename() + "\"", status.getThrowable());
                this.actionLogger.actionYamlOut("ESpec-step", InstructionExecutor.addStatusToMap(Map.of("name", "FileLoad", "position", "inter"), status));
            } else if (!isFast) {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully loaded file \"" + fileSource.getBasename() + "\" (" + byteSize + " byte)");
            }
        }

        public void onPostFileLoadAll(boolean success) {
            if (!success) {
                this.actionLogger.errorPrintln("ExperimentSpecification : Failed to load all files.");
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully finished loading files.");
            }
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "FileLoad", "position", "post", "success", success));
        }

        public void onPreRSpec() {
            this.actionLogger.actionPrintln("ExperimentSpecification : Start Provisioning RSpec.");
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "RSpec", "position", "pre"));
        }

        public void onRequestRSpecKnown(@Nonnull RspecSpec rspecSpec, @Nonnull String requestRspec) {
            this.actionLogger.actionPrintln("ExperimentSpecification : Request RSpec known:\n" + requestRspec);
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "RSpec", "position", "inter", "status", "SUCCESS", "requestRspec", requestRspec));
        }

        public void onPostRSpec(@Nonnull RspecSpec rspec, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                this.actionLogger.errorPrintln("Failed setting up experiment resources", status.getThrowable());
                this.actionLogger.actionYamlOut("ESpec-step", InstructionExecutor.addStatusToMap(Map.of("name", "Rspec", "position", "inter"), status));
            }
        }

        public void onPostRspecAll(boolean success, @Nonnull List<String> allNodeClientIds) {
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "RSpec", "position", "post", "success", success, "allNodeClientIds", allNodeClientIds));
            if (!success) {
                this.actionLogger.errorPrintln("ExperimentSpecification : Failed to Provision RSpec");
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully Provisioned RSpec with nodes " + allNodeClientIds.stream().collect(Collectors.joining()));
            }
        }

        public void onPreDir() {
            this.actionLogger.actionPrintln("ExperimentSpecification : Start dir setup.");
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Dir", "position", "pre"));
        }

        public void onPreDirNode(@Nonnull String nodeClientId) {
        }

        public void onPreDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        }

        public void onPostDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                this.actionLogger.errorPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Failed to setup dir at \"" + fullPath + "\"", status.getThrowable());
                this.actionLogger.actionYamlOut("ESpec-step", InstructionExecutor.addStatusToMap(Map.of("name", "Dir", "position", "inter"), status));
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Successfully setup dir at \"" + fullPath + "\"");
            }
        }

        public void onPostDirNode(@Nonnull String nodeClientId, boolean success) {
        }

        public void onPostDirAll(boolean success) {
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Dir", "position", "post", "success", success));
            if (!success) {
                this.actionLogger.errorPrintln("ExperimentSpecification : Failed to setup dirs");
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully setup dirs");
            }
        }

        public void onPreUpload() {
            this.actionLogger.actionPrintln("ExperimentSpecification : Start upload(s).");
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Upload", "position", "pre"));
        }

        public void onPreUploadNode(@Nonnull String nodeClientId) {
        }

        public void onPreUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull UploadProgressTracker uploadProgressTracker) {
            this.actionLogger.actionYamlOut("ESpec-Upload-step", Map.of("name", uploadSpec.getPath() != null ? uploadSpec.getPath() : fullPath, "position", "pre", "fullPath", fullPath, "nodeClientId", nodeClientId));
        }

        public void onPostUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.actionLogger.actionYamlOut("ESpec-Upload-step", InstructionExecutor.addStatusToMap(Map.of("name", uploadSpec.getPath() != null ? uploadSpec.getPath() : fullPath, "position", "post", "fullPath", fullPath, "nodeClientId", nodeClientId), status));
            if (status.isFailure()) {
                this.actionLogger.errorPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Failed to upload file \"" + uploadSpec.getDesc() + "\" at \"" + fullPath + "\"");
                this.actionLogger.actionYamlOut("ESpec-step", InstructionExecutor.addStatusToMap(Map.of("name", "Upload", "position", "inter"), status));
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Successfully uploaded file \"" + uploadSpec.getDesc() + "\" at \"" + fullPath + "\"");
            }
        }

        public void onPostUploadNode(@Nonnull String nodeClientId, boolean success) {
        }

        public void onPostUploadAll(boolean success) {
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Upload", "position", "post", "success", success));
            if (!success) {
                this.actionLogger.errorPrintln("ExperimentSpecification : Failed to upload at least one file to one node");
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully uploaded files");
            }
        }

        public void onPreExecute() {
            this.actionLogger.actionPrintln("ExperimentSpecification : Start execute(s).");
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Execute", "position", "pre"));
        }

        public void onPreExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullExecutablePath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
            this.eSpecExecuteOutputLogger.addLiveLog(fullExecutablePath, fullLogPath, nodeClientId, currentLog);
            this.actionLogger.actionYamlOut("ESpec-Execute-step", Map.of("name", executeSpec.getPath() != null ? executeSpec.getPath() : fullExecutablePath, "position", "pre", "fullExecutablePath", fullExecutablePath, "fullLogPath", fullLogPath, "nodeClientId", nodeClientId));
        }

        public void onPostExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, int exitStatus, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.actionLogger.actionYamlOut("ESpec-Execute-step", InstructionExecutor.addStatusToMap(Map.of("name", executeSpec.getPath() != null ? executeSpec.getPath() : fullPath, "position", "post", "fullExecutablePath", fullPath, "fullLogPath", fullLogPath == null ? "none" : fullLogPath, "nodeClientId", nodeClientId, "exitStatus", exitStatus), status));
            if (status.isFailure()) {
                this.actionLogger.errorPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Failed to execute script \"" + executeSpec.getDesc() + "\" at \"" + fullPath + "\" exitStatus=" + exitStatus, status.getThrowable());
                this.actionLogger.actionYamlOut("ESpec-step", InstructionExecutor.addStatusToMap(Map.of("name", "Execute", "position", "inter", "fullPath", fullPath, "fullLogPath", fullLogPath == null ? "none" : fullLogPath, "nodeClientId", nodeClientId, "exitStatus", exitStatus), status));
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Successfully executed script \"" + executeSpec.getDesc() + "\" at \"" + fullPath + "\" exitStatus=" + exitStatus);
            }
            this.eSpecExecuteOutputLogger.removeLiveLog(fullPath, fullLogPath, nodeClientId);
        }

        public void onPostExecuteStepAll(@Nonnull ExecuteSpec executeSpec, boolean success) {
            if (!success) {
                this.actionLogger.errorPrintln("ExperimentSpecification : Failed to execute script \"" + executeSpec.getDesc() + "\" on at least one node");
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully executed script \"" + executeSpec.getDesc() + "\" on all nodes");
            }
        }

        public void onPostExecuteAll(boolean success) {
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Execute", "position", "post", "success", success));
            if (!success) {
                this.actionLogger.errorPrintln("ExperimentSpecification : Failed to execute at least one script on at least one node");
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully executed all scripts");
            }
        }

        public void onPreAnsible() {
            this.actionLogger.actionPrintln("ExperimentSpecification : Start ansible(s).");
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Ansible", "position", "pre"));
        }

        public void onPreAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPlaybookPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
            this.actionLogger.actionYamlOut("ESpec-Ansible-step", Map.of("name", ansiblePlaybookSpec.getPath() != null ? ansiblePlaybookSpec.getPath() : fullPlaybookPath, "position", "pre", "fullPlaybookPath", fullPlaybookPath, "fullLogPath", fullLogPath == null ? "none" : fullLogPath, "nodeClientId", nodeClientId));
        }

        public void onPostAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.actionLogger.actionYamlOut("ESpec-Ansible-step", InstructionExecutor.addStatusToMap(Map.of("name", ansiblePlaybookSpec.getPath() != null ? ansiblePlaybookSpec.getPath() : fullPath, "position", "post", "fullPlaybookPath", fullPath, "fullLogPath", fullLogPath == null ? "none" : fullLogPath, "nodeClientId", nodeClientId), status));
            if (status.isFailure()) {
                this.actionLogger.actionPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Failed to execute ansible playbook \"" + ansiblePlaybookSpec.getDesc() + "\" at \"" + fullPath + "\"" + (String)(status.getThrowable() == null ? "" : ": " + IOUtils.exceptionToStacktraceString((Throwable)status.getThrowable())));
                this.actionLogger.actionYamlOut("ESpec-step", InstructionExecutor.addStatusToMap(Map.of("name", "Ansible", "position", "inter", "status", status.getStatus().name(), "fullPath", fullPath, "fullLogPath", fullLogPath == null ? "none" : fullLogPath, "nodeClientId", nodeClientId), status));
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : (on \"" + nodeClientId + "\") Successfully executed ansible playbook \"" + ansiblePlaybookSpec.getDesc() + "\" at \"" + fullPath + "\"");
            }
        }

        public void onPostAnsibleAll(boolean success) {
            this.actionLogger.actionYamlOut("ESpec-step", Map.of("name", "Ansible", "position", "post", "success", success));
            if (!success) {
                this.actionLogger.actionPrintln("ExperimentSpecification : Failed to ansible at least one script on at least one node");
            } else {
                this.actionLogger.actionPrintln("ExperimentSpecification : Successfully ansibled all scripts");
            }
        }
    }

    private static class ESpecLoggingCounter
    implements ESpecLogListener {
        @Nonnull
        private Map<String, Integer> counts = new HashMap<String, Integer>();

        private void inc(@Nonnull String type, boolean failure) {
            String key = type + (failure ? "-fail" : "-ok");
            this.counts.compute(key, (k, v) -> v == null ? 1 : v + 1);
        }

        public void onPreFileLoad() {
        }

        public void onPostFileLoad(@Nonnull FileSource fileSource, boolean isFast, long byteSize, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.inc("upload", status.isFailure());
        }

        public void onPostFileLoadAll(boolean success) {
        }

        public void onPreRSpec() {
        }

        public void onRequestRSpecKnown(@Nonnull RspecSpec rspecSpec, @Nonnull String requestRspec) {
        }

        public void onPostRSpec(@Nonnull RspecSpec rspec, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.inc("rspec", status.isFailure());
        }

        public void onPostRspecAll(boolean success, @Nonnull List<String> allNodeClientIds) {
        }

        public void onPreDir() {
        }

        public void onPreDirNode(@Nonnull String nodeClientId) {
        }

        public void onPreDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        }

        public void onPostDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.inc("dir", status.isFailure());
        }

        public void onPostDirNode(@Nonnull String nodeClientId, boolean success) {
        }

        public void onPostDirAll(boolean success) {
        }

        public void onPreUpload() {
        }

        public void onPreUploadNode(@Nonnull String nodeClientId) {
        }

        public void onPreUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull UploadProgressTracker uploadProgressTracker) {
        }

        public void onPostUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.inc("upload", status.isFailure());
        }

        public void onPostUploadNode(@Nonnull String nodeClientId, boolean success) {
        }

        public void onPostUploadAll(boolean success) {
        }

        public void onPreExecute() {
        }

        public void onPreExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullExecutablePath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        }

        public void onPostExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, int exitStatus, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.inc("execute", status.isFailure());
        }

        public void onPostExecuteStepAll(@Nonnull ExecuteSpec executeSpec, boolean success) {
        }

        public void onPostExecuteAll(boolean success) {
        }

        public void onPreAnsible() {
        }

        public void onPreAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPlaybookPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        }

        public void onPostAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.inc("ansible", status.isFailure());
        }

        public void onPostAnsibleAll(boolean success) {
        }

        @Nonnull
        public Map<String, Integer> getCounts() {
            return this.counts;
        }
    }
}

