/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2;

import be.iminds.ilabt.jfed.ui.cli2.instruction.CreateSliceInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CredentialInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DeleteInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ListResourcesInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ManifestInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.PoaInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RenewInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RunInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceActionInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceInfoInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshExecInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshFetchInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshShellInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.UserInfoInstruction;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionParser {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionParser.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Nonnull
    public Instruction parse(Instruction.Action action, @Nonnull Map instructionMap) {
        Class targetClass = switch (action) {
            case Instruction.Action.RUN -> RunInstruction.class;
            case Instruction.Action.CREATESLICE -> CreateSliceInstruction.class;
            case Instruction.Action.SLICEINFO -> SliceInfoInstruction.class;
            case Instruction.Action.SLICEACTION -> SliceActionInstruction.class;
            case Instruction.Action.USERINFO -> UserInfoInstruction.class;
            case Instruction.Action.MANIFEST -> ManifestInstruction.class;
            case Instruction.Action.SLICECREDENTIAL -> CredentialInstruction.class;
            case Instruction.Action.DELETE -> DeleteInstruction.class;
            case Instruction.Action.RENEW -> RenewInstruction.class;
            case Instruction.Action.POA -> PoaInstruction.class;
            case Instruction.Action.SSHLOGIN -> SshShellInstruction.class;
            case Instruction.Action.SSHEXEC -> SshExecInstruction.class;
            case Instruction.Action.SSHFETCH -> SshFetchInstruction.class;
            case Instruction.Action.LISTRESOURCES -> ListResourcesInstruction.class;
            default -> throw new RuntimeException("Support for action \"" + String.valueOf((Object)action) + "\" is not impemented.");
        };
        String actionInMap = String.valueOf(instructionMap.get("action"));
        LOG.debug("Trying to parse action " + String.valueOf((Object)action) + " to " + String.valueOf(targetClass) + "  (action in map is " + actionInMap + ")");
        Instruction res = (Instruction)MAPPER.convertValue((Object)instructionMap, targetClass);
        assert (res != null);
        return res;
    }
}

