/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTaskInteraction;
import be.iminds.ilabt.jfed.ui.cli2.Context;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverSliceTaskCliInteraction
implements RecoverSliceTaskInteraction {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverSliceTaskCliInteraction.class);
    @Nonnull
    private final Context context;
    private Experiment experiment;

    public RecoverSliceTaskCliInteraction(@Nonnull Context context) {
        this.context = context;
    }

    public void onCouldNotRetrieve(@Nullable Throwable exception) {
        LOG.error("Could not retrieve slice", exception);
        this.context.getActionLogger().errorPrintln("Could not retrieve slice");
    }

    public void onUnknownAuthoritiesDetected(@Nonnull String sliceName, @Nonnull List<GeniUrn> unknownAuthorities) throws InterruptedException {
        String auths = unknownAuthorities.stream().map(GeniUrn::toString).collect(Collectors.joining(", "));
        LOG.error("Unknown Authorities Detected: " + auths);
        this.context.getActionLogger().errorPrintln("Unknown Authorities Detected: " + auths);
    }

    public boolean onNoActiveResources(@Nonnull String sliceName) throws InterruptedException {
        LOG.error("No active resources for " + sliceName);
        this.context.getActionLogger().errorPrintln("No active resources for " + sliceName);
        return false;
    }

    @Nonnull
    public Optional<Set<Server>> requestAuthorities() throws InterruptedException {
        return Optional.empty();
    }

    public void onCouldNotFindInfoWhenUserSelected(@Nonnull String sliceName) throws InterruptedException {
        LOG.error("Could not find active resources on the authorities in the provided manifest RSpec for " + sliceName);
        this.context.getActionLogger().errorPrintln("Could not find active resources on the authorities in the provided manifest RSpec for " + sliceName);
    }

    public void onCouldNotFindInfoWhenAutoSelected(@Nonnull String sliceName, @Nonnull Set<Server> allInvolvedAuthorities) {
        String serverNames = allInvolvedAuthorities.stream().map(Server::getName).collect(Collectors.toList()).toString();
        LOG.error("Could not find information about " + sliceName + " on the involved testbeds: " + serverNames);
        this.context.getActionLogger().errorPrintln("Could not find information about " + sliceName + " on the involved testbeds: " + serverNames);
    }

    public void onFinalFailed(@Nonnull String sliceName, @Nullable String message, @Nullable Throwable exception) {
        LOG.error("Recover failed for " + sliceName + ": " + message, exception);
        this.context.getActionLogger().errorPrintln("Recover failed for " + sliceName + ": " + message);
    }

    public void onFinalSucces(@Nonnull Experiment experiment) {
        LOG.info("Successfully recovered experiment");
        this.experiment = experiment;
    }

    @Nullable
    public Experiment getExperiment() {
        return this.experiment;
    }
}

