/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JSonHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolidLabPerftestUploadOutputStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolidLabPerftestUploadOutputStream.class);
    @Nonnull
    private final String artifactUploadUrl;
    @Nullable
    private final String artifactAuthToken;
    @Nullable
    private final String artifactExtraId;
    @Nonnull
    private final String attachType;
    @Nonnull
    private final String subType;
    @Nonnull
    private final String description;
    @Nonnull
    private final String contentType;
    @Nonnull
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    @Nonnull
    private static final ExecutorService uploadExecutor = Executors.newSingleThreadExecutor();
    @Nonnull
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    @Nonnull
    private final ScheduledFuture<?> periodicUpload;
    private long lastWrite = 0L;
    private long lastUpload = 0L;
    private long bytesQueuedForUpload = 0L;
    private boolean closed = false;
    @Nullable
    private String appendUrl = null;

    @Nonnull
    private static String validateArtifactUploadUrl(@Nonnull String artifactUploadUrl) {
        if (!((String)artifactUploadUrl).startsWith("http://") && !((String)artifactUploadUrl).startsWith("https://")) {
            throw new IllegalArgumentException("artifactUploadUrl \"" + (String)artifactUploadUrl + "\" is not valid (not an URL)");
        }
        if (!(((String)artifactUploadUrl).contains("/experiment/") || ((String)artifactUploadUrl).contains("/testenv/") || ((String)artifactUploadUrl).contains("/perftest/"))) {
            throw new IllegalArgumentException("artifactUploadUrl \"" + (String)artifactUploadUrl + "\" is not valid (missing object)");
        }
        if (!((String)artifactUploadUrl).endsWith("/")) {
            artifactUploadUrl = (String)artifactUploadUrl + "/";
        }
        if (((String)artifactUploadUrl).endsWith("/experiment/") || ((String)artifactUploadUrl).endsWith("/testenv/") || ((String)artifactUploadUrl).endsWith("/perftest/")) {
            throw new IllegalArgumentException("artifactUploadUrl \"" + (String)artifactUploadUrl + "\" is not valid (missing object ID)");
        }
        if (!((String)artifactUploadUrl).endsWith("/artifact/")) {
            artifactUploadUrl = (String)artifactUploadUrl + "artifact/";
        }
        return ((String)artifactUploadUrl).substring(0, ((String)artifactUploadUrl).length() - 1);
    }

    public SolidLabPerftestUploadOutputStream(@Nonnull String location, @Nonnull String attachType, @Nonnull String subType, @Nonnull String description, @Nonnull String contentType) {
        String[] locationParts = location.strip().split(" ");
        if (locationParts.length == 1) {
            this.artifactUploadUrl = SolidLabPerftestUploadOutputStream.validateArtifactUploadUrl(locationParts[0]);
            this.artifactAuthToken = null;
            this.artifactExtraId = null;
        } else if (locationParts.length == 2) {
            this.artifactUploadUrl = SolidLabPerftestUploadOutputStream.validateArtifactUploadUrl(locationParts[0]);
            this.artifactAuthToken = locationParts[1];
            this.artifactExtraId = null;
        } else if (locationParts.length == 3) {
            this.artifactUploadUrl = SolidLabPerftestUploadOutputStream.validateArtifactUploadUrl(locationParts[0]);
            this.artifactAuthToken = locationParts[1];
            this.artifactExtraId = locationParts[2];
        } else {
            throw new IllegalArgumentException("location is not a valid artifact location: '" + location + "'");
        }
        this.attachType = attachType;
        this.subType = subType;
        this.description = this.artifactExtraId != null ? description + " (CLI run ID " + this.artifactExtraId + ")" : description;
        this.contentType = contentType;
        this.periodicUpload = scheduler.scheduleWithFixedDelay(this::triggerUpload, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerUpload() {
        long now = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = this.buffer;
        synchronized (byteArrayOutputStream) {
            if (this.lastUpload == 0L) {
                this.lastUpload = this.lastWrite - 1000L;
            }
            if (this.lastWrite >= this.lastUpload && now - this.lastUpload > 2000L && this.buffer.size() > 0) {
                this.lastUpload = now;
                this.addUpload();
            } else {
                LOGGER.trace("nothing to upload now lw=" + this.lastWrite + " lu=" + this.lastUpload + " n=" + now + " n-w=" + (now - this.lastWrite) + " s=" + this.buffer.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.buffer;
        synchronized (byteArrayOutputStream) {
            this.buffer.write(b);
            this.lastWrite = System.currentTimeMillis();
            this.triggerUpload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.buffer;
        synchronized (byteArrayOutputStream) {
            this.buffer.write(b, off, len);
            this.lastWrite = System.currentTimeMillis();
            this.triggerUpload();
            LOGGER.trace("wrote " + len + " bytes");
        }
    }

    public void upload(@Nonnull Upload upload) {
        try {
            HttpClientBuilder clientBuilder = HttpClients.custom();
            clientBuilder.setUserAgent("jFedCLI2");
            clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(3000).build());
            CloseableHttpClient httpclient = clientBuilder.build();
            if (upload.startByte == 0L) {
                String s;
                HttpPost call = new HttpPost(this.artifactUploadUrl);
                call.addHeader("Accept", "application/json");
                call.setHeader("Content-Type", this.contentType);
                call.setHeader("X-Solidlab-Artifact-Type", this.attachType);
                call.setHeader("X-Solidlab-Artifact-Subtype", this.subType);
                call.setHeader("X-Solidlab-Artifact-Description", this.description);
                if (this.artifactAuthToken != null) {
                    call.setHeader("X-Solidlab-Perftest-Auth", this.artifactAuthToken);
                }
                call.setEntity((HttpEntity)new ByteArrayEntity(upload.content));
                LOGGER.debug("Executing POST with " + upload.content.length + " bytes in body");
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)call);
                LOGGER.debug("POST reply status = " + response.getStatusLine().getStatusCode());
                HttpEntity entity = response.getEntity();
                String string = s = entity != null ? IOUtils.streamToString((InputStream)entity.getContent(), (String)"UTF-8") : null;
                if (entity != null) {
                    EntityUtils.consume((HttpEntity)entity);
                }
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                    String authInfo = this.artifactAuthToken == null ? " without X-Solidlab-Perftest-Auth" : " with X-Solidlab-Perftest-Auth starting with " + this.artifactAuthToken.substring(0, 10);
                    throw new IOException("Got error reply for /artifact POST (" + this.artifactUploadUrl + " " + authInfo + "): " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + " body=" + s);
                }
                Object o = JSonHelper.jsonStringToXmlRpcLikeObject((String)s);
                if (!(o instanceof Map)) {
                    throw new IOException("Got invalid reply for /artifact POST (" + this.artifactUploadUrl + "): " + s);
                }
                Map j = (Map)o;
                String artifactObjUrl = (String)j.get("@id");
                this.appendUrl = (String)j.get("data");
                if (!this.appendUrl.startsWith("https://") && !this.appendUrl.startsWith("http://") || !this.appendUrl.endsWith("/data")) {
                    throw new IOException("Got invalid reply for /artifact POST (" + this.artifactUploadUrl + "): " + s);
                }
                LOGGER.debug("POST reply appendUrl = " + this.appendUrl);
            } else {
                HttpPatch call = new HttpPatch(this.appendUrl);
                call.addHeader("Accept", "*/*");
                call.setHeader("Content-Type", this.contentType);
                call.setHeader("X-Update-Range", upload.startByte + "-");
                if (this.artifactAuthToken != null) {
                    call.setHeader("X-Solidlab-Perftest-Auth", this.artifactAuthToken);
                }
                call.setEntity((HttpEntity)new ByteArrayEntity(upload.content));
                LOGGER.debug("Executing PATCH with " + upload.content.length + " bytes in body");
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)call);
                LOGGER.debug("PATCH reply status = " + response.getStatusLine().getStatusCode());
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                    String s;
                    HttpEntity entity = response.getEntity();
                    String string = s = entity != null ? IOUtils.streamToString((InputStream)entity.getContent(), (String)"UTF-8") : null;
                    if (entity != null) {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                    String authInfo = this.artifactAuthToken == null ? " without X-Solidlab-Perftest-Auth" : " with X-Solidlab-Perftest-Auth starting with " + this.artifactAuthToken.substring(0, 10);
                    throw new IOException("Got error reply for /artifact PATCH (" + this.appendUrl + authInfo + "): " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + " body=" + s);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Will ignore error uploading logs", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpload() {
        ByteArrayOutputStream byteArrayOutputStream = this.buffer;
        synchronized (byteArrayOutputStream) {
            if (this.buffer.size() > 0) {
                LOGGER.debug("submitting upload of " + this.buffer.size() + " bytes");
                byte[] content = this.buffer.toByteArray();
                this.buffer.reset();
                Upload upload = new Upload(this.bytesQueuedForUpload, content);
                this.bytesQueuedForUpload += (long)content.length;
                ExecutorService executorService = uploadExecutor;
                synchronized (executorService) {
                    uploadExecutor.submit(() -> this.upload(upload));
                }
            } else {
                LOGGER.trace("nothing to upload");
            }
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.buffer.flush();
        this.addUpload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.periodicUpload.cancel(false);
            while (!this.periodicUpload.isCancelled()) {
                LOGGER.warn("Waiting for SolidLabUploadOutputStream periodicUpload.isCancelled");
                Thread.sleep(20L);
                this.periodicUpload.cancel(false);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ByteArrayOutputStream byteArrayOutputStream = this.buffer;
        synchronized (byteArrayOutputStream) {
            if (this.closed) {
                return;
            }
            LOGGER.debug("Closing SolidLabUploadOutputStream");
            this.closed = true;
            super.close();
            this.buffer.close();
            this.addUpload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        scheduler.shutdown();
        ExecutorService executorService = uploadExecutor;
        synchronized (executorService) {
            uploadExecutor.shutdown();
        }
        while (!uploadExecutor.isTerminated()) {
            try {
                uploadExecutor.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static class Upload {
        private final long startByte;
        public final byte[] content;

        public Upload(long startByte, byte[] content) {
            this.startByte = startByte;
            this.content = content;
        }
    }
}

