/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.instruction;

import be.iminds.ilabt.jfed.ui.cli2.instruction.OutputTarget;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ActionOutput {
    @Nonnull
    public final Format format;
    @Nonnull
    public final OutputTarget target;
    @Nullable
    public final String location;

    public ActionOutput(@JsonProperty(value="format") @Nullable Format format, @JsonProperty(value="target") @Nullable OutputTarget target, @JsonAlias(value={"filename"}) @JsonProperty(value="location") @Nullable String location) {
        this.format = format == null ? new ActionOutput().format : format;
        this.target = target == null ? new ActionOutput().target : target;
        this.location = location;
    }

    public ActionOutput() {
        this.format = Format.JSON;
        this.target = OutputTarget.STDOUT;
        this.location = null;
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    @Nonnull
    public OutputTarget getTarget() {
        return this.target;
    }

    @Nullable
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public static enum Format {
        TXT("text", "text/plain"),
        JSON(null, "application/json"),
        YAML(null, "application/yaml");

        @Nullable
        private final String altname;
        @Nonnull
        private final String contentType;

        private Format(String altname, String contentType) {
            this.altname = altname;
            this.contentType = contentType;
        }

        public boolean matches(@Nonnull String value) {
            if (value.equalsIgnoreCase(this.name())) {
                return true;
            }
            return value.equalsIgnoreCase(this.altname);
        }

        @JsonCreator
        public static Format parse(@Nonnull String value) {
            return Arrays.stream(Format.values()).filter(m -> m.matches(value)).findAny().orElseThrow(() -> new IllegalArgumentException("Format not known: " + value));
        }

        @Nonnull
        public String getContentType() {
            return this.contentType;
        }
    }
}

