/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.instruction;

import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DebugOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.InstructionTypeIdResolver;
import be.iminds.ilabt.jfed.ui.cli2.instruction.User;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="action", defaultImpl=JsonTypeInfo.class, visible=true)
@JsonTypeIdResolver(value=InstructionTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(value={"@context"})
public abstract class Instruction {
    private static final Logger LOG = LoggerFactory.getLogger(Instruction.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    @Nonnull
    private final Action action;
    @Nonnull
    private final User user;
    @Nonnull
    private final List<ActionOutput> actionOutputs;
    @Nonnull
    private final List<DebugOutput> debugOutputs;
    @Nonnull
    private final List<CallOutput> callOutputs;
    @Nonnull
    private final ProxySettings proxy;
    @JsonIgnore
    public static final List<String> ACTION_OPTIONS = Arrays.asList("ReloadOS", "Restart", "ConsoleUrl");

    @JsonCreator
    public Instruction(@JsonProperty(value="action") @Nonnull Action action, @JsonProperty(value="user") @Nullable User user, @JsonProperty(value="actionOutputs") @Nullable List<ActionOutput> actionOutputs, @JsonProperty(value="debugOutputs") @Nullable List<DebugOutput> debugOutputs, @JsonProperty(value="callOutputs") @Nullable List<CallOutput> callOutputs, @JsonProperty(value="proxy") @Nullable ProxySettings proxy) {
        assert (action == this.getActionOfClass()) : String.valueOf((Object)action) + " != " + String.valueOf((Object)this.getActionOfClass());
        this.action = action;
        this.user = user == null ? new User() : user;
        this.actionOutputs = actionOutputs == null ? Collections.emptyList() : actionOutputs;
        this.debugOutputs = debugOutputs == null ? Collections.emptyList() : debugOutputs;
        this.callOutputs = callOutputs == null ? Collections.emptyList() : callOutputs;
        this.proxy = proxy == null ? new ProxySettings() : proxy;
    }

    protected Instruction(@Nonnull Action action, boolean demo) {
        this(action, demo ? new User(Collections.singletonList("user.pem"), User.PasswordMethod.DIRECT, "my_pem_password", action == Action.RUN ? Collections.emptyList() : null) : new User(), null, null, null, new ProxySettings());
    }

    @JsonProperty
    @Nonnull
    public Action getAction() {
        return this.action;
    }

    @JsonIgnore
    @Nonnull
    protected abstract Action getActionOfClass();

    @JsonProperty
    @Nonnull
    public User getUser() {
        return this.user;
    }

    @JsonProperty
    @Nonnull
    public List<ActionOutput> getActionOutputs() {
        return this.actionOutputs;
    }

    @JsonProperty
    @Nonnull
    public List<DebugOutput> getDebugOutputs() {
        return this.debugOutputs;
    }

    @JsonProperty
    @Nonnull
    public List<CallOutput> getCallOutputs() {
        return this.callOutputs;
    }

    @JsonProperty(value="proxy")
    @Nonnull
    public ProxySettings getProxy() {
        return this.proxy;
    }

    @JsonIgnore
    public static List<String> getActionOptions() {
        return ACTION_OPTIONS;
    }

    public String toString() {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Instruction " + String.valueOf((Object)this.action) + " to JSON", (Throwable)e);
            return "Exception converting Instruction " + String.valueOf((Object)this.action) + " to JSON: " + e.getMessage();
        }
    }

    public static enum Action {
        RUN(true, "run", new String[0]),
        CREATESLICE(true, "createSlice", new String[0]),
        POA(true, "performOperationalAction", "poa"),
        RENEW(true, "renew", new String[0]),
        DELETE(true, "delete", new String[0]),
        USERINFO(false, "userinfo", new String[0]),
        SLICEINFO(true, "sliceinfo", new String[0]),
        SLICEACTION(true, "sliceaction", new String[0]),
        SLICECREDENTIAL(true, "sliceCredential", new String[0]),
        MANIFEST(true, "manifest", new String[0]),
        DECRYPTPEM(false, "decrypt", new String[0]),
        LISTRESOURCES(false, "ListResources", new String[0]),
        SSHLOGIN(true, "login", "ssh", "sshlogin", "sshshell", "shell"),
        SSHEXEC(true, "exec", "sshexec"),
        SSHFETCH(true, "fetch", "sshfetch");

        @Nonnull
        private final String niceName;
        @Nonnull
        private final List<String> aliases;
        private final boolean requireSlice;

        private Action(boolean requireSlice, String niceName, String ... aliases) {
            this.requireSlice = requireSlice;
            this.niceName = niceName;
            this.aliases = Arrays.asList(aliases);
        }

        @JsonCreator
        @Nonnull
        public static Action createFromString(@Nonnull String val) {
            for (Action action : Action.values()) {
                if (!action.matches(val)) continue;
                return action;
            }
            throw new RuntimeException("Unknown action: \"" + val + "\"");
        }

        @Nonnull
        public static String canonize(@Nonnull String s) {
            return s.trim().replaceAll("[-_ ]?", "").toLowerCase();
        }

        public boolean matches(@Nonnull String cliAction) {
            String canonizedCliAction = Action.canonize(cliAction);
            if (Action.canonize(this.niceName).equalsIgnoreCase(canonizedCliAction)) {
                return true;
            }
            for (String alias : this.aliases) {
                if (!Action.canonize(alias).equalsIgnoreCase(canonizedCliAction)) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public List<String> getAliases() {
            return this.aliases;
        }

        @Nonnull
        public String getNiceName() {
            return this.niceName;
        }

        public boolean isSliceArgSupported() {
            return this.requireSlice;
        }

        @Nullable
        public static Action parse(@Nonnull String cliCommand) {
            if (cliCommand == null) {
                throw new NullPointerException("Action.parse requires a non null argument");
            }
            for (Action action : Action.values()) {
                if (!action.matches(cliCommand)) continue;
                return action;
            }
            return null;
        }
    }

    public static class ProxySettings {
        @Nullable
        private final Boolean useForCalls;
        @Nullable
        private final Boolean useForSsh;

        @JsonCreator
        public ProxySettings(@JsonProperty(value="useForCalls") @Nullable Boolean useForCalls, @JsonProperty(value="useForSsh") @Nullable Boolean useForSsh) {
            this.useForCalls = useForCalls;
            this.useForSsh = useForSsh;
        }

        public ProxySettings() {
            this.useForCalls = null;
            this.useForSsh = null;
        }

        @JsonProperty(value="useForCalls")
        @Nullable
        public Boolean getUseForCalls() {
            return this.useForCalls;
        }

        @JsonProperty(value="useForSsh")
        @Nullable
        public Boolean getUseForSsh() {
            return this.useForSsh;
        }
    }
}

