/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.instruction;

import be.iminds.ilabt.jfed.ui.cli2.instruction.CreateSliceInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CredentialInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DeleteInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ListResourcesInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ManifestInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.PoaInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RenewInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RunInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceActionInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceInfoInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshExecInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshFetchInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshShellInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.UserInfoInstruction;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.util.Arrays;
import java.util.stream.Collectors;

public class InstructionTypeIdResolver
extends TypeIdResolverBase {
    public String idFromValue(Object o) {
        return ((Instruction)o).getAction().getNiceName();
    }

    public String idFromValueAndType(Object o, Class<?> aClass) {
        return ((Instruction)o).getAction().getNiceName();
    }

    public static Class<? extends Instruction> classFromAction(Instruction.Action action) {
        switch (action) {
            case RUN: {
                return RunInstruction.class;
            }
            case CREATESLICE: {
                return CreateSliceInstruction.class;
            }
            case SLICECREDENTIAL: {
                return CredentialInstruction.class;
            }
            case SLICEINFO: {
                return SliceInfoInstruction.class;
            }
            case SLICEACTION: {
                return SliceActionInstruction.class;
            }
            case MANIFEST: {
                return ManifestInstruction.class;
            }
            case DECRYPTPEM: {
                return null;
            }
            case RENEW: {
                return RenewInstruction.class;
            }
            case USERINFO: {
                return UserInfoInstruction.class;
            }
            case POA: {
                return PoaInstruction.class;
            }
            case DELETE: {
                return DeleteInstruction.class;
            }
            case SSHLOGIN: {
                return SshShellInstruction.class;
            }
            case SSHEXEC: {
                return SshExecInstruction.class;
            }
            case SSHFETCH: {
                return SshFetchInstruction.class;
            }
            case LISTRESOURCES: {
                return ListResourcesInstruction.class;
            }
        }
        return null;
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        MapperConfig config = context.getConfig();
        Instruction.Action action = Instruction.Action.parse(id);
        if (action == null) {
            return null;
        }
        Class<? extends Instruction> res = InstructionTypeIdResolver.classFromAction(action);
        if (res != null) {
            return config.constructType(res);
        }
        return null;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String getDescForKnownTypeIds() {
        return "[" + Arrays.stream(Instruction.Action.values()).map(Instruction.Action::getNiceName).collect(Collectors.joining(", ")) + "]";
    }
}

