/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.instruction;

import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DebugOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.InstructionWithSlice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.User;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PoaInstruction
extends InstructionWithSlice {
    @Nonnull
    private final PoaAction poaAction;
    @Nullable
    private final String sliverUrn;

    @JsonCreator
    public PoaInstruction(@JsonProperty(value="action") @Nonnull Instruction.Action action, @JsonProperty(value="user") @Nullable User user, @JsonProperty(value="actionOutputs") @Nullable List<ActionOutput> actionOutputs, @JsonProperty(value="debugOutputs") @Nullable List<DebugOutput> debugOutputs, @JsonProperty(value="callOutputs") @Nullable List<CallOutput> callOutputs, @JsonProperty(value="proxy") @Nullable Instruction.ProxySettings proxy, @JsonProperty(value="slice") @Nullable Slice slice, @JsonProperty(value="poaAction") @Nonnull PoaAction poaAction, @JsonProperty(value="sliverUrn") @Nullable String sliverUrn, @JsonProperty(value="ignoreSliceRecoverTimeout") Boolean ignoreSliceRecoverTimeout) {
        super(action, user, actionOutputs, debugOutputs, callOutputs, proxy, slice, ignoreSliceRecoverTimeout);
        if (poaAction == null) {
            throw new IllegalArgumentException("poaAction is required");
        }
        this.poaAction = poaAction;
        this.sliverUrn = sliverUrn;
    }

    private PoaInstruction(boolean demo) {
        super(Instruction.Action.POA, demo, true);
        this.poaAction = demo ? PoaAction.ConsoleUrl : PoaAction.ConsoleUrl;
        this.sliverUrn = demo ? "urn:publicid:IDN+example.com+sliver+s15" : null;
    }

    @JsonProperty
    @Nonnull
    public PoaAction getPoaAction() {
        return this.poaAction;
    }

    @JsonProperty
    @Nullable
    public String getSliverUrn() {
        return this.sliverUrn;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Instruction.Action getActionOfClass() {
        return Instruction.Action.POA;
    }

    public static enum PoaAction {
        Restart(new String[0]),
        ReloadOs("reload"),
        ConsoleUrl("console");

        private final Set<String> names;

        private PoaAction(String ... names) {
            this.names = names == null ? Collections.singleton(PoaAction.canonized(this.name())) : Stream.concat(Arrays.stream(names), Stream.of(this.name())).map(PoaAction::canonized).collect(Collectors.toSet());
        }

        public static String canonized(String value) {
            return value.trim().toLowerCase().replaceAll("^geni", "").replaceAll(" _-", "");
        }

        public boolean matches(@Nonnull String value) {
            return this.names.contains(PoaAction.canonized(value));
        }

        @JsonCreator
        public static PoaAction parse(@Nonnull String value) {
            return Arrays.stream(PoaAction.values()).filter(m -> m.matches(value)).findAny().orElseThrow(() -> new IllegalArgumentException("PoaAction not known: " + value));
        }
    }
}

