/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.instruction;

import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupConfig;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedContentRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Provision;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.experiment.setup.config.WaitForReady;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DebugOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ESpecExecuteLogOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.EspecLoggingInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.OutputTarget;
import be.iminds.ilabt.jfed.ui.cli2.instruction.User;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RunInstruction
extends Instruction
implements EspecLoggingInstruction {
    @Nonnull
    private final ExperimentSetupConfig experiment;
    @Nonnull
    private final ShareWith shareWith;
    @Nonnull
    private final SshKeySource sshKeys;
    @Nonnull
    private final DeleteOn deleteOn;
    @Nonnull
    private final ExperimentOutput output;
    @Nonnull
    private final List<ESpecExecuteLogOutput> eSpecExecuteLogOutputs;

    @JsonCreator
    public RunInstruction(@JsonProperty(value="action") @Nonnull Instruction.Action action, @JsonProperty(value="user") @Nullable User user, @JsonProperty(value="actionOutputs") @Nullable List<ActionOutput> actionOutputs, @JsonProperty(value="debugOutputs") @Nullable List<DebugOutput> debugOutputs, @JsonProperty(value="callOutputs") @Nullable List<CallOutput> callOutputs, @JsonProperty(value="eSpecExecuteLogOutputs") @Nullable List<ESpecExecuteLogOutput> eSpecExecuteLogOutputs, @JsonProperty(value="proxy") @Nullable Instruction.ProxySettings proxy, @JsonProperty(value="experiment") @Nullable ExperimentSetupConfig experiment, @JsonProperty(value="shareWith") @Nullable ShareWith shareWith, @JsonProperty(value="sshKeys") @Nullable SshKeySource sshKeys, @JsonProperty(value="deleteOn") @Nullable DeleteOn deleteOn, @JsonProperty(value="output") @Nullable ExperimentOutput output) {
        super(action, user, actionOutputs, debugOutputs, callOutputs, proxy);
        this.experiment = experiment == null ? new RunInstruction((boolean)false).experiment : experiment;
        this.shareWith = shareWith == null ? new RunInstruction((boolean)false).shareWith : shareWith;
        this.sshKeys = sshKeys == null ? new RunInstruction((boolean)false).sshKeys : sshKeys;
        this.deleteOn = deleteOn == null ? new RunInstruction((boolean)false).deleteOn : deleteOn;
        this.output = output == null ? new RunInstruction((boolean)false).output : output;
        this.eSpecExecuteLogOutputs = eSpecExecuteLogOutputs == null ? new RunInstruction((boolean)false).eSpecExecuteLogOutputs : eSpecExecuteLogOutputs;
    }

    private RunInstruction(boolean demo) {
        super(Instruction.Action.RUN, demo);
        Slice slice = new Slice("myExp1", Boolean.valueOf(false), Boolean.valueOf(false), Long.valueOf(120L), null, Boolean.valueOf(true), Slice.ProjectSource.PROVIDED, Boolean.valueOf(true), "myProject");
        WaitForReady waitForReady = new WaitForReady(Long.valueOf(30L), null, Boolean.valueOf(true));
        Provision provision = new Provision(null, Boolean.valueOf(true), null);
        this.experiment = demo ? new ExperimentSetupConfig(slice, (RequestRSpec)new ProvidedContentRequestRSpec(RequestRSpec.RequestRSpecSource.PROVIDE_CONTENT, "<rspec type=\"request\">\n   <node>\n      <!--my_rspec-->\n   </node>\n</rspec>\n", Boolean.valueOf(false), "urn:publicid:IDN+example.com+authority+am", Boolean.valueOf(false), Boolean.valueOf(false)), null, provision, waitForReady, null, Boolean.valueOf(true)) : new ExperimentSetupConfig();
        this.shareWith = new ShareWith();
        this.sshKeys = new SshKeySource();
        this.deleteOn = new DeleteOn();
        this.output = new ExperimentOutput();
        this.eSpecExecuteLogOutputs = demo ? Collections.singletonList(new ESpecExecuteLogOutput(OutputTarget.SOLIDLAB_UPLOAD, "https://localhost/api/v1/result/42")) : Collections.singletonList(new ESpecExecuteLogOutput());
    }

    @JsonProperty
    @Nonnull
    public ExperimentSetupConfig getExperiment() {
        return this.experiment;
    }

    @JsonProperty
    @Nonnull
    public ShareWith getShareWith() {
        return this.shareWith;
    }

    @JsonProperty
    @Nonnull
    public SshKeySource getSshKeys() {
        return this.sshKeys;
    }

    @JsonProperty
    @Nonnull
    public DeleteOn getDeleteOn() {
        return this.deleteOn;
    }

    @JsonProperty
    @Nonnull
    public ExperimentOutput getOutput() {
        return this.output;
    }

    @JsonIgnore
    @Nonnull
    public Slice getSlice() {
        return this.experiment.getSlice();
    }

    @Override
    @JsonProperty
    @Nonnull
    public List<ESpecExecuteLogOutput> getESpecExecuteLogOutputs() {
        return this.eSpecExecuteLogOutputs;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Instruction.Action getActionOfClass() {
        return Instruction.Action.RUN;
    }

    public static class ShareWith {
        @Nonnull
        private final List<String> users;
        private final boolean projectMembers;

        @JsonCreator
        public ShareWith(@JsonProperty(value="users") @Nonnull List<String> users, @JsonProperty(value="projectMembers") boolean projectMembers) {
            this.users = users;
            this.projectMembers = projectMembers;
        }

        public ShareWith() {
            this.users = Collections.emptyList();
            this.projectMembers = false;
        }

        @JsonProperty
        @Nonnull
        public List<String> getUsers() {
            return this.users;
        }

        @JsonProperty
        public boolean isProjectMembers() {
            return this.projectMembers;
        }
    }

    public static class SshKeySource {
        private final boolean userCert;
        private final boolean userKeys;
        private final boolean shareWith;
        private final boolean rspec;
        @Nonnull
        private final List<String> extraUsernames;
        @Nonnull
        private final List<String> extraKeys;

        @JsonCreator
        public SshKeySource(@JsonProperty(value="userCert") @Nullable Boolean userCert, @JsonProperty(value="userKeys") @Nullable Boolean userKeys, @JsonProperty(value="shareWith") @Nullable Boolean shareWith, @JsonProperty(value="rspec") @Nullable Boolean rspec, @JsonProperty(value="extraUsernames") @Nullable List<String> extraUsernames, @JsonProperty(value="extraKeys") @Nullable List<String> extraKeys) {
            this.userCert = userCert == null ? new SshKeySource().userCert : userCert;
            this.userKeys = userKeys == null ? new SshKeySource().userKeys : userKeys;
            this.shareWith = shareWith == null ? new SshKeySource().shareWith : shareWith;
            this.rspec = rspec == null ? new SshKeySource().rspec : rspec;
            this.extraUsernames = extraUsernames == null ? new SshKeySource().extraUsernames : extraUsernames;
            this.extraKeys = extraKeys == null ? new SshKeySource().extraKeys : extraKeys;
        }

        public SshKeySource() {
            this.userCert = true;
            this.userKeys = true;
            this.shareWith = true;
            this.rspec = true;
            this.extraUsernames = Collections.emptyList();
            this.extraKeys = Collections.emptyList();
        }

        @JsonProperty
        public boolean isUserCert() {
            return this.userCert;
        }

        @JsonProperty
        public boolean isUserKeys() {
            return this.userKeys;
        }

        @JsonProperty
        public boolean isShareWith() {
            return this.shareWith;
        }

        @JsonProperty
        public boolean isRspec() {
            return this.rspec;
        }

        @JsonProperty
        @Nonnull
        public List<String> getExtraUsernames() {
            return this.extraUsernames;
        }

        @JsonProperty
        @Nonnull
        public List<String> getExtraKeys() {
            return this.extraKeys;
        }
    }

    public static class DeleteOn {
        private final boolean failCreate;
        private final boolean failBecomeReady;
        private final boolean failConnectivityTest;
        private final boolean failLinkTest;
        private final boolean failESpec;

        @JsonCreator
        public DeleteOn(@JsonProperty(value="failCreate") @Nullable Boolean failCreate, @JsonProperty(value="failBecomeReady") @Nullable Boolean failBecomeReady, @JsonProperty(value="failConnectivityTest") @Nullable Boolean failConnectivityTest, @JsonProperty(value="failLinkTest") @Nullable Boolean failLinkTest, @JsonProperty(value="failESpec") @Nullable Boolean failESpec) {
            this.failCreate = failCreate == null ? new DeleteOn().failCreate : failCreate;
            this.failBecomeReady = failBecomeReady == null ? new DeleteOn().failBecomeReady : failBecomeReady;
            this.failConnectivityTest = failConnectivityTest == null ? new DeleteOn().failConnectivityTest : failConnectivityTest;
            this.failLinkTest = failLinkTest == null ? new DeleteOn().failLinkTest : failLinkTest;
            this.failESpec = failESpec == null ? new DeleteOn().failESpec : failESpec;
        }

        public DeleteOn() {
            this.failCreate = true;
            this.failBecomeReady = false;
            this.failConnectivityTest = false;
            this.failLinkTest = false;
            this.failESpec = false;
        }

        @JsonProperty
        public boolean isFailCreate() {
            return this.failCreate;
        }

        @JsonProperty
        public boolean isFailBecomeReady() {
            return this.failBecomeReady;
        }

        @JsonProperty
        public boolean isFailConnectivityTest() {
            return this.failConnectivityTest;
        }

        @JsonProperty
        public boolean isFailLinkTest() {
            return this.failLinkTest;
        }

        @JsonProperty
        public boolean isFailESpec() {
            return this.failESpec;
        }
    }

    public static class ExperimentOutput {
        @Nullable
        private final OutputTarget manifestTarget;
        @Nullable
        private final String manifestLocation;
        private final String ansibleDir;

        public ExperimentOutput(@JsonProperty(value="manifestTarget") @Nullable OutputTarget manifestTarget, @JsonAlias(value={"manifestFile"}) @JsonProperty(value="manifestLocation") @Nullable String manifestLocation, @JsonProperty(value="ansibleDir") @Nullable String ansibleDir) {
            this.manifestLocation = manifestLocation;
            this.manifestTarget = manifestTarget != null ? manifestTarget : (manifestLocation != null ? OutputTarget.FILE : null);
            this.ansibleDir = ansibleDir;
            if (manifestTarget != null && manifestLocation == null) {
                throw new IllegalArgumentException("manifestLocation may not be bull when manifestTarget==" + String.valueOf((Object)manifestTarget));
            }
        }

        public ExperimentOutput(boolean demo) {
            if (demo) {
                this.manifestLocation = null;
                this.manifestTarget = null;
                this.ansibleDir = null;
            } else {
                this.manifestLocation = "manifest.rspec";
                this.manifestTarget = OutputTarget.FILE;
                this.ansibleDir = "/tmp/ansible_files/";
            }
        }

        public ExperimentOutput() {
            this(false);
        }

        @Nullable
        @JsonProperty
        public OutputTarget getManifestTarget() {
            return this.manifestTarget;
        }

        @Nullable
        @JsonProperty
        public String getManifestLocation() {
            return this.manifestLocation;
        }

        @JsonProperty
        public String getAnsibleDir() {
            return this.ansibleDir;
        }
    }
}

