/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.instruction;

import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DebugOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ESpecExecuteLogOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.EspecLoggingInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.InstructionWithSlice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.OutputTarget;
import be.iminds.ilabt.jfed.ui.cli2.instruction.User;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceActionInstruction
extends InstructionWithSlice
implements EspecLoggingInstruction {
    @Nonnull
    private final SliceAction sliceAction;
    @Nonnull
    private final List<ESpecExecuteLogOutput> eSpecExecuteLogOutputs;
    @Nullable
    private final ESpec espec;

    @JsonCreator
    public SliceActionInstruction(@JsonProperty(value="action") @Nonnull Instruction.Action action, @JsonProperty(value="user") @Nullable User user, @JsonProperty(value="actionOutputs") @Nullable List<ActionOutput> actionOutputs, @JsonProperty(value="debugOutputs") @Nullable List<DebugOutput> debugOutputs, @JsonProperty(value="callOutputs") @Nullable List<CallOutput> callOutputs, @JsonProperty(value="eSpecExecuteLogOutputs") @Nullable List<ESpecExecuteLogOutput> eSpecExecuteLogOutputs, @JsonProperty(value="proxy") @Nullable Instruction.ProxySettings proxy, @JsonProperty(value="slice") @Nullable Slice slice, @JsonProperty(value="sliceAction") @Nonnull SliceAction sliceAction, @JsonProperty(value="espec") @Nullable ESpec espec, @JsonProperty(value="ignoreSliceRecoverTimeout") Boolean ignoreSliceRecoverTimeout) {
        super(action, user, actionOutputs, debugOutputs, callOutputs, proxy, slice, ignoreSliceRecoverTimeout);
        if (sliceAction == null) {
            throw new IllegalArgumentException("sliceAction is required");
        }
        this.sliceAction = sliceAction;
        this.espec = espec;
        this.eSpecExecuteLogOutputs = eSpecExecuteLogOutputs;
    }

    private SliceActionInstruction(boolean demo) {
        super(Instruction.Action.SLICEACTION, demo, true);
        this.sliceAction = demo ? SliceAction.RerunESpec : SliceAction.RerunESpec;
        this.espec = demo ? new ESpec(ESpec.ESpecSource.PROVIDE_DIR, "/tmp/my-espec/", null) : null;
        this.eSpecExecuteLogOutputs = demo ? Collections.singletonList(new ESpecExecuteLogOutput(OutputTarget.SOLIDLAB_UPLOAD, "https://localhost/api/v1/testenv/42/artifact")) : Collections.singletonList(new ESpecExecuteLogOutput());
    }

    @JsonProperty
    @Nonnull
    public SliceAction getSliceAction() {
        return this.sliceAction;
    }

    @JsonProperty(value="espec")
    @Nullable
    public ESpec getEspec() {
        return this.espec;
    }

    @Override
    @JsonProperty
    @Nonnull
    public List<ESpecExecuteLogOutput> getESpecExecuteLogOutputs() {
        return this.eSpecExecuteLogOutputs;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Instruction.Action getActionOfClass() {
        return Instruction.Action.SLICEACTION;
    }

    public static enum SliceAction {
        LinkTest(new String[0]),
        ConnectivityTest("runConnectivityTest"),
        RerunESpec("espec", "runEspec");

        private final Set<String> names;

        private SliceAction(String ... names) {
            this.names = names == null ? Collections.singleton(SliceAction.canonized(this.name())) : Stream.concat(Arrays.stream(names), Stream.of(this.name())).map(SliceAction::canonized).collect(Collectors.toSet());
        }

        public static String canonized(String value) {
            return value.trim().toLowerCase().replaceAll(" _-", "");
        }

        public boolean matches(@Nonnull String value) {
            return this.names.contains(SliceAction.canonized(value));
        }

        @JsonCreator
        public static SliceAction parse(@Nonnull String value) {
            return Arrays.stream(SliceAction.values()).filter(m -> m.matches(value)).findAny().orElseThrow(() -> new IllegalArgumentException("SliceAction not known: " + value));
        }
    }
}

