/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.instruction;

import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DebugOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.InstructionWithSlice;
import be.iminds.ilabt.jfed.ui.cli2.instruction.User;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SshFetchInstruction
extends InstructionWithSlice {
    @Nonnull
    private final String remoteFile;
    @Nonnull
    private final String localTargetDir;
    @Nullable
    private final String nodeClientId;
    private final boolean flat;
    private final boolean merge;

    @JsonCreator
    public SshFetchInstruction(@JsonProperty(value="action") @Nonnull Instruction.Action action, @JsonProperty(value="user") @Nullable User user, @JsonProperty(value="actionOutputs") @Nullable List<ActionOutput> actionOutputs, @JsonProperty(value="debugOutputs") @Nullable List<DebugOutput> debugOutputs, @JsonProperty(value="callOutputs") @Nullable List<CallOutput> callOutputs, @JsonProperty(value="proxy") @Nullable Instruction.ProxySettings proxy, @JsonProperty(value="slice") Slice slice, @JsonProperty(value="remoteFile") @Nonnull String remoteFile, @JsonProperty(value="localTargetDir") @Nonnull String localTargetDir, @JsonProperty(value="nodeClientId") @Nullable String nodeClientId, @JsonProperty(value="flat") @Nullable Boolean flat, @JsonProperty(value="merge") @Nullable Boolean merge, @JsonProperty(value="ignoreSliceRecoverTimeout") Boolean ignoreSliceRecoverTimeout) {
        super(action, user, actionOutputs, debugOutputs, callOutputs, proxy, slice, ignoreSliceRecoverTimeout);
        this.remoteFile = remoteFile;
        this.localTargetDir = localTargetDir;
        this.nodeClientId = nodeClientId;
        this.flat = flat == null ? false : flat;
        this.merge = merge == null ? false : merge;
    }

    private SshFetchInstruction(boolean demo) {
        super(Instruction.Action.SSHFETCH, demo, true);
        this.remoteFile = "/etc/issue";
        this.localTargetDir = "/tmp/";
        this.nodeClientId = "node0";
        this.flat = true;
        this.merge = false;
    }

    @JsonProperty(value="remoteFile")
    @Nonnull
    public String getRemoteFile() {
        return this.remoteFile;
    }

    @JsonProperty(value="localTargetDir")
    @Nonnull
    public String getLocalTargetDir() {
        return this.localTargetDir;
    }

    @JsonProperty
    @Nullable
    public String getNodeClientId() {
        return this.nodeClientId;
    }

    @JsonProperty
    public boolean isFlat() {
        return this.flat;
    }

    @JsonProperty
    public boolean isMerge() {
        return this.merge;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Instruction.Action getActionOfClass() {
        return Instruction.Action.SSHFETCH;
    }
}

