/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.logging;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.dropwizard.jackson.Jackson;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ActionLogger.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static final ObjectMapper YAML_MAPPER = Jackson.newObjectMapper((JsonFactory)new YAMLFactory());
    private final List<ActionLogListener> listeners = new CopyOnWriteArrayList<ActionLogListener>();
    private final AtomicInteger exceptionCount = new AtomicInteger(0);
    @Nullable
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public ActionLogger() {
        this.uncaughtExceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
    }

    public ActionLogger(@Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public void actionJsonOut(@Nonnull Object o) {
        this.executeSafeForAllListeners(l -> l.onJsonOut(o));
    }

    public void actionYamlOut(@Nonnull String key, @Nonnull Object value) {
        if (value instanceof Map) {
            HashMap<String, String> newValue = new HashMap<String, String>((Map)value);
            newValue.put("time", RFC3339Util.instantToRFC3339String((Instant)Instant.now(), (boolean)true));
            value = newValue;
        }
        HashMap<String, String> finalValue = value;
        this.executeSafeForAllListeners(l -> l.onYamlOut(key, finalValue));
    }

    public void actionPrint(@Nonnull String s) {
        this.executeSafeForAllListeners(l -> l.onOut(s));
    }

    public void actionPrintln(@Nonnull String s) {
        this.executeSafeForAllListeners(l -> l.onOut(s + "\n"));
    }

    public void errorPrintln(@Nonnull String s) {
        this.executeSafeForAllListeners(l -> l.onErr(s + "\n"));
    }

    public void errorPrintln(String msg, Throwable throwable) {
        String stackTrace = throwable == null ? "" : "\n\n" + IOUtils.exceptionToStacktraceString((Throwable)throwable);
        this.errorPrintln(msg + stackTrace);
    }

    public void addESpecLogListener(@Nonnull ActionLogListener listener) {
        this.listeners.add(listener);
    }

    public void removeESpecLogListener(@Nonnull ActionLogListener listener) {
        this.listeners.remove(listener);
    }

    private void executeSafeForAllListeners(Consumer<ActionLogListener> c) {
        for (ActionLogListener l : this.listeners) {
            try {
                c.accept(l);
            }
            catch (Exception e) {
                this.handleExceptionInListener(e);
            }
        }
    }

    private void handleExceptionInListener(Exception e) {
        int count = this.exceptionCount.getAndIncrement();
        if (count == 0 && this.uncaughtExceptionHandler != null) {
            try {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
            catch (Exception e2) {
                LOG.error("Ignoring exception in uncaughtExceptionHandler", (Throwable)e2);
            }
        } else {
            LOG.error("Ignoring exception " + count + " in ESpecLogger listener", (Throwable)e);
        }
    }

    public static interface ActionLogListener {
        public void onOut(@Nonnull String var1);

        public void onJsonOut(@Nonnull Object var1);

        public void onYamlOut(@Nonnull String var1, @Nonnull Object var2);

        public void onErr(@Nonnull String var1);
    }

    public static class StreamActionLogListener
    implements ActionLogListener {
        @Nonnull
        private final PrintStream outStream;
        @Nonnull
        private final PrintStream errStream;
        private final boolean doTextOut;
        private final boolean doJsonOut;
        private final boolean doYamlOut;

        public StreamActionLogListener(@Nonnull PrintStream outStream, @Nonnull PrintStream errStream, boolean doTextOut, boolean doJsonOut, boolean doYamlOut) {
            this.outStream = outStream;
            this.errStream = errStream;
            this.doTextOut = doTextOut;
            this.doJsonOut = doJsonOut;
            this.doYamlOut = doYamlOut;
        }

        @Override
        public void onJsonOut(@Nonnull Object o) {
            Object s;
            if (!this.doJsonOut) {
                return;
            }
            try {
                s = MAPPER.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS}).writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                LOG.error("Error converting action output to JSON", (Throwable)e);
                s = "Error converting action output to JSON: " + e.getMessage();
            }
            this.outStream.print((String)s);
            this.outStream.flush();
        }

        @Override
        public void onYamlOut(@NotNull String key, @NotNull Object value) {
            Object s;
            if (!this.doYamlOut) {
                return;
            }
            try {
                s = YAML_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(Collections.singletonMap(key, value));
            }
            catch (JsonProcessingException e) {
                LOG.error("Error converting action output to YAML", (Throwable)e);
                s = "Error converting action output to YAML: " + e.getMessage();
            }
            this.outStream.print((String)s);
            this.outStream.flush();
        }

        @Override
        public void onOut(@Nonnull String s) {
            if (!this.doTextOut) {
                return;
            }
            this.outStream.print(s);
            this.outStream.flush();
        }

        @Override
        public void onErr(@Nonnull String s) {
            if (!this.doTextOut && !this.doJsonOut) {
                return;
            }
            this.errStream.print(s);
            this.errStream.flush();
        }
    }
}

