/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.logging;

import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESpecExecuteOutputLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ESpecExecuteOutputLogger.class);
    private final List<ESpecExecuteOutputListenerFactory> listenerFactories = new CopyOnWriteArrayList<ESpecExecuteOutputListenerFactory>();
    private final Map<Index, List<LimitedLiveLog.ChangeListener>> listeners = new HashMap<Index, List<LimitedLiveLog.ChangeListener>>();

    public void addESpecExecuteOutputListenerFactory(@Nonnull ESpecExecuteOutputListenerFactory factory) {
        this.listenerFactories.add(factory);
    }

    public void addLiveLog(@Nonnull String fullExecutablePath, @Nonnull String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        for (ESpecExecuteOutputListenerFactory factory : this.listenerFactories) {
            LimitedLiveLog.ChangeListener l = factory.create(fullExecutablePath, fullLogPath, nodeClientId);
            if (l == null) continue;
            currentLog.addChangeListener(l);
            this.listeners.computeIfAbsent(new Index(fullExecutablePath, fullLogPath, nodeClientId), k -> new ArrayList()).add(l);
        }
    }

    public void removeLiveLog(@Nonnull String fullPath, @Nonnull String fullLogPath, @Nonnull String nodeClientId) {
        List<LimitedLiveLog.ChangeListener> toRemove = this.listeners.get(new Index(fullPath, fullLogPath, nodeClientId));
        if (toRemove != null) {
            toRemove.clear();
        }
    }

    static interface ESpecExecuteOutputListenerFactory {
        @Nullable
        public LimitedLiveLog.ChangeListener create(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3);
    }

    private static class Index {
        @Nonnull
        public String fullExecutablePath;
        @Nonnull
        public String fullLogPath;
        @Nonnull
        public String nodeClientId;

        public Index(@Nonnull String fullExecutablePath, @Nonnull String fullLogPath, @Nonnull String nodeClientId) {
            this.fullExecutablePath = fullExecutablePath;
            this.fullLogPath = fullLogPath;
            this.nodeClientId = nodeClientId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            return this.fullExecutablePath.equals(index.fullExecutablePath) && this.fullLogPath.equals(index.fullLogPath) && this.nodeClientId.equals(index.nodeClientId);
        }

        public int hashCode() {
            return Objects.hash(this.fullExecutablePath, this.fullLogPath, this.nodeClientId);
        }
    }

    public static class LimitedLiveLogPrintStreamChangeListener
    implements LimitedLiveLog.ChangeListener {
        @Nonnull
        public final PrintStream out;
        @Nonnull
        public final String prefix;
        public final boolean mustClose;

        public LimitedLiveLogPrintStreamChangeListener(@Nonnull PrintStream out, @Nonnull String prefix, boolean mustClose) {
            this.out = out;
            this.prefix = prefix;
            this.mustClose = mustClose;
        }

        public void onChanged(@NotNull LimitedLiveLog source, @NotNull String addedText) {
            this.out.println(this.prefix + addedText);
        }

        public void onEndReached(@NotNull LimitedLiveLog source) {
            if (this.mustClose) {
                this.out.close();
            }
        }
    }

    public static class LoggingESpecExecuteOutputListenerFactory
    implements ESpecExecuteOutputListenerFactory {
        @Override
        public LimitedLiveLog.ChangeListener create(@NotNull String fullExecutablePath, @NotNull String fullLogPath, @NotNull String nodeClientId) {
            LOG.debug("Will log Espec Execute " + fullExecutablePath + " " + fullLogPath + " " + nodeClientId + " to a logger");
            final Logger logger = LoggerFactory.getLogger((String)("LoggingESpecExecuteOutputListener." + fullExecutablePath + "@" + nodeClientId));
            return new LimitedLiveLog.ChangeListener(){

                public void onChanged(@NotNull LimitedLiveLog source, @NotNull String addedText) {
                    logger.debug(addedText);
                }

                public void onEndReached(@NotNull LimitedLiveLog source) {
                }
            };
        }
    }

    public static class PrintStreamESpecExecuteOutputListenerFactory
    implements ESpecExecuteOutputListenerFactory {
        @Nonnull
        public final PrintStream out;

        public PrintStreamESpecExecuteOutputListenerFactory(@Nonnull PrintStream out) {
            this.out = out;
        }

        @Override
        public LimitedLiveLog.ChangeListener create(@NotNull String fullExecutablePath, @NotNull String fullLogPath, @NotNull String nodeClientId) {
            LOG.debug("Will log Espec Execute " + fullExecutablePath + " " + fullLogPath + " " + nodeClientId + " to a PrintStream");
            return new LimitedLiveLogPrintStreamChangeListener(this.out, "OUT " + fullExecutablePath + "@" + nodeClientId + ": ", false);
        }
    }

    public static abstract class FileBasedESpecExecuteOutputListenerFactory
    implements ESpecExecuteOutputListenerFactory {
        private int count = 0;

        @Override
        @Nullable
        public LimitedLiveLog.ChangeListener create(@Nonnull String fullExecutablePath, @Nonnull String fullLogPath, @Nonnull String nodeClientId) {
            String prefix = (this.count < 10 ? "0" : "") + this.count + "-" + nodeClientId + "-";
            ++this.count;
            String basename = new File(fullLogPath).getName();
            return this.createWithFile(prefix + basename);
        }

        public abstract LimitedLiveLog.ChangeListener createWithFile(@Nonnull String var1);
    }
}

