/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli2.wizard;

import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupConfig;
import be.iminds.ilabt.jfed.experiment.setup.config.AlreadyProvisionedRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateSimpleRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateUsingAdvertisementRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateUsingJFedRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedContentRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedFileRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedUrlRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Provision;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.experiment.setup.config.WaitForReady;
import be.iminds.ilabt.jfed.rspec.adv_based_generator.AdvertisementBasedRspecGeneratorConfig;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ActionOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CallOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.CreateSliceInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DebugOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DecryptPemInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.DeleteInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ESpecExecuteLogOutput;
import be.iminds.ilabt.jfed.ui.cli2.instruction.Instruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ListResourcesInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.ManifestInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.OutputTarget;
import be.iminds.ilabt.jfed.ui.cli2.instruction.PoaInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RenewInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.RunInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceActionInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceCredentialInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SliceInfoInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshExecInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshFetchInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.SshShellInstruction;
import be.iminds.ilabt.jfed.ui.cli2.instruction.User;
import be.iminds.ilabt.jfed.ui.cli2.instruction.UserInfoInstruction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public class ActionWizard {
    private final PrintStream out;
    private final PrintStream err;
    private final InputStream in;
    private final BufferedReader readin;
    private User user;
    private List<ActionOutput> actionOutputs;
    private List<DebugOutput> debugOutputs;
    private List<CallOutput> callOutputs;
    private List<ESpecExecuteLogOutput> especExecuteLogOutputs;
    private Instruction.ProxySettings proxy;
    private boolean ignoreSliceRecoverTimeout = false;
    private Slice slice;

    public ActionWizard(@Nonnull PrintStream out, @Nonnull PrintStream err, @Nonnull InputStream in) {
        this.out = out;
        this.err = err;
        this.in = in;
        this.readin = new BufferedReader(new InputStreamReader(in));
    }

    @Contract(value="_,!null,_,_,_ -> !null; _,_,_,false,_ -> !null")
    private <T> T ask(String question, T defaultValue, Function<String, T> parser, boolean allowNull, String defaultShownOverride) throws IOException {
        while (true) {
            this.out.print(question + "? ");
            if (defaultValue != null && defaultShownOverride == null) {
                this.out.print("(default=" + String.valueOf(defaultValue) + ") ");
            }
            if (defaultShownOverride != null) {
                this.out.print("(" + defaultShownOverride + ") ");
            }
            String val = this.readin.readLine();
            this.out.println();
            if (val.trim().isEmpty() && defaultValue != null) {
                return defaultValue;
            }
            T res = parser.apply(val);
            if (res != null) {
                return res;
            }
            if (allowNull) {
                return null;
            }
            this.err.println("Illegal answer, try again.");
        }
    }

    @Contract(value="_,!null,_,_,_ -> !null; _,_,_,false,_ -> !null")
    private <T> T askMultiLine(String question, T defaultValue, Function<String, T> parser, boolean allowNull, String defaultShownOverride) throws IOException {
        while (true) {
            this.out.print(question + "? ");
            if (defaultValue != null && defaultShownOverride == null) {
                this.out.print("(default=" + String.valueOf(defaultValue) + ") ");
            }
            if (defaultShownOverride != null) {
                this.out.print("(" + defaultShownOverride + ") ");
            }
            StringBuilder val = new StringBuilder();
            String line = this.readin.readLine();
            val.append(line + "\n");
            while (!line.trim().equals("EOF")) {
                val.append(line + "\n");
                line = this.readin.readLine();
            }
            this.out.println();
            String fval = val.toString();
            if (fval.trim().isEmpty() && defaultValue != null) {
                return defaultValue;
            }
            T res = parser.apply(fval);
            if (res != null) {
                return res;
            }
            if (allowNull) {
                return null;
            }
            this.err.println("Illegal answer, try again.");
        }
    }

    public String askString(String question, String defaultValue, boolean allowNull) throws IOException {
        return this.ask(question, defaultValue, s -> s.trim().isEmpty() ? null : s, allowNull, null);
    }

    public String askMultiString(String question, String defaultValue, boolean allowNull) throws IOException {
        return this.askMultiLine(question, defaultValue, s -> s.trim().isEmpty() ? null : s, allowNull, null);
    }

    public int askInt(String question, Integer defaultValue) throws IOException {
        return this.ask(question, defaultValue, s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }, false, null);
    }

    public long askLong(String question, Long defaultValue) throws IOException {
        return this.ask(question, defaultValue, s -> {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }, false, null);
    }

    public Long askLongOrNull(String question, Long defaultValue) throws IOException {
        return this.ask(question, defaultValue, s -> {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }, true, null);
    }

    public boolean askBool(String question, Boolean defaultValue) throws IOException {
        return this.ask(question, defaultValue, s -> {
            if (s == null) {
                return null;
            }
            if (Arrays.asList("true", "yes", "t", "y", "1").contains(s.toLowerCase())) {
                return true;
            }
            if (Arrays.asList("false", "no", "f", "n", "0").contains(s.toLowerCase())) {
                return false;
            }
            return null;
        }, false, defaultValue == null ? "y/n" : (defaultValue != false ? "Y/n" : "y/N"));
    }

    public List<String> askStringList(@Nonnull String question, boolean allowEmpty) throws IOException {
        String csvList = this.askString(question, null, allowEmpty);
        if (csvList == null || csvList.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(csvList.trim().split(","));
    }

    public int askListPosition(@Nonnull String question, @Nonnull List<String> options, @Nullable Integer defaultValue) throws IOException {
        assert (options.size() > 0);
        for (int i = 0; i < options.size(); ++i) {
            this.out.println(i + ") " + options.get(i));
        }
        this.out.println();
        return this.ask(question, defaultValue, s -> {
            try {
                int res = Integer.parseInt(s);
                if (res < 0 || res > options.size()) {
                    return null;
                }
                return res;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }, false, null);
    }

    public <T extends Enum> T askEnum(@Nonnull String question, @Nonnull Class<T> enumClass, @Nullable T defaultValue) throws IOException {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < values.length; ++i) {
            assert (values[i].ordinal() == i);
            this.out.println(i + ") " + values[i].name());
        }
        this.out.println();
        return (T)this.ask(question, defaultValue, s -> {
            try {
                int res = Integer.parseInt(s);
                if (res < 0 || res > values.length) {
                    return null;
                }
                return values[res];
            }
            catch (NumberFormatException e) {
                return null;
            }
        }, false, null);
    }

    public String askListValue(@Nonnull String question, @Nonnull List<String> options, @Nullable Integer defaultValue) throws IOException {
        int res = this.askListPosition(question, options, defaultValue);
        return options.get(res);
    }

    public boolean askBoolChoice(@Nonnull String trueCase, @Nonnull String falseCase, Boolean defaultValue) throws IOException {
        int res = this.askListPosition("Choose", Arrays.asList(trueCase, falseCase), defaultValue == null ? null : Integer.valueOf(defaultValue != false ? 0 : 1));
        return res == 0;
    }

    @Nullable
    public Instruction generate() throws IOException {
        this.out.println("Welcome to the jFed CLI Wizard. This tool guide you through all the available actions and options.");
        this.out.println("This will only create the YaML config for the action, it will not execute the action.");
        this.out.println("At the end, it will be shown how the created action can be executed.");
        this.out.println();
        this.out.println("Available actions:");
        this.out.println();
        for (Instruction.Action action : Instruction.Action.values()) {
            this.out.println(action.ordinal() + ") " + action.getNiceName());
        }
        this.out.println();
        int actionOrdinal = this.askInt("Action", null);
        Instruction.Action action = Instruction.Action.values()[actionOrdinal];
        this.out.println("You chose action: " + action.name());
        this.askGenericQuestions();
        switch (action) {
            case USERINFO: {
                return this.generateUserInfo();
            }
            case SLICEINFO: {
                return this.generateSliceInfo();
            }
            case SLICEACTION: {
                return this.generateSliceAction();
            }
            case RUN: {
                return this.generateRun();
            }
            case CREATESLICE: {
                return this.generateCreateSlice();
            }
            case LISTRESOURCES: {
                return this.generateListResources();
            }
            case MANIFEST: {
                return this.generateManifest();
            }
            case DELETE: {
                return this.generateDelete();
            }
            case POA: {
                return this.generatePoa();
            }
            case RENEW: {
                return this.generateRenew();
            }
            case SLICECREDENTIAL: {
                return this.generateSliceCredential();
            }
            case SSHLOGIN: {
                return this.generateSshShell();
            }
            case SSHEXEC: {
                return this.generateSshExec();
            }
            case SSHFETCH: {
                return this.generateSshFetch();
            }
            case DECRYPTPEM: {
                return this.generateDecryptPem();
            }
        }
        throw new RuntimeException("Action " + action.name() + " not yet supported in wizard.");
    }

    public void askGenericQuestions() throws IOException {
        this.out.println("\n*** Generic questions:\n");
        this.askUserQuestions();
        this.askProxyQuestions();
        this.askOutputQuestions();
    }

    public void askUserQuestions() throws IOException {
        String pem = this.askString("User PEM login filename", null, false);
        boolean hasPassword = this.askBool("Is this file password protected", true);
        if (!hasPassword) {
            this.user = new User(Collections.singletonList(pem), User.PasswordMethod.NONE, null, null);
            return;
        }
        if (this.askBool("Store the password in the generated action file", false)) {
            this.user = new User(Collections.singletonList(pem), User.PasswordMethod.DIRECT, this.askString("Password", null, false), null);
            return;
        }
        if (this.askBool("Store the password in a seperate file", false)) {
            this.user = new User(Collections.singletonList(pem), User.PasswordMethod.FILE, this.askString("Password file", null, false), null);
            return;
        }
        this.out.println("Password won't be stored. It will be asked each time you execute the action with the CLI.");
        this.user = new User(Collections.singletonList(pem), User.PasswordMethod.INTERACTIVE, null, null);
    }

    public void askProxyQuestions() throws IOException {
        if (this.askBool("Use same jFed proxy settings as in GUI", true)) {
            this.proxy = null;
            return;
        }
        this.proxy = new Instruction.ProxySettings(this.askBool("Use jFed proxy for API calls", false), this.askBool("Use jFed proxy for SSH", false));
    }

    private OutputPair askOutputPair(String defaultVal) throws IOException {
        String out = this.askString("Where to write output? (STDOUT or STDERR, filename or solidlab result URL) ", defaultVal, false);
        if (out.equalsIgnoreCase("stdout")) {
            return new OutputPair(OutputTarget.STDOUT, null);
        }
        if (out.equalsIgnoreCase("stderr")) {
            return new OutputPair(OutputTarget.STDERR, null);
        }
        if (out.startsWith("http://") || out.startsWith("https://")) {
            return new OutputPair(OutputTarget.SOLIDLAB_UPLOAD, out);
        }
        return new OutputPair(OutputTarget.FILE, out);
    }

    public void askOutputQuestions() throws IOException {
        this.out.println("Most actions have in an \"action output\" (the requested information, a boolean indicating the operation success, ...)\nYou can choose in which format (text or json), and where (stream or file) this output should be written.\nYou can choose multiple outputs.\nDefault: text is sent to stdout.");
        if (this.askBool("Use default action output", true)) {
            this.actionOutputs = null;
        } else {
            OutputPair outputPair;
            this.actionOutputs = new ArrayList<ActionOutput>();
            if (this.askBool("Output action as plain text", true)) {
                outputPair = this.askOutputPair("STDOUT");
                this.actionOutputs.add(new ActionOutput(ActionOutput.Format.TXT, outputPair.target, outputPair.filename));
            }
            if (this.askBool("Output action as JSON", true)) {
                outputPair = this.askOutputPair("STDOUT");
                this.actionOutputs.add(new ActionOutput(ActionOutput.Format.JSON, outputPair.target, outputPair.filename));
            }
        }
        this.out.println("Debug output can be useful if things go wrong.\nDefault: no debug output.");
        if (!this.askBool("Use debug output", false)) {
            this.debugOutputs = null;
        } else {
            OutputPair outputPair;
            DebugOutput.Level level = this.askEnum("Debug Level", DebugOutput.Level.class, DebugOutput.Level.INFO);
            if (this.askBool("debug as full text", true)) {
                outputPair = this.askOutputPair("debug.txt");
                this.debugOutputs = Collections.singletonList(new DebugOutput(level, DebugOutput.Format.TXT_FULL, outputPair.target, outputPair.filename));
            } else {
                outputPair = this.askOutputPair("STDOUT");
                this.debugOutputs = Collections.singletonList(new DebugOutput(level, DebugOutput.Format.TXT, outputPair.target, outputPair.filename));
            }
        }
        this.out.println("API calls made by the CLI can be logged to a file. This can be very useful in debugging any issues.\nDefault: no API call logging.");
        if (!this.askBool("Write API calls to file", false)) {
            this.callOutputs = null;
        } else {
            String callFile = this.askString("Call filename", null, false);
            CallOutput.Format outputFormat = this.askEnum("Call Output Format", CallOutput.Format.class, CallOutput.Format.HTML);
            this.callOutputs = Collections.singletonList(new CallOutput(outputFormat, OutputTarget.FILE, callFile));
        }
        this.out.println("If you run an ESpec using jFed CLI2, each steps in the executes section runs a remote command the generates data.\nYou can choose in where this log output need to go to.\nYou can choose multiple outputs.\nDefault: output added to debug output.");
        if (this.askBool("Use default action output", true)) {
            this.especExecuteLogOutputs = null;
        } else {
            this.out.println("Sorry, no wizard for the non default output yet.");
            this.especExecuteLogOutputs = null;
        }
    }

    private void askSliceQuestions(@Nullable Boolean failOnExistingSlice, @Nullable Boolean failOnNonExistingSlice, @Nullable Boolean renewExistingSliceIfNeeded, boolean askExpire, boolean askRecover) throws IOException {
        boolean failIfNoProject;
        Slice.ProjectSource projectSource;
        String sliceName = this.askString("Slice Name", null, false);
        Long expireTimeMin = askExpire ? Long.valueOf(this.askInt("Expiration time in minutes", 120)) : null;
        Long maxWaitForExperimentRecoveredSeconds = askRecover ? Long.valueOf(this.askInt("When recovering the slice, how long to wait before giving up?", 10)) : null;
        String project = this.askString("Project (leave empty for more options)", null, true);
        if (project != null && !project.trim().isEmpty()) {
            projectSource = Slice.ProjectSource.PROVIDED;
            failIfNoProject = true;
        } else if (this.askBool("Determine project automatically", true)) {
            projectSource = Slice.ProjectSource.AUTO;
            failIfNoProject = true;
        } else if (this.askBool("Do not use a project (not advised)", false)) {
            projectSource = Slice.ProjectSource.NONE;
            failIfNoProject = false;
        } else {
            throw new RuntimeException("Out of options: You should probably just have provided a project name");
        }
        this.slice = new Slice(sliceName, failOnExistingSlice, failOnNonExistingSlice, expireTimeMin, maxWaitForExperimentRecoveredSeconds, renewExistingSliceIfNeeded, projectSource, Boolean.valueOf(failIfNoProject), project);
        this.ignoreSliceRecoverTimeout = this.askBool("If the slice cannot be recovered on time, try to continue anyway?", false);
    }

    public void askExistingSliceQuestions() throws IOException {
        this.askExistingSliceQuestions(false);
    }

    public void askExistingSliceQuestions(boolean askExpire) throws IOException {
        this.out.println("\n*** Slice questions:\n");
        this.askSliceQuestions(false, true, false, askExpire, true);
    }

    public void askNewSliceQuestions() throws IOException {
        this.out.println("\n*** Slice questions:\n");
        this.askSliceQuestions(true, false, true, true, false);
    }

    public Instruction generateUserInfo() throws IOException {
        this.out.println("\n*** User Info request specific questions:\n");
        boolean showUserUrn = this.askBool("Show user URN", true);
        boolean listSlices = this.askBool("List slices", true);
        boolean listProjects = this.askBool("List projects", true);
        return new UserInfoInstruction(Instruction.Action.USERINFO, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, showUserUrn, listSlices, listProjects);
    }

    private Instruction generateSliceInfo() throws IOException {
        this.askExistingSliceQuestions();
        this.out.println("\n*** Slice Info request specific questions:\n");
        Boolean showStatus = this.askBool("Show Status", true);
        Boolean showMetaInfo = this.askBool("Show Meta Info", true);
        Boolean showUsers = this.askBool("Show Slice Users", true);
        Boolean showCredentials = this.askBool("Show Slice Credentials", false);
        return new SliceInfoInstruction(Instruction.Action.SLICEINFO, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, showStatus, showMetaInfo, showUsers, showCredentials, this.ignoreSliceRecoverTimeout);
    }

    private ESpec generateESpec() throws IOException {
        throw new RuntimeException("ESpec not yet supported in wizard.");
    }

    private Instruction generateSliceAction() throws IOException {
        this.askExistingSliceQuestions();
        this.out.println("\n*** Slice Action specific questions:\n");
        String sliceActionName = this.askListValue("Slice Action", Stream.of(SliceActionInstruction.SliceAction.values()).map(Enum::name).collect(Collectors.toList()), 0);
        SliceActionInstruction.SliceAction sliceAction = SliceActionInstruction.SliceAction.valueOf(sliceActionName);
        ESpec espec = null;
        if (sliceAction == SliceActionInstruction.SliceAction.RerunESpec) {
            espec = this.generateESpec();
        }
        return new SliceActionInstruction(Instruction.Action.SLICEACTION, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.especExecuteLogOutputs, this.proxy, this.slice, sliceAction, espec, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateRun() throws IOException {
        RunInstruction.DeleteOn deleteOn;
        RunInstruction.SshKeySource sshKeys;
        RunInstruction.ShareWith shareWith;
        Boolean overrideESpecRSpec;
        ESpec eSpec;
        AlreadyProvisionedRequestRSpec requestRSpec;
        this.out.println("\n*** Slice questions:\n");
        boolean failOnExistingSlice = this.askBool("Allow running in new slice", true);
        boolean failOnNonExistingSlice = this.askBool("Allow running in existing slice", false);
        boolean renewExistingSliceIfNeeded = failOnNonExistingSlice ? false : this.askBool("Renew existing slice if needed", true);
        this.askSliceQuestions(failOnExistingSlice, failOnNonExistingSlice, renewExistingSliceIfNeeded, true, failOnExistingSlice);
        this.out.println("\n*** Run questions:\n");
        int rspecEspecChoice = this.askListPosition("What do you want to use to define the experiment", Arrays.asList("Only Request RSpec", "Only ESpec", "(ADVANCED) Both RSpec and ESpec"), 0);
        if (rspecEspecChoice != 1) {
            RequestRSpec.RequestRSpecSource source = this.askEnum("Request RSpec source", RequestRSpec.RequestRSpecSource.class, RequestRSpec.RequestRSpecSource.PROVIDE_FILE);
            Boolean autoAssignSpecificNodesUsingListResources = this.askBool("(ADVANCED) If the RSpec contains nodes without component_id, assign to available nodes using a ListResources call", false);
            Boolean useNitosLease = this.askBool("(ADVANCED) use Nitos lease (nitos testbed only)", false);
            switch (source) {
                case PROVIDE_URL: {
                    String providedContentSource = this.askString("URL of the Request RSpec", null, false);
                    String bindUnboundNodesUrn = this.askString("(ADVANCED) URL To bind unbound (= no component_manager_id) nodes to (leave empty to not bind them)", null, true);
                    requestRSpec = new ProvidedUrlRequestRSpec(source, providedContentSource, Boolean.valueOf(false), bindUnboundNodesUrn, autoAssignSpecificNodesUsingListResources, useNitosLease);
                    break;
                }
                case PROVIDE_FILE: {
                    String providedContentSource = this.askString("File of the Request RSpec", null, false);
                    String bindUnboundNodesUrn = this.askString("(ADVANCED) URL To bind unbound (= no component_manager_id) nodes to (leave empty to not bind them)", null, true);
                    requestRSpec = new ProvidedFileRequestRSpec(source, providedContentSource, Boolean.valueOf(false), bindUnboundNodesUrn, autoAssignSpecificNodesUsingListResources, useNitosLease);
                    break;
                }
                case PROVIDE_CONTENT: {
                    String providedContentSource = this.askMultiString("Request RSpec (use EOF on a seperate line to end input)", null, false);
                    String bindUnboundNodesUrn = this.askString("(ADVANCED) URL To bind unbound (= no component_manager_id) nodes to (leave empty to not bind them)", null, true);
                    requestRSpec = new ProvidedContentRequestRSpec(source, providedContentSource, Boolean.valueOf(false), bindUnboundNodesUrn, autoAssignSpecificNodesUsingListResources, useNitosLease);
                    break;
                }
                case GENERATE_SIMPLE: {
                    GenerateSimpleRequestRSpec defaultGen = new GenerateSimpleRequestRSpec();
                    Integer nodeCount = this.askInt("Number of nodes in Request RSpec", defaultGen.getNodeCount());
                    String nodeSliverType = this.askString("Sliver Type of node(s)", defaultGen.getNodeSliverType(), true);
                    Boolean nodeExclusive = this.askBool("Is the \"exclusive\" attribute set for the nodes", defaultGen.getNodeExclusive());
                    List<String> nodeComponentUrn = this.askStringList("Component URNs of the nodes (comma separated list, may be empty)", true);
                    List<String> nodeAnsibleGroup = this.askStringList("Node ansible groups (comma separated list, may be empty)", true);
                    requestRSpec = new GenerateSimpleRequestRSpec(source, nodeCount, nodeSliverType, nodeExclusive, nodeComponentUrn, nodeAnsibleGroup, autoAssignSpecificNodesUsingListResources, useNitosLease);
                    break;
                }
                case GENERATE_USING_JFED: {
                    Integer nodeCount = this.askInt("Number of nodes in Request RSpec", 1);
                    String jFedResourceClass = this.askString("\"ResourceClass\" to use (= jFed icon ID, see https://flsmonitor-api.fed4fire.eu/resourceclass for a full list)", null, true);
                    List<String> nodeAnsibleGroup = this.askStringList("Node ansible groups (comma separated list, may be empty)", true);
                    requestRSpec = new GenerateUsingJFedRequestRSpec(source, nodeCount, jFedResourceClass, nodeAnsibleGroup, autoAssignSpecificNodesUsingListResources, useNitosLease);
                    break;
                }
                case GENERATE_USING_ADVERTISEMENT: {
                    AdvertisementBasedRspecGeneratorConfig config = new GenerateUsingAdvertisementRequestRSpec().getConfig();
                    this.out.println("(ADVANCED) The default AdvertisementBasedRspecGeneratorConfig will be used. Edit it in the result.");
                    requestRSpec = new GenerateUsingAdvertisementRequestRSpec(source, autoAssignSpecificNodesUsingListResources, useNitosLease, config);
                    break;
                }
                case ALREADY_PROVISIONED: {
                    requestRSpec = new AlreadyProvisionedRequestRSpec(source, autoAssignSpecificNodesUsingListResources, useNitosLease);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported RSpec source: " + String.valueOf(source));
                }
            }
        } else {
            requestRSpec = null;
        }
        if (rspecEspecChoice != 0) {
            ESpec.ESpecSource source = this.askEnum("ESpec source", ESpec.ESpecSource.class, ESpec.ESpecSource.PROVIDE_DIR);
            String providedContentSource = switch (source) {
                case ESpec.ESpecSource.PROVIDE_ARCHIVE_URL -> this.askString("ESpec Archive URL", null, false);
                case ESpec.ESpecSource.PROVIDE_ARCHIVE_FILE -> this.askString("ESpec Archive Filename", null, false);
                case ESpec.ESpecSource.PROVIDE_DIR -> this.askString("ESpec Directory", null, false);
                case ESpec.ESpecSource.PROVIDE_GIT_REPO_DIR -> this.askString("ESpec Git Repo Dir", null, false);
                case ESpec.ESpecSource.DIRECT -> this.askMultiString("ESpec experiment-specification.yml content (use EOF on a seperate line to end input)", null, false);
                default -> throw new RuntimeException("Unsupported ESpec source: " + String.valueOf(source));
            };
            List logStorage = null;
            eSpec = new ESpec(source, providedContentSource, logStorage);
        } else {
            eSpec = null;
        }
        if (eSpec != null && requestRSpec != null && requestRSpec.getSource() != RequestRSpec.RequestRSpecSource.ALREADY_PROVISIONED && rspecEspecChoice == 2) {
            this.out.println("You provided an RSpec, and an ESpec containing an RSpec. Which RSpec should be used?");
            overrideESpecRSpec = this.askBoolChoice("Use the RSpec provided seperatly", "Use the RSpec inside of the ESpec", true);
        } else {
            overrideESpecRSpec = null;
        }
        Provision provision = this.askBool("Do you want to start the experiment (=\"Provision the slice\")", true) ? new Provision(Boolean.valueOf(this.askBool("(ADVANCED) Do you want to use the geni_end_time option for CreateSliver", false)), Boolean.valueOf(true), this.askString("(ADVANCED) Set SCS (URL or service ID)", null, true)) : new Provision(Boolean.valueOf(false), Boolean.valueOf(false), null);
        WaitForReady waitForReady = this.askBool("Do you want to wait until the experiment is ready", true) ? new WaitForReady(this.askLongOrNull("What is the maximum wait time (in minutes) (leave empty to use a default)", null), this.askLongOrNull("(ADVANCED) How long should jFed wait after the experiment is ready, before proceeding (this is only useful to work around some testbed specific bugs) (in minutes) (leave empty not to wait extra)", null), Boolean.valueOf(false)) : new WaitForReady(null, null, Boolean.valueOf(false));
        Boolean runLinkTest = this.askBool("Do you want to run a link test", false);
        ExperimentSetupConfig experiment = new ExperimentSetupConfig(this.slice, (RequestRSpec)requestRSpec, eSpec, provision, waitForReady, overrideESpecRSpec, runLinkTest);
        if (this.askBool("Share the experiment", false)) {
            boolean shareMembers = this.askBool("Share the experiment with all project members", false);
            List<String> shareUsernames = this.askStringList("Share the experiment with specific users (provide usernames, in a comma seperated list)", true);
            shareWith = new RunInstruction.ShareWith(shareUsernames, shareMembers);
        } else {
            shareWith = null;
        }
        this.out.println("Questions about login SSH keys on requested nodes:");
        if (!this.askBool("   Use default login SSH keys", true)) {
            boolean userCert = this.askBool("   Add your login PEM SSH key", true);
            boolean userKeys = this.askBool("   Add the custom SSH key configured in jFed", true);
            boolean shareWithKeys = this.askBool("   Add SSH keys of all users the slice is shared with", true);
            boolean shareSshRspec = this.askBool("   Add all SSH keys specified in the RSpec (if any)", true);
            List<String> extraUsernames = this.askStringList("   Extra users of which to add SSH keys (provide usernames, in a comma seperated list)", true);
            List<String> extraKeys = this.askStringList("   Extra SSH keys (provide openssh format, in a comma seperated list)", true);
            sshKeys = new RunInstruction.SshKeySource(userCert, userKeys, shareWithKeys, shareSshRspec, extraUsernames, extraKeys);
        } else {
            sshKeys = null;
        }
        if (!this.askBool("   Use default Experiment Delete conditions (= only delete on failed basic experiment creation)", true)) {
            boolean failCreate = this.askBool("Delete experiment if basic experiment creation fails", true);
            boolean failBecomeReady = this.askBool("Delete experiment if experiment fails to become ready", false);
            boolean failConnectivityTest = this.askBool("Delete experiment if connectivity test fails", false);
            boolean failLinkTest = this.askBool("Delete experiment if link test fails", false);
            boolean failESpec = this.askBool("Delete experiment if ESpec execution fails", false);
            deleteOn = new RunInstruction.DeleteOn(failCreate, failBecomeReady, failConnectivityTest, failLinkTest, failESpec);
        } else {
            deleteOn = null;
        }
        String manifestFile = this.askString("File in which to store manifest RSpec", null, true);
        String ansibleDir = this.askString("Directory in which to store ansible files (inventory etc)", null, true);
        RunInstruction.ExperimentOutput experimentOutput = new RunInstruction.ExperimentOutput(manifestFile == null ? null : OutputTarget.FILE, manifestFile, ansibleDir);
        return new RunInstruction(Instruction.Action.RUN, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.especExecuteLogOutputs, this.proxy, experiment, shareWith, sshKeys, deleteOn, experimentOutput);
    }

    private Instruction generateCreateSlice() throws IOException {
        this.askNewSliceQuestions();
        return new CreateSliceInstruction(Instruction.Action.CREATESLICE, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice);
    }

    private Instruction generateListResources() throws IOException {
        this.out.println("\n*** ListResources questions:\n");
        boolean available = this.askBoolChoice("Request only available resources", "Request all resources", false);
        String testbedId = this.askString("Target Testbed (Give either a fedmon testbed ID, a fedmon server ID, or a testbed URN)", null, false);
        return new ListResourcesInstruction(Instruction.Action.LISTRESOURCES, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, available, testbedId);
    }

    private Instruction generateManifest() throws IOException {
        this.askExistingSliceQuestions();
        String manifestFilename = this.askString("File in which to store manifest RSpec (Note: you can also use callOutput for this. If you specify both, both will be used.)", null, true);
        String ansibleDirname = this.askString("Directory in which to store ansible files (inventory etc)", null, true);
        RunInstruction.ExperimentOutput output = new RunInstruction.ExperimentOutput(manifestFilename == null ? null : OutputTarget.FILE, manifestFilename, ansibleDirname);
        return new ManifestInstruction(Instruction.Action.MANIFEST, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, output, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateDelete() throws IOException {
        this.askExistingSliceQuestions();
        return new DeleteInstruction(Instruction.Action.DELETE, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generatePoa() throws IOException {
        this.askExistingSliceQuestions();
        String poaActionName = this.askListValue("Choose Operational Action to Perform", Stream.of(PoaInstruction.PoaAction.values()).map(Enum::name).collect(Collectors.toList()), 0);
        PoaInstruction.PoaAction poaAction = PoaInstruction.PoaAction.valueOf(poaActionName);
        String sliverUrn = this.askString("Sliver URN (you can leave this blank, which means \"all slivers\")", null, true);
        return new PoaInstruction(Instruction.Action.POA, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, poaAction, sliverUrn, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateRenew() throws IOException {
        this.askExistingSliceQuestions(true);
        return new RenewInstruction(Instruction.Action.RENEW, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateSliceCredential() throws IOException {
        this.askExistingSliceQuestions();
        return new SliceCredentialInstruction(Instruction.Action.SLICECREDENTIAL, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateSshShell() throws IOException {
        this.askExistingSliceQuestions();
        Boolean showCommand = this.askBoolChoice("Show SSH Command", "Login to the node using SSH", false);
        String clientId = this.askString("clientId of node to login to (leave empty to login to the only node of single nod experiments)", null, true);
        return new SshShellInstruction(Instruction.Action.SSHLOGIN, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, showCommand, clientId, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateSshExec() throws IOException {
        this.askExistingSliceQuestions();
        String command = this.askString("SSH Command", null, false);
        String clientId = this.askString("clientId of node to login to (leave empty to execute on all nodes)", null, true);
        return new SshExecInstruction(Instruction.Action.SSHEXEC, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, command, clientId, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateSshFetch() throws IOException {
        this.askExistingSliceQuestions();
        String remoteFile = this.askString("Remote file", null, false);
        String localTargetDir = this.askString("Local target dir", null, false);
        Boolean flat = this.askBoolChoice("Store files from all machines in localTargetDir", "Store files in subdir of localTargetDir with clientId of the node as name", false);
        Boolean merge = this.askBoolChoice("Concatenate the content of all files on all hosts (implies flat=true) (no guaranteed order!)", "Do not merge files", false);
        String clientId = this.askString("clientId of node to login to (leave empty to login to the only node of single nod experiments)", null, true);
        return new SshFetchInstruction(Instruction.Action.SSHFETCH, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy, this.slice, remoteFile, localTargetDir, clientId, flat, merge, this.ignoreSliceRecoverTimeout);
    }

    private Instruction generateDecryptPem() throws IOException {
        return new DecryptPemInstruction(Instruction.Action.DECRYPTPEM, this.user, this.actionOutputs, this.debugOutputs, this.callOutputs, this.proxy);
    }

    private class OutputPair {
        private final OutputTarget target;
        private final String filename;

        public OutputPair(OutputTarget target, String filename) {
            this.target = target;
            this.filename = filename;
        }

        public OutputTarget getTarget() {
            return this.target;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

