/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.request.geni_rspec_3.LoginServiceContents;
import be.iminds.ilabt.jfed.rspec.request.geni_rspec_3.NodeContents;
import be.iminds.ilabt.jfed.rspec.request.geni_rspec_3.RSpecContents;
import be.iminds.ilabt.jfed.rspec.request.geni_rspec_3.RspecTypeContents;
import be.iminds.ilabt.jfed.rspec.request.geni_rspec_3.ServiceContents;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

public class TestAggregateManager2ListResources
extends BaseApiTest<LegacyApiTestConfig> {
    private ProtogeniSliceAuthority sa;
    private AggregateManager2 am2;
    private List<AnyCredential> userCredentials;
    private SSHKeyHelper sshKeyHelper;
    private Map versionRawResult = null;
    private AggregateManager2.VersionInfo versionInfo = null;
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Test ListResources call. ListResources can take some time and bandwidth. This also tests all supported advertisement RSpec of an Aggregate Manager. A ListResources calls might be done for each.";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            return Collections.emptyList();
        }
    };

    @Inject
    public TestAggregateManager2ListResources(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    private List<AnyCredential> getUserCredentialList() {
        return this.userCredentials;
    }

    public SfaConnection getSAConnection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.user.getUserAuthorityServer(), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1));
    }

    public SfaConnection getAM2Connection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2));
    }

    private boolean isValidGeni3AdvertisementRspec(String rspec) {
        if (rspec == null) {
            return false;
        }
        this.assertNotNull(rspec, "Rspec is null");
        int nodeCount = 0;
        boolean loginCount = false;
        try {
            Class<RSpecContents> docClass = RSpecContents.class;
            String packageName = docClass.getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement doc = (JAXBElement)u.unmarshal((Reader)new StringReader(rspec));
            RSpecContents c = (RSpecContents)doc.getValue();
            RspecTypeContents typ = c.getType();
            this.assertEquals(typ.value(), "manifest", "Received manifest RSpec is not a manifest.");
            for (Object o : c.getAnyOrNodeOrLink()) {
                JAXBElement el;
                if (!(o instanceof JAXBElement) || !((el = (JAXBElement)o).getValue() instanceof NodeContents)) continue;
                NodeContents node = (NodeContents)el.getValue();
                String nodeName = node.getClientId();
                ++nodeCount;
                for (Object nodeElO : node.getAnyOrRelationOrLocation()) {
                    JAXBElement nodeEl;
                    if (!(nodeElO instanceof JAXBElement) || !((nodeEl = (JAXBElement)nodeElO).getValue() instanceof ServiceContents)) continue;
                    ServiceContents serviceC = (ServiceContents)nodeEl.getValue();
                    for (Object serviceElO : serviceC.getAnyOrLoginOrInstall()) {
                        JAXBElement serviceEl;
                        if (!(serviceElO instanceof JAXBElement) || !((serviceEl = (JAXBElement)serviceElO).getValue() instanceof LoginServiceContents)) continue;
                        LoginServiceContents loginSC = (LoginServiceContents)serviceEl.getValue();
                        String auth = loginSC.getAuthentication();
                        String aHostname = loginSC.getHostname();
                        int aPort = 0;
                        if (loginSC.getPort() != null) {
                            aPort = Integer.parseInt(loginSC.getPort());
                        }
                        String aUsername = (String)loginSC.getOtherAttributes().get(new QName("username"));
                        if (!Objects.equals(auth, "ssh-keys")) continue;
                        this.assertEquals("ssh-keys", auth, "service login authentication must be ssh-keys for node " + nodeName);
                        this.assertNotNull(aHostname, "no hostname in service login for node " + nodeName);
                        this.assertNotNull(aUsername, "no username in service login for node " + nodeName);
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Exception parsing manifest RSpec Xml: " + e.getMessage(), e);
        }
        return true;
    }

    private boolean isEmptyRspec(String rspec) {
        return rspec.length() < 30;
    }

    public void testAM2CorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM2CorrectnessXmlRpcResult code == null in " + String.valueOf(res));
        this.assertNotNull(value, "testAM2CorrectnessXmlRpcResult value == null in " + String.valueOf(res));
        this.assertInstanceOf(code, Map.class, "testAM2CorrectnessXmlRpcResult code is not Map in " + String.valueOf(res));
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM2CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + String.valueOf(res));
        this.assertEquals(genicode.getClass(), Integer.class, "testAM2CorrectnessXmlRpcResult code.geni_code is not int in " + String.valueOf(res));
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + String.valueOf(res));
            this.assertEquals(output.getClass(), String.class, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else {
            if (output == null) {
                this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
            }
            if (output != null && !(output instanceof String)) {
                this.warn("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
            }
        }
    }

    @Override
    public void setUp() throws JFedException {
        this.am2 = new AggregateManager2(this.logger, this.getJFedPreferences());
        System.out.println("Fetching User credential needed for AM tests");
        AutomaticUserAndSliceApiWrapper credWrapper = this.getAutomaticUserAndSliceApiWrapperFactory().create();
        this.userCredentials = credWrapper.getUserCredentials(this.logger, this.user.getUserUrn());
    }

    @ApiTest.Test
    public void testGetVersionXmlRpcCorrectness() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.getVersion(this.getAM2Connection());
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.versionRawResult = reply.getRawResult();
        this.assertNotNull(this.versionRawResult);
        Object ver = this.versionRawResult.get("geni_api");
        assert (ver != null);
        assert (ver instanceof Integer);
        int v = (Integer)ver;
        assert (v == 2);
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        this.versionInfo = (AggregateManager2.VersionInfo)reply.getValue();
        this.assertNotNull(this.versionInfo);
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"})
    public void testGetVersionResultCorrectness() throws JFedException {
        String[] rspecVersionListnames;
        Map value = (Map)this.versionRawResult.get("value");
        this.assertEquals(value.get("geni_api"), 2);
        this.assertNotNull(value.get("geni_api_versions"), "geni_api_versions not in version result");
        this.assertTrue(value.get("geni_api_versions") instanceof Map, "geni_api_versions is not a Map but a " + value.get("geni_api_versions").getClass().getName());
        for (String name : rspecVersionListnames = new String[]{"geni_request_rspec_versions", "geni_ad_rspec_versions"}) {
            this.assertNotNull(value.get(name), name + " not in version result");
            Object[] v = this.assertInstanceOf(value.get(name), Object[].class, name + " is not a List but a " + value.get(name).getClass().getName());
            this.assertTrue(v.length > 0, name + " array is empty");
            for (Object o : v) {
                Object[] extensions;
                this.assertTrue(o instanceof Map, name + " array should contain only Map not a " + o.getClass().getName());
                Map t = (Map)o;
                this.assertMapContainsNonemptyString(t, "type");
                this.assertMapContainsNonemptyString(t, "version");
                this.assertMapContainsString(t, "schema");
                this.assertMapContainsString(t, "namespace");
                Object extensionsO = t.get("extensions");
                this.assertNotNull(extensionsO);
                for (Object e : extensions = this.assertInstanceOf(extensionsO, Object[].class, "value for extensions of " + name + " is not a String but a " + extensionsO.getClass().getName())) {
                    this.assertTrue(e instanceof String, "an extension of \"+name+\" is not a string but a " + e.getClass().getName());
                }
            }
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionResultCorrectness"})
    public void testGetVersionResultNoDuplicates() throws JFedException {
        ArrayList<AggregateManager2.VersionInfo.RspecVersion> adRspecVersions = new ArrayList<AggregateManager2.VersionInfo.RspecVersion>();
        for (AggregateManager2.VersionInfo.RspecVersion rspecVer : this.versionInfo.getAdRspecVersions()) {
            for (AggregateManager2.VersionInfo.RspecVersion other : adRspecVersions) {
                this.assertFalse(other.equalTypeAndVersion(rspecVer), "VersionInfo Result invalid: Duplicate Rspec type/version pair in supported Advertisement RSpec:type=" + other.getType() + " version=" + other.getVersion() + " VS type=" + rspecVer.getType() + " version=" + rspecVer.getVersion() + " ");
            }
            adRspecVersions.add(rspecVer);
        }
        ArrayList<AggregateManager2.VersionInfo.RspecVersion> reqRspecVersions = new ArrayList<AggregateManager2.VersionInfo.RspecVersion>();
        for (AggregateManager2.VersionInfo.RspecVersion rspecVer : this.versionInfo.getRequestRspecVersions()) {
            for (AggregateManager2.VersionInfo.RspecVersion other : reqRspecVersions) {
                this.assertFalse(other.equalTypeAndVersion(rspecVer), "VersionInfo Result invalid: Duplicate Rspec type/version pair in supported Request RSpectype=" + other.getType() + " version=" + other.getVersion() + " VS type=" + rspecVer.getType() + " version=" + rspecVer.getVersion() + " ");
            }
            reqRspecVersions.add(rspecVer);
        }
    }

    @ApiTest.DataProvider(name="testListResourcesDataProvider")
    public Object[][] getTypeVersionList() {
        assert (this.versionInfo != null);
        Object[][] res = new Object[this.versionInfo.getAdRspecVersions().size()][1];
        int i = 0;
        for (AggregateManager2.VersionInfo.RspecVersion rspecVersion : this.versionInfo.getAdRspecVersions()) {
            res[i++][0] = rspecVersion;
        }
        return res;
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness", "testGetVersionResultCorrectness", "testGetVersionResultNoDuplicates"}, dataProvider="testListResourcesDataProvider")
    public void testListAllResources(AggregateManager2.VersionInfo.RspecVersion rspecVersion) throws JFedException {
        this.note("Testing ListResources for type=" + rspecVersion.getType() + " version=" + rspecVersion.getVersion());
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.listResources(this.getAM2Connection(), this.getUserCredentialList(), rspecVersion.getType(), rspecVersion.getVersion(), Boolean.valueOf(true), Boolean.valueOf(true), null, null);
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        if (rspecVersion.getType().equalsIgnoreCase("geni") && Objects.equals(rspecVersion.getVersion(), "3")) {
            this.assertTrue(this.isValidGeni3AdvertisementRspec((String)reply.getValue()));
        }
        this.assertTrue(!this.isEmptyRspec((String)reply.getValue()));
    }
}

