/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationRegistryApi2;
import be.iminds.ilabt.jfed.lowlevel.api.test.AbstractFederationApi2Test;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.NoConfigApiTestMetaData;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestFederationRegistry2
extends AbstractFederationApi2Test {
    private static final ApiTestMetaData metadata = new NoConfigApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Test Federation API Federation Registry version 2";
        }
    };
    private FederationRegistryApi2 fr;
    private GeniUrn testUserUrn;
    final List<String> serviceDefaultFieldNames = new ArrayList<String>();
    List<AbstractFederationApi.GetVersionResult.FieldInfo> serviceDefaultFields = new ArrayList<AbstractFederationApi.GetVersionResult.FieldInfo>();
    private AbstractFederationApi.LookupResult<FederationRegistryApi2.ServiceDetails> amDetails;
    private AbstractFederationApi.LookupResult<FederationRegistryApi2.ServiceDetails> maDetails;
    private AbstractFederationApi.LookupResult<FederationRegistryApi2.ServiceDetails> saDetails;
    private boolean hasTestedMulti = false;

    @Inject
    public TestFederationRegistry2(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static ApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getConnection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH, 2));
    }

    protected void checkLookupServiceCorrectness(AbstractFederationApi.FederationApiReply reply, List<String> filter) {
        this.setErrorsFatal();
        Object rawReplyValue = reply.getRawValue();
        Object[] rawReplyValueV = this.assertInstanceOf(rawReplyValue, Object[].class, "Lookup service result should be an array (=List), but is of type " + rawReplyValue.getClass().getName());
        this.setErrorsNotFatal();
        for (Object o : rawReplyValueV) {
            this.assertInstanceOf(o, Map.class, "Lookup service array should contain dictionaries (=Map) of string to object . But at least one value is not dict but " + o.getClass().getName());
            Map ht = (Map)o;
            if (filter == null) {
                this.assertMapContainsNonemptyString(ht, "SERVICE_TYPE");
                this.assertMapContainsNonemptyString(ht, "SERVICE_URN");
                this.assertMapContainsNonemptyString(ht, "SERVICE_URL");
                this.assertMapContainsNonemptyString(ht, "SERVICE_NAME");
                continue;
            }
            for (String requiredField : filter) {
                this.assertMapContainsNonemptyString(ht, requiredField);
            }
        }
        this.setErrorsFatal();
    }

    @Override
    public void setUp() {
        this.fr = new FederationRegistryApi2(this.logger, this.getJFedPreferences());
        this.fr.setHandleMalformedReplies(false);
        this.testUserUrn = GeniUrn.parse((String)this.user.getUserUrnString());
        this.assertNotNull(this.testUserUrn, "Error in test user urn: " + this.user.getUserUrnString());
        this.serviceDefaultFields = this.fr.getMinimumFields("SERVICE");
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.serviceDefaultFields) {
            this.serviceDefaultFieldNames.add(fi.getName());
        }
    }

    @ApiTest.Test
    public void getVersion() throws JFedException {
        AbstractFederationApi.FederationApiReply reply = this.fr.getVersion(this.getConnection());
        this.checkGetVersion((AbstractFederationApi.FederationApiReply<? extends AbstractFederationApi.GetVersionResult>)reply, (AbstractFederationApi)this.fr, false);
    }

    @ApiTest.Test
    public void lookupAggregatesNoFilter() throws JFedException {
        Map match = null;
        List filter = null;
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupAM(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        this.checkLookupServiceCorrectness(reply, filter);
        this.amDetails = (AbstractFederationApi.LookupResult)reply.getValue();
        this.assertNotNull(this.amDetails, "lookup_aggregates returned null reply");
        for (FederationRegistryApi2.ServiceDetails sd : this.amDetails.values()) {
            this.note("lookup_aggregates returned aggregate: " + String.valueOf(sd.getUrl()));
        }
    }

    @ApiTest.Test
    public void lookupMemberAuthoritiesNoFilter() throws JFedException {
        Map match = null;
        List filter = null;
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupMA(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        this.maDetails = (AbstractFederationApi.LookupResult)reply.getValue();
        this.assertNotNull(this.maDetails);
        for (FederationRegistryApi2.ServiceDetails sd : this.maDetails.values()) {
            this.note("lookup_member_authorities returned aggregate: " + String.valueOf(sd.getUrl()));
        }
    }

    @ApiTest.Test
    public void lookupSliceAuthoritiesNoFilter() throws JFedException {
        Map match = null;
        List filter = null;
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupSA(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        this.saDetails = (AbstractFederationApi.LookupResult)reply.getValue();
        this.assertNotNull(this.saDetails);
        for (FederationRegistryApi2.ServiceDetails sd : this.saDetails.values()) {
            this.note("lookup_slice_authorities returned: " + String.valueOf(sd.getUrl()));
        }
    }

    @ApiTest.Test(hardDepends={"lookupAggregatesNoFilter"})
    public void lookupAggregatesWithMatchNoFilter() throws JFedException {
        if (this.amDetails.isEmpty()) {
            this.skip("cannot test match if there are no AM");
        }
        ArrayList<FederationRegistryApi2.ServiceDetails> toMatch = new ArrayList<FederationRegistryApi2.ServiceDetails>();
        ArrayList<String> urnToMatch = new ArrayList<String>();
        ArrayList<String> urlToMatch = new ArrayList<String>();
        ArrayList list = new ArrayList(this.amDetails.values());
        if (!this.hasTestedMulti && list.size() > 3) {
            this.note("Testing list of scalars, indicating an OR, as value in the match dictionary");
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(1));
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(2));
            this.hasTestedMulti = true;
        } else {
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(0));
        }
        for (FederationRegistryApi2.ServiceDetails amDetail : toMatch) {
            this.assertNotNull(amDetail.getUrn(), "A service in a previous test call did not specify an URN");
            this.assertNotNull(amDetail.getUrl(), "A service in a previous test call did not specify an URL");
            urnToMatch.add(amDetail.getUrn().getValue());
            urlToMatch.add(amDetail.getUrl().toExternalForm());
        }
        this.note("Testing match by URL");
        HashMap<String, ArrayList<String>> match = new HashMap<String, ArrayList<String>>();
        List filter = null;
        if (urlToMatch.size() > 1) {
            match.put("SERVICE_URL", urlToMatch);
        } else {
            match.put("SERVICE_URL", (ArrayList<String>)urlToMatch.get(0));
        }
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupAM(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        this.amDetails = (AbstractFederationApi.LookupResult)reply.getValue();
        this.assertNotNull(this.amDetails);
        this.assertEquals(this.amDetails.size(), toMatch.size(), "The search returned a different number of results than expected.");
        for (FederationRegistryApi2.ServiceDetails sd : this.amDetails.values()) {
            this.assertTrue(urnToMatch.remove(sd.getUrn().getValue()), "returned a service that should not have been matched: " + String.valueOf(sd.getUrn()));
        }
        this.assertEmpty(urnToMatch, "Some services where not matched as expected: " + String.valueOf(urnToMatch));
    }

    @ApiTest.Test(hardDepends={"lookupMemberAuthoritiesNoFilter"})
    public void lookupMemberAuthoritiesWithMatchNoFilter() throws JFedException {
        if (this.maDetails.isEmpty()) {
            this.skip("cannot test match if there are no MA");
        }
        ArrayList<FederationRegistryApi2.ServiceDetails> toMatch = new ArrayList<FederationRegistryApi2.ServiceDetails>();
        ArrayList<String> urnToMatch = new ArrayList<String>();
        ArrayList<String> nameToMatch = new ArrayList<String>();
        ArrayList list = new ArrayList(this.amDetails.values());
        if (!this.hasTestedMulti && list.size() > 3) {
            this.note("Testing list of scalars, indicating an OR, as value in the match dictionary");
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(1));
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(2));
            this.hasTestedMulti = true;
        } else {
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(0));
        }
        for (FederationRegistryApi2.ServiceDetails maDetail : toMatch) {
            this.assertNotNull(maDetail.getUrn(), "A service in a previous test call did not specify an URN");
            this.assertNotNull(maDetail.getName(), "A service in a previous test call did not specify an name");
            urnToMatch.add(maDetail.getUrn().getValue());
            nameToMatch.add(maDetail.getName());
        }
        this.note("Testing match by NAME");
        HashMap<String, ArrayList<String>> match = new HashMap<String, ArrayList<String>>();
        List filter = null;
        if (nameToMatch.size() > 1) {
            match.put("SERVICE_NAME", nameToMatch);
        } else {
            match.put("SERVICE_NAME", (ArrayList<String>)nameToMatch.get(0));
        }
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupMA(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        this.maDetails = (AbstractFederationApi.LookupResult)reply.getValue();
        this.assertNotNull(this.maDetails);
        this.assertEquals(this.maDetails.size(), toMatch.size(), "The search returned a different number of results than expected.");
        for (FederationRegistryApi2.ServiceDetails sd : this.maDetails.values()) {
            this.assertTrue(urnToMatch.remove(sd.getUrn().getValue()), "returned a service that should not have been matched: " + String.valueOf(sd.getUrn()));
        }
        this.assertEmpty(urnToMatch, "Some services where not matched as expected: " + String.valueOf(urnToMatch));
    }

    @ApiTest.Test(hardDepends={"lookupSliceAuthoritiesNoFilter"})
    public void lookupSliceAuthoritiesWithMatchNoFilter() throws JFedException {
        if (this.saDetails.isEmpty()) {
            this.skip("cannot test match if there are no SA");
        }
        ArrayList<FederationRegistryApi2.ServiceDetails> toMatch = new ArrayList<FederationRegistryApi2.ServiceDetails>();
        ArrayList<String> urnToMatch = new ArrayList<String>();
        ArrayList list = new ArrayList(this.amDetails.values());
        if (!this.hasTestedMulti && this.saDetails.size() > 3) {
            this.note("Testing list of scalars, indicating an OR, as value in the match dictionary");
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(1));
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(2));
            this.hasTestedMulti = true;
        } else {
            toMatch.add((FederationRegistryApi2.ServiceDetails)list.get(0));
        }
        for (FederationRegistryApi2.ServiceDetails saDetail : toMatch) {
            this.assertNotNull(saDetail.getUrn(), "A service in a previous test call did not specify an URN");
            urnToMatch.add(saDetail.getUrn().getValue());
        }
        this.note("Testing match by URN");
        HashMap<String, ArrayList<String>> match = new HashMap<String, ArrayList<String>>();
        List filter = null;
        if (urnToMatch.size() > 1) {
            match.put("SERVICE_URN", urnToMatch);
        } else {
            match.put("SERVICE_URN", (ArrayList<String>)urnToMatch.get(0));
        }
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupSA(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        this.saDetails = (AbstractFederationApi.LookupResult)reply.getValue();
        this.assertNotNull(this.saDetails);
        this.assertEquals(this.saDetails.size(), toMatch.size(), "The search returned a different number of results than expected.");
        for (FederationRegistryApi2.ServiceDetails sd : this.saDetails.values()) {
            this.assertTrue(urnToMatch.remove(sd.getUrn().getValue()), "returned a service that should not have been matched: " + String.valueOf(sd.getUrn()));
        }
        this.assertEmpty(urnToMatch, "Some services where not matched as expected: " + String.valueOf(urnToMatch));
    }

    private void checkRawLookupResult(List<Map<String, String>> rawLookupResult, List<String> expectedFieldNames, List<String> excludedFieldNames) {
        this.assertNotNull(rawLookupResult);
        for (Map<String, String> serviceInfo : rawLookupResult) {
            for (String fieldName : expectedFieldNames) {
                if (serviceInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result does not contain field: \"" + fieldName + "\"");
            }
            for (String fieldName : excludedFieldNames) {
                if (!serviceInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result contains unexpected field: \"" + fieldName + "\"");
            }
        }
    }

    @ApiTest.Test(softDepends={"lookupAggregatesWithMatchNoFilter"})
    public void lookupAggregatesWithFilter() throws JFedException {
        Map match = null;
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("SERVICE_URL");
        filter.add("SERVICE_CERT");
        filter.add("SERVICE_DESCRIPTION");
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupAM(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        List rawResult = (List)reply.getRawValue();
        this.assertNotNull(rawResult);
        ArrayList<String> expectedFieldNames = new ArrayList<String>(filter);
        ArrayList<String> excludedFieldNames = new ArrayList<String>(this.serviceDefaultFieldNames);
        excludedFieldNames.removeAll(expectedFieldNames);
        this.checkRawLookupResult(rawResult, expectedFieldNames, excludedFieldNames);
    }

    @ApiTest.Test(softDepends={"lookupMemberAuthoritiesWithMatchNoFilter"})
    public void lookupMemberAuthoritiesWithFilter() throws JFedException {
        Map match = null;
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("SERVICE_NAME");
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupMA(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        List rawResult = (List)reply.getRawValue();
        this.assertNotNull(rawResult);
        ArrayList<String> expectedFieldNames = new ArrayList<String>(filter);
        ArrayList<String> excludedFieldNames = new ArrayList<String>(this.serviceDefaultFieldNames);
        excludedFieldNames.removeAll(expectedFieldNames);
        this.checkRawLookupResult(rawResult, expectedFieldNames, excludedFieldNames);
    }

    @ApiTest.Test(softDepends={"lookupSliceAuthoritiesWithMatchNoFilter"})
    public void lookupSliceAuthoritiesWithFilter() throws JFedException {
        Map match = null;
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("SERVICE_URN");
        filter.add("SERVICE_CERT");
        filter.add("SERVICE_DESCRIPTION");
        AbstractFederationApi.FederationApiReply reply = this.fr.lookupSA(this.getConnection(), filter, match, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.checkLookupServiceCorrectness(reply, filter);
        List rawResult = (List)reply.getRawValue();
        this.assertNotNull(rawResult);
        ArrayList<String> expectedFieldNames = new ArrayList<String>(filter);
        ArrayList<String> excludedFieldNames = new ArrayList<String>(this.serviceDefaultFieldNames);
        excludedFieldNames.removeAll(expectedFieldNames);
        this.checkRawLookupResult(rawResult, expectedFieldNames, excludedFieldNames);
    }

    @ApiTest.Test(hardDepends={"lookupAggregatesNoFilter"})
    public void lookupAMForUrns() throws JFedException {
        URL returnedUrl;
        Map mapping;
        AbstractFederationApi.FederationApiReply reply;
        this.assertNotNull(this.amDetails);
        ArrayList<GeniUrn> urns = new ArrayList<GeniUrn>();
        for (FederationRegistryApi2.ServiceDetails amDetail : this.amDetails.values()) {
            this.assertNotNull(amDetail.getUrn(), "A service in a previous test call did not specify an URN");
            urns.add(GeniUrn.createGeniUrnFromEncodedParts((String)amDetail.getUrn().getEncodedTopLevelAuthority(), (String)"sliver", (String)"fakesliver"));
        }
        this.note("Looking up " + urns.size() + " AM urns: " + String.valueOf(urns));
        try {
            reply = this.fr.lookupAuthoritiesForUrns(this.getConnection(), urns);
            this.assertTrue(reply.getGeniResponseCode().isSuccess());
            mapping = (Map)reply.getValue();
            this.assertNotNull(mapping);
            this.setErrorsNotFatal();
            this.assertEquals(mapping.size(), urns.size(), "Size of returned Map differs from number of requested urns. returned Map=" + String.valueOf(mapping));
            for (FederationRegistryApi2.ServiceDetails amDetail : this.amDetails.values()) {
                returnedUrl = (URL)mapping.get(GeniUrn.createGeniUrnFromEncodedParts((String)amDetail.getUrn().getEncodedTopLevelAuthority(), (String)"sliver", (String)"fakesliver"));
                this.assertNotNull(returnedUrl, "lookup_authorities_for_urns did not return an entry for " + String.valueOf(amDetail.getUrn()));
                if (returnedUrl == null) continue;
                this.assertEquals(returnedUrl, amDetail.getUrl(), "lookup_authorities_for_urns did not return the same URL for " + String.valueOf(amDetail.getUrn()));
            }
            this.note("first test done.");
        }
        catch (JFedException e) {
            this.errorNonFatal("Error calling lookup_authorities_for_urns: probably malformed URN or URL in reply. error message:" + e.getMessage());
        }
        this.setErrorsFatal();
        urns = new ArrayList();
        for (FederationRegistryApi2.ServiceDetails amDetail : this.amDetails.values()) {
            this.assertNotNull(amDetail.getUrn(), "A service in a previous test call did not specify an URN");
            urns.add(amDetail.getUrn());
        }
        this.note("Looking up " + urns.size() + " AM urns: " + String.valueOf(urns));
        try {
            reply = this.fr.lookupAuthoritiesForUrns(this.getConnection(), urns);
            this.assertTrue(reply.getGeniResponseCode().isSuccess());
            mapping = (Map)reply.getValue();
            this.assertNotNull(mapping);
            this.setErrorsNotFatal();
            this.assertEquals(mapping.size(), urns.size(), "Size of returned Map differs from number of requested urns. returned Map=" + String.valueOf(mapping));
            for (FederationRegistryApi2.ServiceDetails amDetail : this.amDetails.values()) {
                returnedUrl = (URL)mapping.get(amDetail.getUrn());
                this.assertNotNull(returnedUrl, "lookup_authorities_for_urns did not return an entry for " + String.valueOf(amDetail.getUrn()));
                if (returnedUrl == null) continue;
                this.assertEquals(returnedUrl, amDetail.getUrl(), "lookup_authorities_for_urns did not return the same URL for " + String.valueOf(amDetail.getUrn()));
            }
        }
        catch (JFedException e) {
            this.errorNonFatal("Error calling lookup_authorities_for_urns: probably malformed URN or URL in reply. error message:" + e.getMessage());
        }
        this.setErrorsFatal();
    }

    @ApiTest.Test(hardDepends={"lookupSliceAuthoritiesNoFilter"})
    public void lookupSAForUrns() throws JFedException {
        this.assertNotNull(this.saDetails);
        Random r = new Random(System.currentTimeMillis());
        ArrayList<GeniUrn> urns = new ArrayList<GeniUrn>();
        HashMap<GeniUrn, URL> requestUrnToExpectedUrl = new HashMap<GeniUrn, URL>();
        for (FederationRegistryApi2.ServiceDetails saDetail : this.saDetails.values()) {
            this.assertNotNull(saDetail.getUrn(), "A service in a previous test call did not specify an URN");
            Object type = switch (r.nextInt(2)) {
                case 0 -> "slice";
                default -> "project";
            };
            GeniUrn geniUrn = GeniUrn.createGeniUrnFromEncodedParts((String)saDetail.getUrn().getEncodedTopLevelAuthority(), (String)type, (String)("fake" + (String)type));
            requestUrnToExpectedUrl.put(geniUrn, saDetail.getUrl());
            urns.add(geniUrn);
        }
        this.note("Looking up " + urns.size() + " SA urns: " + String.valueOf(urns));
        try {
            AbstractFederationApi.FederationApiReply reply = this.fr.lookupAuthoritiesForUrns(this.getConnection(), urns);
            this.assertTrue(reply.getGeniResponseCode().isSuccess());
            Map mapping = (Map)reply.getValue();
            this.assertNotNull(mapping);
            this.setErrorsNotFatal();
            this.assertEquals(mapping.size(), urns.size(), "Size of returned Map differs from number of requested urns. returned Map=" + String.valueOf(mapping));
            for (Map.Entry entry : requestUrnToExpectedUrl.entrySet()) {
                URL returnedUrl = (URL)mapping.get(entry.getKey());
                URL expectedURL = (URL)entry.getValue();
                this.assertNotNull(returnedUrl, "lookup_authorities_for_urns did not return an entry for " + String.valueOf(entry.getKey()));
                if (returnedUrl == null) continue;
                this.assertEquals(returnedUrl, expectedURL, "lookup_authorities_for_urns did not return the same URL for " + String.valueOf(entry.getKey()));
            }
            this.note("first test done.");
        }
        catch (JFedException e) {
            this.errorNonFatal("Error calling lookup_authorities_for_urns: probably malformed URN or URL in reply. error message:" + e.getMessage());
        }
        this.setErrorsFatal();
        urns = new ArrayList();
        for (FederationRegistryApi2.ServiceDetails saDetail : this.saDetails.values()) {
            this.assertNotNull(saDetail.getUrn(), "A service in a previous test call did not specify an URN");
            urns.add(saDetail.getUrn());
        }
        this.note("Looking up " + urns.size() + " SA urns: " + String.valueOf(urns));
        try {
            AbstractFederationApi.FederationApiReply reply = this.fr.lookupAuthoritiesForUrns(this.getConnection(), urns);
            this.assertTrue(reply.getGeniResponseCode().isSuccess());
            Map mapping = (Map)reply.getValue();
            this.assertNotNull(mapping);
            this.setErrorsNotFatal();
            this.assertEquals(mapping.size(), urns.size(), "Size of returned Map differs from number of requested urns. returned Map=" + String.valueOf(mapping));
            for (FederationRegistryApi2.ServiceDetails saDetail : this.saDetails.values()) {
                URL uRL = (URL)mapping.get(saDetail.getUrn());
                this.assertNotNull(uRL, "lookup_authorities_for_urns did not return an entry for " + String.valueOf(saDetail.getUrn()));
                if (uRL == null) continue;
                this.assertEquals(uRL, saDetail.getUrl(), "lookup_authorities_for_urns did not return the same URL for " + String.valueOf(saDetail.getUrn()));
            }
        }
        catch (JFedException e) {
            this.errorNonFatal("Error calling lookup_authorities_for_urns: probably malformed URN or URL in reply. error message:" + e.getMessage());
        }
        this.setErrorsFatal();
    }

    @ApiTest.Test(hardDepends={"lookupMemberAuthoritiesNoFilter"})
    public void lookupMAForUrns() throws JFedException {
        this.assertNotNull(this.maDetails);
        Random r = new Random(System.currentTimeMillis());
        ArrayList<GeniUrn> urns = new ArrayList<GeniUrn>();
        HashMap<GeniUrn, URL> requestUrnToExpectedUrl = new HashMap<GeniUrn, URL>();
        for (FederationRegistryApi2.ServiceDetails maDetail : this.maDetails.values()) {
            this.assertNotNull(maDetail.getUrn(), "A service in a previous test call did not specify an URN");
            Object type = switch (r.nextInt(2)) {
                case 0 -> "member";
                default -> "key";
            };
            GeniUrn geniUrn = GeniUrn.createGeniUrnFromEncodedParts((String)maDetail.getUrn().getEncodedTopLevelAuthority(), (String)type, (String)("fake" + (String)type));
            requestUrnToExpectedUrl.put(geniUrn, maDetail.getUrl());
            urns.add(geniUrn);
        }
        this.note("Looking up " + urns.size() + " MA urns: " + String.valueOf(urns));
        try {
            AbstractFederationApi.FederationApiReply reply = this.fr.lookupAuthoritiesForUrns(this.getConnection(), urns);
            this.assertTrue(reply.getGeniResponseCode().isSuccess());
            Map mapping = (Map)reply.getValue();
            this.assertNotNull(mapping);
            this.setErrorsNotFatal();
            this.assertEquals(mapping.size(), urns.size(), "Size of returned Map differs from number of requested urns. returned Map=" + String.valueOf(mapping));
            for (Map.Entry entry : requestUrnToExpectedUrl.entrySet()) {
                URL returnedUrl = (URL)mapping.get(entry.getKey());
                URL expectedURL = (URL)entry.getValue();
                this.assertNotNull(returnedUrl, "lookup_authorities_for_urns did not return an entry for " + String.valueOf(entry.getKey()));
                if (returnedUrl == null) continue;
                this.assertEquals(returnedUrl, expectedURL, "lookup_authorities_for_urns did not return the same URL for " + String.valueOf(entry.getKey()));
            }
            this.note("first test done.");
        }
        catch (JFedException e) {
            this.errorNonFatal("Error calling lookup_authorities_for_urns: probably malformed URN or URL in reply. error message:" + e.getMessage());
        }
        this.setErrorsFatal();
        urns = new ArrayList();
        for (FederationRegistryApi2.ServiceDetails maDetail : this.maDetails.values()) {
            this.assertNotNull(maDetail.getUrn(), "A service in a previous test call did not specify an URN");
            urns.add(maDetail.getUrn());
        }
        this.note("Looking up " + urns.size() + " MA urns: " + String.valueOf(urns));
        try {
            AbstractFederationApi.FederationApiReply reply = this.fr.lookupAuthoritiesForUrns(this.getConnection(), urns);
            this.assertTrue(reply.getGeniResponseCode().isSuccess());
            Map mapping = (Map)reply.getValue();
            this.assertNotNull(mapping);
            this.setErrorsNotFatal();
            this.assertEquals(mapping.size(), urns.size(), "Size of returned Map differs from number of requested urns. returned Map=" + String.valueOf(mapping));
            for (FederationRegistryApi2.ServiceDetails maDetail : this.maDetails.values()) {
                URL uRL = (URL)mapping.get(maDetail.getUrn());
                this.assertNotNull(uRL, "lookup_authorities_for_urns did not return an entry for " + String.valueOf(maDetail.getUrn()));
                if (uRL == null) continue;
                this.assertEquals(uRL, maDetail.getUrl(), "lookup_authorities_for_urns did not return the same URL for " + String.valueOf(maDetail.getUrn()));
            }
        }
        catch (JFedException e) {
            this.errorNonFatal("Error calling lookup_authorities_for_urns: probably malformed URN or URL in reply. error message:" + e.getMessage());
        }
        this.setErrorsFatal();
    }

    @ApiTest.Test
    public void lookupTrustRoots() throws JFedException {
        AbstractFederationApi.FederationApiReply reply = this.fr.getTrustRoots(this.getConnection());
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        List trustRoots = (List)reply.getValue();
        this.assertNotNull(trustRoots);
        for (String trustRoot : trustRoots) {
            Object tr = trustRoot;
            if (((String)tr).length() > 30) {
                tr = trustRoot.substring(0, 30) + "...";
            }
            this.note("get_trust_roots returned (showing maximum of 30 chars): " + (String)tr);
        }
    }
}

