/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv2Wrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv3Wrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStep;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStepConfig;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestNodeLogin
extends BaseApiTest<LegacyApiTestConfig> {
    protected NodeLoginTestStep nodeLoginTestStep;
    protected CommonAMTest commonAMTest;
    protected AggregateManagerWrapper amWrapper;
    private Boolean createSliceIfNotExists = true;
    private Boolean reuseSliceIfExists = false;
    private Boolean requireNodesInManifest = true;
    private Boolean disableCleanup = false;
    private Boolean useGeniEndTimeOptionForCreateSliver = true;
    private Map versionMap = null;
    protected CommonAMTest.SliceInfo slice;
    private boolean foundNodeLoginInProvision = false;
    private final AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory;
    private String fixedNodeUrnString;
    private String fixedNodeSliverType;
    private Boolean fixedNodeExclusive;
    private boolean needListResources;
    protected String requestRspec;
    protected String manifestRspec;
    protected String manifestRspec2;
    protected Boolean notEnoughResourcesDetected = null;
    protected int sliceExpireTimeInMinutes = 60;
    protected int provisionExpireTimeInMinutes = 25;
    protected int maxTimeToWaitForReadyInMinutes = 20;
    protected boolean forceUseExistingSliver = false;
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "This tests login to a node. AMv2 or AMv3 can be used, and login to a specific node can be configured.The sliver will be deleted afterwards.";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("fixed_ssh_public_key_file");
            res.add("fixed_ssh_private_key_file");
            res.add("fixed_ssh_private_key_password");
            res.add("use_geni_end_time_option_for_createsliver_calls");
            res.add("create_slice_if_not_exists");
            res.add("reuse_slice_if_exists");
            res.add("disable_slice_cleanup");
            res.add("fixed_slice_name");
            res.add("fixed_project_name");
            res.add("try_to_use_project_for_slices");
            CommonAMTest.addOptionsForFixedRspec(res);
            res.add("require_nodes_in_manifest");
            res.add("skip_final_manifest_check");
            res.add("fixed_node_sliver_type");
            res.add("fixed_node_exclusive");
            res.add("fixed_node_urn");
            res.add("am_version");
            res.add("nodelogin_deadline_ms");
            res.add("nodelogin_preferred_user");
            res.add("force_uses_existing_sliver");
            res.add("extra_wait_after_status_ready_in_seconds");
            res.add("nodelogin_force_ip_version");
            res.add("nodelogin_use_external_ssh");
            res.add("use_nitos_lease");
            res.add("slice_expire_time_in_minutes");
            res.add("provision_expire_time_in_minutes");
            res.add("max_time_to_wait_for_ready_in_minutes");
            CommonAMTest.addOptionsForNodeLoginSshProxy(res);
            CommonAMTest.addOptionsForConnectionSshProxy(res);
            CommonAMTest.addCredentialOptions(res);
            return res;
        }
    };
    protected boolean isGeniRspec = true;
    protected Date requestedEndTime;
    protected final Set<GeniUrn> createSliverUrns = new HashSet<GeniUrn>();

    @Inject
    public TestNodeLogin(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences, AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
        this.automaticAggregateManagerWrapperFactory = automaticAggregateManagerWrapperFactory;
    }

    private static List<String> toStringList(String s) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(s);
        return res;
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    @Override
    public void setUp() {
        String existingSliverStr;
        this.assertNotNull(this.user);
        this.assertNotNull(this.user.getUserAuthorityServerId());
        this.commonAMTest = new CommonAMTest(this, this.user.getUserAuthorityServerId(), this.getTestbedInfoSource());
        String amVersion = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("am_version");
        if (amVersion == null || amVersion.trim().equalsIgnoreCase("auto")) {
            this.amWrapper = this.automaticAggregateManagerWrapperFactory.create(this.logger, this.testedAuthority.getServerToConnect());
        } else {
            if (amVersion.trim().equalsIgnoreCase("2")) {
                this.amWrapper = new AMv2Wrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.getJFedPreferences(), this.testedAuthority.getServerToConnect());
            }
            if (amVersion.trim().equalsIgnoreCase("3")) {
                this.amWrapper = new AMv3Wrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.getJFedPreferences(), this.testedAuthority.getServerToConnect());
            }
            if (this.amWrapper == null) {
                throw new RuntimeException("Option \"am_version\" has unknown value (\"" + amVersion + "\") should be \"auto\", \"2\" or \"3\"");
            }
        }
        this.commonAMTest.processCredentialOptions(this.testbedInfoSource, this.authorityFinder);
        this.createSliceIfNotExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("create_slice_if_not_exists"));
        this.reuseSliceIfExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("reuse_slice_if_exists"));
        this.requireNodesInManifest = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("require_nodes_in_manifest"));
        this.disableCleanup = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("disable_slice_cleanup"));
        if (this.createSliceIfNotExists == null) {
            this.createSliceIfNotExists = true;
        }
        if (this.reuseSliceIfExists == null) {
            this.reuseSliceIfExists = false;
        }
        if (this.disableCleanup == null) {
            this.disableCleanup = false;
        }
        if (this.requireNodesInManifest == null) {
            this.requireNodesInManifest = true;
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("use_geni_end_time_option_for_createsliver_calls") != null) {
            Object v = ((LegacyApiTestConfig)this.getTestConfig()).get("use_geni_end_time_option_for_createsliver_calls");
            this.useGeniEndTimeOptionForCreateSliver = TextUtil.objectToBoolean((Object)String.valueOf(v));
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("slice_expire_time_in_minutes") != null) {
            this.sliceExpireTimeInMinutes = Integer.parseInt(TextUtil.objectToStringOrNull((Object)((LegacyApiTestConfig)this.getTestConfig()).get("slice_expire_time_in_minutes"), (boolean)true));
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("provision_expire_time_in_minutes") != null) {
            this.provisionExpireTimeInMinutes = Integer.parseInt(TextUtil.objectToStringOrNull((Object)((LegacyApiTestConfig)this.getTestConfig()).get("provision_expire_time_in_minutes"), (boolean)true));
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("max_time_to_wait_for_ready_in_minutes") != null) {
            this.maxTimeToWaitForReadyInMinutes = Integer.parseInt(TextUtil.objectToStringOrNull((Object)((LegacyApiTestConfig)this.getTestConfig()).get("max_time_to_wait_for_ready_in_minutes"), (boolean)true));
        }
        this.commonAMTest.setupProxyForConnectionPool((LegacyApiTestConfig)this.getTestConfig());
        this.fixedNodeUrnString = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_node_urn");
        boolean bl = this.needListResources = this.fixedNodeUrnString != null && this.fixedNodeUrnString.trim().equalsIgnoreCase("auto");
        if (this.needListResources) {
            this.fixedNodeUrnString = null;
        }
        this.fixedNodeSliverType = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_node_sliver_type");
        this.fixedNodeExclusive = TextUtil.stringToBoolean((String)((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_node_exclusive"));
        if (this.commonAMTest.getSpeaksForConfig() != null) {
            this.amWrapper.setSpeaksFor(this.commonAMTest.getSpeaksForConfig().getSpeaksForCredentials(), this.commonAMTest.getSpeaksForConfig().getUser2Urn());
            if (!this.commonAMTest.getSpeaksForConfig().isAutomaticSpeaksForOptionNames()) {
                this.amWrapper.setExtraOptionsForCallsWithCredential(this.commonAMTest.addCredentialExtraOptions(null));
            }
        }
        if ((existingSliverStr = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("force_uses_existing_sliver")) != null) {
            this.forceUseExistingSliver = TextUtil.stringToBoolean((String)existingSliverStr);
            if (this.forceUseExistingSliver) {
                this.assertTrue(this.reuseSliceIfExists, "Can only reuse slive if slice is fixed and exists");
                String fixedSliceName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_slice_name");
                this.assertNonEmptyString(fixedSliceName, "Can only reuse slive if slice is fixed and exists");
            }
        }
    }

    @ApiTest.Test(groups={"getversion", "nonodelogin", "beforesliver"})
    public void testGetVersion() throws JFedException {
        this.versionMap = this.amWrapper.getVersion();
    }

    @ApiTest.Test(hardDepends={}, softDepends={"testGetVersion"}, description="Create the slices used in the next tests", groups={"nonodelogin", "beforesliver"})
    public void createTestSlices() throws JFedException, IOException {
        String fixedProjectName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_project_name");
        boolean tryToUseProject = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("try_to_use_project_for_slices")) != Boolean.FALSE;
        String fixedSliceName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_slice_name");
        if (this.reuseSliceIfExists.booleanValue() && fixedSliceName != null) {
            this.slice = this.commonAMTest.reuseSlice(fixedSliceName);
            if (this.slice != null) {
                return;
            }
            if (!this.createSliceIfNotExists.booleanValue()) {
                throw new RuntimeException("create_slice_if_not_exists is false, and slice does not exist.");
            }
        }
        this.note("Will create slice that expires in " + this.sliceExpireTimeInMinutes + " minutes");
        this.slice = fixedSliceName == null ? this.commonAMTest.createSlice("s", fixedProjectName, tryToUseProject, true, this.sliceExpireTimeInMinutes) : this.commonAMTest.createSlice(fixedSliceName, false, fixedProjectName, tryToUseProject, true, this.sliceExpireTimeInMinutes);
        this.assertNotNull(this.slice.urnString, "sliceS.urnString may not be null");
        this.assertTrue(this.slice.urnString.startsWith("urn:publicid:IDN+"));
        this.assertNotNull(this.slice.credentials, "sliceS.credential may not be null");
        this.assertNotEmpty(this.slice.credentials, "sliceS.credential may not be empty");
        this.assertValidUrn(this.slice.urnString, "slice");
    }

    @ApiTest.Test(hardDepends={}, softDepends={"testGetVersion"}, groups={"createslivernowait", "createsliver", "nodelogin", "nonodelogin", "beforesliver"})
    public void listResources() throws JFedException, NoSuchAlgorithmException, ParseException, IOException {
        if (!this.needListResources) {
            this.note("The \"fixed_node_urn\" option is not \"auto\", so a ListResources call is not needed.");
            return;
        }
        this.note("The \"fixed_node_urn\" option is \"auto\", so ListResources call is needed to fill in the node URN to test.");
        List<AnyCredential> userCredentials = this.commonAMTest.getUserCredentialListForAM();
        String advertismentRspec = this.amWrapper.listResources(userCredentials, true);
        if (advertismentRspec == null) {
            this.errorFatal("ListResources call did not return an advertisement RSpec");
            return;
        }
        AdvertisementRspecSource advertisementRspecSource = new AdvertisementRspecSource(advertismentRspec, ModelRspecType.BASIC);
        List<BasicStringRspec.BasicNodeInfo> basicNodeInfos = advertisementRspecSource.getBasicNodeInfo();
        if (basicNodeInfos == null) {
            this.errorFatal("info could not be extracted from the advertisement RSpec. Is it valid?");
            return;
        }
        for (BasicStringRspec.BasicNodeInfo basicNodeInfo : basicNodeInfos) {
            if (basicNodeInfo.getComponentId() == null) continue;
            if (Objects.equals(basicNodeInfo.isAvailable(), Boolean.FALSE)) {
                this.warn("Found an node to use: \"" + basicNodeInfo.getComponentId() + "\", but it is marked as not available. This is a server bug, as we requested only available nodes.");
                continue;
            }
            this.fixedNodeUrnString = basicNodeInfo.getComponentId();
            this.fixedNodeSliverType = basicNodeInfo.getSliverTypes().isEmpty() ? null : (String)basicNodeInfo.getSliverTypes().iterator().next();
            this.fixedNodeExclusive = basicNodeInfo.isExclusive();
            this.note("Found an available node to use: \"" + this.fixedNodeUrnString + "\" sliver_type=" + this.fixedNodeSliverType + " exclusive=" + this.fixedNodeExclusive);
            return;
        }
        this.errorFatal("Did not find a single available node in the advertisement RSpec. The createSliver test will continue, BUT NOT specify a component_id.");
    }

    protected boolean isGeniRequestRspec() {
        return this.isGeniRspec;
    }

    protected boolean isGeniManifestRspec() {
        return this.isGeniRspec;
    }

    protected String getRequestRspec() throws IOException {
        String rspecArg = this.commonAMTest.getFixedRspecOption();
        if (rspecArg == null) {
            String res;
            GeniUrn fixedNodeUrn;
            boolean noFixedNode = this.fixedNodeUrnString == null || this.fixedNodeUrnString.trim().isEmpty();
            GeniUrn geniUrn = fixedNodeUrn = noFixedNode ? null : GeniUrn.parse((String)this.fixedNodeUrnString.trim());
            if (!noFixedNode && fixedNodeUrn == null) {
                this.warn("The setting \"fixed_node_urn\" contains an invalid urn: \"" + this.fixedNodeUrnString + "\". It will be ignored.");
            }
            if ((res = this.commonAMTest.getOneNodeRequestRSpec(this.testedAuthority.getServerForRspecComponentManager(), this.slice.urn, fixedNodeUrn, this.fixedNodeExclusive, this.fixedNodeSliverType)) == null) {
                this.skip("testCreateSliver skipped, because no RSpec example known for type=\"" + this.testedAuthority.getServerForRspecComponentManager().getServerType() + "\"");
            }
            this.isGeniRspec = true;
            return res;
        }
        this.isGeniRspec = this.commonAMTest.isGeniFixedRspec();
        return rspecArg;
    }

    @ApiTest.Test(hardDepends={"createTestSlices"}, softDepends={"testGetVersion", "listResources"}, groups={"createslivernowait", "createsliver", "nodelogin", "nonodelogin"})
    public void createSliver() throws JFedException, NoSuchAlgorithmException, ParseException, IOException {
        this.assertNotNull(this.slice);
        this.requestRspec = this.getRequestRspec();
        assert (this.requestRspec != null);
        int requestNodeCount = this.isGeniRequestRspec() ? new BasicStringRspec(this.requestRspec).getBasicNodeInfo().size() : 0;
        this.note("Using request with " + requestNodeCount + " nodes.");
        if (requestNodeCount < 1) {
            this.note("Fallback activated. Since " + requestNodeCount + " are in request RSpec, no node count will be assumed in manifest.");
            this.requireNodesInManifest = false;
        }
        this.requestedEndTime = null;
        if (this.useGeniEndTimeOptionForCreateSliver.booleanValue()) {
            this.note("Will Provision slivers with " + this.provisionExpireTimeInMinutes + " minutes expire time");
            this.requestedEndTime = new Date(System.currentTimeMillis() + (long)(this.provisionExpireTimeInMinutes * 60) * 1000L);
        } else {
            this.note("Will Provision slivers without explicit expire time (thus slice expire time should be used automatically by AM)");
        }
        NodeLoginTestStepConfig nodeLoginTestStepConfig = NodeLoginTestStepConfig.generateFromLegacyConfig(this, (LegacyApiTestConfig)this.getTestConfig(), this.geniUserProvider);
        this.nodeLoginTestStep = new NodeLoginTestStep(this, nodeLoginTestStepConfig);
        ArrayList<String> sshKeys = new ArrayList<String>();
        sshKeys.add(this.nodeLoginTestStep.getSshKeyHelper().getSshPublicKeyString());
        UserSpec userSpec = new UserSpec(this.user.getUserUrnString(), sshKeys);
        ArrayList<UserSpec> users = new ArrayList<UserSpec>();
        users.add(userSpec);
        if (this.forceUseExistingSliver) {
            this.notEnoughResourcesDetected = false;
            return;
        }
        try {
            this.manifestRspec = this.amWrapper.createSliver(this.slice.urn, this.commonAMTest.getSliceCredentialListForAM(this.slice), this.requestRspec, users, this.requestedEndTime);
            this.notEnoughResourcesDetected = false;
        }
        catch (AggregateManagerWrapper.NotEnoughFreeResourcesException e) {
            this.warn("Not enough free resources");
            this.notEnoughResourcesDetected = true;
            return;
        }
        if (this.manifestRspec == null) {
            this.warn("Created sliver for \"" + this.slice.urnString + "\" manifest=null");
        } else {
            this.note("Created sliver for \"" + this.slice.urnString + "\" manifest.length=" + this.manifestRspec.length());
        }
        this.assertNotNull(this.manifestRspec, "Provision should return a manifest RSpec");
        if (this.requireNodesInManifest.booleanValue()) {
            int nodesInManifest = CommonAMTest.testValidGeni3ManifestRspec(this, this.manifestRspec);
            this.assertEquals(nodesInManifest, requestNodeCount, "Provision did not return a the correct number of nodes in the manifest RSpec. The manifest RSpec has " + nodesInManifest + " nodes instead of the expected " + requestNodeCount + ". Full rspec: " + this.manifestRspec);
            this.assertFalse(CommonAMTest.isEmptyRspec(this, this.manifestRspec), "Provision returned and empty RSpec: " + this.manifestRspec);
            this.setErrorsNotFatal();
            this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest(this, this.requestRspec, this.manifestRspec));
            this.setErrorsFatal();
        } else if (this.isGeniManifestRspec()) {
            CommonAMTest.testValidGeni3ManifestRspec(this, this.manifestRspec);
        }
        if (this.isGeniManifestRspec()) {
            assert (!this.nodeLoginTestStep.hasParsed());
            this.foundNodeLoginInProvision = this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(this.manifestRspec, null, null);
            if (this.foundNodeLoginInProvision) {
                this.note("Successfully found node login info in reply");
            } else {
                this.note("Did not find node login info in reply");
            }
            ManifestRspecSource manifestRspecSource = new ManifestRspecSource(this.manifestRspec, ModelRspecType.BASIC);
            ImmutableModelRspec modelRspec = manifestRspecSource.getImmutableModelRspec();
            if (modelRspec != null) {
                for (RspecNode rspecNode : modelRspec.getNodes()) {
                    NodeLocation location = rspecNode.getLocation();
                    if (location == null) continue;
                    if (location.getCountry() != null) {
                        this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("location", "country").setValue(location.getCountry()).setLarge(false));
                        this.note("NODE COUNTRY: " + location.getCountry());
                    }
                    if (location.getLatitude() != null) {
                        this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("location", "latitude").setValue(location.getLatitude()).setLarge(false));
                        this.note("NODE LATITUDE: " + location.getLatitude());
                    }
                    if (location.getLongitude() == null) continue;
                    this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("location", "longitude").setValue(location.getLongitude()).setLarge(false));
                    this.note("NODE LONGITUDE: " + location.getLongitude());
                }
            }
        }
    }

    @ApiTest.Test(hardDepends={"createSliver"}, softDepends={}, groups={"createsliver", "nodelogin", "nonodelogin"})
    public void registerSlivers() throws JFedException, ParseException {
        if (this.requestedEndTime == null) {
            this.skip("Something went wrong creating the slivers. Will not register them.");
        }
        if (this.manifestRspec == null) {
            this.skip("No manifest after createSliver. Will not register any slivers.");
        }
        if (!this.isGeniManifestRspec()) {
            this.skip("Manifest after createSliver is no geni v3 format. Will not register any slivers.");
        }
        try {
            ManifestRspecSource manifestRspecSource = new ManifestRspecSource(this.manifestRspec, ModelRspecType.BASIC);
            ImmutableModelRspec modelRspec = manifestRspecSource.getImmutableModelRspec();
            if (modelRspec != null) {
                for (RspecNode rspecNode : modelRspec.getNodes()) {
                    if (rspecNode.getSliverId() == null) continue;
                    this.createSliverUrns.add(rspecNode.getSliverId());
                }
                if (!this.createSliverUrns.isEmpty()) {
                    this.commonAMTest.registerSlivers(this.slice, this.testedAuthority.getServerToConnect(), this.createSliverUrns, this.requestedEndTime);
                } else {
                    this.skip("No info on sliver URN's in manifest. Must skip register.");
                }
            } else {
                this.skip("Problem parsing manifest. Will not register any slivers.");
            }
        }
        catch (Exception t) {
            this.skip("Exception registering slivers.", t);
        }
    }

    @ApiTest.Test(hardDepends={"createSliver"}, softDepends={"registerSlivers"}, groups={"createsliver", "nodelogin", "nonodelogin"})
    public void waitForSliverReady() throws JFedException, ParseException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        this.assertNotNull(this.slice);
        this.note("Will wait max " + this.maxTimeToWaitForReadyInMinutes + " minutes for sliver to become ready");
        long now = System.currentTimeMillis();
        long deadline = now + (long)(this.maxTimeToWaitForReadyInMinutes * 60 * 1000);
        while (now < deadline) {
            StatusDetails statusDetails = this.amWrapper.status(this.slice.urn, this.commonAMTest.getSliceCredentialListForAM(this.slice));
            switch (statusDetails.getGlobalStatus()) {
                default: {
                    this.note("testCreatedSliverBecomesReady -> sliver not ready: " + String.valueOf(statusDetails.getGlobalStatus()) + ".  Trying again in 30 seconds...");
                    break;
                }
                case READY: {
                    this.note("testSliverBecomesReady -> sliver ready: " + String.valueOf(statusDetails));
                    String extraWait = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("extra_wait_after_status_ready_in_seconds");
                    if (extraWait != null && !extraWait.trim().isEmpty() && extraWait.matches("[0-9]*")) {
                        int extraSeconds = Integer.parseInt(extraWait);
                        this.note("Waiting " + extraSeconds + " extra seconds before continuing. (due to extra_wait_after_status_ready_in_seconds option)");
                        try {
                            Thread.sleep((long)extraSeconds * 1000L);
                        }
                        catch (InterruptedException e) {
                            this.warn("Extra waiting time was interrupted. This should not happen.", e);
                        }
                    }
                    return;
                }
                case FAIL: {
                    this.note("testSliverBecomesReady -> sliver failed: " + String.valueOf(statusDetails));
                    return;
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        throw new RuntimeException("Sliver did not become ready within " + this.maxTimeToWaitForReadyInMinutes + " minutes!");
    }

    @ApiTest.Test(hardDepends={"createSliver"}, softDepends={"waitForSliverReady"}, groups={"createsliver", "nodelogin", "nonodelogin"})
    public void describeReadySliver() throws JFedException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        this.assertNotNull(this.slice);
        this.manifestRspec2 = this.amWrapper.describe(this.slice.urn, this.commonAMTest.getSliceCredentialListForAM(this.slice));
        this.assertNotNull(this.manifestRspec2);
        this.setErrorsNotFatal();
        if (this.requestRspec != null && this.manifestRspec2 != null && this.isGeniRequestRspec() && this.isGeniManifestRspec()) {
            this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest(this, this.requestRspec, this.manifestRspec2));
        }
        this.setErrorsFatal();
        if (this.isGeniManifestRspec()) {
            boolean foundNodeLoginInDescribe = this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(this.manifestRspec2, null, null);
            if (foundNodeLoginInDescribe) {
                this.note("Successfully found node login info in Describe reply");
            } else {
                this.note("Did not find node login info in Describe reply");
            }
            if (this.foundNodeLoginInProvision) {
                this.assertTrue(foundNodeLoginInDescribe, "Found node login info in the CreateSliver/Provision reply. But NO node login info was found in the Describe/ListResources call done afterwards!");
            }
            if (TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("skip_final_manifest_check")) != Boolean.TRUE) {
                this.nodeLoginTestStep.checkManifestCorrectness(this.manifestRspec, this.testedAuthority);
            }
        }
    }

    @ApiTest.Test(hardDepends={"createSliver"}, softDepends={"waitForSliverReady", "describeReadySliver"}, groups={"nodelogin"})
    public void testNodeLogin() throws JFedException, IOException {
        this.assertNotNull(this.geniUserProvider);
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
            return;
        }
        if (!this.isGeniManifestRspec()) {
            this.skip("Test skipped because manifest is not a geni version 3 RSpec (so this test does not know how to extract node login info)");
            return;
        }
        assert (this.nodeLoginTestStep != null);
        this.nodeLoginTestStep.testNodeLogin(false, this.geniUserProvider, this.slice.urn.toString());
    }

    @ApiTest.Test(softDepends={"testNodeLogin", "createSliver", "describeReadySliver", "waitForSliverReady"}, groups={"createsliver", "nodelogin", "nonodelogin"})
    public void testDeleteSliver() throws JFedException {
        if (this.disableCleanup.booleanValue()) {
            this.note("Config specified that no cleanup is needed.");
            return;
        }
        if (this.slice.urnString == null) {
            this.skip("Skipped because other test created nothing to delete");
        }
        this.assertNotNull(this.slice);
        System.out.println("DeleteSliver for slice " + this.slice.urnString);
        this.amWrapper.deleteSliver(this.slice.urn, this.commonAMTest.getSliceCredentialListForAM(this.slice));
    }

    @ApiTest.Test(hardDepends={"testDeleteSliver", "registerSlivers"}, softDepends={}, groups={"createsliver", "nodelogin", "nonodelogin"})
    public void unregisterSlivers() throws JFedException {
        if (!this.createSliverUrns.isEmpty()) {
            this.commonAMTest.unregisterSlivers(this.slice, this.testedAuthority.getServerToConnect(), this.createSliverUrns);
        }
    }
}

