/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestRunner;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiTest<SpecificApiTestConfig extends ApiTestConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(ApiTest.class);
    @Nonnull
    protected final be.iminds.ilabt.jfed.log.Logger logger;
    @Nullable
    protected final TargetAuthority testedAuthority;
    @Nullable
    protected final GeniUserProvider geniUserProvider;
    @Nullable
    protected final GeniUser user;
    @Nonnull
    protected final SpecificApiTestConfig testConfig;
    protected ApiTestResult.ApiTestMethodResult currentTestResult;
    @Deprecated
    private boolean errorsFatal = true;
    @Deprecated
    private boolean errorsAreWarnings = false;

    @Nonnull
    public be.iminds.ilabt.jfed.log.Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public TargetAuthority getTestedAuthority() {
        return this.testedAuthority;
    }

    @Nullable
    public GeniUser getUser() {
        return this.user;
    }

    @Nullable
    public GeniUserProvider getGeniUserProvider() {
        return this.geniUserProvider;
    }

    @Nonnull
    public SpecificApiTestConfig getTestConfig() {
        return this.testConfig;
    }

    public ApiTest(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nullable TargetAuthority testedAuthority, @Nullable GeniUserProvider geniUserProvider, @Nonnull SpecificApiTestConfig testConfig) {
        this.logger = logger;
        this.testedAuthority = testedAuthority;
        this.geniUserProvider = geniUserProvider;
        this.user = geniUserProvider != null ? geniUserProvider.getLoggedInGeniUser() : null;
        this.testConfig = testConfig;
    }

    @Nonnull
    public static ApiTestMetaData getMetaData(@Nonnull ApiTest test) {
        return ApiTest.getMetaData(test.getClass());
    }

    @Nonnull
    public static ApiTestMetaData getMetaData(@Nonnull Class<? extends ApiTest> testClass) {
        try {
            Method m = testClass.getDeclaredMethod("getMetaData", new Class[0]);
            ApiTestMetaData res = (ApiTestMetaData)m.invoke(null, new Object[0]);
            if (res == null) {
                throw new NullPointerException("getMetaData() is incorrectly implemented. Each inheritor of ApiTest must have a static getMetaData() method, and that method should NOT return null.");
            }
            return res;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("getMetaData() is incorrectly implemented. Each inheritor of ApiTest must have a static getMetaData() method.", e);
        }
    }

    public abstract void setUp() throws Exception;

    void setCurrentTestResult(ApiTestResult.ApiTestMethodResult currentTestResult) {
        this.currentTestResult = currentTestResult;
    }

    ApiTestResult.ApiTestMethodResult getCurrentTestResult() {
        return this.currentTestResult;
    }

    public LogOutput.TestResultState getCurrentResultState() {
        return this.currentTestResult.getState();
    }

    @Deprecated
    public void addExtraResultWithBC(@Nonnull Object val, String ... nestedkey) {
        assert (nestedkey.length > 0);
        this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(nestedkey).setValue(val).setLarge(false));
        String usedKey = Arrays.asList(nestedkey).stream().map(String::trim).collect(Collectors.joining("_")).toUpperCase().replaceAll(" ", "_");
        assert (!usedKey.isEmpty());
        this.note("RAW_INFO BEGIN_" + usedKey + " " + String.valueOf(val) + " END_" + usedKey);
    }

    public void addExtraResult(@Nonnull ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder extraBuilder) {
        this.currentTestResult.addExtraResult(extraBuilder);
    }

    public void addExtraResult(@Nonnull ApiTestResult.ApiTestMethodResult.FedmonResultExtra extra) {
        this.currentTestResult.addExtraResult(extra);
    }

    public void note(String val) {
        this.currentTestResult.addLogLine(LogOutput.LogLineType.NOTE, val);
    }

    public void note(String val, boolean formatAsCode) {
        this.currentTestResult.addLogLine(LogOutput.LogLineType.NOTE, val, formatAsCode);
    }

    public void note(String val, Throwable t) {
        this.currentTestResult.addLogLine(LogOutput.LogLineType.NOTE, val, t);
    }

    public void note(String val, Throwable t, boolean formatAsCode) {
        this.currentTestResult.addLogLine(LogOutput.LogLineType.NOTE, val, t, formatAsCode);
    }

    public void skip(String reason) {
        this.currentTestResult.state = LogOutput.TestResultState.SKIPPED;
        throw new AutomatedTestRunner.SkipTestException(reason);
    }

    public void skip(String reason, Throwable t) {
        this.currentTestResult.state = LogOutput.TestResultState.SKIPPED;
        throw new AutomatedTestRunner.SkipTestException(reason, t);
    }

    @Deprecated
    public void setErrorsNotFatal() {
        this.errorsFatal = false;
        this.errorsAreWarnings = false;
    }

    @Deprecated
    public void setErrorsFatal() {
        this.errorsFatal = true;
        this.errorsAreWarnings = false;
    }

    @Deprecated
    public void setErrorsAreWarnings(boolean warn) {
        this.errorsAreWarnings = warn;
    }

    public void errorNonFatal(@Nullable String val) {
        this.currentTestResult.state = LogOutput.TestResultState.FAILED;
        this.currentTestResult.addLogLine(LogOutput.LogLineType.ERROR, val);
    }

    public void errorNonFatal(@Nullable String val, @Nullable Throwable t) {
        this.currentTestResult.state = LogOutput.TestResultState.FAILED;
        this.currentTestResult.addLogLine(LogOutput.LogLineType.ERROR, val, t);
    }

    public void errorNonFatal(@Nullable String val, boolean formatAsCode) {
        this.currentTestResult.state = LogOutput.TestResultState.FAILED;
        this.currentTestResult.addLogLine(LogOutput.LogLineType.ERROR, val, formatAsCode);
    }

    public void errorNonFatal(@Nullable String val, @Nullable Throwable t, boolean formatAsCode) {
        this.currentTestResult.state = LogOutput.TestResultState.FAILED;
        this.currentTestResult.addLogLine(LogOutput.LogLineType.ERROR, val, t, formatAsCode);
    }

    @Contract(value="_ -> fail")
    public void errorFatal(@Nullable String val) {
        this.fatalError(val);
    }

    @Contract(value="_,_ -> fail")
    public void errorFatal(@Nullable String val, @Nullable Throwable t) {
        this.fatalError(val, t);
    }

    @Contract(value="_ -> fail")
    public void fatalError(@Nullable String val) {
        this.fatalError(val, null);
    }

    @Contract(value="_,_ -> fail")
    public void fatalError(@Nullable String val, @Nullable Throwable t) {
        if (this.errorsAreWarnings) {
            this.warn(val, t);
        } else {
            if (this.errorsFatal) {
                this.currentTestResult.state = LogOutput.TestResultState.FAILED;
                throw new AssertionError(val, t);
            }
            this.errorNonFatal(val, t);
        }
    }

    public void warn(@Nullable String val, boolean formatAsCode) {
        this.currentTestResult.addLogLine(LogOutput.LogLineType.WARN, val, formatAsCode);
        if (this.currentTestResult.state == LogOutput.TestResultState.SUCCESS) {
            this.currentTestResult.state = LogOutput.TestResultState.WARN;
        }
    }

    public void warn(@Nullable String val) {
        this.warn(val, false);
    }

    public void warn(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
        this.currentTestResult.addLogLine(LogOutput.LogLineType.WARN, val, e);
        if (this.currentTestResult.state == LogOutput.TestResultState.SUCCESS) {
            this.currentTestResult.state = LogOutput.TestResultState.WARN;
        }
    }

    public void warn(@Nullable String val, @Nullable Throwable e) {
        this.warn(val, e, false);
    }

    public void warnIfNot(boolean v) {
        this.warnIfNot(v, "warnIfNot failed");
    }

    public void warnIfNot(boolean v, String failText) {
        if (!v) {
            this.warn(failText);
        }
    }

    public void errorNonFatalIfNot(boolean v) {
        this.errorNonFatalIfNot(v, "warnIfNot failed");
    }

    public void errorNonFatalIfNot(boolean v, @Nullable String failText) {
        if (!v) {
            this.errorNonFatal(failText);
        }
    }

    @Contract(value="false -> fail")
    public void assertTrue(boolean v) {
        this.assertTrue(v, "assertTrue failed");
    }

    @Contract(value="false,_ -> fail")
    public void assertTrue(boolean v, String failText) {
        if (!v) {
            this.fatalError(failText);
        }
    }

    @Contract(value="true -> fail")
    public void assertFalse(boolean v) {
        this.assertFalse(v, "assertFalse failed");
    }

    @Contract(value="true,_ -> fail")
    public void assertFalse(boolean v, String failText) {
        if (v) {
            this.fatalError(failText);
        }
    }

    @Contract(value="null -> fail")
    public void assertNotNull(Object o) {
        this.assertNotNull(o, "object is null");
    }

    @Contract(value="null,_ -> fail")
    public void assertNotNull(Object o, String failText) {
        if (o == null) {
            this.fatalError(failText);
        }
    }

    public void assertNonEmptyString(String s) {
        this.assertNonEmptyString(s, "string should not be empty");
    }

    public void assertNonEmptyString(String s, String failText) {
        if (s == null) {
            this.fatalError(failText);
        } else if (s.trim().isEmpty()) {
            this.fatalError(failText);
        }
    }

    public void assertNotEmpty(Collection c) {
        this.assertNotEmpty(c, "list is empty");
    }

    public void assertEmpty(Collection c) {
        this.assertEmpty(c, "list is not empty");
    }

    public void assertNotEmpty(Collection c, String failText) {
        if (c.isEmpty()) {
            this.fatalError(failText);
        }
    }

    public void assertEmpty(Collection c, String failText) {
        if (!c.isEmpty()) {
            this.fatalError(failText);
        }
    }

    @Contract(value="!null -> fail")
    public void assertNull(Object o) {
        this.assertNotNull(o, "object is null");
    }

    @Contract(value="!null,_ -> fail")
    public void assertNull(Object o, String failText) {
        if (o != null) {
            this.fatalError(failText);
        }
    }

    public void assertEquals(Object a, Object b, String failText) {
        if (!Objects.equals(a, b)) {
            this.fatalError(failText + " -> " + (a instanceof String ? "object are not equal: a=\"" + a.toString() + "\" b=\"" + b.toString() + "\"" : "object are not equal: a=" + a.toString() + "b=" + b.toString()));
        }
    }

    public void assertEquals(Object a, Object b) {
        this.assertEquals(a, b, a instanceof String ? "object are not equal: a=\"" + a.toString() + "\" b=\"" + b.toString() + "\"" : "object are not equal: a=" + a.toString() + "b=" + b.toString());
    }

    public void assertEqualDatesNoMs(Date a, Date b) {
        long as = a.getTime() / 1000L;
        long bs = b.getTime() / 1000L;
        LOG.debug("assertEqualDatesNoMs compare as=" + as + " bs=" + bs + "   a=" + String.valueOf(a) + "  b=" + String.valueOf(b));
        if (as != bs) {
            this.fatalError("dates are not equal: " + a.toString() + " differs from " + b.toString());
        }
    }

    public void assertNotEquals(Object a, Object b, String failText) {
        if (Objects.equals(a, b)) {
            this.fatalError(failText + " -> object are equal: a=b=" + a.toString());
        }
    }

    public void assertNotEquals(Object a, Object b) {
        this.assertNotEquals(a, b, "object are equal: a=b=" + a.toString());
    }

    public <T> T assertInstanceOf(Object o, Class<T> c) {
        return this.assertInstanceOf(o, c, "object is not an instance of class \"" + c.getName() + "\". (It is instance of class " + c.getName() + ")");
    }

    public <T> T assertInstanceOf(Object o, Class<T> c, String failText) {
        if (!c.isInstance(o)) {
            this.fatalError(failText + " -> object is not an instance of class \"" + c.getName() + "\". (It is instance of class " + c.getName() + ")");
            return null;
        }
        return c.cast(o);
    }

    @Nullable
    public List assertMapContainsList(@Nonnull Map t, @Nonnull String key) {
        Object o = t.get(key);
        this.assertNotNull(o, "Map does not contain key \"" + key + "\"");
        if (o == null) {
            return null;
        }
        this.assertTrue(o instanceof Object[], "value for " + key + " is not a List but a " + o.getClass().getName());
        if (o instanceof Object[]) {
            return Arrays.asList((Object[])o);
        }
        return null;
    }

    public <T> List<T> assertMapContainsList(Map t, String key, Class<T> clazz) {
        List list = this.assertMapContainsList(t, key);
        for (Object o : list) {
            this.assertInstanceOf(o, clazz, "Value in List was expected to be a " + clazz.getName() + ", but got a " + o.getClass().getName());
        }
        return list;
    }

    public Map assertMapContainsMap(Map t, String key) {
        Object o = t.get(key);
        this.assertNotNull(o, "Map does not contain key \"" + key + "\"");
        if (o == null) {
            return null;
        }
        this.assertInstanceOf(o, Map.class, "value for " + key + " is not a Map but a " + o.getClass().getName());
        if (!(o instanceof Map)) {
            return null;
        }
        return (Map)o;
    }

    public String assertMapContainsString(Map t, String key) {
        Object o = t.get(key);
        this.assertNotNull(o, "Map does not contain key \"" + key + "\"");
        if (o == null) {
            return null;
        }
        this.assertEquals(o.getClass(), String.class, "value for " + key + " is not a String but a " + o.getClass().getName());
        if (!Objects.equals(o.getClass(), String.class)) {
            return null;
        }
        return (String)o;
    }

    public String assertMapContainsString(Map t, String key, String expectedValue) {
        Object o = t.get(key);
        this.assertNotNull(o, "Map does not contain key \"" + key + "\"");
        if (o == null) {
            return null;
        }
        this.assertEquals(o.getClass(), String.class, "value for " + key + " is not a String but a " + o.getClass().getName());
        this.assertEquals(o, expectedValue, "value for " + key + " is not \"" + expectedValue + "\" but \"" + String.valueOf(o) + "\"");
        if (!Objects.equals(o.getClass(), String.class)) {
            return null;
        }
        return (String)o;
    }

    public Object assertMapContainsObject(Map t, String key) {
        Object o = t.get(key);
        this.assertNotNull(o, "Map does not contain key \"" + key + "\"");
        return o;
    }

    public String assertMapContainsNonemptyString(Map t, String key) {
        Object o = t.get(key);
        this.assertNotNull(o, "Map does not contain key \"" + key + "\"");
        if (o == null) {
            return null;
        }
        this.assertEquals(o.getClass(), String.class, "value for " + key + " is not a String but a " + o.getClass().getName());
        if (!Objects.equals(o.getClass(), String.class)) {
            return null;
        }
        String s = (String)o;
        this.assertTrue(s.length() > 0, "value for " + key + " is an empty string");
        return s;
    }

    @Nullable
    public Map<String, Object> assertStringObjectMap(Object o) {
        Map t = this.assertInstanceOf(o, Map.class, "Expected a dictionary (=Map), but is of type " + o.getClass().getName());
        if (t != null) {
            for (Object key : t.keySet()) {
                this.assertInstanceOf(key, String.class, "Expected dictionary to only contain Strings as keys, but got a " + key.getClass().getName());
            }
            return t;
        }
        return null;
    }

    public void assertValidUrn(String urn, String type) {
        this.assertValidUrn(urn, type, null);
    }

    public void assertValidUrn(String urn, String type, String message) {
        Object msgHelp = message == null ? "" : message + ": ";
        GeniUrn geniUrn = GeniUrn.parse((String)urn);
        this.assertTrue(geniUrn != null, (String)msgHelp + "Urn is not valid: \"" + urn + "\"");
        if (geniUrn == null) {
            return;
        }
        if (type != null) {
            this.assertEquals(geniUrn.getEncodedResourceType(), type, (String)msgHelp + "Urn type is not correct in urn=\"" + urn + "\"");
        }
        this.assertFalse(geniUrn.getEncodedTopLevelAuthority().isEmpty(), (String)msgHelp + "Urn authority is empty in urn=\"" + urn + "\"");
        this.assertFalse(geniUrn.getEncodedResourceName().isEmpty(), (String)msgHelp + "Urn resource name is empty in urn=\"" + urn + "\"");
    }

    public static @interface DataProvider {
        public String name() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Test {
        public String description() default "";

        public String[] groups() default {};

        public String[] hardDepends() default {};

        public String[] softDepends() default {};

        public String dataProvider() default "";
    }
}

