/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public abstract class BaseApiTest<SpecificApiTestConfig extends ApiTestConfig>
extends ApiTest<SpecificApiTestConfig> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(BaseApiTest.class);
    @Nonnull
    protected final JFedConnectionProvider connectionProvider;
    @Nonnull
    protected final TestbedInfoSource testbedInfoSource;
    @Nonnull
    protected final AuthorityFinder authorityFinder;
    @Nonnull
    private final JFedPreferences jFedPreferences;

    public BaseApiTest(@Nonnull Logger logger, @Nullable TargetAuthority testedAuthority, @Nullable GeniUserProvider geniUserProvider, @Nonnull SpecificApiTestConfig testConfig, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authorityFinder, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig);
        this.connectionProvider = connectionProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.jFedPreferences = jFedPreferences;
    }

    public BaseApiTest(@Nonnull Logger logger, @Nullable TargetAuthority testedAuthority, @Nullable GeniUserProvider geniUserProvider, @Nonnull SpecificApiTestConfig testConfig, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, new AuthorityFinder(testbedInfoSource, jFedPreferences), jFedPreferences);
    }

    @Nonnull
    public JFedConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Nonnull
    public TestbedInfoSource getTestbedInfoSource() {
        return this.testbedInfoSource;
    }

    public JFedPreferences getJFedPreferences() {
        return this.jFedPreferences;
    }

    public AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory getAutomaticUserAndSliceApiWrapperFactory() {
        return new AutomaticUserAndSliceApiWrapper.BasicAutomaticUserAndSliceApiWrapperFactory(this.logger, this.geniUserProvider, this.connectionProvider, this.getJFedPreferences());
    }

    public AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory getAutomaticAggregateManagerWrapperFactory() {
        return new AutomaticAggregateManagerWrapper.BasicAutomaticAggregateManagerWrapperFactory(this.logger, this.geniUserProvider, this.connectionProvider, this.getJFedPreferences());
    }
}

