/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfigEditor;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfigProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTestConfigEditor<C extends ApiTestConfig>
implements ApiTestConfigEditor<C> {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(JsonTestConfigEditor.class);
    @Nonnull
    private final Class<C> apiTestConfigClass;
    @Nonnull
    private Map curMap = new HashMap();

    public JsonTestConfigEditor(@Nonnull Class<C> apiTestConfigClass) {
        this.apiTestConfigClass = apiTestConfigClass;
    }

    @Override
    @Nonnull
    public List<ApiTestConfigEditor.ApiTestConfigParameter> getParameters() {
        ArrayList<ApiTestConfigEditor.ApiTestConfigParameter> parameters = new ArrayList<ApiTestConfigEditor.ApiTestConfigParameter>();
        ApiTestConfig defaultObject = null;
        try {
            defaultObject = (ApiTestConfig)this.apiTestConfigClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Reflection problem creating default ApiTestConfig. Probably the config is not in the expected/supported structure.", e);
        }
        this.addParameters(parameters, Collections.emptyList(), this.apiTestConfigClass, defaultObject);
        return parameters;
    }

    public void addParameters(List<ApiTestConfigEditor.ApiTestConfigParameter> parameters, List<String> nest, Class clazz, Object defaultObject) {
        Method[] methods;
        LOG.debug("addParameters(_, " + String.valueOf(nest) + ", " + clazz.getName() + ", " + (defaultObject == null ? "null" : defaultObject.getClass().getName()) + ")");
        for (Method method : methods = defaultObject == null ? clazz.getMethods() : defaultObject.getClass().getMethods()) {
            boolean isCollectionReturn;
            Object defaultValue;
            int prefixLen;
            boolean isProperty;
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameters().length != 0) continue;
            JsonProperty jsonPropertAnnotation = method.getAnnotation(JsonProperty.class);
            JsonIgnore jsonIgnoreAnnotation = method.getAnnotation(JsonIgnore.class);
            ApiTestConfigProperty propertyAnnotation = method.getAnnotation(ApiTestConfigProperty.class);
            boolean hasNonnullAnnotation = Arrays.stream(method.getDeclaredAnnotations()).map(Annotation::annotationType).map(Class::toString).anyMatch(a -> a.equals("javax.annotation.Nonnull"));
            boolean noEdit = propertyAnnotation != null && propertyAnnotation.noEdit();
            boolean bl = isProperty = jsonPropertAnnotation != null;
            if (jsonIgnoreAnnotation != null && jsonIgnoreAnnotation.value()) {
                isProperty = false;
            }
            if (!isProperty) continue;
            Object name = jsonPropertAnnotation.value();
            int n = prefixLen = method.getName().startsWith("is") ? 2 : 3;
            if (((String)name).isEmpty() && method.getName().length() >= prefixLen + 1) {
                char first = Character.toLowerCase(method.getName().charAt(prefixLen));
                name = first + method.getName().substring(prefixLen + 1, method.getName().length());
            }
            if (defaultObject != null) {
                try {
                    defaultValue = method.invoke(defaultObject, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Reflection problem traversing ApiTestConfig. Probably the config is not in the expected/supported structure. defaultObject.class=" + (defaultObject == null ? "null" : defaultObject.getClass().getName()) + " clazz=" + clazz.getName(), e);
                }
            } else {
                Object defaultValue2 = null;
                return;
            }
            Class<?> returnType = method.getReturnType();
            assert (returnType != null);
            LOG.debug("Checking method " + method.getName() + " returning " + returnType.getName() + " in package " + (returnType.getPackage() == null ? null : returnType.getPackage().getName()));
            boolean isEditableType = returnType.isPrimitive() || returnType.getPackage() == null || returnType.getPackage().getName().startsWith("java.lang") || returnType.isEnum();
            boolean isPojoReturn = !isEditableType;
            boolean bl2 = isCollectionReturn = !returnType.isPrimitive() && returnType.getPackage() != null && Collection.class.isAssignableFrom(returnType);
            if (noEdit) {
                isCollectionReturn = false;
                isEditableType = false;
                isPojoReturn = false;
            }
            ArrayList<String> newNest = new ArrayList<String>(nest.size() + 1);
            newNest.addAll(nest);
            if (!isCollectionReturn) {
                if (isEditableType) {
                    newNest.add((String)name);
                    ApiTestConfigEditor.ApiTestConfigParameter param = new ApiTestConfigEditor.ApiTestConfigParameter(newNest, propertyAnnotation == null ? null : (propertyAnnotation.description().isEmpty() ? null : propertyAnnotation.description()), method.getReturnType(), defaultValue, !hasNonnullAnnotation, propertyAnnotation == null ? null : (propertyAnnotation.editorHint().isEmpty() ? null : propertyAnnotation.editorHint()));
                    parameters.add(param);
                    continue;
                }
                if (!isPojoReturn) continue;
                newNest.add((String)name);
                this.addParameters(parameters, newNest, method.getReturnType(), defaultValue);
                continue;
            }
            if (defaultValue == null) continue;
            assert (defaultValue instanceof Collection);
            assert (List.class.isAssignableFrom(returnType)) : "Only list is currently supported";
            assert (defaultValue instanceof List);
            List defaultValueList = (List)defaultValue;
            if (!defaultValueList.isEmpty()) {
                Object firstElement = defaultValueList.get(0);
                Class<?> collectionClass = firstElement.getClass();
                newNest.add((String)name + "[0]");
                this.addParameters(parameters, Collections.singletonList((String)name + "[0]"), collectionClass, firstElement);
                continue;
            }
            newNest.add((String)name);
            LOG.debug("EMPTY LIST of default value for parameter " + String.valueOf(newNest));
        }
    }

    @Override
    public void setParameter(@Nonnull ApiTestConfigEditor.ApiTestConfigParameter parameter, @Nullable Object value) {
        Map m = this.getSubMap(parameter);
        m.put(parameter.getLastName(), value);
    }

    @Override
    @Nullable
    public Object getParameter(@Nonnull ApiTestConfigEditor.ApiTestConfigParameter parameter) {
        Map m = this.getSubMap(parameter);
        return m.get(parameter.getLastName());
    }

    @Nonnull
    private Map getSubMap(@Nonnull ApiTestConfigEditor.ApiTestConfigParameter parameter) {
        List<String> keys = parameter.getName();
        Map<String, Object> res = this.curMap;
        for (int i = 0; i < keys.size() - 1; ++i) {
            HashMap<String, Object> newMap;
            String key = keys.get(i);
            boolean isCollection = key.endsWith("[0]");
            if (isCollection) {
                key = key.substring(0, key.length() - 3);
            }
            Object val = res.get(key);
            if (isCollection) {
                if (val == null) {
                    newMap = new HashMap<String, Object>();
                    List newList = Collections.singletonList(newMap);
                    res.put(key, newList);
                    res = newMap;
                    continue;
                }
                if (val instanceof List) {
                    List valList = (List)val;
                    Object firstval = valList.get(0);
                    if (firstval instanceof Map) {
                        res = (Map)firstval;
                        continue;
                    }
                    throw new RuntimeException("Invalid list nesting! Something must be wrong with the parameters. keys=" + String.valueOf(keys) + " i=" + i + " val=" + String.valueOf(val) + " valclass=" + val.getClass().getName() + " firstval class = " + firstval.getClass().getName());
                }
                throw new RuntimeException("Invalid list nesting! Something must be wrong with the parameters. keys=" + String.valueOf(keys) + " i=" + i + " val=" + String.valueOf(val) + " valclass=" + val.getClass().getName());
            }
            if (val == null) {
                newMap = new HashMap();
                res.put(key, newMap);
                res = newMap;
                continue;
            }
            if (val instanceof Map) {
                res = (Map)val;
                continue;
            }
            throw new RuntimeException("Invalid nesting! Something must be wrong with the parameters. keys=" + String.valueOf(keys) + " i=" + i + " val=" + String.valueOf(val) + " valclass=" + val.getClass().getName());
        }
        return res;
    }

    @Override
    public void setConfig(@Nonnull C apiTestConfig) {
        this.curMap = (Map)MAPPER.convertValue(apiTestConfig, Map.class);
    }

    @Override
    @Nonnull
    public C build() {
        return (C)((ApiTestConfig)MAPPER.convertValue((Object)this.curMap, this.apiTestConfigClass));
    }
}

