/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.dropwizard.jackson.Jackson;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredTestbedInfo {
    private static final Logger LOG = LoggerFactory.getLogger(StoredTestbedInfo.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public static List<Testbed> loadOrNull(String content) {
        try {
            ByteArrayInputStream sis = new ByteArrayInputStream(content.getBytes("UTF-8"));
            return StoredTestbedInfo.loadOrNull(sis);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("UnsupportedEncodingException", (Throwable)e);
            return null;
        }
    }

    public static List<Testbed> loadOrNull(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return StoredTestbedInfo.load(new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.warn("Error reading authorities from XML file \"" + String.valueOf(file) + "\": ", (Throwable)e);
            return null;
        }
    }

    public static List<Testbed> load(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File \"" + file.getPath() + "\" not found");
        }
        return StoredTestbedInfo.load(new FileInputStream(file));
    }

    public static List<Testbed> loadOrNull(InputStream is) {
        try {
            return StoredTestbedInfo.load(is);
        }
        catch (IOException e) {
            LOG.error("Failed to process List<Testbed> Json", (Throwable)e);
            return null;
        }
    }

    public static List<Testbed> load(InputStream is) throws IOException {
        Object inputObject = MAPPER.readValue(is, Object.class);
        if (inputObject instanceof Collection) {
            ArrayList<Testbed> resList = new ArrayList<Testbed>();
            for (Object o : (Collection)inputObject) {
                Testbed testbed = (Testbed)MAPPER.convertValue(o, Testbed.class);
                resList.add(testbed);
            }
            return resList;
        }
        if (inputObject instanceof Map) {
            Testbed testbed = (Testbed)MAPPER.convertValue(inputObject, Testbed.class);
            return Collections.singletonList(testbed);
        }
        throw new RuntimeException("Unknown object read: \"" + inputObject.getClass().getName() + "\"");
    }

    public static void saveIgnoringErrors(File file, TestbedInfoSource testbedInfoSource) {
        try {
            StoredTestbedInfo.save(file, testbedInfoSource);
        }
        catch (IOException e) {
            LOG.warn("Error writing authorities to XML file \"" + file.getName() + "\": ", (Throwable)e);
        }
    }

    public static void save(File file, TestbedInfoSource testbedInfoSource) throws IOException {
        List minimizedTestbeds = TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, (Collection)testbedInfoSource.getTestbeds());
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!dir.exists()) {
            LOG.warn("could not save authorities to \"" + file.getName() + "\", as dir \"" + dir.getName() + "\" could not be created.");
            return;
        }
        MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValue(file, (Object)minimizedTestbeds);
    }

    public static String toJson(TestbedInfoSource testbedInfoSource) {
        return StoredTestbedInfo.toJson(testbedInfoSource.getTestbeds());
    }

    public static String toJson(List<Testbed> testbeds) {
        try {
            List minimizedTestbeds = TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, testbeds);
            String json = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)minimizedTestbeds);
            return json;
        }
        catch (Exception e) {
            LOG.warn("WARNING: Error writing Testbeds to JSON: ", (Throwable)e);
            return null;
        }
    }

    public static void toJson(Writer outputWriter, List<Testbed> testbeds) {
        try {
            List minimizedTestbeds = TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, testbeds);
            MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValue(outputWriter, (Object)minimizedTestbeds);
        }
        catch (Exception e) {
            LOG.warn("WARNING: Error writing Testbeds to JSON: ", (Throwable)e);
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

