/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi1;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FederationRegistryApi1
extends AbstractFederationApi1 {
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_SERVICE_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE_URL", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URL), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE_CERT", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.CERTIFICATE), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE_NAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING)));

    public static String getApiName() {
        return "Uniform Federation Registry API v1";
    }

    @Override
    @Nonnull
    public String getName() {
        return FederationRegistryApi1.getApiName();
    }

    public FederationRegistryApi1(@Nonnull Logger logger, @Nullable RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH, 1), jFedPreferences);
    }

    public FederationRegistryApi1(@Nonnull Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    @ApiMethod(order=1, hint="get_version call: Provide a structure detailing the version information as well as details of accepted options for CH API calls.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.GetVersionResult> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", new ArrayList<Object>(), resultValueObject -> new AbstractFederationApi.GetVersionResult(resultValueObject, false));
    }

    @Override
    public List<String> getApiObjects() {
        return Collections.singletonList("SERVICE");
    }

    @Override
    public List<String> getRequiredApiServices() {
        return Collections.singletonList("SERVICE");
    }

    @Override
    public List<String> getOptionalApiServices() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<AbstractFederationApi.GetVersionResult.FieldInfo> getMinimumFields(String objectName) {
        if (objectName.equalsIgnoreCase("SERVICE")) {
            return MINIMUM_SERVICE_FIELDS;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public String getMethodObject(Method method) {
        if (Objects.equals(method.getName(), "lookupAggregates") || Objects.equals(method.getName(), "lookupMemberAuthorities") || Objects.equals(method.getName(), "lookupSliceAuthorities")) {
            return "SERVICE";
        }
        return null;
    }

    private AbstractFederationApi.FederationApiReply<List<ServiceDetails>> genericLookupServiceDetails(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String javaMethodName, @Nonnull String apiMethodName, @Nonnull ApiInfo.ApiName role, @Nullable List<String> filter, @Nullable Map<String, ?> match, @Nullable Map<String, Object> extraOptions) throws JFedException {
        ArrayList<Object> args = new ArrayList<Object>();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (match != null) {
            options.put("match", match);
        }
        if (filter != null) {
            options.put("filter", filter);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, javaMethodName, apiMethodName, args, resultValueObject -> {
            List<Map> resultList = FederationRegistryApi1.apiSpecifiesListOfT(Map.class, resultValueObject);
            ArrayList<ServiceDetails> resList = new ArrayList<ServiceDetails>();
            for (Map h : resultList) {
                ServiceDetails serviceDetails = new ServiceDetails(role, h);
                resList.add(serviceDetails);
            }
            return resList;
        });
    }

    @ApiMethod(order=2, hint="lookup_aggregates call: Return information about all aggregates associated with the Federation", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<ServiceDetails>> lookupAggregates(@Nonnull SfaConnection con, @ApiMethodParameter(name="filter", hint="fields names included in reply. If omitted: all fields.", required=false, parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationRegistryApi1.makeMethodParameters("filter", filter, "match", match, "extraOptions", extraOptions);
        return this.genericLookupServiceDetails(methodParams, con, "lookupAggregates", "lookup_aggregates", ApiInfo.ApiName.GENI_AM, filter, match, extraOptions);
    }

    @ApiMethod(order=3, hint="lookup_member_authorities call: Return information about all MA\u2019s associated with the Federation", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<ServiceDetails>> lookupMemberAuthorities(@Nonnull SfaConnection con, @ApiMethodParameter(name="filter", hint="fields names included in reply. If omitted: all fields.", required=false, parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationRegistryApi1.makeMethodParameters("filter", filter, "match", match, "extraOptions", extraOptions);
        return this.genericLookupServiceDetails(methodParams, con, "lookupMemberAuthorities", "lookup_member_authorities", ApiInfo.ApiName.GENI_CH_MA, filter, match, extraOptions);
    }

    @ApiMethod(order=4, hint="lookup_slice_authorities call: Return information about all SA\u2019s associated with the Federation", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<ServiceDetails>> lookupSliceAuthorities(@Nonnull SfaConnection con, @ApiMethodParameter(name="filter", hint="fields names included in reply. If omitted: all fields.", required=false, parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationRegistryApi1.makeMethodParameters("filter", filter, "match", match, "extraOptions", extraOptions);
        return this.genericLookupServiceDetails(methodParams, con, "lookupSliceAuthorities", "lookup_slice_authorities", ApiInfo.ApiName.GENI_CH_SA, filter, match, extraOptions);
    }

    @ApiMethod(order=5, hint="lookup_authorities_for_urns call: Lookup the authorities for a given URNs", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Map<GeniUrn, URL>> lookupAuthoritiesForUrns(@Nonnull SfaConnection con, @ApiMethodParameter(name="urns", hint="URNs of entities for which the authority is requested", parameterType=ApiMethodParameterType.LIST_OF_URN_STRING) @Nonnull List<GeniUrn> urns) throws JFedException {
        Map<String, Object> methodParams = FederationRegistryApi1.makeMethodParameters("urns", urns);
        ArrayList<Object> args = new ArrayList<Object>(1);
        List stringUrns = urns.stream().map(GeniUrn::toString).collect(Collectors.toList());
        args.add(stringUrns);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupAuthoritiesForUrns", "lookup_authorities_for_urns", args, FederationRegistryApi1::processAuthoritiesLookup);
    }

    static Map<GeniUrn, URL> processAuthoritiesLookup(Object resultValueObject) throws BadReplyGeniException {
        Map<String, String> resMap = FederationRegistryApi1.apiSpecifiesMapStringToString(resultValueObject);
        HashMap<GeniUrn, URL> urls = new HashMap<GeniUrn, URL>();
        for (Map.Entry<String, String> e : resMap.entrySet()) {
            URL url;
            GeniUrn urn;
            try {
                urn = new GeniUrn(e.getKey());
            }
            catch (GeniUrn.GeniUrnParseException ex) {
                throw new BadReplyGeniException("Error processing lookup_authorities_for_urns result, not an urn: \"" + e.getKey() + "\":  error message: \"" + ex.getMessage() + "\"", (Exception)((Object)ex));
            }
            try {
                url = new URL(e.getValue());
            }
            catch (MalformedURLException ex) {
                throw new BadReplyGeniException("Error processing lookup_authorities_for_urns result, not an url: \"" + e.getValue() + "\":  error message: \"" + ex.getMessage() + "\"", ex);
            }
            urls.put(urn, url);
        }
        return urls;
    }

    @ApiMethod(order=6, hint="get_trust_roots call: Return list of trust roots (certificates) associated with this CH. Often this concatenates of the trust roots of the included authorities.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<String>> getTrustRoots(@Nonnull SfaConnection con) throws JFedException {
        ArrayList<Object> args = new ArrayList<Object>();
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getTrustRoots", "get_trust_roots", args, AbstractApi::apiSpecifiesListOfString);
    }

    public class ServiceDetails {
        private final ApiInfo.ApiName serverRole;
        private GeniUrn urn;
        private URL url;
        private String certificate;
        private String name;
        private String description;
        private final Map<String, Object> extraFields = new HashMap<String, Object>();

        public ServiceDetails(ApiInfo.ApiName serverRole, Map fields) throws BadReplyGeniException {
            this.serverRole = serverRole;
            Iterator iterator = fields.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entryO;
                Map.Entry entry = entryO = iterator.next();
                assert (entry.getKey() instanceof String) : "not String in in ServiceDetails fields=" + String.valueOf(fields);
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String stringValue = null;
                if (value instanceof String) {
                    stringValue = (String)value;
                }
                boolean known = false;
                if (Objects.equals(key, "SERVICE_URN")) {
                    assert (stringValue != null) : "service value must be String for key SERVICE_URN";
                    this.urn = GeniUrn.parse((String)stringValue);
                    known = true;
                }
                if (Objects.equals(key, "SERVICE_URL")) {
                    try {
                        assert (stringValue != null) : "service value must be String for key SERVICE_URL";
                        this.url = new URL(stringValue);
                    }
                    catch (MalformedURLException e) {
                        if (!FederationRegistryApi1.this.handleMalformedReplies) {
                            throw new BadReplyGeniException("Error parsing Federation Registry reply. Malformed URL \"" + String.valueOf(value) + "\". Error: " + e.getMessage(), e);
                        }
                        e.printStackTrace();
                        this.url = null;
                    }
                    known = true;
                }
                if (Objects.equals(key, "SERVICE_CERTIFICATE")) {
                    assert (stringValue != null) : "service value must be String for key SERVICE_CERTIFICATE";
                    this.certificate = stringValue;
                    known = true;
                }
                if (Objects.equals(key, "SERVICE_NAME")) {
                    assert (stringValue != null) : "service value must be String for key SERVICE_NAME";
                    this.name = stringValue;
                    known = true;
                }
                if (Objects.equals(key, "SERVICE_DESCRIPTION")) {
                    assert (stringValue != null) : "service value must be String for key SERVICE_DESCRIPTION";
                    this.description = stringValue;
                    known = true;
                }
                if (known) continue;
                this.extraFields.put(key, value);
            }
        }

        public ApiInfo.ApiName getServerRole() {
            return this.serverRole;
        }

        public GeniUrn getUrn() {
            return this.urn;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "ServiceDetails{serverRole=" + String.valueOf((Object)this.serverRole) + ", urn=" + String.valueOf(this.urn) + ", url=" + String.valueOf(this.url) + ", certificate='" + this.certificate + "', name='" + this.name + "', description='" + this.description + "', extraFields=" + String.valueOf(this.extraFields) + "}";
        }
    }
}

