/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XmlRpcApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregateManagerWrapper
extends ApiWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateManagerWrapper.class);
    @Nonnull
    protected final Server amServer;
    @Nullable
    protected AbstractGeniAggregateManager.AggregateManagerReply lastAmReply = null;
    protected Map<String, ?> extraOptionsForCallsWithCredential;
    protected List<AnyCredential> speaksForCredentials;

    protected AggregateManagerWrapper(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull Server amServer) {
        super(logger, geniUserProvider, connectionProvider, jFedPreferences);
        this.amServer = amServer;
    }

    protected JFedConnection getConnection(@Nonnull ApiInfo.Api api) throws JFedException {
        if (this.amServer == null) {
            throw new IllegalStateException("Cannot create a connection object when specified server is null");
        }
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        return this.connectionProvider.getConnectionByAuthority(user, this.amServer, api);
    }

    protected GeniUser getUser() {
        return this.geniUserProvider.getLoggedInGeniUser();
    }

    @Nullable
    protected Server getUserAuthority() {
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        return user.getUserAuthorityServer();
    }

    @Nonnull
    public Server getAmServer() {
        return this.amServer;
    }

    @Override
    public void setSpeaksFor(List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
    }

    public void setExtraOptionsForCallsWithCredential(Map<String, ?> extraOptionsForCallsWithCredential) {
        this.extraOptionsForCallsWithCredential = extraOptionsForCallsWithCredential;
    }

    @Nullable
    protected Map<String, Object> addCredentialExtraOptionsToMap(@Nullable Map<String, Object> extraOptions) {
        if (this.extraOptionsForCallsWithCredential == null) {
            if (extraOptions == null) {
                return null;
            }
            return extraOptions;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (extraOptions != null) {
            res.putAll(extraOptions);
        }
        res.putAll(this.extraOptionsForCallsWithCredential);
        return res;
    }

    @Nullable
    protected Map<String, Object> addCredentialExtraOptions(@Nullable Map<String, Object> extraOptions) {
        if (this.extraOptionsForCallsWithCredential == null) {
            return extraOptions;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (extraOptions != null) {
            res.putAll(extraOptions);
        }
        res.putAll(this.extraOptionsForCallsWithCredential);
        return res;
    }

    public abstract Map getVersion() throws JFedException;

    public String listResources(@Nonnull List<AnyCredential> userCredentials, boolean available) throws JFedException {
        if (this.amServer != null && this.amServer.getServerType() != null && this.amServer.getServerType().equalsIgnoreCase("FOAM")) {
            return this.listResources(userCredentials, available, "GENI", "3");
        }
        return this.listResources(userCredentials, available, "geni", "3");
    }

    public abstract String listResources(@Nonnull List<AnyCredential> var1, boolean var2, @Nonnull String var3, @Nonnull String var4) throws JFedException;

    public abstract String createSliver(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2, @Nonnull String var3, @Nullable List<UserSpec> var4, @Nullable Date var5) throws JFedException;

    public abstract boolean hasSeperateAllocateAndProvision();

    public abstract AllocateReply allocate(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2, @Nonnull String var3, @Nullable Date var4) throws JFedException;

    public abstract AllocateReply allocate(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2, @Nonnull String var3, Date var4, Date var5) throws JFedException;

    public abstract String provisionAndStart(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2, @Nullable List<UserSpec> var3, @Nullable Date var4) throws JFedException;

    public abstract ProvisionReply provision(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2, @Nullable List<UserSpec> var3, @Nullable Date var4) throws JFedException;

    public abstract void poaStart(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2) throws JFedException;

    public abstract void deleteSliver(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2) throws JFedException;

    @Nullable
    public abstract StatusDetails status(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2) throws JFedException;

    @Nullable
    public abstract AggregateManager3.StatusInfo status_v3(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2) throws JFedException;

    public abstract String describe(@Nonnull GeniUrn var1, @Nonnull List<AnyCredential> var2) throws JFedException;

    public abstract List<GeniUrn> renewSlivers(@Nullable GeniUrn var1, @Nullable List<GeniUrn> var2, @Nonnull List<AnyCredential> var3, @Nonnull Date var4) throws JFedException;

    @Nullable
    public AbstractGeniAggregateManager.AggregateManagerReply getLastReply() {
        return this.lastAmReply;
    }

    public abstract boolean isExirationdateSetByCreateSliver();

    public abstract boolean isShareLanSupported();

    public void shareLan(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String lanClientId, @Nonnull String newSharedLanName) throws JFedException {
        throw new UnsupportedOperationException("AM does not support shareLan");
    }

    public void unshareLan(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String lanClientId, @Nonnull String sharedLanName) throws JFedException {
        throw new UnsupportedOperationException("AM does not support unshareLan");
    }

    public abstract boolean isRestartSupported();

    public void restart(@Nonnull GeniUrn sliverUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        throw new UnsupportedOperationException("AM does not support restart");
    }

    public abstract boolean isReloadOSSupported();

    public void reloadOS(@Nonnull GeniUrn sliverUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        throw new UnsupportedOperationException("AM does not support reloadOS");
    }

    public abstract boolean isOpenConsoleSupported();

    public URL openConsole(@Nonnull GeniUrn sliverUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        throw new UnsupportedOperationException("AM does not support openConsole");
    }

    public abstract boolean isEditSshKeysSupported();

    public void editSshKeys(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Collection<UserSpec> userSpecs) throws JFedException {
        throw new UnsupportedOperationException("AM does not support editSshKeys");
    }

    public boolean areUserDiskImageFunctionsSupported() {
        return false;
    }

    public ImageInfo createImage(@Nonnull GeniUrn sliceUrn, List<AnyCredential> sliceCredentials, @Nonnull GeniUrn componentUrn, @Nonnull String imageName, boolean global, boolean updatePrepare) throws JFedException {
        throw new UnsupportedOperationException("AM does not support createImage");
    }

    @Nonnull
    public List<ImageInfo> listImages(@Nonnull List<AnyCredential> userCredentials) throws JFedException {
        throw new UnsupportedOperationException("AM does not support listImages");
    }

    public boolean deleteImage(@Nonnull List<AnyCredential> userCredentials, @Nonnull GeniUrn imageUrn) throws JFedException {
        throw new UnsupportedOperationException("AM does not support deleteImage");
    }

    public static class NoAmException
    extends RuntimeException {
        public NoAmException() {
        }

        public NoAmException(String message) {
            super(message);
        }

        public NoAmException(String message, Throwable cause) {
            super(message, cause);
        }

        public NoAmException(Throwable cause) {
            super(cause);
        }

        public NoAmException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }

    public static class AnyVlanUnsupportedException
    extends JFedException {
        public AnyVlanUnsupportedException(XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super("vlan \"any\" not supported", null, xmlRpcResult, geniResponseCode);
        }

        public AnyVlanUnsupportedException(String message, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super(message, null, xmlRpcResult, geniResponseCode);
        }

        public AnyVlanUnsupportedException(XmlRpcApiCallReply reply) {
            super("vlan \"any\" not supported", reply);
        }
    }

    public static class VlanUnavailableException
    extends JFedException {
        private final Integer vlan;

        public VlanUnavailableException(Integer vlan, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super("vlan not available", null, xmlRpcResult, geniResponseCode);
            this.vlan = vlan;
        }

        public VlanUnavailableException(Integer vlan, String message, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super(message, null, xmlRpcResult, geniResponseCode);
            this.vlan = vlan;
        }

        public VlanUnavailableException(Integer vlan, XmlRpcApiCallReply reply) {
            super("vlan not available", reply);
            this.vlan = vlan;
        }

        public Integer getVlan() {
            return this.vlan;
        }
    }

    public static class TermsAndConditionsException
    extends JFedException {
        public TermsAndConditionsException(XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super("Testbed access refused: Terms & Conditions not accepted", null, xmlRpcResult, geniResponseCode);
        }

        public TermsAndConditionsException(String message, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super(message, null, xmlRpcResult, geniResponseCode);
        }

        public TermsAndConditionsException(XmlRpcApiCallReply reply) {
            super("Testbed access refused: Terms & Conditions not accepted", reply);
        }
    }

    public static class ReservationProblemException
    extends JFedException {
        public ReservationProblemException(XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super("Testbed Resource Reservation Problem", null, xmlRpcResult, geniResponseCode);
        }

        public ReservationProblemException(String message, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super(message, null, xmlRpcResult, geniResponseCode);
        }

        public ReservationProblemException(XmlRpcApiCallReply reply) {
            super("Testbed Resource Reservation Problem", reply);
        }
    }

    public static class NotEnoughFreeResourcesException
    extends JFedException {
        public NotEnoughFreeResourcesException(XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super("not enough free resources", null, xmlRpcResult, geniResponseCode);
        }

        public NotEnoughFreeResourcesException(String message, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
            super(message, null, xmlRpcResult, geniResponseCode);
        }

        public NotEnoughFreeResourcesException(XmlRpcApiCallReply reply) {
            super("not enough free resources", reply);
        }
    }

    public static interface ImageInfo {
        public String getUrn();

        public String getUrl();
    }

    public static interface AllocateReply {
        public String getManifest();

        @Nullable
        public List<GeniUrn> getSliverUrns();
    }

    public static class ProvisionReply {
        @Nonnull
        private final String manifest;
        @Nonnull
        private final List<AggregateManager3.SliverInfo> sliverStatus;

        public ProvisionReply(@Nonnull String manifest, @Nonnull List<AggregateManager3.SliverInfo> sliverStatus) {
            this.manifest = manifest;
            this.sliverStatus = sliverStatus;
        }

        @Nonnull
        public String getManifest() {
            return this.manifest;
        }

        @Nonnull
        public List<AggregateManager3.SliverInfo> getSliverInfo() {
            return this.sliverStatus;
        }
    }
}

