/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper;

import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ErrorDetails;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StatusDetails {
    private SliverStatus globalStatus;
    private final List<ErrorDetails> allErrors = new ArrayList<ErrorDetails>();
    private final Map<GeniUrn, SliverStatus> statusByComponentUrn = new HashMap<GeniUrn, SliverStatus>();
    private final Map<GeniUrn, SliverStatus> statusBySliverUrn = new HashMap<GeniUrn, SliverStatus>();
    private Date earliestKnownExpires = null;
    private Date latestKnownExpires = null;
    public static StatusDetails identityStatus = new StatusDetails(SliverStatus.UNKNOWN);
    public static BinaryOperator<StatusDetails> merge = (a, b) -> {
        if (a == identityStatus) {
            return b;
        }
        if (b == identityStatus) {
            return a;
        }
        StatusDetails res = new StatusDetails((StatusDetails)a);
        res.add((StatusDetails)b);
        return res;
    };

    public StatusDetails(@Nonnull SliverStatus globalStatus) {
        this.globalStatus = globalStatus;
    }

    public StatusDetails(@Nonnull SliverStatus globalStatus, GeniUrn forSliverUrn) {
        this.globalStatus = globalStatus;
        if (forSliverUrn != null) {
            this.addSliverStatus(forSliverUrn, globalStatus);
        }
    }

    public StatusDetails(@Nonnull String status) {
        this(SliverStatus.parse(status));
    }

    public StatusDetails(StatusDetails o) {
        this.globalStatus = o.globalStatus;
        this.allErrors.addAll(o.allErrors);
        this.statusByComponentUrn.putAll(o.statusByComponentUrn);
        this.statusBySliverUrn.putAll(o.statusBySliverUrn);
    }

    public SliverStatus getGlobalStatus() {
        return this.globalStatus;
    }

    @Nonnull
    public List<ErrorDetails> getAllErrors() {
        return this.allErrors;
    }

    @Nonnull
    public Collection<GeniUrn> getAllSliverUrns() {
        return this.statusBySliverUrn.keySet();
    }

    @Nonnull
    public Collection<GeniUrn> getAllComponentUrns() {
        return this.statusByComponentUrn.keySet();
    }

    public boolean hasComponentStatus(@Nonnull GeniUrn geniUrn) {
        return this.statusByComponentUrn.containsKey(geniUrn);
    }

    public boolean hasSliverStatus(@Nonnull GeniUrn geniUrn) {
        return this.statusBySliverUrn.containsKey(geniUrn);
    }

    @Nullable
    public SliverStatus getNodeStatusByComponentUrn(@Nonnull GeniUrn componentUrn) {
        return this.statusByComponentUrn.get(componentUrn);
    }

    @Nullable
    public SliverStatus getStatusBySliverUrn(@Nonnull GeniUrn sliverUrn) {
        return this.statusBySliverUrn.get(sliverUrn);
    }

    public void addError(@Nonnull ErrorDetails errorDetails) {
        this.allErrors.add(errorDetails);
    }

    public void addComponentStatus(@Nonnull String componentUrn, @Nonnull String status) {
        GeniUrn u = GeniUrn.parse((String)componentUrn);
        if (u == null) {
            return;
        }
        this.addComponentStatus(u, status);
    }

    public void addComponentStatus(@Nonnull GeniUrn componentUrn, @Nonnull String status) {
        this.statusByComponentUrn.put(componentUrn, SliverStatus.parse(status));
    }

    public void addSliverStatus(@Nonnull String sliverUrn, @Nonnull String status) {
        GeniUrn u = GeniUrn.parse((String)sliverUrn);
        if (u == null) {
            return;
        }
        this.addSliverStatus(u, SliverStatus.parse(status));
    }

    public void addSliverStatus(@Nonnull String sliverUrn, @Nonnull SliverStatus status) {
        GeniUrn u = GeniUrn.parse((String)sliverUrn);
        if (u == null) {
            return;
        }
        this.addSliverStatus(u, status);
    }

    public void addSliverStatus(@Nonnull GeniUrn sliverUrn, @Nonnull String status) {
        this.addSliverStatus(sliverUrn, SliverStatus.parse(status));
    }

    public void addSliverStatus(@Nonnull GeniUrn sliverUrn, @Nonnull SliverStatus status) {
        this.statusBySliverUrn.put(sliverUrn, status);
    }

    public void mergeGlobalStatus(@Nonnull SliverStatus globalStatus) {
        this.globalStatus = SliverStatus.merge(this.globalStatus, globalStatus);
    }

    @Nullable
    public Date getEarliestKnownExpires() {
        return this.earliestKnownExpires;
    }

    @Nullable
    public Date getLatestKnownExpires() {
        return this.latestKnownExpires;
    }

    public void addKnownExpires(@Nullable Date knownExpires) {
        if (knownExpires == null) {
            return;
        }
        if (this.earliestKnownExpires == null || knownExpires.before(this.earliestKnownExpires)) {
            this.earliestKnownExpires = knownExpires;
        }
        if (this.latestKnownExpires == null || knownExpires.after(this.latestKnownExpires)) {
            this.latestKnownExpires = knownExpires;
        }
    }

    public void add(@Nonnull StatusDetails otherStatus) {
        this.mergeGlobalStatus(otherStatus.globalStatus);
        this.allErrors.addAll(otherStatus.allErrors);
        this.statusByComponentUrn.putAll(otherStatus.statusByComponentUrn);
        this.statusBySliverUrn.putAll(otherStatus.statusBySliverUrn);
        this.addKnownExpires(otherStatus.getEarliestKnownExpires());
    }

    @Nonnull
    public Map<GeniUrn, SliverStatus> getStatusByComponentUrn() {
        return Collections.unmodifiableMap(this.statusByComponentUrn);
    }

    @Nonnull
    public Map<GeniUrn, SliverStatus> getStatusBySliverUrn() {
        return Collections.unmodifiableMap(this.statusBySliverUrn);
    }

    public String toString() {
        return this.globalStatus != null ? this.globalStatus.name() : "NULL";
    }

    @Nonnull
    public String detailedToString() {
        return "StatusDetails{globalStatus=" + String.valueOf((Object)this.globalStatus) + ", allErrors=" + String.valueOf(this.allErrors) + ", statusByComponentUrn=" + String.valueOf(this.statusByComponentUrn) + ", statusBySliverUrn=" + String.valueOf(this.statusBySliverUrn) + "}";
    }

    public static enum SliverStatus {
        UNINITIALISED,
        READY,
        NOTREADY,
        UNALLOCATED,
        UNKNOWN,
        CHANGING,
        FAIL;

        private static final SliverStatus[] PRECEDENCE_ORDER;

        public static SliverStatus parse(@Nonnull String s) {
            if (s.startsWith(":")) {
                s = s.substring(1);
            }
            if (s.startsWith("geni_")) {
                s = s.substring(5);
            }
            if (s.equalsIgnoreCase("ready")) {
                return READY;
            }
            if (s.equalsIgnoreCase("failed")) {
                return FAIL;
            }
            if (s.equalsIgnoreCase("unknown")) {
                return UNKNOWN;
            }
            if (s.equalsIgnoreCase("notready")) {
                return NOTREADY;
            }
            if (s.equalsIgnoreCase("ready_busy")) {
                return READY;
            }
            if (s.equalsIgnoreCase("configuring")) {
                return CHANGING;
            }
            if (s.equalsIgnoreCase("pending_allocation")) {
                return CHANGING;
            }
            if (s.equalsIgnoreCase("stopping")) {
                return CHANGING;
            }
            if (s.equalsIgnoreCase("changing")) {
                return CHANGING;
            }
            if (s.equalsIgnoreCase("updating_users")) {
                return CHANGING;
            }
            if (s.equalsIgnoreCase("error")) {
                return FAIL;
            }
            if (s.toLowerCase().startsWith("fail")) {
                return FAIL;
            }
            if (s.equalsIgnoreCase("uninitialised")) {
                return UNINITIALISED;
            }
            if (s.equalsIgnoreCase("unallocated")) {
                return UNALLOCATED;
            }
            return UNKNOWN;
        }

        public static SliverStatus merge(SliverStatus ss1, SliverStatus ss2) {
            for (SliverStatus ss : PRECEDENCE_ORDER) {
                if (ss1 != ss && ss2 != ss) continue;
                return ss;
            }
            throw new IllegalStateException("Could not establish precedence!");
        }

        static {
            PRECEDENCE_ORDER = new SliverStatus[]{FAIL, UNKNOWN, UNALLOCATED, UNINITIALISED, NOTREADY, CHANGING, READY};
        }
    }
}

