/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoGeniSAUserAndSliceApiWrapper
extends UserAndSliceApiWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoGeniSAUserAndSliceApiWrapper.class);
    private static final ApiInfo.Api API_INFO = new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1);
    private List<AnyCredential> userCredentialsNoSubAuth;
    private final Map<String, List<AnyCredential>> userCredentialsBySubAuth = new HashMap<String, List<AnyCredential>>();
    @Nullable
    private HashMap<String, String> subAuthNamesToUrl = null;

    public ProtoGeniSAUserAndSliceApiWrapper(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, geniUserProvider, connectionProvider, jFedPreferences);
    }

    @Nonnull
    private ProtogeniSliceAuthority sa(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) {
        return new ProtogeniSliceAuthority(logger, this.jFedPreferences);
    }

    @Nonnull
    protected SfaConnection getConnection(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nullable String subAuthName) throws JFedException {
        URL subAuthUrl;
        if (subAuthName == null) {
            return this.getConnection(API_INFO);
        }
        if (this.subAuthNamesToUrl == null) {
            if (this.userCredentialsNoSubAuth == null) {
                throw new JFedException("There are no user credentials stored yet, while that is needed to request the names of the sub authorities");
            }
            GeniUrn userUrn = this.speaksForUserUrn != null ? this.speaksForUserUrn : this.geniUserProvider.getLoggedInGeniUser().getUserUrn();
            this.getSubAuthorityNames(logger, userUrn);
        }
        if (this.subAuthNamesToUrl == null) {
            throw new JFedException("Error in ProtoGeniSAUserAndSliceApiWrapper getSubAuthority: no sub authorities known. subAuthName=" + subAuthName);
        }
        String subAuthUrlStr = this.subAuthNamesToUrl.get(subAuthName);
        if (subAuthUrlStr == null) {
            throw new JFedException("Error in ProtoGeniSAUserAndSliceApiWrapper getSubAuthority: no sub authority for subAuthName=" + subAuthName);
        }
        try {
            subAuthUrl = new URL(subAuthUrlStr);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Error in ProtoGeniSAUserAndSliceApiWrapper getSubAuthority: no valid URL for subAuthName=" + subAuthName + " subAuthUrlStr=\"" + subAuthUrlStr + "\"", (Throwable)e);
        }
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        assert (user.getUserAuthorityServer() != null);
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        jFedTrustStore.addTrustedPemCertificateIfNotAdded(user.getUserAuthorityServer().getCertificateChain());
        Service service = ApiInfo.findService(user.getUserAuthorityServer(), ApiInfo.ApiName.PROTOGENI_SA, 1);
        return (SfaConnection)this.connectionProvider.getConnectionByUrl(jFedTrustStore, user, subAuthUrl, null, API_INFO, service, null);
    }

    @Nonnull
    public List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, GeniUrn userUrn, @Nullable String subAuthorityName) throws JFedException {
        if (subAuthorityName != null) assert (this.userCredentialsNoSubAuth != null);
        SfaConnection con = this.getConnection(logger, subAuthorityName);
        assert (con.getDebugInfo() != null && con.getDebugInfo().getServiceId() != null);
        ProtogeniSliceAuthority.SliceAuthorityReply<AnyCredential> reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).getCredential(con) : this.sa(logger).getAnyCredential(con, this.speaksForCredentials, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve user credential from server", reply);
        }
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        res.add(reply.getValue());
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            res.addAll(this.speaksForCredentials);
        }
        if (subAuthorityName == null) {
            this.userCredentialsNoSubAuth = res;
        } else {
            this.userCredentialsBySubAuth.put(subAuthorityName, res);
        }
        return new ArrayList<AnyCredential>(res);
    }

    @Override
    @Nonnull
    public List<AnyCredential> getCachedUserCredentialsForAM() {
        if (this.userCredentialsNoSubAuth == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AnyCredential>(this.userCredentialsNoSubAuth);
    }

    @Override
    public boolean hasUserCredentials() {
        return this.hasUserCredentials(this.userCredentialsNoSubAuth);
    }

    protected List<AnyCredential> getSubAuthCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, String subAuthName) throws JFedException {
        List<AnyCredential> res = this.userCredentialsBySubAuth.get(subAuthName);
        if (res == null) {
            res = this.getUserCredentials(logger, this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), subAuthName);
        }
        if (res.isEmpty() || !this.hasUserCredentials(res)) {
            res = this.getUserCredentials(logger, this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), subAuthName);
        }
        return res;
    }

    @Override
    @Nonnull
    public List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
        return this.getUserCredentials(logger, userUrn, null);
    }

    @Override
    @Nonnull
    public List<AnyCredential> getSliceCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn) throws JFedException {
        List<AnyCredential> userCredentials_forCall = this.getCredentialsForCall(logger, sliceUrn);
        ProtogeniSliceAuthority.SliceAuthorityReply<AnyCredential> reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).getSliceCredential(this.getConnection(logger, sliceUrn.getEncodedSubAuthName()), AnyCredential.toSingleCredential(userCredentials_forCall), (ResourceId)sliceUrn) : this.sa(logger).getSliceCredential(this.getConnection(logger, sliceUrn.getEncodedSubAuthName()), userCredentials_forCall, (ResourceId)sliceUrn);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slice credential from server");
        }
        if (this.speaksForCredentials == null || this.speaksForCredentials.isEmpty()) {
            return Collections.singletonList(reply.getValue());
        }
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        res.add(reply.getValue());
        res.addAll(this.speaksForCredentials);
        return res;
    }

    @Nonnull
    private List<AnyCredential> getCredentialsForCall(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn urn) throws JFedException {
        return this.getCredentialsForCall(logger, urn.getEncodedSubAuthName());
    }

    @Nonnull
    private List<AnyCredential> getCredentialsForCall(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nullable String subAuthName) throws JFedException {
        List<AnyCredential> userCredentials_forCall = subAuthName == null ? this.userCredentialsNoSubAuth : this.getSubAuthCredentials(logger, subAuthName);
        if (userCredentials_forCall == null) {
            throw new JFedException("Internal jFed error: no correct credential stored. (subAuthName=" + subAuthName + ")");
        }
        return userCredentials_forCall;
    }

    @Override
    @Nonnull
    public List<GeniUrn> getSlicesForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        ProtogeniSliceAuthority.SliceAuthorityReply<ProtogeniSliceAuthority.UserInfo> reply;
        if (!this.hasUserCredentials()) {
            this.getUserCredentials(logger, user);
            assert (this.hasUserCredentials());
        }
        if (!(reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).resolveUser(this.getConnection(logger, null), AnyCredential.toSingleCredential(this.userCredentialsNoSubAuth), (ResourceId)user) : this.sa(logger).resolveUser(this.getConnection(logger, null), this.userCredentialsNoSubAuth, (ResourceId)user)).getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slices for user", reply);
        }
        return reply.getValue().getSlices();
    }

    @Override
    @Nonnull
    public List<GeniUrn> getAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        List<AnyCredential> userCredentials_forCall = this.getCredentialsForCall(logger, sliceUrn);
        ProtogeniSliceAuthority.SliceAuthorityReply<ProtogeniSliceAuthority.SliceInfo> reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).resolveSlice(this.getConnection(logger, sliceUrn.getEncodedSubAuthName()), AnyCredential.toSingleCredential(userCredentials_forCall), (ResourceId)sliceUrn) : this.sa(logger).resolveSlice(this.getConnection(logger, sliceUrn.getEncodedSubAuthName()), userCredentials_forCall, (ResourceId)sliceUrn);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve aggregates for slice", reply);
        }
        return reply.getValue().getComponentManagers();
    }

    @Override
    @Nullable
    public Date getSliceExpiration(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        return null;
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        ProtogeniSliceAuthority.SliceAuthorityReply<Boolean> reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).bindToSlice(this.getConnection(logger, sliceUrn.getEncodedSubAuthName()), AnyCredential.toSingleCredential(sliceCredentials), (ResourceId)userUrn) : this.sa(logger).bindToSlice(this.getConnection(logger, sliceUrn.getEncodedSubAuthName()), sliceCredentials, (ResourceId)userUrn);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("shareSlice call not succesful", reply);
        }
    }

    @Override
    public void unshareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    @Nonnull
    public UserAndSliceApiWrapper.SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String sliceName, @Nullable Date expirationDate, @Nullable String subAuthName) throws JFedException {
        boolean mustRenew;
        List<AnyCredential> userCredentials_forCall = this.getCredentialsForCall(logger, subAuthName);
        if (this.getLoggedInUserAuthorityServer() == null) {
            throw new IllegalStateException("Cannot createSlice when User Authority-server is unknown");
        }
        GeniUrn sliceUrn = subAuthName != null ? GeniUrn.createGeniUrnFromEncodedParts((String)(this.getLoggedInUserAuthorityServer().getUrnTld() + ":" + subAuthName), (String)"slice", (String)sliceName) : GeniUrn.createGeniUrnFromEncodedParts((String)this.getLoggedInUserAuthorityServer().getUrnTld(), (String)"slice", (String)sliceName);
        ProtogeniSliceAuthority.SliceAuthorityReply<AnyCredential> reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).register(this.getConnection(logger, subAuthName), AnyCredential.toSingleCredential(userCredentials_forCall), (ResourceUrn)sliceUrn) : this.sa(logger).register(this.getConnection(logger, subAuthName), userCredentials_forCall, (ResourceUrn)sliceUrn);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not create slice on server", reply);
        }
        AnyCredential sliceCredential = reply.getValue();
        boolean bl = mustRenew = expirationDate != null;
        if (expirationDate != null && sliceCredential instanceof SfaCredential) {
            SfaCredential sfaCredential = (SfaCredential)sliceCredential;
            boolean bl2 = mustRenew = sfaCredential.getExpiresDate() != null && sfaCredential.getExpiresDate().before(expirationDate);
        }
        if (mustRenew) {
            try {
                ProtogeniSliceAuthority.SliceAuthorityReply<AnyCredential> replyRenew = this.sa(logger).renewSlice(this.getConnection(logger, subAuthName), sliceCredential, RFC3339Util.dateToRFC3339String((Date)expirationDate, (boolean)true, (boolean)true, (boolean)true));
                if (replyRenew.getGeniResponseCode().isSuccess()) {
                    sliceCredential = replyRenew.getValue();
                } else {
                    LOG.warn("Renew call to set expiration of new Slice date failed. Ignoring. Output: " + replyRenew.getOutput());
                }
            }
            catch (JFedException e) {
                LOG.error("Ignoring exception when renewing: " + e.getMessage(), (Throwable)e);
            }
        }
        GeniUrn returnedSliceUrn = sliceUrn;
        if (sliceCredential instanceof SfaCredential) {
            SfaCredential sfaCred = (SfaCredential)sliceCredential;
            try {
                returnedSliceUrn = new GeniUrn(sfaCred.getTargetUrn());
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new JFedException("Could not parse the returned SliceUrn '" + sfaCred.getTargetUrn() + "'", reply);
            }
            if (!Objects.equals(returnedSliceUrn, sliceUrn)) {
                LOG.warn("URN CHANGED: \"Register\" of slice with urn \"" + String.valueOf(sliceUrn) + "\" returned credential for URN \"" + String.valueOf(returnedSliceUrn) + "\"");
            }
        }
        ArrayList<AnyCredential> sliceCredentials = new ArrayList<AnyCredential>();
        sliceCredentials.add(sliceCredential);
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            sliceCredentials.addAll(this.speaksForCredentials);
        }
        return new UserAndSliceApiWrapper.SliceInfo(sliceName, returnedSliceUrn, sliceCredentials);
    }

    @Override
    @Nonnull
    public List<AnyCredential> renewSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Date newExpirationDate) throws JFedException {
        String subAuthName;
        try {
            GeniUrn sliceUrn = ProtoGeniSAUserAndSliceApiWrapper.findSliceUrn(sliceCredentials);
            subAuthName = sliceUrn.getEncodedSubAuthName();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("renewSlice: could not find sliceUrn in credential list. cannot determine if this is slice for subAuthority! Assuming no", (Throwable)e);
            subAuthName = null;
        }
        if (subAuthName != null) assert (this.subAuthNamesToUrl != null);
        ProtogeniSliceAuthority.SliceAuthorityReply<AnyCredential> reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).renewSlice(this.getConnection(logger, subAuthName), AnyCredential.toSingleCredential(sliceCredentials), RFC3339Util.dateToRFC3339String((Date)newExpirationDate, (boolean)true, (boolean)true, (boolean)true)) : this.sa(logger).renewSlice(this.getConnection(logger, subAuthName), sliceCredentials, RFC3339Util.dateToRFC3339String((Date)newExpirationDate, (boolean)true, (boolean)true, (boolean)true));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not renew slice on server: code=" + String.valueOf(reply.getGeniResponseCode()) + " output=" + reply.getOutput(), (XMLRPCCallDetails)reply.getXMLRPCCallDetailsWithCodeValueError(), (GeniResponseCode)reply.getGeniResponseCode());
        }
        ArrayList<AnyCredential> newSliceCredentials = new ArrayList<AnyCredential>();
        newSliceCredentials.add(reply.getValue());
        if (this.speaksForCredentials != null) {
            newSliceCredentials.addAll(this.speaksForCredentials);
        }
        return newSliceCredentials;
    }

    @Override
    public List<String> getSshKeysForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
        if (!Objects.equals(this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), userUrn)) {
            throw new JFedException("Protogeni SA API can NOT get keys for other user than logged in user.");
        }
        ProtogeniSliceAuthority.SliceAuthorityReply<List<String>> reply = this.sa(logger).getKeys(this.getConnection(logger, null), AnyCredential.toSingleCredential(this.userCredentialsNoSubAuth));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to get SSH keys", reply);
        }
        return reply.getValue();
    }

    @Override
    @Nonnull
    public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        return UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_OPTIONAL;
    }

    @Override
    @Nonnull
    public List<String> getSubAuthorityNames(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        ProtogeniSliceAuthority.SliceAuthorityReply<ProtogeniSliceAuthority.UserInfo> reply = this.speaksForCredentials == null || this.speaksForCredentials.isEmpty() ? this.sa(logger).resolveUser(this.getConnection(logger, null), AnyCredential.toSingleCredential(this.userCredentialsNoSubAuth), (ResourceId)user) : this.sa(logger).resolveUser(this.getConnection(logger, null), this.userCredentialsNoSubAuth, (ResourceId)user);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("getSubAuthorityNames call not succesful", reply);
        }
        Map<GeniUrn, String> subAuthorities = reply.getValue().getSubAuthorities();
        return reply.getValue().getSubAuthorities().keySet().stream().map(GeniUrn::getSubAuthName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<GeniUrn> getUsersForSubAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String projectName) throws JFedException {
        throw new UnsupportedOperationException("Not supported by API");
    }

    @Override
    @Nonnull
    public List<GeniUrn> getUsersForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        throw new UnsupportedOperationException("Not supported by API");
    }

    @Override
    public boolean hasSubAuthDetailsSupport() {
        return false;
    }

    @Override
    public void getSubAuthorityDetails(@NotNull be.iminds.ilabt.jfed.log.Logger logger, @NotNull String projectName) throws JFedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull List<GeniUrn> userUrns, @Nonnull String role) throws JFedException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isRegisterAggregatesForSliceSupported() {
        return false;
    }

    @Override
    public boolean hasSpeaksForSupport() {
        return true;
    }
}

