/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority.legacy;

import be.iminds.ilabt.jfed.lowlevel.authority.binding.Authorities;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.lib.Gid;
import be.iminds.ilabt.jfed.lowlevel.lib.ServerType;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacySfaAuthority {
    private static final Logger LOG = LoggerFactory.getLogger(LegacySfaAuthority.class);
    private static final String FAKE_TYPE = "fake";
    public static final boolean debug = true;
    private GeniUrn urn;
    private String urnString;
    private String urnPart;
    private String hrn;
    private Location location;
    private Map<ServerType, URL> urls;
    private List<ProxyInfo> proxies;
    private Gid gid;
    private String type;
    private InfoSource source;
    private boolean wasStored = false;
    private List<String> pemSslTrustCerts;
    private List<String> allowedCertificateHostnameAliases;
    private GeniUrn defaultScsUrn;
    private final Set<SpecialCase> specialCases = new HashSet<SpecialCase>();

    public LegacySfaAuthority(LegacySfaAuthority otherAuthority) {
        this.urn = otherAuthority.urn;
        this.urnString = otherAuthority.urnString;
        this.urnPart = otherAuthority.urnPart;
        this.hrn = otherAuthority.hrn;
        this.location = otherAuthority.location;
        this.gid = otherAuthority.gid != null ? new Gid(otherAuthority.gid) : null;
        this.urls = new HashMap<ServerType, URL>(otherAuthority.urls);
        this.proxies = new ArrayList<ProxyInfo>(otherAuthority.proxies);
        this.source = otherAuthority.source;
        this.pemSslTrustCerts = otherAuthority.pemSslTrustCerts == null ? null : new ArrayList<String>(otherAuthority.pemSslTrustCerts);
        this.allowedCertificateHostnameAliases = new ArrayList<String>(otherAuthority.allowedCertificateHostnameAliases);
        this.defaultScsUrn = otherAuthority.defaultScsUrn;
        this.specialCases.addAll(otherAuthority.specialCases);
    }

    public LegacySfaAuthority(String urnString, String hrn, Location location, Map<ServerType, URL> urls, List<ProxyInfo> proxies, Gid gid, String type) throws JFedException {
        assert (urnString != null) : "Cannot create GeniAuthority if URN is not known";
        this.urnString = urnString;
        this.urn = GeniUrn.parse((String)urnString);
        this.urnPart = LegacySfaAuthority.urnPartFromUrn(urnString);
        this.hrn = hrn;
        this.location = location;
        this.urls = new HashMap<ServerType, URL>();
        if (urls != null) {
            this.urls.putAll(urls);
        }
        this.proxies = proxies == null ? new ArrayList<ProxyInfo>() : new ArrayList<ProxyInfo>(proxies);
        this.gid = gid;
        this.type = type;
        this.allowedCertificateHostnameAliases = new ArrayList<String>();
        this.source = InfoSource.USER_PROVIDED;
        this.wasStored = false;
        this.defaultScsUrn = null;
    }

    public LegacySfaAuthority(String urnString) throws JFedException {
        this.urnString = urnString;
        this.urn = GeniUrn.parse((String)urnString);
        this.urnPart = LegacySfaAuthority.urnPartFromUrn(urnString);
        this.hrn = null;
        this.location = null;
        this.urls = new HashMap<ServerType, URL>();
        this.proxies = new ArrayList<ProxyInfo>();
        this.gid = null;
        this.allowedCertificateHostnameAliases = new ArrayList<String>();
        this.defaultScsUrn = null;
    }

    public static String urnPartFromUrn(String urn) throws JFedException {
        assert (urn != null);
        GeniUrn geniUrn = GeniUrn.parse((String)urn);
        if (geniUrn == null) {
            throw new JFedException("Illegal Geni Authority URN: \"" + urn + "\"");
        }
        String urnPart = geniUrn.getEncodedTopLevelAuthority();
        if (urnPart == null) {
            throw new JFedException("Illegal Geni Authority URN: urnPart=null in \"" + urn + "\"");
        }
        if (urnPart.length() < 2) {
            throw new JFedException("Illegal Geni Authority URN: urnPart=\"" + urnPart + "\" in \"" + urn + "\"");
        }
        if (Objects.equals(urnPart, urn)) {
            throw new JFedException("Error extracting urnPart from urn=\"" + urn + "\"");
        }
        return urnPart;
    }

    public static LegacySfaAuthority fromXml(String xml) throws JFedException {
        try {
            Class<Authorities.Authority> docClass = Authorities.Authority.class;
            String packageName = docClass.getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement doc = (JAXBElement)u.unmarshal((Reader)new StringReader(xml));
            Authorities.Authority c = (Authorities.Authority)doc.getValue();
            return LegacySfaAuthority.fromXml(c);
        }
        catch (JFedException ex) {
            throw ex;
        }
        catch (Exception e) {
            LOG.warn("Error reading Authority XML", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static LegacySfaAuthority fromXml(Authorities.Authority xmlAuthority) throws JFedException {
        try {
            LegacySfaAuthority res = new LegacySfaAuthority(xmlAuthority.getUrn());
            res.wasStored = true;
            if (xmlAuthority.getGid() != null) {
                res.setGid(new Gid(xmlAuthority.getGid()));
            }
            res.setHrn(xmlAuthority.getHrn());
            if (xmlAuthority.getLocation() != null) {
                res.setLocation(new Location(xmlAuthority.getLocation().getCountry(), xmlAuthority.getLocation().getLatitude(), xmlAuthority.getLocation().getLongitude()));
            }
            res.addPemSslTrustCert(xmlAuthority.getPemSslTrustCert());
            for (String string : xmlAuthority.getSpecial()) {
                try {
                    SpecialCase specialCase = SpecialCase.fromString(string.trim());
                    res.setSpecialCase(specialCase, true);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Parsed authority XML contained unknown <special> option: \"" + string + "\"");
                }
            }
            if (xmlAuthority.isReconnectEachTime()) {
                res.setReconnectEachTime(xmlAuthority.isReconnectEachTime());
            }
            res.setType(xmlAuthority.getType());
            if (xmlAuthority.getSource() != null) {
                Object source = null;
                if (Objects.equals(xmlAuthority.getSource(), "Clearinghouse")) {
                    source = InfoSource.UTAH_CLEARINGHOUSE;
                }
                if (Objects.equals(xmlAuthority.getSource(), "Builtin")) {
                    source = InfoSource.BUILTIN;
                }
                if (Objects.equals(xmlAuthority.getSource(), "User")) {
                    source = InfoSource.USER_PROVIDED;
                }
                res.setSource((InfoSource)((Object)source));
            }
            if (xmlAuthority.getAllowedCertificateHostnameAliases() != null) {
                res.setAllowedCertificateHostnameAlias(xmlAuthority.getAllowedCertificateHostnameAliases().getAlias());
            }
            for (Authorities.Authority.Urls.Serverurl serverurl : xmlAuthority.getUrls().getServerurl()) {
                ServerType.GeniServerRole role = null;
                if (Objects.equals(serverurl.getServertype().getRole(), "Slice Authority")) {
                    role = ServerType.GeniServerRole.PROTOGENI_SA;
                }
                if (Objects.equals(serverurl.getServertype().getRole(), "Aggregate Manager")) {
                    role = ServerType.GeniServerRole.AM;
                }
                if (Objects.equals(serverurl.getServertype().getRole(), "PlanetLab registry")) {
                    role = ServerType.GeniServerRole.PlanetLabSliceRegistry;
                }
                if (role == null) {
                    try {
                        role = ServerType.GeniServerRole.valueOf(serverurl.getServertype().getRole());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error("Unknown role: \"" + serverurl.getServertype().getRole() + "\"", (Throwable)e);
                        role = null;
                    }
                }
                if (role != null) {
                    ServerType serverType = new ServerType(role, serverurl.getServertype().getVersion());
                    res.setUrl(serverType, new URL(serverurl.getUrl()));
                    continue;
                }
                LOG.error("Ignoring URL for unknown role: \"" + serverurl.getServertype().getRole() + "\"");
            }
            ArrayList<ProxyInfo> proxies = new ArrayList<ProxyInfo>();
            if (xmlAuthority.getProxies() != null && xmlAuthority.getProxies().getProxy() != null) {
                for (Authorities.Authority.Proxies.Proxy proxyXml : xmlAuthority.getProxies().getProxy()) {
                    ProxyInfo proxyInfo = new ProxyInfo(proxyXml);
                    proxies.add(proxyInfo);
                }
            }
            res.replaceProxies(proxies);
            if (xmlAuthority.getDefaultScsUrn() != null) {
                try {
                    res.defaultScsUrn = new GeniUrn(xmlAuthority.getDefaultScsUrn());
                }
                catch (GeniUrn.GeniUrnParseException geniUrnParseException) {
                    LOG.warn("defaultScsUrn is invalid URN: \"" + xmlAuthority.getDefaultScsUrn() + "\"", (Throwable)geniUrnParseException);
                }
            }
            return res;
        }
        catch (JFedException ex) {
            throw ex;
        }
        catch (Exception e) {
            LOG.error("WARNING: Error reading authority xml: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<GeniUrn> authoritiesToUrns(LegacySfaAuthority auth) {
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        res.add(auth.getUrn());
        return res;
    }

    public static List<GeniUrn> authoritiesToUrns(LegacySfaAuthority ... auths) {
        return Arrays.stream(auths).map(LegacySfaAuthority::getUrn).collect(Collectors.toList());
    }

    public static List<GeniUrn> authoritiesToUrns(List<LegacySfaAuthority> auths) {
        return auths.stream().map(LegacySfaAuthority::getUrn).collect(Collectors.toList());
    }

    public String getName() {
        if (this.hrn == null) {
            return this.urnPart;
        }
        return this.hrn;
    }

    public void setName(String name) {
        this.hrn = name;
    }

    public String getHrn() {
        return this.getName();
    }

    public void setHrn(String hrn) {
        this.hrn = hrn;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public URL getUrl(ServerType serverType) {
        return this.urls.get(serverType);
    }

    public URL getUrl(ServerType.GeniServerRole role, int version) {
        return this.urls.get(new ServerType(role, version));
    }

    public Map<ServerType, URL> getUrls() {
        return Collections.unmodifiableMap(this.urls);
    }

    public List<ProxyInfo> getProxies() {
        return Collections.unmodifiableList(this.proxies);
    }

    public boolean isReconnectEachTime() {
        return this.hasSpecialCase(SpecialCase.RECONNECT_EACH_TIME);
    }

    public void setReconnectEachTime(boolean reconnectEachTime) {
        this.setSpecialCase(SpecialCase.RECONNECT_EACH_TIME, reconnectEachTime);
    }

    public String getType() {
        return this.type;
    }

    public boolean isType(String checkType) {
        if (this.type == null) {
            return false;
        }
        if (checkType == null) {
            LOG.warn("authority.isType(null) called! This makes little sense (will handle by replying false).");
            return false;
        }
        return this.type.equalsIgnoreCase(checkType);
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getAllowedCertificateHostnameAliases() {
        if (this.allowedCertificateHostnameAliases == null) {
            return new LinkedList<String>();
        }
        return Collections.unmodifiableList(this.allowedCertificateHostnameAliases);
    }

    public void setUrl(ServerType serverType, URL newUrl) {
        this.urls.put(serverType, newUrl);
    }

    public void replaceUrls(Map<ServerType, URL> newMap) {
        this.urls.clear();
        this.urls.putAll(newMap);
    }

    public void replaceProxies(List<ProxyInfo> proxies) {
        this.proxies = proxies;
    }

    public void addAllowedCertificateHostnameAlias(String alias) {
        this.allowedCertificateHostnameAliases.add(alias);
    }

    public void setAllowedCertificateHostnameAlias(List<String> aliases) {
        this.allowedCertificateHostnameAliases.clear();
        this.allowedCertificateHostnameAliases.addAll(aliases);
    }

    public void updateAll(String hrn, Map<ServerType, URL> urls, Gid gid, String type) {
        this.updateHrn(hrn);
        for (Map.Entry<ServerType, URL> e : urls.entrySet()) {
            this.updateUrl(e.getKey(), e.getValue());
        }
        this.updateGid(gid);
        this.updateType(type);
    }

    public void updateUrl(ServerType serverType, URL newUrl) {
        URL prevUrl = this.getUrl(serverType);
        if (prevUrl == null) {
            return;
        }
        if (!Objects.equals(prevUrl, newUrl)) {
            LOG.warn("updateUrl(" + String.valueOf(serverType) + ", \"" + String.valueOf(newUrl) + "\") while prevUrl=\"" + String.valueOf(prevUrl) + "\"");
        }
        this.urls.put(serverType, newUrl);
    }

    public boolean hasAmUrl() {
        for (ServerType st : this.urls.keySet()) {
            if (st.getRole() != ServerType.GeniServerRole.AM) continue;
            return true;
        }
        return false;
    }

    public void updateHrn(String hrn) {
        if (hrn == null) {
            return;
        }
        if (this.hrn != null && !Objects.equals(hrn, this.hrn)) {
            LOG.warn("updateHrn(\"" + hrn + "\") while hrn=\"" + this.hrn + "\"");
        }
        this.hrn = hrn;
    }

    public void updateUrn(String urn) throws JFedException {
        if (urn == null) {
            return;
        }
        if (this.urnString != null && !Objects.equals(urn, this.urnString)) {
            LOG.warn("updateUrn(\"" + urn + "\") while urn=\"" + this.urnString + "\"");
        }
        if (this.urnString == null || !Objects.equals(urn, this.urnString)) {
            this.urn = GeniUrn.parse((String)this.urnString);
            this.urnString = urn;
            this.urnPart = LegacySfaAuthority.urnPartFromUrn(urn);
        }
    }

    public void updateName(String name) {
        this.updateHrn(name);
    }

    public void updateGid(Gid gid) {
        if (gid == null) {
            return;
        }
        if (this.gid != null && !Objects.equals(gid, this.gid)) {
            LOG.warn("updateGid(\"" + String.valueOf(gid) + "\") while gid=\"" + String.valueOf(this.gid) + "\"");
        }
        this.gid = gid;
    }

    public void updateType(String type) {
        if (type == null) {
            return;
        }
        if (this.type != null && !Objects.equals(type, this.type)) {
            LOG.warn("updateType(\"" + type + "\") while type=\"" + this.type + "\"");
        }
        this.type = type;
    }

    public String getNameForUrn() {
        return this.urnPart;
    }

    public String getUrnString() {
        return this.urnString;
    }

    public GeniUrn getUrn() {
        return this.urn;
    }

    public Gid getGid() {
        return this.gid;
    }

    public void setGid(Gid gid) {
        this.gid = gid;
    }

    public void clearPemSslTrustCerts() {
        this.pemSslTrustCerts = null;
    }

    public void addPemSslTrustCert(String pemSslTrustCert) {
        if (this.pemSslTrustCerts == null) {
            this.pemSslTrustCerts = new ArrayList<String>();
        }
        this.pemSslTrustCerts.add(pemSslTrustCert);
    }

    public void addPemSslTrustCert(List<String> extraPemSslTrustCerts) {
        if (extraPemSslTrustCerts == null) {
            return;
        }
        if (this.pemSslTrustCerts == null) {
            this.pemSslTrustCerts = new ArrayList<String>();
        }
        this.pemSslTrustCerts.addAll(extraPemSslTrustCerts);
    }

    public void addPemSslTrustCert(X509Certificate sslTrustCert) {
        assert (sslTrustCert != null);
        this.addPemSslTrustCert(KeyUtil.x509certificateToPem((X509Certificate)sslTrustCert));
    }

    public List<String> getPemSslTrustCerts() {
        if (this.pemSslTrustCerts == null) {
            return new ArrayList<String>();
        }
        return Collections.unmodifiableList(this.pemSslTrustCerts);
    }

    public boolean hasPemSslTrustCerts() {
        return this.pemSslTrustCerts != null && !this.pemSslTrustCerts.isEmpty();
    }

    public InfoSource getSource() {
        return this.source;
    }

    public void setSource(InfoSource source) {
        this.source = source;
    }

    public GeniUrn getDefaultScsUrn() {
        return this.defaultScsUrn;
    }

    public void setDefaultScsUrn(GeniUrn defaultScsUrn) {
        this.defaultScsUrn = defaultScsUrn;
    }

    public boolean isWasStored() {
        return this.wasStored;
    }

    public void setWasStored(boolean wasStored) {
        this.wasStored = wasStored;
    }

    public String toXmlString() {
        return this.toXmlString(true, false);
    }

    public String toXmlString(boolean omitDeclaration, boolean noNamespace) {
        try {
            StringWriter stringWriter = new StringWriter();
            Authorities.Authority xmlAuth = this.toXml();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Authorities.Authority.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (omitDeclaration) {
                m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            }
            m.marshal((Object)new JAXBElement(new QName("http://jfed.iminds.be/authority", "authority"), Authorities.Authority.class, (Object)xmlAuth), (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException | JAXBException e) {
            LOG.error("Exception marshaling SfaAuthorityBackwardCompatibility to xml", e);
            return null;
        }
    }

    public Authorities.Authority toXml() {
        Authorities.Authority res = new Authorities.Authority();
        res.setUrn(this.urnString);
        if (this.gid != null) {
            res.setGid(this.gid.toString());
        }
        if (this.hrn != null) {
            res.setHrn(this.hrn);
        }
        if (this.location != null) {
            Authorities.Authority.Location resLocation = new Authorities.Authority.Location();
            resLocation.setCountry(this.location.getCountry());
            resLocation.setLatitude(this.location.getLatitude());
            resLocation.setLongitude(this.location.getLongitude());
            res.setLocation(resLocation);
        }
        if (this.pemSslTrustCerts != null) {
            res.getPemSslTrustCert().addAll(this.pemSslTrustCerts);
        }
        if (this.type != null) {
            res.setType(this.type);
        }
        for (SpecialCase specialCase : this.specialCases) {
            res.getSpecial().add(specialCase.getId());
        }
        res.setReconnectEachTime(this.hasSpecialCase(SpecialCase.RECONNECT_EACH_TIME));
        if (this.source != null) {
            String sourceString = null;
            switch (this.source.ordinal()) {
                case 0: {
                    sourceString = "Clearinghouse";
                    break;
                }
                case 1: {
                    sourceString = "Builtin";
                    break;
                }
                case 2: {
                    sourceString = "User";
                }
            }
            res.setSource(sourceString);
        }
        if (this.allowedCertificateHostnameAliases != null && !this.allowedCertificateHostnameAliases.isEmpty()) {
            Authorities.Authority.AllowedCertificateHostnameAliases xmlAllowedCertificateHostnameAliases = new Authorities.Authority.AllowedCertificateHostnameAliases();
            for (String string : this.allowedCertificateHostnameAliases) {
                xmlAllowedCertificateHostnameAliases.getAlias().add(string);
            }
            res.setAllowedCertificateHostnameAliases(xmlAllowedCertificateHostnameAliases);
        }
        Authorities.Authority.Urls xmlUrls = new Authorities.Authority.Urls();
        for (Map.Entry<ServerType, URL> entry : this.urls.entrySet()) {
            Authorities.Authority.Urls.Serverurl xmlServerUrl = new Authorities.Authority.Urls.Serverurl();
            Authorities.Authority.Urls.Serverurl.Servertype xmlServerType = new Authorities.Authority.Urls.Serverurl.Servertype();
            String roleString = entry.getKey().getRole().toString();
            if (Objects.equals((Object)entry.getKey().getRole(), (Object)ServerType.GeniServerRole.PROTOGENI_SA)) {
                roleString = "Slice Authority";
            }
            if (Objects.equals((Object)entry.getKey().getRole(), (Object)ServerType.GeniServerRole.AM)) {
                roleString = "Aggregate Manager";
            }
            if (Objects.equals((Object)entry.getKey().getRole(), (Object)ServerType.GeniServerRole.PlanetLabSliceRegistry)) {
                roleString = "PlanetLab registry";
            }
            xmlServerType.setRole(roleString);
            xmlServerType.setVersion(entry.getKey().getVersion());
            xmlServerUrl.setServertype(xmlServerType);
            xmlServerUrl.setUrl(entry.getValue().toExternalForm());
            xmlUrls.getServerurl().add(xmlServerUrl);
        }
        res.setUrls(xmlUrls);
        Authorities.Authority.Proxies proxies = new Authorities.Authority.Proxies();
        for (ProxyInfo proxyInfo : this.proxies) {
            Authorities.Authority.Proxies.Proxy proxyXml = new Authorities.Authority.Proxies.Proxy();
            proxyXml.setHostKey(proxyInfo.getHostKey());
            proxyXml.setHostname(proxyInfo.getHostname());
            proxyXml.setPortRange(proxyInfo.getPortRangeString());
            proxyXml.setProxyType(proxyInfo.getProxyType());
            proxies.getProxy().add(proxyXml);
        }
        res.setProxies(proxies);
        if (this.defaultScsUrn != null) {
            res.setDefaultScsUrn(this.defaultScsUrn.getValue());
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacySfaAuthority that = (LegacySfaAuthority)o;
        return Objects.equals(this.urnString, that.urnString);
    }

    public int hashCode() {
        return this.urnString.hashCode();
    }

    public String toString() {
        return "SfaAuthorityBackwardCompatibility{urn='" + this.urnString + "'}";
    }

    public boolean isFake() {
        return Objects.equals(FAKE_TYPE, this.type);
    }

    public boolean isReal() {
        return !this.isFake();
    }

    public void setSpecialCase(SpecialCase specialCase, boolean enabled) {
        if (enabled) {
            this.specialCases.add(specialCase);
        } else {
            this.specialCases.remove((Object)specialCase);
        }
    }

    public Collection<SpecialCase> getSpecialCases() {
        return this.specialCases;
    }

    public boolean hasSpecialCase(SpecialCase specialCase) {
        return this.specialCases.contains((Object)specialCase);
    }

    public boolean isAuthoritative(GeniUrn anyUrn) {
        String thisUrnPart = this.getNameForUrn();
        String checkedUrnPart = anyUrn.getEncodedTopLevelAuthority();
        return checkedUrnPart.startsWith(thisUrnPart);
    }

    public static final class Location {
        private final String country;
        private final double latitude;
        private final double longitude;

        public Location(String country, double latitude, double longitude) {
            this.country = country;
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public String getCountry() {
            return this.country;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public String toString() {
            return "Location{country='" + this.country + "', latitude=" + this.latitude + ", longitude=" + this.longitude + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (Double.compare(location.latitude, this.latitude) != 0) {
                return false;
            }
            if (Double.compare(location.longitude, this.longitude) != 0) {
                return false;
            }
            return !(this.country != null ? !Objects.equals(this.country, location.country) : location.country != null);
        }

        public int hashCode() {
            int result = this.country != null ? this.country.hashCode() : 0;
            long temp = Double.doubleToLongBits(this.latitude);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.longitude);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }

    public static enum InfoSource {
        UTAH_CLEARINGHOUSE,
        BUILTIN,
        USER_PROVIDED;

    }

    public static enum SpecialCase {
        HIDE_IN_GUI("hide_in_gui"),
        RECONNECT_EACH_TIME("must_reconnect_each_call"),
        FORCE_DESCRIBE_V2("force_amv2_describe"),
        FORCE_STATUS_V2("force_amv2_status"),
        FORCE_DELETE_V2("force_amv2_delete"),
        FORCE_V2("force_amv2_all"),
        FORCE_V3("force_amv3_all"),
        REMOVE_ABAC_CRED("remove_abac_credential"),
        REMOVE_SFA_CRED("remove_sfa_credential"),
        PREFER_TOPLEVEL("prefer_toplevel_over_subauthority"),
        CENTRAL_BROKER_AUTH("central_broker_architecture_brokerauth"),
        CENTRAL_BROKER_SUBAUTH("central_broker_architecture_subauth"),
        STITCHING_ADVERTISEMENT_RSPEC_UPTODATE("stitching_advertisement_rspec_uptodate"),
        STITCHING_SUPPORTS_ANY("stitching_supports_any"),
        FORCE_RENEW_AFTER_CREATESLIVER("force_renew_after_createsliver"),
        IGNORE_PROVISION_OPERATIONAL_STATUS("ignore_provision_operational_status"),
        SUPPORTS_UPDATE_SSH_KEYS("supports_poa_update_ssh_keys"),
        SUPPORTS_POA_SHARE_LAN("supports_poa_share_lan"),
        SUPPORTS_POA_NODE_RESTART("supports_poa_node_restart"),
        SUPPORTS_POA_NODE_RELOAD_OS("supports_poa_reload_os"),
        SUPPORTS_POA_OPEN_CONSOLE("supports_poa_open_console"),
        SUPPORTS_EXT_USER_DISK_IMAGE_OPS("supports_poa_ext_diskimage_ops"),
        SUPPORTS_RESERVATIONS_NITOS("supports_reservations_nitos"),
        SUPPORTS_RESERVATIONS_GENI("supports_reservations_geni"),
        ADD_EXPIRES_ATTRIBUTE_TO_REQUEST("add_expires_attribute_to_request_rspec"),
        HAS_MATCH_PROJECT_EXPIRED("match_project_expired"),
        HAS_FEATURE_LOOKUP_SLICE_FOR_MEMBER_MATCH_EXPIRED("feature_lookup_slice_for_member_match_expired"),
        HAS_FEATURE_REQUEST_MEMBER_SSH_KEYS("feature_request_member_ssh_keys"),
        HAS_FEATURE_REQUEST_PROJECT_MEMBERS("feature_request_project_members"),
        BUG_WORKAROUND_LOOKUP_SLICE_EXPIRED_MATCH_BOOLEAN("bug_workaround_lookup_slice_expired_match_boolean"),
        EXCLUDE_IN_CONNECTIVITY_TEST("exclude_in_connectivity_test"),
        SUPPORTS_STITCHING("supports_stitching"),
        FEDMON_HAS_NODE_AVAILABILITY_DETAILS("fedmon_has_node_availability_details");

        private final String id;

        private SpecialCase(String id) {
            this.id = id;
        }

        public static SpecialCase fromString(String id) {
            if (id == null) {
                throw new IllegalArgumentException("null is not a valid argument");
            }
            if (id.trim().isEmpty()) {
                throw new IllegalArgumentException("\"" + id + "\" is not a valid argument");
            }
            for (SpecialCase sc : SpecialCase.values()) {
                if (!sc.id.equalsIgnoreCase(id)) continue;
                return sc;
            }
            throw new IllegalArgumentException("\"" + id + "\" is not a known <special>");
        }

        public String getId() {
            return this.id;
        }
    }

    public static class ProxyInfo {
        protected final String proxyType;
        protected final String hostname;
        protected final String portRange;
        protected final String hostKey;

        public ProxyInfo(Authorities.Authority.Proxies.Proxy p) {
            this.proxyType = p.getProxyType();
            this.hostname = p.getHostname();
            this.portRange = p.getPortRange();
            this.hostKey = p.getHostKey();
        }

        public ProxyInfo(ProxyInfo p) {
            this.proxyType = p.getProxyType();
            this.hostname = p.getHostname();
            this.portRange = p.getPortRangeString();
            this.hostKey = p.getHostKey();
        }

        public String getProxyType() {
            return this.proxyType;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getPortRangeString() {
            return this.portRange;
        }

        public VlanRange getPortRange() {
            return new VlanRange(this.portRange);
        }

        public String getHostKey() {
            return this.hostKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyInfo proxyInfo = (ProxyInfo)o;
            if (this.hostKey != null ? !Objects.equals(this.hostKey, proxyInfo.hostKey) : proxyInfo.hostKey != null) {
                return false;
            }
            if (this.hostname != null ? !Objects.equals(this.hostname, proxyInfo.hostname) : proxyInfo.hostname != null) {
                return false;
            }
            if (this.portRange != null ? !Objects.equals(this.portRange, proxyInfo.portRange) : proxyInfo.portRange != null) {
                return false;
            }
            return !(this.proxyType != null ? !Objects.equals(this.proxyType, proxyInfo.proxyType) : proxyInfo.proxyType != null);
        }

        public int hashCode() {
            int result = this.proxyType != null ? this.proxyType.hashCode() : 0;
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
            result = 31 * result + (this.hostKey != null ? this.hostKey.hashCode() : 0);
            return result;
        }
    }
}

