/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.testbed_info;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestbedInfoSource {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedInfoSource.class);

    public abstract Service getServiceByUrl(String var1);

    public abstract Service getServiceByUrl(URL var1);

    public abstract List<Server> getServers();

    public abstract List<Testbed> getTestbeds();

    public abstract int getServiceCount();

    @Nullable
    public abstract Collection<Federation> getFederations();

    @Nullable
    public abstract Collection<Organisation> getOrganisation();

    @Nullable
    public abstract Collection<TestbedCategory> getTestbedCategories();

    @Nullable
    public abstract Federation getFederation(@Nonnull String var1);

    @Nullable
    public abstract Organisation getOrganisation(@Nonnull String var1);

    @Nullable
    public abstract TestbedCategory getTestbedCategory(@Nonnull String var1);

    @Nullable
    public abstract TestbedCategory getTestbedCategory(@Nonnull Integer var1);

    @Nonnull
    public Federation getFederation(@Nonnull Federation o) {
        if (o.getId() == null) {
            return o;
        }
        Federation res = this.getFederation((String)o.getId());
        return res == null ? o : res;
    }

    @Nonnull
    public Organisation getOrganisation(@Nonnull Organisation o) {
        if (o.getId() == null) {
            return o;
        }
        Organisation res = this.getOrganisation((String)o.getId());
        return res == null ? o : res;
    }

    @Nonnull
    public TestbedCategory getTestbedCategory(@Nonnull TestbedCategory o) {
        if (o.getId() == null) {
            return o;
        }
        TestbedCategory res = this.getTestbedCategory((Integer)o.getId());
        return res == null ? o : res;
    }

    public abstract Service getServiceById(Integer var1);

    public abstract Server getServerById(Integer var1);

    public abstract Testbed getTestbedById(String var1);

    public abstract Service getServiceByUrn(GeniUrn var1, SubAuthMatchAllowed var2, SubAuthMatchPreference var3, boolean var4, String var5, String var6);

    public abstract Testbed getTestbedByUrn(GeniUrn var1, SubAuthMatchAllowed var2, SubAuthMatchPreference var3, boolean var4);

    public abstract Server getByUrn(GeniUrn var1, SubAuthMatchAllowed var2, SubAuthMatchPreference var3, boolean var4);

    public Server getServerByUrn(GeniUrn urn, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred, boolean ignoreUrnTypeAndName) {
        return this.getByUrn(urn, matchAllowed, matchPreferred, ignoreUrnTypeAndName);
    }

    public boolean matchUrn(String candidate, GeniUrn requested, SubAuthMatchAllowed matchAllowed, boolean ignoreUrnTypeAndName) throws GeniUrn.GeniUrnParseException {
        return this.matchUrn(new GeniUrn(candidate), requested, matchAllowed, ignoreUrnTypeAndName);
    }

    public boolean matchUrn(@Nonnull GeniUrn candidate, @Nonnull GeniUrn requested, @Nonnull SubAuthMatchAllowed matchAllowed, boolean ignoreUrnTypeAndName) {
        String requestedTldTop;
        String candidateTldTop;
        if (!ignoreUrnTypeAndName) {
            if (!Objects.equals(candidate.getType(), requested.getType())) {
                return false;
            }
            if (!Objects.equals(candidate.getResourceName(), requested.getResourceName())) {
                return false;
            }
        }
        if (!Objects.equals(candidateTldTop = candidate.getEncodedTopLevelAuthority_withoutSubAuth(), requestedTldTop = requested.getEncodedTopLevelAuthority_withoutSubAuth())) {
            return false;
        }
        switch (matchAllowed.ordinal()) {
            case 0: {
                return Objects.equals(candidate.getEncodedTopLevelAuthority(), requested.getEncodedTopLevelAuthority());
            }
            case 1: {
                int reqcount = requested.getSubAuthCount();
                int cancount = candidate.getSubAuthCount();
                if (reqcount < cancount) {
                    return false;
                }
                for (int i = 0; i < cancount; ++i) {
                    if (Objects.equals(requested.getSubAuthName(i), candidate.getSubAuthName(i))) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                return true;
            }
        }
        throw new RuntimeException("case " + String.valueOf((Object)matchAllowed) + " not supported");
    }

    public Server getServerByUrl(String urlString) {
        Service service = this.getServiceByUrl(urlString);
        if (service == null) {
            return null;
        }
        assert (service.getServer() != null);
        return service.getServer();
    }

    public Server getServerByUrl(URL url) {
        Service service = this.getServiceByUrl(url);
        if (service == null) {
            return null;
        }
        assert (service.getServer() != null);
        return service.getServer();
    }

    public Server getByUrn(String urnString, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred, boolean ignoreUrnTypeAndName) {
        GeniUrn u = GeniUrn.parse((String)urnString);
        if (u == null) {
            LOG.warn("Tried to lookup Server using the invalid URN \"" + urnString + "\" -> solving problem by returning null");
            return null;
        }
        return this.getByUrn(u, matchAllowed, matchPreferred, ignoreUrnTypeAndName);
    }

    public Server getByUrn(String urnString, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urnString, matchAllowed, matchPreferred, false);
    }

    public Server getByUrn(GeniUrn urn, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urn, matchAllowed, matchPreferred, false);
    }

    public Server getByUrnExact(String urnString) {
        return this.getByUrn(urnString, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, false);
    }

    public Server getByUrnExact(GeniUrn urn) {
        return this.getByUrn(urn, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, false);
    }

    public Server getFromAnyUrn(String urnString, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urnString, matchAllowed, matchPreferred, true);
    }

    public Server getFromAnyUrn(GeniUrn urn, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urn, matchAllowed, matchPreferred, true);
    }

    public Server getFromAnyUrnExact(String urnString) {
        return this.getByUrn(urnString, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, true);
    }

    public Server getFromAnyUrnExact(GeniUrn urn) {
        return this.getByUrn(urn, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, true);
    }

    public static boolean isAuthoritative(Server server, GeniUrn testedUrn) {
        String serverUrnTld = server.getUrnTld();
        String checkedUrnPart = testedUrn.getEncodedTopLevelAuthority();
        return checkedUrnPart.startsWith(serverUrnTld);
    }

    public static enum SubAuthMatchAllowed {
        ALLOW_ONLY_EXACT_SUBAUTHORITY,
        ALLOW_TOPLEVEL,
        ALLOW_OTHER_SUBAUTHORITY;

    }

    public static enum SubAuthMatchPreference {
        PREFER_EXACT_SUBAUTHORITY,
        PREFER_TOPLEVEL;

    }
}

