/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertFileUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertUrlUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.ManualUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UserLoginInfoFactory {
    private final GeniUserFactory geniUserFactory;
    private final AuthorityFinder authorityFinder;

    @Inject
    UserLoginInfoFactory(GeniUserFactory geniUserFactory, AuthorityFinder authorityFinder) {
        this.geniUserFactory = geniUserFactory;
        this.authorityFinder = authorityFinder;
    }

    public KeyCertFileUserLoginInfo createKeyCertFileUserLoginInfo(File keyCertFile) throws IOException {
        return new KeyCertFileUserLoginInfo(keyCertFile, this.geniUserFactory, this.authorityFinder);
    }

    public KeyCertFileUserLoginInfo createKeyCertFileUserLoginInfo(File keyCertFile, GeniUrn userUrn, Server selectedServer) throws IOException {
        return new KeyCertFileUserLoginInfo(keyCertFile, userUrn, selectedServer, this.geniUserFactory);
    }

    public KeyCertUrlUserLoginInfo createKeyCertUrlUserLoginInfo(URL keyCertUrl) throws IOException {
        return new KeyCertUrlUserLoginInfo(keyCertUrl, this.geniUserFactory, this.authorityFinder);
    }

    public KeyCertUrlUserLoginInfo createKeyCertUrlUserLoginInfo(URL keyCertUrl, GeniUrn userUrn, Server selectedServer) throws IOException {
        return new KeyCertUrlUserLoginInfo(keyCertUrl, userUrn, selectedServer, this.geniUserFactory);
    }

    public ManualUserLoginInfo createManualUserLoginInfo(@Nullable String keyCertContent) {
        return new ManualUserLoginInfo(keyCertContent, this.geniUserFactory, this.authorityFinder);
    }

    public ManualUserLoginInfo createManualUserLoginInfo(@Nullable String keyCertContent, @Nullable GeniUrn userUrn, Server userAuthority) {
        return new ManualUserLoginInfo(keyCertContent, userUrn, userAuthority, this.geniUserFactory);
    }

    public ManualUserLoginInfo createManualUserLoginInfo(UserLoginInfo userLoginInfo) {
        if (userLoginInfo.isUserAndAuthorityProvidedSeperately()) {
            return new ManualUserLoginInfo(userLoginInfo, this.geniUserFactory);
        }
        return new ManualUserLoginInfo(userLoginInfo, this.geniUserFactory, this.authorityFinder);
    }
}

