/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool.unix;

import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshFilesKeyInfo;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAgentHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SshAgentHelper.class);
    private static String cachedSshAgentEnvironment = null;

    public static void registerKey(@Nonnull SshFilesKeyInfo sshKeyInfo) throws SshAgentHelperException {
        if (SshAgentHelper.isKeyRegistered(sshKeyInfo)) {
            return;
        }
        if (sshKeyInfo.hasUnencryptedPrivateKey()) {
            TmpFile unencryptedPrivateKeyFile = sshKeyInfo.getUnencryptedPrivateKeyFile();
            unencryptedPrivateKeyFile.store();
            SshAgentHelper.myCommandHelperWithinEnvironment(false, "ssh-add", unencryptedPrivateKeyFile.getFilename());
            unencryptedPrivateKeyFile.delete();
        } else if (sshKeyInfo.canReturnLockedPrivateKeyFile()) {
            TmpFile encryptedPrivateKeyFile = sshKeyInfo.getPrivateKeyFile();
            encryptedPrivateKeyFile.store();
            SshAgentHelper.myCommandHelperWithinEnvironment(false, "ssh-add", encryptedPrivateKeyFile.getFilename());
            encryptedPrivateKeyFile.delete();
        } else {
            throw new SshAgentHelperException("Key did not register successfully, because no access to private key file, not even to locked version");
        }
        if (!SshAgentHelper.isKeyRegistered(sshKeyInfo)) {
            throw new SshAgentHelperException("Key did not register successfully");
        }
    }

    public static boolean isKeyRegistered(@Nonnull SshKeyInfo sshKeyInfo) throws SshAgentHelperException {
        String openSshFormatPubKey = KeyUtil.rsaPublicKeyToOpenSshAuthorizedKeysFormatData((RSAPublicKey)((RSAPublicKey)sshKeyInfo.getPublicKey()));
        LOG.debug("Searching for pubkey \"" + openSshFormatPubKey + "\"");
        String pubKeys = SshAgentHelper.myCommandHelperWithinEnvironment(true, "ssh-add", "-L");
        if (pubKeys != null) {
            for (String pubKey : pubKeys.split("\n")) {
                LOG.debug("     Checking pubkey \"" + pubKey.trim() + "\"");
                if (!pubKey.trim().contains(openSshFormatPubKey)) continue;
                return true;
            }
        }
        LOG.debug("Did not find matching pubkey in: " + pubKeys);
        return false;
    }

    @Nonnull
    public static String getSshAgentEnvironment() throws SshAgentHelperException {
        if (cachedSshAgentEnvironment != null) {
            return cachedSshAgentEnvironment;
        }
        cachedSshAgentEnvironment = SshAgentHelper.myCommandHelper(false, "ssh-agent", "-s");
        if (cachedSshAgentEnvironment == null) {
            throw new SshAgentHelperException("Assumption failed calling ssh-agent -s");
        }
        LOG.debug("cachedSshAgentEnvironment: " + cachedSshAgentEnvironment);
        cachedSshAgentEnvironment = cachedSshAgentEnvironment.replaceFirst("echo Agent pid [0-9]*;", "");
        LOG.debug("cachedSshAgentEnvironment without echo: " + cachedSshAgentEnvironment);
        return cachedSshAgentEnvironment;
    }

    public static void stopSshAgent() throws SshAgentHelperException {
        if (cachedSshAgentEnvironment != null) {
            SshAgentHelper.myCommandHelperWithinEnvironment(true, "ssh-agent", "-k");
            cachedSshAgentEnvironment = null;
        }
    }

    @Nullable
    @Contract(value="false, _ -> !null")
    private static String myCommandHelperWithinEnvironment(boolean mayFail, String ... command) throws SshAgentHelperException {
        File tmpDir = new File(JFedUtils.getUserDataDirectoryFile(), "tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        long nr = new Date().getTime();
        File tmpScript = new File(tmpDir, "ssh-agent-helper=" + nr + ".sh");
        String script = "#!/bin/bash\n\n" + SshAgentHelper.getSshAgentEnvironment() + "\n";
        boolean first = true;
        for (String c : command) {
            script = first ? script + c : script + " '" + c + "'";
            first = false;
        }
        LOG.debug("Script: " + script);
        IOUtils.stringToFile((File)tmpScript, (String)script);
        tmpScript.deleteOnExit();
        String res = SshAgentHelper.myCommandHelper(mayFail, "bash", tmpScript.getPath());
        LOG.debug("Script output: " + res);
        tmpScript.delete();
        return res;
    }

    @Nullable
    @Contract(value="false, _ -> !null")
    private static String myCommandHelper(boolean mayFail, String ... command) throws SshAgentHelperException {
        Process p;
        StringBuilder res = new StringBuilder();
        LOG.debug("Starting command: " + String.valueOf(Arrays.asList(command)));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectErrorStream(true);
        try {
            p = pb.start();
            p.getOutputStream().close();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                res.append(line);
            }
            input.close();
        }
        catch (IOException e) {
            LOG.error("Error executing command: " + e.getMessage(), (Throwable)e);
            throw new SshAgentHelperException("Exception executing command: " + String.valueOf(Arrays.asList(command)), e);
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            LOG.warn("SshAgentHelper.myCommandHelper thread interrupted while waiting for terminal to stop", (Throwable)e);
        }
        if (p.exitValue() != 0) {
            if (mayFail) {
                LOG.info("SshAgentHelper command \"" + command[0] + "\" returned non zero exit value: " + p.exitValue() + " output: " + res.toString());
                return null;
            }
            throw new SshAgentHelperException("SshAgentHelper command " + String.valueOf(Arrays.asList(command)) + " returned non zero exit value: " + p.exitValue() + " output: " + res.toString());
        }
        return res.toString();
    }

    public static class SshAgentHelperException
    extends Exception {
        public SshAgentHelperException() {
        }

        public SshAgentHelperException(String s) {
            super(s);
        }

        public SshAgentHelperException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public SshAgentHelperException(Throwable throwable) {
            super(throwable);
        }

        public SshAgentHelperException(String s, Throwable throwable, boolean b, boolean b1) {
            super(s, throwable, b, b1);
        }
    }
}

