/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.lib;

import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnectivityDetector {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectivityDetector.class);
    private boolean noInternet = false;
    private Boolean forceNoInternet = null;

    @Inject
    public ConnectivityDetector(ApplicationParametersModule.ApplicationParameters applicationParameters) {
        if (applicationParameters != null) {
            String paramKey;
            Map<String, String> params = applicationParameters.getParameters();
            if (params.containsKey(paramKey = "no-internet")) {
                this.setNoInternet(true);
                LOG.debug("Parameter " + paramKey + " set: will avoid using internet.");
            } else {
                LOG.debug("Parameter " + paramKey + " not set: will assume there is internet connectivity.");
            }
            LOG.debug("Parameters set: " + String.valueOf(params));
        } else {
            LOG.debug("ConnectivityDetector received no ApplicationParameters");
        }
    }

    public boolean isNoInternet() {
        boolean res = this.forceNoInternet != null ? this.forceNoInternet : this.noInternet;
        LOG.debug("isNoInternet() = " + res);
        return res;
    }

    public void setNoInternet(boolean noInternet) {
        this.noInternet = noInternet;
    }

    public void forceNoInternet(boolean forceNoInternet) {
        this.forceNoInternet = forceNoInternet;
        LOG.debug("forceNoInternet = " + forceNoInternet);
    }
}

