/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.lib;

import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.ExtraInfoCallback;
import be.iminds.ilabt.jfed.util.library.FileEncrypter;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JFedPasswordManager {
    private static final Logger LOG = LoggerFactory.getLogger(JFedPasswordManager.class);
    private final List<LoginInfo> logins = new ArrayList<LoginInfo>();
    private static final File defaultLoginDir = new File(JFedUtils.getUserDataDirectoryFile(), "logins");
    private final File loginDir;

    public JFedPasswordManager() {
        this(defaultLoginDir);
    }

    JFedPasswordManager(File loginDir) {
        LOG.debug("Created JFedPasswordManager");
        this.loginDir = loginDir;
    }

    private String createUserId(@Nonnull GeniUser user) {
        Date expireDate = null;
        if (!user.getClientCertificateChain().isEmpty() && user.getClientCertificateChain().get(0) != null) {
            expireDate = user.getClientCertificateChain().get(0).getNotAfter();
        }
        return user.getUserUrn().getEncodedTopLevelAuthority().replaceAll("[^A-Za-z0-9_-]", "X") + "+" + user.getUserUrn().getEncodedResourceName().replaceAll("[^A-Za-z0-9_-]", "X") + "+" + (expireDate == null ? null : Long.valueOf(expireDate.getTime()));
    }

    public File getEncryptedSaveFile(JFedPreferences prefs, GeniUser user) {
        return new File(this.loginDir, "logins-" + this.createUserId(user) + ".encrypted");
    }

    public void save(JFedPreferences prefs, GeniUser user) throws IOException {
        assert (user != null);
        if (!this.loginDir.exists()) {
            this.loginDir.mkdir();
        }
        if (!this.loginDir.exists() || !this.loginDir.isDirectory()) {
            throw new IOException("Could not save login info: dir \"" + this.loginDir.getAbsolutePath() + "\" does not exist and could not be created.");
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(this.logins);
        out.close();
        byteOut.close();
        byte[] encryptedContent = FileEncrypter.encryptData((byte[])byteOut.toByteArray(), (PublicKey)user.getPublicKey());
        File loginsFile = this.getEncryptedSaveFile(prefs, user);
        IOUtils.byteArrayToFile((File)loginsFile, (byte[])encryptedContent);
    }

    public void load(JFedPreferences prefs, GeniUser user) {
        LOG.debug("Loading jFed password for user " + user.getUserUrnString());
        File loginsFile = this.getEncryptedSaveFile(prefs, user);
        this.logins.clear();
        if (!(loginsFile.exists() && loginsFile.canRead() && loginsFile.isFile())) {
            LOG.warn("logins file does not exist: {}", (Object)loginsFile.getAbsolutePath());
            return;
        }
        try {
            byte[] encryptedContent = IOUtils.fileToByteArray((File)loginsFile);
            byte[] decryptedContent = FileEncrypter.decryptData((byte[])encryptedContent, (PrivateKey)user.getPrivateKey());
            if (decryptedContent == null) {
                LOG.warn("Failed to decrypt {}", (Object)loginsFile);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(decryptedContent);
            ObjectInputStream in = new ObjectInputStream(bais);
            Object inputObj = in.readObject();
            if (!(inputObj instanceof List)) {
                LOG.warn("Expected a list of LoginInfo objects, but got a {} instead", (Object)inputObj.getClass().getName());
                return;
            }
            List newLogins = (List)inputObj;
            for (Object newLogin : newLogins) {
                if (newLogin instanceof LoginInfo) {
                    this.logins.add((LoginInfo)newLogin);
                    continue;
                }
                LOG.warn("Unexpected entry in list: got a {} instead of LoginInfo", (Object)newLogin.getClass().getName());
            }
            LOG.debug("  user has " + this.logins.size() + " passwords stored");
        }
        catch (IOException e) {
            LOG.error("Error loading loginFile: " + loginsFile.getAbsolutePath() + " -> file will be ignored.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Error deserializing loginFile: " + loginsFile.getAbsolutePath() + " -> file will be ignored.", (Throwable)e);
        }
    }

    public List<LoginInfo> getLoginsAndRequestIfNone(String service, String serviceFriendlyName, JFedPreferences prefs, GeniUser user) {
        List<LoginInfo> res = this.getLogins(service);
        if (res.isEmpty()) {
            LOG.debug("Requesting login for service \"" + service + "\" to user.");
            LoginInfo login = ExtraInfoCallback.getAnyLogin((String)service, (String)serviceFriendlyName);
            if (login != null) {
                LOG.debug("  user provided login for user " + login.getUsername());
                res.add(login);
                this.logins.add(login);
                try {
                    this.save(prefs, user);
                }
                catch (IOException e) {
                    LOG.error("Failed to save new login", (Throwable)e);
                }
            } else {
                LOG.debug("  user did not provide a login");
            }
        }
        return res;
    }

    public List<LoginInfo> getLogins(String service) {
        LOG.debug("Checking login info for service \"" + service + "\"");
        List<LoginInfo> res = this.logins.stream().filter(l -> Objects.equals(l.getService(), service)).collect(Collectors.toList());
        LOG.debug("Found " + res.size() + " logins matching service \"" + service + "\" out of " + this.logins.size() + " total logins");
        return res;
    }

    public List<LoginInfo> getLogins() {
        return Collections.unmodifiableList(this.logins);
    }

    public void removeLogin(LoginInfo itRemove) {
        ListIterator<LoginInfo> it = this.logins.listIterator();
        while (it.hasNext()) {
            LoginInfo cur = (LoginInfo)it.next();
            if (!Objects.equals(cur, itRemove)) continue;
            it.remove();
        }
    }

    public void removeLogin(String service, String username) {
        ListIterator<LoginInfo> it = this.logins.listIterator();
        while (it.hasNext()) {
            LoginInfo cur = (LoginInfo)it.next();
            if (!Objects.equals(cur.getService(), service) || !Objects.equals(cur.getUsername(), username)) continue;
            it.remove();
        }
    }

    public void clear() {
        this.logins.clear();
    }

    public void addLogin(LoginInfo loginInfo) {
        ListIterator<LoginInfo> it = this.logins.listIterator();
        while (it.hasNext()) {
            LoginInfo cur = (LoginInfo)it.next();
            if (!Objects.equals(cur.getService(), loginInfo.getService()) || !Objects.equals(cur.getUsername(), loginInfo.getUsername())) continue;
            LOG.debug("Removed existing loginInfo for " + cur.getService() + " " + cur.getUsername());
            it.remove();
        }
        this.logins.add(loginInfo);
    }
}

