/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.FlavorList;
import be.iminds.ilabt.jfed.rspec.model.GeantTestbedType;
import be.iminds.ilabt.jfed.rspec.model.HardwareTypeInfo;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.OpenflowSliver;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicDistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicOpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecWriter;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXGeantTestbedType;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.CollectionsUtil;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXModelRspec
implements ModelRspec {
    private static final Logger LOG = LoggerFactory.getLogger(FXModelRspec.class);
    final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();
    private final Map<String, String> origNameSpaceInfo = new HashMap<String, String>();
    private final ObservableList<FXRspecNode> nodes = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<FXRspecLink> links = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<BasicOpenflowDataPath> openflowDataPaths = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<OpenflowSliver> openflowSlivers = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<Lease> leases = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<FXRspecChannel> channels = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<FXGeantTestbedType> geantTestbedTypes = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<FXAddressPool> addressPools = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<BasicExecuteAnsiblePlaybook> ansibleCookbooks = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<BasicDistributeSshKeypair> distributeSshKeypairs = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<DiskImageList> diskImageLists = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<FlavorList> flavorLists = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final StringProperty expiresDate = new SimpleStringProperty();
    private final ObjectProperty<HardwareTypeInfo> hardwareTypeInfo = new SimpleObjectProperty();
    private final BooleanProperty routableAddressesAvailableUsed = new SimpleBooleanProperty(false);
    private final BooleanProperty routableAddressesConfiguredUsed = new SimpleBooleanProperty(false);
    private final IntegerProperty routableAddressesAvailable = new SimpleIntegerProperty();
    private final IntegerProperty routableAddressesConfigured = new SimpleIntegerProperty();
    private final ObjectProperty<Integer> multiplexFactor = new SimpleObjectProperty();
    private String origDefaultNamespace = null;
    private String origSchemaLocation = null;
    private final String rspecType;
    private final ObservableList<UserSpec> sshKeys = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final RspecFactory factory;

    public FXModelRspec(String rspecType) {
        this.rspecType = rspecType;
        this.factory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)this.getModelRspecType());
    }

    @Nonnull
    public ModelRspecType getModelRspecType() {
        return ModelRspecType.FX;
    }

    public void setParseData(@Nullable String schemaLocation, @Nullable String defaultNamespace, @Nonnull Map<String, String> namespaces) {
        this.origSchemaLocation = schemaLocation;
        this.origDefaultNamespace = defaultNamespace;
        this.origNameSpaceInfo.putAll(namespaces);
    }

    public String getSchemaLocation() {
        return this.origSchemaLocation;
    }

    public String getOrigDefaultNamespace() {
        return this.origDefaultNamespace;
    }

    @Nonnull
    public Map<String, String> getNameSpaceInfo() {
        return this.origNameSpaceInfo;
    }

    public void addNode(@Nonnull RspecNode node) {
        Objects.requireNonNull(node, "may not add null node");
        if (!(node instanceof FXRspecNode)) {
            throw new IllegalArgumentException("may only add FXRspecNode, not " + node.getClass().getName());
        }
        this.nodes.add((Object)((FXRspecNode)node));
    }

    public void addLink(@Nonnull RspecLink link) {
        Objects.requireNonNull(link, "may not add null link");
        if (!(link instanceof FXRspecLink)) {
            throw new IllegalArgumentException("may only add FXRspecLink, not " + link.getClass().getName());
        }
        this.links.add((Object)((FXRspecLink)link));
    }

    @Nonnull
    public ObservableList<FXRspecNode> getNodes() {
        return this.nodes;
    }

    @Nonnull
    public ObservableList<FXRspecLink> getLinks() {
        return this.links;
    }

    public void addOpenflowDataPath(@Nonnull OpenflowDataPath dp) {
        assert (dp instanceof BasicOpenflowDataPath);
        this.openflowDataPaths.add((Object)((BasicOpenflowDataPath)dp));
    }

    @Nonnull
    public List<BasicOpenflowDataPath> getOpenflowDataPaths() {
        return this.openflowDataPaths;
    }

    public void addOpenflowSliver(@Nonnull OpenflowSliver sliver) {
        this.openflowSlivers.add((Object)sliver);
    }

    @Nonnull
    public List<OpenflowSliver> getOpenflowSlivers() {
        return this.openflowSlivers;
    }

    public void addLease(@Nonnull Lease lease) {
        this.leases.add((Object)lease);
    }

    @Nonnull
    public List<Lease> getLeases() {
        return this.leases;
    }

    public void addChannel(@Nonnull Channel channel) {
        assert (channel instanceof FXRspecChannel);
        this.channels.add((Object)((FXRspecChannel)channel));
    }

    public boolean deleteChannel(@Nonnull Channel channel) {
        assert (channel instanceof FXRspecChannel);
        return this.channels.remove((Object)channel);
    }

    @Nonnull
    public ObservableList<FXRspecChannel> getChannels() {
        return this.channels;
    }

    public void addAddressPool(@Nonnull AddressPool addressPool) {
        if (addressPool instanceof FXAddressPool) {
            this.addressPools.add((Object)((FXAddressPool)addressPool));
        } else {
            this.addressPools.add((Object)new FXAddressPool(addressPool));
        }
    }

    public boolean deleteAddressPool(@Nonnull AddressPool addressPool) {
        return this.addressPools.remove((Object)addressPool);
    }

    @Nonnull
    public ObservableList<FXAddressPool> getAddressPools() {
        return this.addressPools;
    }

    @Nullable
    public FXAddressPool getAddressPoolByClientId(@Nonnull String clientId) {
        return this.addressPools.stream().filter(addressPool -> Objects.equals(clientId, addressPool.getClientId())).findFirst().orElse(null);
    }

    public void addExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook executeAnsiblePlaybook) {
        if (executeAnsiblePlaybook instanceof BasicExecuteAnsiblePlaybook) {
            this.ansibleCookbooks.add((Object)((BasicExecuteAnsiblePlaybook)executeAnsiblePlaybook));
        } else {
            this.ansibleCookbooks.add((Object)new BasicExecuteAnsiblePlaybook(executeAnsiblePlaybook));
        }
    }

    public boolean deleteExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook executeAnsiblePlaybook) {
        return this.ansibleCookbooks.remove((Object)executeAnsiblePlaybook);
    }

    @Nonnull
    public List<? extends BasicExecuteAnsiblePlaybook> getExecuteAnsiblePlaybooks() {
        return this.ansibleCookbooks;
    }

    public void addDistributeSshKeypair(@Nonnull DistributeSshKeypair distributeSshKeypair) {
        if (distributeSshKeypair instanceof BasicDistributeSshKeypair) {
            this.distributeSshKeypairs.add((Object)((BasicDistributeSshKeypair)distributeSshKeypair));
        } else {
            this.distributeSshKeypairs.add((Object)new BasicDistributeSshKeypair(distributeSshKeypair));
        }
    }

    public boolean deleteDistributeSshKeypair(@Nonnull DistributeSshKeypair distributeSshKeypair) {
        return this.distributeSshKeypairs.remove((Object)distributeSshKeypair);
    }

    @Nonnull
    public List<DiskImageList> getDiskImageLists() {
        return this.diskImageLists;
    }

    @Nonnull
    public List<FlavorList> getFlavorLists() {
        return this.flavorLists;
    }

    public void addDiskImageList(@Nonnull DiskImageList list) {
        this.diskImageLists.add((Object)list);
    }

    public void addFlavorList(@Nonnull FlavorList list) {
        this.flavorLists.add((Object)list);
    }

    @Nonnull
    public List<? extends DistributeSshKeypair> getDistributeSshKeypairs() {
        return this.distributeSshKeypairs;
    }

    @Nonnull
    public ObjectProperty<HardwareTypeInfo> hardwareTypeInfoProperty() {
        return this.hardwareTypeInfo;
    }

    @Nullable
    public HardwareTypeInfo getHardwareTypeInfo() {
        return (HardwareTypeInfo)this.hardwareTypeInfo.get();
    }

    public void setHardwareTypeInfo(@Nullable HardwareTypeInfo hardwareTypeInfo) {
        this.hardwareTypeInfo.setValue((Object)hardwareTypeInfo);
    }

    @Nullable
    public FXRspecNode getNodeByUniqueId(@Nonnull String id) {
        for (FXRspecNode node : this.nodes) {
            if (!Objects.equals(node.getUniqueId(), id)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public FXRspecNode getNodeByClientId(@Nonnull String id) {
        for (FXRspecNode node : this.nodes) {
            if (!Objects.equals(id, node.getClientId())) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public FXRspecNode getNodeByComponentId(@Nonnull String id) {
        for (FXRspecNode node : this.nodes) {
            if (node.getComponentId() == null || !Objects.equals(node.getComponentId().toString(), id)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public FXRspecChannel getChannelByComponentId(@Nonnull GeniUrn urn) {
        return this.channels.stream().filter(channel -> Objects.equals(channel.getComponentId(), urn)).findAny().orElse(null);
    }

    @Nonnull
    public List<FXRspecNode> getNodesByAuthority(@Nonnull Server authority) {
        assert (authority != null);
        ArrayList<FXRspecNode> nodesOfAuthority = new ArrayList<FXRspecNode>();
        for (FXRspecNode node : this.nodes) {
            assert (node != null);
            if (!authority.getDefaultComponentManagerAsGeniUrn().equalsIgnoringSubAuth((Object)node.getComponentManagerId())) continue;
            nodesOfAuthority.add(node);
        }
        return nodesOfAuthority;
    }

    @Nullable
    public FXRspecLink getLinkByClientId(@Nonnull String id) {
        for (FXRspecLink link : this.links) {
            if (!Objects.equals(link.getClientId(), id)) continue;
            return link;
        }
        return null;
    }

    @Nullable
    public FXRspecLink getLinkByUniqueId(@Nonnull String id) {
        for (FXRspecLink link : this.links) {
            if (!Objects.equals(link.getUniqueId(), id)) continue;
            return link;
        }
        return null;
    }

    public void deleteNode(@Nonnull RspecNode node) {
        assert (node instanceof FXRspecNode);
        ArrayList<RspecLink> linksToDelete = new ArrayList<RspecLink>();
        ArrayList<RspecInterface> ifacesToDelete = new ArrayList<RspecInterface>();
        for (RspecInterface iface : node.getInterfaces()) {
            RspecLink link;
            if (iface.isLinkBound() && (link = iface.getLink()) != null && link.getInterfaces().size() <= 2) {
                linksToDelete.add(link);
            }
            ifacesToDelete.add(iface);
        }
        ifacesToDelete.forEach(RspecInterface::delete);
        this.nodes.remove((Object)node);
        linksToDelete.forEach(this::deleteLink);
    }

    public void deleteLink(@Nonnull RspecLink link) {
        assert (link instanceof FXRspecLink);
        ArrayList ifacesToDelete = new ArrayList(link.getInterfaces());
        ifacesToDelete.forEach(RspecInterface::delete);
        this.links.remove((Object)link);
    }

    @Nonnull
    public String toGeni3Rspec(@Nonnull ModelRspec.RequestRspecSpecialCases specialCase) {
        StaxRspecWriter staxRspecWriter = new StaxRspecWriter((ModelRspec)this);
        switch (specialCase) {
            case NONE: {
                break;
            }
            case PLE: {
                ArrayList<String> allowedComponentManagers = new ArrayList<String>();
                allowedComponentManagers.add("urn:publicid:IDN+ple:ibbtple+authority+cm");
                staxRspecWriter.setComponentManagerFilter(allowedComponentManagers);
                staxRspecWriter.setAddSchemaLocation(false);
                staxRspecWriter.setAddEmptySliverToNodeHack(true);
                break;
            }
            case NITOS_NO_E_NODE_B_HACK: {
                staxRspecWriter.setUseNitosENodeBHack(false);
                break;
            }
            default: {
                throw new RuntimeException("Special case " + String.valueOf(specialCase) + " not supported");
            }
        }
        try {
            return staxRspecWriter.call();
        }
        catch (RspecParseException e) {
            LOG.error("Error converting to Rspec: ", (Throwable)e);
            throw new RuntimeException("Error converting to Rspec: " + String.valueOf((Object)e), e);
        }
    }

    @Nonnull
    public String toGeni3Rspec() {
        return this.toGeni3Rspec(ModelRspec.RequestRspecSpecialCases.NONE);
    }

    @Nullable
    public Date getExpires() throws ParseException {
        if (this.expiresDate.get() == null) {
            return null;
        }
        return RFC3339Util.iso8601StringToDate((String)((String)this.expiresDate.get()));
    }

    public void setExpires(@Nullable Date expires) {
        if (expires == null) {
            this.expiresDate.setValue(null);
        } else {
            this.expiresDate.setValue(RFC3339Util.dateToRFC3339String((Date)expires, (boolean)true));
        }
    }

    @Nullable
    public String getExpiresString() {
        return (String)this.expiresDate.get();
    }

    public void setExpires(@Nullable String expires) {
        this.expiresDate.setValue(expires);
    }

    @Nullable
    public Integer getRoutableAddressesAvailable() {
        return this.routableAddressesAvailableUsed.getValue() != false ? this.routableAddressesAvailable.getValue() : null;
    }

    @Nullable
    public Integer getRoutableAddressesConfigured() {
        return this.routableAddressesConfiguredUsed.getValue() != false ? this.routableAddressesConfigured.getValue() : null;
    }

    public void setRoutableAddressesAvailable(@Nullable Integer i) {
        if (i == null) {
            this.routableAddressesAvailableUsed.set(false);
        } else {
            this.routableAddressesAvailableUsed.set(true);
            this.routableAddressesAvailable.set(i.intValue());
        }
    }

    public void setRoutableAddressesConfigured(@Nullable Integer i) {
        if (i == null) {
            this.routableAddressesConfiguredUsed.set(false);
        } else {
            this.routableAddressesConfiguredUsed.set(true);
            this.routableAddressesConfigured.set(i.intValue());
        }
    }

    @Nonnull
    public List<GeniUrn> getAllComponentManagerUrns() {
        HashSet urns = new HashSet();
        this.nodes.stream().map(RspecNode::getComponentManagerId).filter(Objects::nonNull).forEach(urns::add);
        this.links.stream().flatMap(link -> link.getComponentManagerUrns().stream()).forEach(urns::add);
        this.channels.stream().map(Channel::getComponentManagerId).forEach(urns::add);
        this.addressPools.stream().map(AddressPool::getComponentManagerId).forEach(urns::add);
        this.geantTestbedTypes.stream().map(GeantTestbedType::getComponentManagerId).forEach(urns::add);
        if (urns.contains(null)) {
            LOG.warn("Detected a null component_manager_id. This rspec is not valid! Doing a workaround now...");
            urns.remove(null);
        }
        return new ArrayList<GeniUrn>(urns);
    }

    @Nonnull
    public ObservableList<UserSpec> getSshKeys() {
        return this.sshKeys;
    }

    public void setSshKeys(@Nonnull List<UserSpec> newKeys) {
        this.sshKeys.setAll(newKeys);
    }

    @Nonnull
    public String nextLinkName() {
        int c = this.links.size();
        String res = "link" + c;
        while (this.getLinkByClientId(res) != null) {
            res = "link" + ++c;
        }
        return res;
    }

    @Nonnull
    public String nextNodeName() {
        int c = this.nodes.size();
        String res = "node" + c;
        while (this.getNodeByClientId(res) != null) {
            res = "node" + ++c;
        }
        return res;
    }

    @Nullable
    public String getType() {
        return this.rspecType;
    }

    @Nonnull
    public String nextIfaceName(@Nonnull RspecNode node) {
        int c = node.getInterfaces().size();
        String res = node.getClientId() + ":if" + c;
        while (this.getInterfaceByClientId(res) != null) {
            res = node.getClientId() + ":if" + ++c;
        }
        return res;
    }

    @Nullable
    public FXRspecInterface getInterfaceByUniqueId(@Nonnull String uniqueId) {
        FXRspecInterface iface;
        for (FXRspecNode node : this.nodes) {
            iface = node.getInterfaceByUniqueId(uniqueId);
            if (iface == null) continue;
            return iface;
        }
        for (FXRspecLink link : this.links) {
            iface = link.getInterfaceByUniqueId(uniqueId);
            if (iface == null) continue;
            return iface;
        }
        return null;
    }

    @Nullable
    public FXRspecInterface getInterfaceByClientId(@Nonnull String clientId) {
        FXRspecInterface res = this.nodes.stream().map(node -> node.getInterfaceByClientId(clientId)).filter(Objects::nonNull).findFirst().orElse(null);
        if (res == null) {
            res = this.links.stream().map(link -> link.getInterfaceByClientId(clientId)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return res;
    }

    @Nullable
    public Integer getMultiplexFactor() {
        return (Integer)this.multiplexFactor.get();
    }

    @Nonnull
    public ObjectProperty<Integer> multiplexFactorProperty() {
        return this.multiplexFactor;
    }

    public void setMultiplexFactor(@Nullable Integer multiplexFactor) {
        this.multiplexFactor.set((Object)multiplexFactor);
    }

    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    public void setExtraXml(@Nonnull List<ExtraXml> extraXml) {
        this.extraXml.clear();
        this.extraXml.addAll(extraXml);
    }

    @Nonnull
    public ModelRspec copy() {
        return this.factory.copyModelRspec((ModelRspec)this, null);
    }
}

