/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.probe_cli;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.ProtoGeniAMExtensions;
import be.iminds.ilabt.jfed.lowlevel.api.ProtoGeniClearingHouse1;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.api_scripts.GetAllProjects;
import be.iminds.ilabt.jfed.lowlevel.api_scripts.GetAllProjectsWithUsers;
import be.iminds.ilabt.jfed.lowlevel.api_scripts.GetAllUsers;
import be.iminds.ilabt.jfed.lowlevel.api_scripts.GetProjectsForUsers;
import be.iminds.ilabt.jfed.lowlevel.api_scripts.GetUsersInProject;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilderFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ServerTrustInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.commandline.BaseCli;
import be.iminds.ilabt.jfed.ui.probe_cli.CommandLineCore;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.debug_info.DebugInfoFactory;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.SSLCertificateDownloader;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineClient {
    private static final Logger LOG = LoggerFactory.getLogger(CommandLineClient.class);

    public static void help(PrintStream out, Options options) {
        PrintWriter pw = new PrintWriter(out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 200, "jfed-probe-cli [options ... ] <command> [command arguments ...]", "Possible options:", options, formatter.defaultLeftPad, formatter.defaultDescPad, "Required options:\n         --api\n         either --context-file or both -k and -u    (-u can be replaced by -a)\n");
        pw.close();
    }

    public static void main(String[] args) throws IOException, JFedException {
        int retval = CommandLineClient.main_helper(args, System.out, System.err, System.in, new BaseCli(System.err), true);
        System.exit(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main_helper(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli, boolean temporarilyRedirectSystemStreams) throws IOException, JFedException {
        PrintStream orig_out = System.out;
        PrintStream orig_err = System.err;
        InputStream orig_in = System.in;
        if (temporarilyRedirectSystemStreams) {
            System.setOut(out);
            System.setErr(err);
            System.setIn(in);
        }
        int retval = -1;
        try {
            retval = CommandLineClient.main_internal(args, out, err, in, baseCli);
        }
        finally {
            if (temporarilyRedirectSystemStreams) {
                System.setOut(orig_out);
                System.setErr(orig_err);
                System.setIn(orig_in);
            }
        }
        return retval;
    }

    public static int main_internal(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli) throws IOException, JFedException {
        JFedConnection con;
        boolean connectionDetailsExist;
        BasicParser parser = new BasicParser();
        Options options = new Options();
        options.addOption(Option.builder().longOpt("api").desc("The API to call (MANDATORY)").hasArg().argName("API").required().build());
        options.addOption("u", "server-url", true, "URL of server");
        options.addOption("a", "authority", true, "fill in server url based on hrn. Only works for known authorities");
        BaseCli.addUserConfig((Options)options, (String)"replaces all previous parameters by those in the provided context properties file (same format as used by automated tester)", (boolean)true);
        BaseCli.addAuthoritiesConfig((Options)options);
        options.addOption(Option.builder().longOpt("output-file").desc("file to write output to").hasArg().argName("OUTPUT_FILE").build());
        options.addOption(Option.builder().longOpt("use-tested-SA").desc("do not use the SA of the user, use the SA of the tested authority").build());
        options.addOption(Option.builder().longOpt("accept-self-signed").desc("accept unknown self signed certificates (DANGER: this is a big security risk)").build());
        options.addOption("q", "quiet", false, "less output");
        options.addOption("d", "debug", false, "extra debugging output");
        options.addOption("i", "interactive", false, "interactively request some missing options and command arguments. The --api option and the <command> are still required");
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            err.println("Command line argument Syntax error: " + exp.getMessage());
            CommandLineClient.help(err, options);
            return 1;
        }
        boolean useTestedSA = line.hasOption("use-tested-SA");
        boolean debug = line.hasOption("debug");
        String outputfile = line.getOptionValue("output-file");
        boolean silent = line.hasOption("quiet");
        boolean interactive = line.hasOption("interactive");
        boolean acceptSelfSigned = line.hasOption("accept-self-signed");
        String serverUrlStr = line.getOptionValue("server-url");
        String auth = line.getOptionValue("authority");
        List arguments = line.getArgList();
        if (arguments.size() < 1) {
            err.println("Error: No command specified after options.");
            CommandLineClient.help(err, options);
            return 1;
        }
        baseCli.initAuthoritiesModule(line);
        try {
            baseCli.initUserModule(line, out, err, in);
        }
        catch (BaseCli.CliArgumentException e) {
            LOG.debug("Got CliArgumentException", (Throwable)e);
            return 1;
        }
        boolean contextExists = line.hasOption("context-file");
        if (line.hasOption("u") && line.hasOption("a")) {
            err.println("You can only use either -u or -a, not both");
            CommandLineClient.help(err, options);
            return 1;
        }
        boolean bl = connectionDetailsExist = !(!line.hasOption("k") && !line.hasOption("p") || !line.hasOption("u") && !line.hasOption("a") && !line.hasOption("p"));
        if (contextExists && connectionDetailsExist) {
            err.println("--context-file cannot be mixed with -u, -k- and -a");
            CommandLineClient.help(err, options);
            return 1;
        }
        if (!(interactive || contextExists || connectionDetailsExist)) {
            err.println("illegal combination of --context-file and -u, -k-, -a");
            CommandLineClient.help(err, options);
            return 1;
        }
        String command = (String)arguments.remove(0);
        if (command.equalsIgnoreCase("GetUsersInProject")) {
            if (arguments.size() != 2) {
                System.err.println("GetUsersInProject requires 2 arguments (PROJECT_NAME and USERS_DIR). Not " + arguments.size() + ": " + String.valueOf(arguments));
                return 1;
            }
            Injector injector = baseCli.getInjector(err, new AbstractModule[0]);
            GeniUser user = (GeniUser)injector.getInstance(GeniUser.class);
            if (!BaseCli.checkUser((GeniUser)user, (CommandLine)line, (PrintStream)out, (PrintStream)err, (InputStream)in)) {
                return 1;
            }
            GetUsersInProject getUsersInProject = (GetUsersInProject)injector.getInstance(GetUsersInProject.class);
            String projectName = (String)arguments.remove(0);
            String usersDirString = (String)arguments.remove(0);
            File usersDir = new File(usersDirString);
            getUsersInProject.save(projectName, usersDir);
            return 0;
        }
        if (command.equalsIgnoreCase("GetProjects")) {
            Injector injector = baseCli.getInjector(err, new AbstractModule[0]);
            GeniUser user = (GeniUser)injector.getInstance(GeniUser.class);
            if (!BaseCli.checkUser((GeniUser)user, (CommandLine)line, (PrintStream)out, (PrintStream)err, (InputStream)in)) {
                return 1;
            }
            GetProjectsForUsers getProjects = (GetProjectsForUsers)injector.getInstance(GetProjectsForUsers.class);
            String resJson = getProjects.getProjectsForUsersAsJson(arguments);
            System.out.println(resJson);
            return 0;
        }
        if (command.equalsIgnoreCase("ListProjects")) {
            Injector injector = baseCli.getInjector(err, new AbstractModule[0]);
            GeniUser user = (GeniUser)injector.getInstance(GeniUser.class);
            if (!BaseCli.checkUser((GeniUser)user, (CommandLine)line, (PrintStream)out, (PrintStream)err, (InputStream)in)) {
                return 1;
            }
            GetAllProjects getProjects = (GetAllProjects)injector.getInstance(GetAllProjects.class);
            String resJson = getProjects.getAllProjectsAsJson();
            System.out.println(resJson);
            return 0;
        }
        if (command.equalsIgnoreCase("ListUsers")) {
            Injector injector = baseCli.getInjector(err, new AbstractModule[0]);
            GeniUser user = (GeniUser)injector.getInstance(GeniUser.class);
            if (!BaseCli.checkUser((GeniUser)user, (CommandLine)line, (PrintStream)out, (PrintStream)err, (InputStream)in)) {
                return 1;
            }
            GetAllUsers getProjects = (GetAllUsers)injector.getInstance(GetAllUsers.class);
            String resJson = getProjects.getAllUsersAsJson();
            System.out.println(resJson);
            return 0;
        }
        if (command.equalsIgnoreCase("ListProjectsWithUsers")) {
            Injector injector = baseCli.getInjector(err, new AbstractModule[0]);
            GeniUser user = (GeniUser)injector.getInstance(GeniUser.class);
            if (!BaseCli.checkUser((GeniUser)user, (CommandLine)line, (PrintStream)out, (PrintStream)err, (InputStream)in)) {
                return 1;
            }
            GetAllProjectsWithUsers getProjects = (GetAllProjectsWithUsers)injector.getInstance(GetAllProjectsWithUsers.class);
            String resJson = getProjects.getAllProjectsWithUserssAsJson();
            System.out.println(resJson);
            return 0;
        }
        be.iminds.ilabt.jfed.log.Logger logger = new be.iminds.ilabt.jfed.log.Logger();
        JFedCorePreferences jFedPreferences = new JFedCorePreferences();
        CommandLineCore<AggregateManager2> core = null;
        ApiInfo.Api api = null;
        String apiArg = line.getOptionValue("api");
        if (apiArg.equalsIgnoreCase("AM2") || apiArg.equalsIgnoreCase("AMv2")) {
            api = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2);
            core = new CommandLineCore<AggregateManager2>(AggregateManager2.class, new AggregateManager2(logger, (JFedPreferences)jFedPreferences));
        }
        if (apiArg.equalsIgnoreCase("MA2")) {
            api = new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 2);
            core = new CommandLineCore<FederationMemberAuthorityApi2>(FederationMemberAuthorityApi2.class, new FederationMemberAuthorityApi2(logger, (JFedPreferences)jFedPreferences));
        }
        if (apiArg.equalsIgnoreCase("SA2")) {
            api = new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 2);
            core = new CommandLineCore<FederationSliceAuthorityApi2>(FederationSliceAuthorityApi2.class, new FederationSliceAuthorityApi2(logger, (JFedPreferences)jFedPreferences));
        }
        if (apiArg.equalsIgnoreCase("AM3") || apiArg.equalsIgnoreCase("AMv3")) {
            api = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3);
            core = new CommandLineCore<AggregateManager3>(AggregateManager3.class, new AggregateManager3(logger, (JFedPreferences)jFedPreferences));
        }
        if (apiArg.equalsIgnoreCase("PROTOGENI_SA")) {
            api = new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1);
            core = new CommandLineCore<ProtogeniSliceAuthority>(ProtogeniSliceAuthority.class, new ProtogeniSliceAuthority(logger, (JFedPreferences)jFedPreferences));
        }
        if (apiArg.equalsIgnoreCase("PROTOGENI_CH")) {
            api = new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_CH, 1);
            core = new CommandLineCore<ProtoGeniClearingHouse1>(ProtoGeniClearingHouse1.class, new ProtoGeniClearingHouse1(logger, (JFedPreferences)jFedPreferences));
        }
        if (apiArg.equalsIgnoreCase("PROTOGENI_AM_EXT")) {
            api = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2);
            core = new CommandLineCore<ProtoGeniAMExtensions>(ProtoGeniAMExtensions.class, new ProtoGeniAMExtensions(logger, (JFedPreferences)jFedPreferences));
        }
        if (core == null || api == null) {
            err.println("Error: unknown API: \"" + apiArg + "\"  (registered here: PROTOGENI_SA, PROTOGENI_CH, AM2, AM3, PROTOGENI_EXT_AM)");
            CommandLineClient.help(err, options);
            return 1;
        }
        if (core != null && !core.getAvailableMethodNamesLowerCase().contains(command.toLowerCase())) {
            err.println("Error: Unknown command: '" + command + "'");
            CommandLineClient.help(err, options);
            return 1;
        }
        if (!line.hasOption("context-file")) {
            Service targetService = null;
            Server targetServer = null;
            Injector injector = baseCli.getInjector(err, new AbstractModule[0]);
            TestbedInfoSource testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
            GeniUser user = (GeniUser)injector.getInstance(GeniUser.class);
            assert (user != null);
            assert (user.getUserAuthorityServer() != null);
            boolean asked = false;
            if (serverUrlStr == null) {
                if (auth != null) {
                    if (auth.startsWith("urn:publicid")) {
                        targetServer = testbedInfoSource.getFromAnyUrnExact(auth);
                        targetService = ApiInfo.findService((Server)targetServer, (ApiInfo.Api)api);
                        serverUrlStr = targetService == null ? null : targetService.getUrl();
                    } else {
                        for (Server knownAuth : testbedInfoSource.getServers()) {
                            if (!Objects.equals(knownAuth.getName(), auth)) continue;
                            targetService = ApiInfo.findService((Server)knownAuth, (ApiInfo.Api)api);
                            serverUrlStr = targetService == null ? null : targetService.getUrl();
                            targetServer = knownAuth;
                        }
                    }
                    if (targetServer == null) {
                        err.println("ERROR: Authority '" + auth + "' is unknown.");
                        return -1;
                    }
                    if (targetService == null || serverUrlStr == null) {
                        err.println("ERROR: Server URL for authority '" + auth + "' and server type " + apiArg + " is unknown.");
                        return -1;
                    }
                }
                if (serverUrlStr == null) {
                    assert (interactive);
                    serverUrlStr = IOUtils.askCommandLineInput((String)"Server URL", (InputStream)in);
                    asked = true;
                }
            }
            if (targetServer == null) {
                URL server = new URL(serverUrlStr);
                String serverHostname = server.getHost();
                for (Server knownAuth : testbedInfoSource.getServers()) {
                    for (Service service : knownAuth.getServices()) {
                        URL url = new URL(service.getUrl());
                        if (!Objects.equals(url.getHost(), serverHostname)) continue;
                        targetServer = knownAuth;
                        targetService = service;
                    }
                }
            }
            if (targetServer == null) {
                Server fakeServer;
                out.println("WARNING: No known authority matches server URL. Will check if certificate is trusted.");
                SSLCertificateDownloader.SSLCertificateJFedInfo info = SSLCertificateDownloader.getCertificateInfo(new URL(serverUrlStr));
                out.println("Note: Unknown authority, so created temporary fake authority info, in order to connect to server.");
                String urnString = "urn:publicid:IDN+fake+authority+fake";
                TestbedBuilder testbedBuilder = new TestbedBuilder();
                ServerBuilder serverBuilder = new ServerBuilder();
                testbedBuilder.addServerBuilder(serverBuilder);
                testbedBuilder.setLongName("Temporarily created fake authority for URL " + serverUrlStr);
                serverBuilder.setName("Temporarily created fake authority for URL " + serverUrlStr);
                serverBuilder.setServerType("temp-fake-unknown");
                testbedBuilder.setDefaultComponentManagerUrn(urnString);
                serverBuilder.setDefaultComponentManagerUrn(urnString);
                ServiceBuilder serviceBuilder = new ServiceBuilder();
                serviceBuilder.setApi(api.getId());
                serviceBuilder.setApiVersion(api.getVersion());
                serviceBuilder.setUrl(serverUrlStr);
                serviceBuilder.setUrn(urnString);
                serverBuilder.addServiceBuilder(serviceBuilder);
                if (info.isSelfSigned().booleanValue()) {
                    boolean trust = acceptSelfSigned;
                    if (!trust) {
                        if (!interactive) {
                            err.println("FATAL: The server's self-signed certificate is not trusted! Either add the authority to the list, or add a command line option to trust any self signed certificate (dangerous).");
                            return 1;
                        }
                        out.println("Note: The server's self-signed certificate is not trusted! Either add the authority to the list, or trust it temporarily. Certificate:");
                        out.println(KeyUtil.x509certificateToPem(info.getCert()));
                        assert (interactive);
                        String trustSelfSignedCert = IOUtils.askCommandLineInput((String)"Trust self-signed certificate (Unsafe!)? (y/N)", (InputStream)in);
                        trust = trustSelfSignedCert.equalsIgnoreCase("y");
                    }
                    if (trust) {
                        if (info != null && !info.isTrusted()) {
                            if (Objects.equals(info.getSubjectMatchesHostname(), Boolean.FALSE)) {
                                serverBuilder.setAllowedCertificateAlias(info.getSubject());
                            }
                            serverBuilder.setCertificateChain(KeyUtil.x509certificateToPem(info.getCert()));
                        }
                    } else {
                        err.println("FATAL: the server's certificate is not trusted. Connecting would fail.");
                        return 1;
                    }
                }
                Testbed fakeTestbed = testbedBuilder.create();
                targetServer = fakeServer = (Server)fakeTestbed.getServers().get(0);
                targetService = (Service)fakeServer.getServices().get(0);
            }
            assert (targetServer != null);
            JFedTrustStore trustStore = new JFedTrustStore(ServerTrustInfo.convert((TestbedInfoSource)testbedInfoSource));
            trustStore.addTrustedPemCertificateIfNotAdded(targetServer.getCertificateChain());
            trustStore.addAllowedServerCertificateHostnameAlias(targetServer.getAllowedCertificateAlias());
            if (user.getUserAuthorityServer().getCertificateChain() != null) {
                trustStore.addTrustedPemCertificateIfNotAdded(user.getUserAuthorityServer().getCertificateChain());
            }
            assert (injector != null);
            ConnectionBuilderFactory connectionBuilderFactory = (ConnectionBuilderFactory)injector.getInstance(ConnectionBuilderFactory.class);
            ConnectionBuilder connectionBuilder = connectionBuilderFactory.createConnectionBuilder();
            connectionBuilder.setDebugInfo(DebugInfoFactory.createFromService((GeniUser)user, (Service)targetService));
            connectionBuilder.setProxy(null, false);
            connectionBuilder.setUrl(serverUrlStr);
            connectionBuilder.useHttps(trustStore, null);
            connectionBuilder.useSslClientAuthentication(user.getClientCertificateChain(), user.getPrivateKey());
            connectionBuilder.setSocketConnectTimeoutMs(jFedPreferences.getInt((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SOCKET_CONNECT_TIMEOUT_MS, 10000));
            connectionBuilder.setSocketReadTimeoutMs(jFedPreferences.getInt((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SOCKET_READ_TIMEOUT_MS, 120000));
            con = connectionBuilder.buildSfaConnection();
        } else {
            GeniUser user;
            TargetAuthority targetAuthority;
            try {
                baseCli.initTestTargetFromContextFileModule(line, out, err, in);
            }
            catch (BaseCli.CliArgumentException e) {
                LOG.debug("Got CliArgumentException", (Throwable)e);
                return 1;
            }
            Injector injector = baseCli.getInjector(err, new AbstractModule[0]);
            if (injector == null) {
                return 1;
            }
            try {
                targetAuthority = (TargetAuthority)injector.getInstance(TargetAuthority.class);
                user = (GeniUser)injector.getInstance(GeniUser.class);
            }
            catch (AssertionError | Exception e) {
                baseCli.handleInjectException((Throwable)e, err);
                return 1;
            }
            Server testedAuthorityToConnect = targetAuthority.getServerToConnect();
            assert (api != null);
            URL serverUrl = ApiInfo.findUrl((Server)testedAuthorityToConnect, (ApiInfo.Api)api);
            if (serverUrl == null) {
                err.println("FATAL error: Authority " + testedAuthorityToConnect.getDefaultComponentManagerUrn() + " has no URL for " + apiArg + " (internal type = " + String.valueOf(api) + ")");
                return 1;
            }
            assert (serverUrl != null) : "Authority " + testedAuthorityToConnect.getDefaultComponentManagerUrn() + " has no URL for " + String.valueOf(api);
            serverUrlStr = serverUrl.toString();
            if (!silent) {
                out.println("Read context properties from file \"" + line.getOptionValue("context-file") + "\":");
                out.println("   Tested Authority: " + testedAuthorityToConnect.getName());
                out.println("      URN: " + testedAuthorityToConnect.getDefaultComponentManagerUrn());
                out.println("      Hrn: " + testedAuthorityToConnect.getName());
                out.println("      Server certificates: " + testedAuthorityToConnect.getCertificateChain());
                out.println("      allowed server certificate hostname alias: " + testedAuthorityToConnect.getAllowedCertificateAlias());
                out.println("      URL for " + String.valueOf(api) + ": " + serverUrlStr);
                out.println("   User: " + user.getUserUrnString());
                out.println("      Authority URN: " + user.getUserAuthorityServer().getDefaultComponentManagerUrn());
            }
            con = ((JFedConnectionProvider)injector.getInstance(JFedConnectionProvider.class)).getConnectionByAuthority(user, testedAuthorityToConnect, api);
        }
        assert (con != null);
        if (!silent) {
            out.println("Connecting and executing " + command + "...");
        }
        CommandLineCore.ExecuteMethodResult res = core.executeMethod(con, command, arguments, interactive);
        if (!silent && outputfile == null) {
            out.println(apiArg + " " + command + " result: ");
        }
        if (!silent && outputfile != null) {
            out.println("Writing " + apiArg + " " + command + " result to file \"" + outputfile + "\"");
        }
        if (outputfile == null) {
            out.println(res.output);
        } else {
            IOUtils.stringToFile((File)new File(outputfile), (String)res.output);
        }
        if (!silent && debug) {
            out.println("DEBUG:");
            out.println("  Server URL: " + con.getServerUrl());
            if (con instanceof SfaConnection) {
                out.println("  HTTP sent: " + ((SfaConnection)con).getXmlRpcTransportFactory().getHttpSentHistory());
                out.println("  HTTP reply: " + ((SfaConnection)con).getXmlRpcTransportFactory().getHttpReceivedHistory());
            }
        }
        return res.exitvalue;
    }
}

