/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.probe_cli;

import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceIdParser;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.rspec.parser.extensions.UserSpecParser;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineCore<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CommandLineCore.class);
    private final Class<T> targetClass;
    private final T targetObject;
    private final Map<String, Method> availableMethods;
    private final Map<String, Method> availableMethodsLowerCase;

    private static Map<String, Method> findAvailableMethods(Class targetClass) {
        HashMap<String, Method> res = new HashMap<String, Method>();
        for (Method m : targetClass.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(ApiMethod.class)) continue;
            ApiMethod am = m.getAnnotation(ApiMethod.class);
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (parameterTypes.length == 0 || !JFedConnection.class.isAssignableFrom(parameterTypes[0])) {
                throw new RuntimeException("Method " + String.valueOf(m) + " does not have GeniConnection as first parameter but it does have @ApiMethod");
            }
            res.put(m.getName(), m);
        }
        return res;
    }

    public CommandLineCore(Class<T> targetClass, T targetObject) {
        this.targetClass = targetClass;
        this.targetObject = targetObject;
        this.availableMethods = CommandLineCore.findAvailableMethods(targetClass);
        this.availableMethodsLowerCase = new HashMap<String, Method>();
        for (Map.Entry<String, Method> e : this.availableMethods.entrySet()) {
            this.availableMethodsLowerCase.put(e.getKey().toLowerCase(), e.getValue());
        }
    }

    public Collection<String> getAvailableMethodNames() {
        return this.availableMethods.keySet();
    }

    public Collection<String> getAvailableMethodNamesLowerCase() {
        return this.availableMethodsLowerCase.keySet();
    }

    public String getMethodSyntax(String methodName) {
        Method m = this.availableMethodsLowerCase.get(methodName.toLowerCase());
        Class<?>[] parameterTypes = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        Object res = "";
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] paramAnnotations = annotations[i];
            Class<?> paramClass = parameterTypes[i];
            for (Annotation paramAnnotation : paramAnnotations) {
                if (!Objects.equals(paramAnnotation.annotationType(), ApiMethodParameter.class)) continue;
                ApiMethodParameter amp = (ApiMethodParameter)paramAnnotation;
                if (((String)res).length() > 0) {
                    res = (String)res + " ";
                }
                if (Objects.equals(amp.name(), "credentialList")) {
                    res = (String)res + "<credential file>";
                    continue;
                }
                if (Objects.equals(amp.name(), "rspec")) {
                    res = (String)res + "<rspec file>";
                    continue;
                }
                res = amp.required() ? (String)res + "<" : (String)res + "[";
                res = (String)res + amp.name();
                if (Objects.equals(paramClass, Boolean.class)) {
                    res = (String)res + " (true|false)";
                }
                if (Objects.equals(paramClass, Integer.class)) {
                    res = (String)res + " (int)";
                }
                res = amp.required() ? (String)res + ">" : (String)res + "]";
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecuteMethodResult executeMethod(JFedConnection connection, String methodName, List<String> arguments, boolean interactive) {
        Method m = this.availableMethodsLowerCase.get(methodName.toLowerCase());
        Class<?>[] parameterTypes = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        ExecuteMethodResult res = new ExecuteMethodResult();
        Object[] parameters = new Object[parameterTypes.length];
        LinkedList<String> remainingArguments = new LinkedList<String>(arguments);
        int i = 0;
        while (true) {
            block31: {
                int n;
                Annotation[] annotationArray;
                Class<?> paramClass;
                block32: {
                    block29: {
                        Annotation[] paramAnnotations;
                        block30: {
                            if (i >= parameterTypes.length) break block29;
                            paramAnnotations = annotations[i];
                            paramClass = parameterTypes[i];
                            if (!JFedConnection.class.isAssignableFrom(paramClass)) break block30;
                            parameters[i] = connection;
                            break block31;
                        }
                        annotationArray = paramAnnotations;
                        n = annotationArray.length;
                        break block32;
                    }
                    try {
                        Object methodRes = m.invoke(this.targetObject, parameters);
                        ApiCallReply methodResRep = (ApiCallReply)methodRes;
                        if (methodResRep.getGeniResponseCode().isSuccess()) {
                            res.output = res.output + methodResRep.getValue().toString();
                            res.exitvalue = 0;
                            return res;
                        }
                        res.output = res.output + "Error reported by server: " + String.valueOf(methodResRep.getGeniResponseCode()) + " output=" + methodResRep.getOutput();
                        if (methodResRep.getGeniResponseCode().isBusy()) {
                            res.exitvalue = 99;
                            return res;
                        }
                        res.exitvalue = 1;
                        return res;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                        res.exitvalue = 2;
                    }
                    return res;
                }
                for (int j = 0; j < n; ++j) {
                    Annotation paramAnnotation = annotationArray[j];
                    if (!Objects.equals(paramAnnotation.annotationType(), ApiMethodParameter.class)) continue;
                    ApiMethodParameter amp = (ApiMethodParameter)paramAnnotation;
                    String arg = null;
                    if (remainingArguments.isEmpty()) {
                        if (amp.required()) {
                            if (!interactive) {
                                System.err.println("Missing " + methodName + " argument '" + amp.name() + "'");
                                throw new RuntimeException("Error in CLI");
                            }
                            arg = IOUtils.askCommandLineInput((String)("Enter " + methodName + " argument '" + amp.name() + "'"));
                        } else {
                            arg = null;
                        }
                    } else {
                        arg = remainingArguments.pollFirst();
                    }
                    if (arg == null || arg.equals("null")) {
                        parameters[i] = null;
                        if (!Objects.equals(amp.name(), "credentialList")) continue;
                        parameters[i] = Collections.emptyList();
                        continue;
                    }
                    try {
                        if (Objects.equals(amp.name(), "credentialList")) {
                            ArrayList<AnyCredential> credList = new ArrayList<AnyCredential>();
                            String cred = IOUtils.fileToString((String)arg);
                            credList.add(AnyCredential.createSfa2((String)("credential from file " + arg), (String)cred));
                            parameters[i] = credList;
                            continue;
                        }
                        if (Objects.equals(amp.name(), "urns")) {
                            List<String> urns;
                            String[] helper = arg.split(",");
                            parameters[i] = urns = Arrays.asList(helper);
                            continue;
                        }
                        if (Objects.equals(amp.name(), "users")) {
                            String xml = arg.trim();
                            if (xml.isEmpty()) {
                                parameters[i] = new ArrayList();
                                continue;
                            }
                            List userSpecs = null;
                            try {
                                UserSpecParser userSpecParser = new UserSpecParser(xml);
                                userSpecs = userSpecParser.call();
                            }
                            catch (Exception e) {
                                LOG.error("Error unmarhalling XML list", (Throwable)e);
                                e.printStackTrace(System.err);
                                String exampleXml = "<user-list xmlns=\"http://jfed.iminds.be/rspec/ext/jfed-ssh-keys/1\">        <user-ssh-keys user=\"urn:publicid:IDN+example.com+user+tester\">\n           <sshkey>ssh-rsa foo</sshkey>\n       </user-ssh-keys>\n       <user-ssh-keys user=\"urn:publicid:IDN+example.com+user+tester2\">\n           <sshkey>ssh-rsa bar</sshkey>\n           <sshkey>ssh-rsa baz</sshkey>\n       </user-ssh-keys>\n</user-list>\n";
                                System.err.println("\nError: Argument \"users\" must be empty, or the xml representation of a list of user specifications. Example of such an xml:\n" + exampleXml + "\n");
                                throw new RuntimeException("Error in CLI");
                            }
                            parameters[i] = userSpecs;
                            continue;
                        }
                        if (Objects.equals(amp.name(), "rspec")) {
                            parameters[i] = IOUtils.fileToString((String)arg);
                            continue;
                        }
                        if (Objects.equals(paramClass, String.class)) {
                            parameters[i] = arg;
                            continue;
                        }
                        if (Objects.equals(paramClass, Integer.class)) {
                            parameters[i] = Integer.parseInt(arg);
                            continue;
                        }
                        if (Objects.equals(paramClass, Boolean.class)) {
                            parameters[i] = Boolean.parseBoolean(arg);
                            continue;
                        }
                        if (Objects.equals(paramClass, ResourceId.class)) {
                            parameters[i] = ResourceIdParser.parse((String)arg);
                            continue;
                        }
                        if (Objects.equals(paramClass, ResourceUrn.class)) {
                            parameters[i] = new ResourceUrn(arg);
                            continue;
                        }
                        if (!(Objects.equals(paramClass, AnyCredential.class) || Objects.equals(paramClass, SfaCredential.class) || Objects.equals(paramClass, AbacCredential.class))) {
                            res.exitvalue = 3;
                            throw new RuntimeException("ERROR: Implementation incomplete: Unsupported parameter type: " + paramClass.getName() + " (name=\"" + amp.name() + "\")");
                        }
                        String cred = IOUtils.fileToString((String)arg);
                        parameters[i] = AnyCredential.createSfa2((String)("credential from file " + arg), (String)cred);
                        continue;
                    }
                    catch (IOException e) {
                        res.exitvalue = 3;
                        throw new RuntimeException("ERROR: IOException reading credential file: " + e.getMessage(), e);
                    }
                    catch (CredentialException e) {
                        res.exitvalue = 3;
                        throw new RuntimeException("ERROR: CredentialException processing credential file: " + e.getMessage(), e);
                    }
                }
            }
            ++i;
        }
    }

    public static class ExecuteMethodResult {
        int exitvalue = 0;
        String output = "";
    }
}

