/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.library.SshProxySocketImplFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketImplFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshServerProxyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SshServerProxyHelper.class);

    public static class PlainHttpOverSshProxySocketFactory
    extends PlainConnectionSocketFactory {
        private final JFedConnection.SshProxyInfo sshProxyInfo;
        protected final String forcedCreateSocketHostname;
        protected final Integer forcedCreateSocketPort;

        public PlainHttpOverSshProxySocketFactory(JFedConnection.SshProxyInfo sshProxyInfo) {
            this(sshProxyInfo, null, null);
        }

        public PlainHttpOverSshProxySocketFactory(JFedConnection.SshProxyInfo sshProxyInfo, String forcedCreateSocketHostname, Integer forcedCreateSocketPort) {
            this.sshProxyInfo = sshProxyInfo;
            this.forcedCreateSocketHostname = forcedCreateSocketHostname;
            this.forcedCreateSocketPort = forcedCreateSocketPort;
        }

        public Socket createSocket(HttpContext context) {
            SshProxySocket socket;
            try {
                SshProxySocketImplFactory sshHSocketImplFactory = SshProxySocketImplFactory.getFactory(this.sshProxyInfo, this.forcedCreateSocketHostname, this.forcedCreateSocketPort);
                socket = new SshProxySocket(sshHSocketImplFactory);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while creating SshProxySocket", e);
            }
            return socket;
        }
    }

    public static class SslOverSshProxySocketFactory
    extends SSLConnectionSocketFactory {
        private JFedConnection.SshProxyInfo sshProxyInfo;
        protected final String forcedCreateSocketHostname;
        protected final Integer forcedCreateSocketPort;

        public SslOverSshProxySocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier, JFedConnection.SshProxyInfo sshProxyInfo, String forcedCreateSocketHostname, Integer forcedCreateSocketPort) {
            super(sslContext, hostnameVerifier);
            this.sshProxyInfo = sshProxyInfo;
            this.forcedCreateSocketHostname = forcedCreateSocketHostname;
            this.forcedCreateSocketPort = forcedCreateSocketPort;
        }

        public SslOverSshProxySocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier, JFedConnection.SshProxyInfo sshProxyInfo) {
            this(sslContext, hostnameVerifier, sshProxyInfo, null, null);
        }

        public Socket createSocket(HttpContext context) throws IOException {
            SshProxySocket socket;
            try {
                assert (this.sshProxyInfo != null);
                SshProxySocketImplFactory sshHSocketImplFactory = SshProxySocketImplFactory.getFactory(this.sshProxyInfo, this.forcedCreateSocketHostname, this.forcedCreateSocketPort);
                assert (sshHSocketImplFactory != null);
                socket = new SshProxySocket(sshHSocketImplFactory);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while creating SshProxySocket", e);
            }
            return socket;
        }
    }

    private static class SshProxySocket
    extends Socket {
        public SshProxySocket(SocketImplFactory sshHSocketImplFactory) throws IOException {
            super(sshHSocketImplFactory.createSocketImpl());
            LOG.debug("Creating wrapping SshProxySocket");
        }
    }
}

