/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.preloader;

import java.util.Calendar;
import java.util.Random;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.PathTransition;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public class JFedPreloader
extends Preloader {
    private static final Random RAND = new Random();
    private static final int HEIGHT = 250;
    private static final String MESSAGE_LOADING_RESOURCES = "Loading resources";
    private static final String MESSAGE_INITALIZING = "Initializing";
    private Stage stage;
    private Scene scene;
    private final Pane root;
    private final Label progressLabel = new Label("Loading resources");
    private final ProgressBar progressBar = new ProgressBar(0.0);
    private static final int WIDTH = 400;
    private static final int PROGRESSBAR_HEIGHT = 4;
    private final BoxBlur boxBlur = new BoxBlur(10.0, 3.0, 3);
    private final DropShadow glow = new DropShadow(1.0, 0.0, 0.0, Color.YELLOW);
    private final String[] paths = new String[]{"M -184.00,170.00\n           C -184.00,170.00 -99.00,94.00 20.00,122.00\n             139.00,150.00 279.00,235.00 391.00,223.00\n             503.00,211.00 691.00,101.00 691.00,101.00", "M -84.00,221.00\n           C -84.00,221.00 148.00,164.00 236.00,167.00\n             324.00,170.00 408.00,206.00 489.00,205.00\n             570.00,204.00 712.00,189.00 733.00,177.00", "M -157.00,249.00\n           C -157.00,249.00 5.00,184.00 93.00,187.00\n             181.00,190.00 381.00,227.00 462.00,226.00\n             543.00,225.00 712.00,189.00 733.00,177.00", "M -170.00,205.00\n           C -170.00,205.00 -6.00,151.00 113.00,179.00\n             232.00,207.00 341.00,218.00 453.00,206.00\n             565.00,194.00 688.00,145.00 688.00,145.00", "M -148.00,220.00\n           C -148.00,220.00 -10.00,129.00 109.00,157.00\n             228.00,185.00 351.00,224.00 463.00,212.00\n             575.00,200.00 684.00,171.00 684.00,171.00"};
    private final Color[] colors = new Color[]{Color.AQUAMARINE, Color.GOLD, Color.LAWNGREEN, Color.YELLOWGREEN, Color.GREENYELLOW};
    private int count = 0;
    private String currentProgressMessage = "Loading resources";

    public JFedPreloader() {
        SVGPath path;
        this.root = new Pane();
        this.root.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("preloader.css").toExternalForm());
        this.root.getStyleClass().add((Object)"pane");
        Label logoLabel = new Label("jFed");
        logoLabel.getStyleClass().add((Object)"title");
        Image logo = new Image(((Object)((Object)this)).getClass().getResource("jfed-logo_64.png").toExternalForm());
        ImageView logoImageView = new ImageView(logo);
        logoLabel.setGraphic((Node)logoImageView);
        this.progressLabel.getStyleClass().add((Object)"progress-message");
        Label copyrightLabel = new Label(String.format("\u00a9 2012-%d iMinds vzw. Available under MIT license.", Calendar.getInstance().get(1)));
        copyrightLabel.getStyleClass().add((Object)"copyright");
        this.progressBar.setPrefHeight(4.0);
        this.progressBar.setPrefWidth(400.0);
        this.root.getChildren().addAll((Object[])new Node[]{logoLabel, this.progressLabel, copyrightLabel, this.progressBar});
        this.progressBar.relocate(0.0, 246.0);
        this.progressLabel.relocate(120.0, 140.0);
        copyrightLabel.relocate(10.0, 221.0);
        for (int i = 0; i < this.paths.length; ++i) {
            path = new SVGPath();
            path.setContent(this.paths[i]);
            path.setStroke((Paint)this.colors[i]);
            path.setFill((Paint)Color.TRANSPARENT);
            path.setEffect((Effect)this.boxBlur);
            path.getTransforms().addAll((Object[])new Transform[]{new Translate(0.0, 40.0), new Scale(0.6, 0.6)});
            Circle circle = new Circle(0.0, 0.0, 2.0, (Paint)this.colors[i]);
            circle.setEffect((Effect)this.glow);
            this.root.getChildren().add(0, (Object)circle);
            this.root.getChildren().add(0, (Object)path);
            PathTransition transition = new PathTransition(Duration.seconds((double)(5.0 + RAND.nextDouble() * 5.0)), (Shape)path, (Node)circle);
            transition.setCycleCount(-1);
            transition.play();
        }
        FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.3), (Node)logoLabel);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        fadeTransition.setInterpolator(Interpolator.EASE_OUT);
        path = new Path();
        path.getElements().add((Object)new MoveTo(250.0, 100.0));
        path.getElements().add((Object)new HLineTo(190.0));
        PathTransition pathTransition = new PathTransition(Duration.seconds((double)1.3), (Shape)path, (Node)logoLabel);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{fadeTransition, pathTransition});
        parallelTransition.play();
    }

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        this.scene = new Scene((Parent)this.root, 400.0, 250.0, (Paint)Color.WHITE);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.setScene(this.scene);
        Task<Void> counterTask = new Task<Void>(){

            protected Void call() throws Exception {
                while (true) {
                    ++JFedPreloader.this.count;
                    JFedPreloader.this.count %= 4;
                    Platform.runLater(() -> JFedPreloader.this.updateProgressMessage());
                    Thread.sleep(800L);
                }
            }
        };
        Thread counterThread = new Thread((Runnable)counterTask);
        counterThread.setDaemon(true);
        counterThread.start();
    }

    public static void main(String[] args) {
        JFedPreloader.launch((String[])args);
    }

    public void handleProgressNotification(Preloader.ProgressNotification pn) {
        if (pn.getProgress() != 1.0 && !this.stage.isShowing()) {
            this.stage.show();
        }
        this.progressBar.setProgress(pn.getProgress());
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification stateChangeNotification) {
        if (stateChangeNotification.getType() == Preloader.StateChangeNotification.Type.BEFORE_LOAD) {
            this.currentProgressMessage = MESSAGE_LOADING_RESOURCES;
            this.updateProgressMessage();
        } else if (stateChangeNotification.getType() == Preloader.StateChangeNotification.Type.BEFORE_INIT) {
            this.currentProgressMessage = MESSAGE_INITALIZING;
            this.updateProgressMessage();
        } else if (this.stage.isShowing()) {
            FadeTransition ft = new FadeTransition(Duration.millis((double)1000.0), (Node)this.stage.getScene().getRoot());
            ft.setFromValue(1.0);
            ft.setToValue(0.0);
            Stage s = this.stage;
            EventHandler eh = t -> s.hide();
            ft.setOnFinished(eh);
            ft.play();
        } else {
            this.stage.hide();
        }
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification preloaderNotification) {
        super.handleApplicationNotification(preloaderNotification);
    }

    private void updateProgressMessage() {
        StringBuilder sb = new StringBuilder(this.currentProgressMessage);
        for (int i = 0; i < this.count; ++i) {
            sb.append('.');
        }
        this.progressLabel.setText(sb.toString());
    }
}

