/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsWriter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.ui.cli.ExperimenterCommandLineParser;
import be.iminds.ilabt.jfed.ui.commandline.BaseCli;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterCli {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimenterCli.class);
    private static final String KEY_EXPIRATION_TIME = "expiration-time";
    private static final String KEY_REQUEST_RSPEC = "request-rspec";

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int retval = ExperimenterCli.main_helper(args, System.out, System.err, System.in, new BaseCli(System.err), true);
        System.exit(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main_helper(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli, boolean temporarilyRedirectSystemStreams) throws IOException, ClassNotFoundException {
        PrintStream orig_out = System.out;
        PrintStream orig_err = System.err;
        InputStream orig_in = System.in;
        if (temporarilyRedirectSystemStreams) {
            System.setOut(out);
            System.setErr(err);
            System.setIn(in);
        }
        int retval = -1;
        try {
            retval = ExperimenterCli.main_internal(args, out, err, in, baseCli);
        }
        finally {
            if (temporarilyRedirectSystemStreams) {
                System.setOut(orig_out);
                System.setErr(orig_err);
                System.setIn(orig_in);
            }
        }
        return retval;
    }

    /*
     * Exception decompiling
     */
    public static int main_internal(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK], 7[TRYBLOCK]], but top level block is 246[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void callAnsible(String ansiblePlaybookExe, File ansiblePlaybook, File ansibleDir, boolean ansibleDebug, File outputFile) throws IOException {
        String line;
        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
        ArrayList<String> command = new ArrayList<String>();
        assert (ansiblePlaybookExe != null);
        String[] ansiblePlaybookExeParts = ansiblePlaybookExe.split(" ");
        Collections.addAll(command, ansiblePlaybookExeParts);
        command.add(ansiblePlaybook.getAbsolutePath());
        if (ansibleDebug) {
            command.add("-vvvv");
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(ansibleDir);
        pb = pb.redirectErrorStream(true);
        Process p = pb.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            pw.println(line);
        }
        input.close();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        pw.close();
    }

    private static void deleteAll(List<AggregateManagerWrapper> amWrappers, boolean silent, PrintStream out, PrintStream err, GeniUrn usedSliceUrn, List<AnyCredential> sliceCredentials, be.iminds.ilabt.jfed.log.Logger logger, UserAndSliceApiWrapper sa) {
        if (!silent) {
            err.println("Failure: will delete all slivers, on " + String.valueOf(amWrappers) + " AMs.");
        }
        for (AggregateManagerWrapper am : amWrappers) {
            String message;
            Server currentAuthority = am.getAmServer();
            String rspecComponentManager = currentAuthority.getDefaultComponentManagerUrn();
            GeniUrn rspecComponentManagerUrn = currentAuthority.getDefaultComponentManagerAsGeniUrn();
            if (!silent) {
                out.println("Contacting  " + rspecComponentManager + "...");
            }
            try {
                am.deleteSliver(usedSliceUrn, sliceCredentials);
                if (!silent) {
                    out.println("Slivers at  " + rspecComponentManager + " have been deleted.");
                }
                try {
                    sa.unregisterAggregatesForSlice(logger, sliceCredentials, usedSliceUrn, rspecComponentManagerUrn, null);
                    if (silent) continue;
                    out.println("Slivers at  " + rspecComponentManager + " has been unregistered.");
                }
                catch (JFedException e) {
                    message = "Error unregistering sliver at " + rspecComponentManager + ". (this error will be ignored)";
                    if (e.getXmlRpcResult() != null) {
                        err.println((String)message + ": \"" + e.getXmlRpcResult().getResultXmlRpcString() + "\"");
                        continue;
                    }
                    err.println((String)message + ":");
                    e.printStackTrace(err);
                }
            }
            catch (JFedException e) {
                message = "Error deleting sliver at " + rspecComponentManager + ". (this error will be ignored)";
                if (e.getXmlRpcResult() != null) {
                    err.println(message + ": \"" + e.getXmlRpcResult().getResultXmlRpcString() + "\"");
                    continue;
                }
                err.println(message + ":");
                e.printStackTrace(err);
            }
        }
    }

    private static int callFailed(String message, JFedException e, PrintStream err, CallLogOutput callLogOutput) {
        Thread.yield();
        Thread.yield();
        callLogOutput.flush();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread.yield();
        callLogOutput.flush();
        if (e == null) {
            err.println(message);
        } else if (e.getXmlRpcResult() != null) {
            err.println(message + ": \"" + e.getXmlRpcResult().getResultXmlRpcString() + "\"");
        } else {
            err.println(message + ":");
            e.printStackTrace(err);
        }
        return 2;
    }

    private static void addToUserSpecs(List<UserSpec> userSpecs, GeniUrn userUrn, String sshKey) {
        assert (userUrn != null);
        ExperimenterCli.addToUserSpecs(userSpecs, userUrn, Collections.singletonList(sshKey));
    }

    private static void addToUserSpecs(List<UserSpec> userSpecs, String userUrnString, String sshKey) {
        ExperimenterCli.addToUserSpecs(userSpecs, userUrnString, Collections.singletonList(sshKey));
    }

    private static void addToUserSpecs(List<UserSpec> userSpecs, GeniUrn userUrn, Collection<String> sshKeys) {
        assert (userUrn != null);
        ExperimenterCli.addToUserSpecs(userSpecs, userUrn.toString(), sshKeys);
    }

    private static void addToUserSpecs(List<UserSpec> userSpecs, String userUrnString, Collection<String> sshKeys) {
        if (sshKeys == null || sshKeys.isEmpty()) {
            return;
        }
        for (UserSpec us : userSpecs) {
            if (!Objects.equals(us.getUrn(), userUrnString)) continue;
            HashSet<String> newSskKeys = new HashSet<String>(sshKeys);
            newSskKeys.removeAll(us.getSshKey());
            if (!newSskKeys.isEmpty()) {
                us.getSshKey().addAll(newSskKeys);
            }
            return;
        }
        UserSpec newUs = new UserSpec(userUrnString, sshKeys);
        userSpecs.add(newUs);
    }

    public static List<String> extractCredentials(String multiCredentialString) {
        ArrayList<String> res = new ArrayList<String>();
        String namespaceStartChar = "A-Za-z_\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";
        String namespaceChar = namespaceStartChar + ".0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040-";
        Pattern startCredentialPattern = Pattern.compile("<([" + namespaceStartChar + "][" + namespaceChar + "]*:)?signed-credential");
        Pattern endCredentialPattern = Pattern.compile("</([" + namespaceStartChar + "][" + namespaceChar + "]*:)?signed-credential[^>]*>");
        Matcher startMatcher = startCredentialPattern.matcher(multiCredentialString);
        Matcher endMatcher = endCredentialPattern.matcher(multiCredentialString);
        int i = 0;
        while (startMatcher.find(i) && endMatcher.find(startMatcher.end())) {
            String credentialString = multiCredentialString.substring(startMatcher.start(), endMatcher.end());
            res.add(credentialString);
            i = endMatcher.end();
        }
        return res;
    }

    private static ModelRspec getModelRspec(ModelRspec existingModel, StringRspec rspec) throws RspecParseException {
        if (existingModel != null) {
            return existingModel;
        }
        ImmutableRequestRspecSource rspecSource = new ImmutableRequestRspecSource(rspec, ModelRspecType.BASIC);
        return rspecSource.getImmutableModelRspec();
    }

    private static boolean isBefore(Date a, Date b) {
        Date aa = new Date(a.getTime() + 999L);
        return aa.before(b);
    }

    private static GeniUrn verifyBindRspecUrn(ExperimenterCommandLineParser cli, PrintStream out, PrintStream err, AuthorityFinder authorityFinder) throws CLIException {
        if (cli.bindRspecArg != null) {
            GeniUrn bindRspecUrn = GeniUrn.parse((String)cli.bindRspecArg);
            if (bindRspecUrn == null) {
                err.println("Error parsing provided component_manager_id URN: " + cli.bindRspecArg);
                throw new CLIException(true, "Argument error");
            }
            Server bindRspecAuth = authorityFinder.findByUrn(bindRspecUrn, AuthorityFinder.Purpose.REQUEST_RSPEC);
            if (bindRspecAuth == null) {
                err.println("Error: could not find server matching component_manager_id URN provided by --bind-rspec: " + cli.bindRspecArg);
                throw new CLIException(true, "Unknown server");
            }
            return bindRspecUrn;
        }
        return null;
    }

    private static CallLogOutput initCallLogOutput(ExperimenterCommandLineParser cli, PrintStream out, PrintStream err, be.iminds.ilabt.jfed.log.Logger logger) throws CLIException {
        CallLogOutput callLogOutput = new CallLogOutput(err);
        if (cli.callLogArg != null) {
            try {
                callLogOutput.fos = new FileOutputStream(cli.callLogArg);
            }
            catch (FileNotFoundException e) {
                throw new CLIException(true, "Failed to open call log file \"" + cli.callLogArg + "\"", e);
            }
            try {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                callLogOutput.xtw = new IndentingXMLEventWriter(xof.createXMLEventWriter(callLogOutput.fos, "UTF-8"));
                callLogOutput.eventFactory = XMLEventFactory.newInstance();
                callLogOutput.xtw.add(callLogOutput.eventFactory.createStartDocument());
                callLogOutput.xtw.add(callLogOutput.eventFactory.createStartElement(new QName("calls"), null, null));
            }
            catch (XMLStreamException e) {
                callLogOutput.onFailure();
                LOG.error("Exception generating XML for call output", (Throwable)e);
                err.println("Exception generating XML for call output: " + e.getMessage());
            }
            logger.addResultListener(result -> {
                if (callLogOutput.isDisabled()) {
                    return;
                }
                SerializableApiCallDetails serializableApiCallDetails = new SerializableApiCallDetailsFactory().createFromApiCallDetails(result);
                try {
                    if (result.getServerUrnString() != null) {
                        callLogOutput.xtw.add(callLogOutput.eventFactory.createComment(result.getGeniMethodName() + " on " + result.getServerUrnString()));
                    }
                    SerializableApiCallDetailsWriter.writeApiCallDetails((SerializableApiCallDetails)serializableApiCallDetails, (XMLEventWriter)callLogOutput.xtw, (XMLEventFactory)callLogOutput.eventFactory);
                    callLogOutput.xtw.add(callLogOutput.eventFactory.createCharacters(System.getProperty("line.separator") + System.getProperty("line.separator")));
                    callLogOutput.xtw.flush();
                    callLogOutput.fos.flush();
                }
                catch (IOException e) {
                    err.println("Error flushing: " + e.getMessage());
                    e.printStackTrace();
                }
                catch (XMLStreamException e) {
                    err.println("Error writing call to stream: " + e.getMessage());
                    e.printStackTrace();
                    callLogOutput.onFailure();
                }
            });
        } else {
            callLogOutput.fos = null;
            callLogOutput.xtw = null;
            callLogOutput.eventFactory = null;
        }
        if (cli.printCalls) {
            PrintStream printCallsOut = out;
            String printCallsPrefix = "CALL: ";
            logger.addResultListener(result -> {
                printCallsOut.println();
                printCallsOut.println(TextUtil.indent((int)("CALL: ".length() + 1), (String)("CALL: " + result.getGeniMethodName() + " on " + result.getServerUrnString() + " at " + result.getConnectionConfig().getServerUrlString())));
                String req = result.getXmlRpcRequestJsonString();
                String res = result.getXmlRpcResponseJsonString();
                if (req != null) {
                    printCallsOut.println("CALL: Request: " + req);
                }
                if (res != null) {
                    printCallsOut.println("CALL: Reply: " + res);
                }
                printCallsOut.println();
                printCallsOut.println();
                printCallsOut.flush();
            });
        }
        return callLogOutput;
    }

    private static Triplet<StringRspec, ModelRspec, List<String>> initRspec(ExperimenterCommandLineParser cli, PrintStream out, PrintStream err, GeniUrn bindRspecUrn) throws CLIException {
        StringRspec rspec = null;
        ModelRspec modelRspec = null;
        List rspecComponentManagers = null;
        if (cli.rspecArg != null) {
            String rspecString;
            assert (cli.rspecArg != null);
            if (cli.rspecArg.startsWith("http")) {
                URL url;
                try {
                    url = new URL(cli.rspecArg);
                }
                catch (MalformedURLException e) {
                    LOG.debug("The URL specified in the --rspec argument, \"" + cli.rspecArg + "\", is not valid", (Throwable)e);
                    err.println("The URL specified in the --rspec argument, \"" + cli.rspecArg + "\", is not valid: " + e.getMessage());
                    throw new CLIException(true, "Invalid RSpec URL", e);
                }
                try {
                    rspecString = IOUtils.urlToString((URL)url, (Charset)Charset.defaultCharset());
                }
                catch (IOException e) {
                    LOG.debug("Exception reading the URL specified in the --rspec argument, \"" + cli.rspecArg + "\"", (Throwable)e);
                    err.println("There was an error reading the URL specified in the --rspec argument, \"" + cli.rspecArg + "\": " + e.getMessage());
                    throw new CLIException(true, "Error downloading RSpec", e);
                }
            }
            try {
                rspecString = IOUtils.fileToString((String)cli.rspecArg);
            }
            catch (IOException e) {
                err.println("The RSpec file \"" + cli.rspecArg + "\" was not found.");
                throw new CLIException(true, "Error opening RSpec file", e);
            }
            rspec = new StringRspec(rspecString);
            if (cli.rewriteRspecArg) {
                try {
                    modelRspec = ExperimenterCli.getModelRspec(modelRspec, rspec);
                    if (bindRspecUrn != null) {
                        int bindCount = 0;
                        for (RspecNode rspecNode : modelRspec.getNodes()) {
                            if (rspecNode.getComponentManagerId() != null) continue;
                            rspecNode.setComponentManagerId(bindRspecUrn);
                            ++bindCount;
                        }
                        int nodeCount = modelRspec.getNodes().size();
                        if (bindCount == 0) {
                            if (!cli.silent) {
                                err.println("WARNING: --bind-rspec was specified, but the RSpec did NOT contain any unbound nodes (0 nodes of " + nodeCount + " nodes have been bound).");
                            }
                        } else if (cli.debug) {
                            out.println("--bind-rspec was specified: " + bindCount + " nodes of " + nodeCount + " nodes have been bound to " + String.valueOf(bindRspecUrn));
                        }
                    }
                    ImmutableRequestRspecSource rspecSource2 = new ImmutableRequestRspecSource(modelRspec);
                    rspecString = rspecSource2.getRspecXmlString();
                    rspec = rspecSource2.getStringRspec();
                }
                catch (AssertionError | Exception t) {
                    LOG.error("Error rewriting RSpec", (Throwable)t);
                    err.println("Error parsing and rewriting RSpec, will use original RSpec! Error message: " + ((Throwable)t).getMessage());
                }
            }
            if (((rspecComponentManagers = rspec.getAllComponentManagerUrns()).size() != 1 || cli.debug) && !cli.silent) {
                out.println("Note: This RSpec has " + rspecComponentManagers.size() + " component managers: " + String.valueOf(rspecComponentManagers));
            }
            if (rspecComponentManagers.size() == 0) {
                if (cli.isCommand(ExperimenterCommandLineParser.Command.CREATE)) {
                    err.println("ERROR: The provided RSpec has no component managers. Something went wrong during parsing, or this is an empty RSpec. Either way, 'createSliver' cannot continue.");
                    throw new CLIException(true, "RSpec error");
                }
                err.println("WARNING: The provided RSpec has no component managers. Something went wrong during parsing, or this is an empty RSpec. Either way, few commands can now meaningfully continue. Will try anyway.");
            }
        }
        return new Triplet<Object, Object, Object>(rspec, modelRspec, rspecComponentManagers);
    }

    private static Object helperMethod3(ExperimenterCommandLineParser cli, PrintStream out, PrintStream err) throws CLIException {
        return null;
    }

    private static Object helperMethod4(ExperimenterCommandLineParser cli, PrintStream out, PrintStream err) throws CLIException {
        return null;
    }

    private static Object helperMethod5(ExperimenterCommandLineParser cli, PrintStream out, PrintStream err) throws CLIException {
        return null;
    }

    private static class CallLogOutput {
        public FileOutputStream fos;
        public XMLEventWriter xtw;
        public XMLEventFactory eventFactory;
        public final PrintStream err;

        public CallLogOutput(PrintStream err) {
            this.err = err;
        }

        public void onFailure() {
            this.close();
            this.fos = null;
            this.xtw = null;
            this.eventFactory = null;
        }

        public void flush() {
            try {
                this.xtw.flush();
                this.fos.flush();
            }
            catch (Exception e) {
                LOG.warn("Unexpected error flusing", (Throwable)e);
            }
        }

        public boolean isDisabled() {
            return this.fos == null || this.xtw == null || this.eventFactory == null;
        }

        public void close() {
            if (this.xtw != null && this.eventFactory != null) {
                try {
                    this.xtw.add(this.eventFactory.createEndElement(new QName("calls"), null));
                    this.xtw.add(this.eventFactory.createEndDocument());
                    this.xtw.flush();
                }
                catch (XMLStreamException e) {
                    LOG.error("Exception while closing call log output", (Throwable)e);
                    this.err.println("Exception while closing call log output: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (this.fos != null) {
                try {
                    this.fos.close();
                }
                catch (IOException e) {
                    LOG.error("Exception while closing call log output file", (Throwable)e);
                    this.err.println("Exception while closing call log output file: " + e.getMessage());
                }
            }
        }
    }

    public static class Triplet<T1, T2, T3> {
        public final T1 first;
        public final T2 second;
        public final T3 third;

        public Triplet(T1 first, T2 second, T3 third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }
    }

    private static class AutoShareLanInfo {
        private final GeniUrn componentManagerUrn;
        private final String lanClientId;
        private final String sharedLanName;

        public AutoShareLanInfo(GeniUrn componentManagerUrn, String lanClientId, String sharedLanName) {
            this.componentManagerUrn = componentManagerUrn;
            this.lanClientId = lanClientId;
            this.sharedLanName = sharedLanName;
        }
    }

    private static class AnsiblePlaybookInfo {
        private final ExecuteAnsiblePlaybook executeAnsiblePlaybook;
        private String outputFilename;
        private String outputBasename;
        private String scriptContent;

        public AnsiblePlaybookInfo(ExecuteAnsiblePlaybook executeAnsiblePlaybook) {
            this.executeAnsiblePlaybook = executeAnsiblePlaybook;
            this.outputFilename = executeAnsiblePlaybook.getOutputFilename();
        }

        public void checkFilename(boolean mustBeBasename, boolean allowAnyOutputFile) throws AnsiblePlaybookException {
            boolean isBasename;
            if (this.outputFilename == null) {
                return;
            }
            boolean bl = isBasename = this.outputFilename.indexOf(File.separatorChar) == -1;
            if (mustBeBasename && !isBasename) {
                throw new AnsiblePlaybookException("Invalid Output filename: " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE.getLocalPart() + " \"" + this.outputFilename + "\" is not a base filename.");
            }
            if (isBasename) {
                this.outputBasename = this.outputFilename;
                return;
            }
            File outputFile = new File(this.outputFilename);
            if (allowAnyOutputFile) {
                if (!outputFile.getParentFile().exists()) {
                    throw new AnsiblePlaybookException("Invalid Output filename: " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE.getLocalPart() + " \"" + this.outputFilename + "\" parent directory does not exist.");
                }
                if (outputFile.exists() && !outputFile.isFile()) {
                    throw new AnsiblePlaybookException("Invalid Output filename: " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE.getLocalPart() + " \"" + this.outputFilename + "\" exists but is not a normal file.");
                }
            } else {
                this.outputFilename = outputFile.getName();
            }
            this.outputBasename = outputFile.getName();
        }

        public void loadContent(boolean allowFile) throws AnsiblePlaybookException {
            if (this.executeAnsiblePlaybook.getSource() == null) {
                throw new AnsiblePlaybookException("Invalid RSpec: " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " has no " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + " attribute");
            }
            if (this.executeAnsiblePlaybook.getSource().startsWith("http")) {
                URL url;
                try {
                    url = new URL(this.executeAnsiblePlaybook.getSource());
                }
                catch (MalformedURLException e) {
                    throw new AnsiblePlaybookException("Invalid " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + " url: \"" + this.executeAnsiblePlaybook.getSource() + "\"", e);
                }
                try {
                    this.scriptContent = IOUtils.urlToString((URL)url, (Charset)Charset.defaultCharset());
                }
                catch (IOException e) {
                    throw new AnsiblePlaybookException("Error reading URL in " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + " attribute: \"" + this.executeAnsiblePlaybook.getSource() + "\": " + e.getMessage(), e);
                }
            }
            if (!allowFile) {
                throw new AnsiblePlaybookException(RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + " is \"" + this.executeAnsiblePlaybook.getSource() + "\" but the --ansible-allow-playbook-inputfile option is not set, so only URLs are allowed.");
            }
            File localFile = new File(this.executeAnsiblePlaybook.getSource());
            if (!localFile.exists()) {
                throw new AnsiblePlaybookException("Bad " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + " filename: \"" + this.executeAnsiblePlaybook.getSource() + "\" does not exist");
            }
            try {
                this.scriptContent = IOUtils.fileToString((File)localFile);
            }
            catch (IOException e) {
                throw new AnsiblePlaybookException("Error reading " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + " file: \"" + this.executeAnsiblePlaybook.getSource() + "\": " + e.getMessage(), e);
            }
        }

        public ExecuteAnsiblePlaybook getExecuteAnsiblePlaybook() {
            return this.executeAnsiblePlaybook;
        }

        public String getOutputFilename() {
            return this.outputFilename;
        }

        public String getScriptContent() {
            return this.scriptContent;
        }

        public String getOutputBasename() {
            return this.outputBasename;
        }

        public static class AnsiblePlaybookException
        extends Exception {
            public AnsiblePlaybookException(String message) {
                super(message);
            }

            public AnsiblePlaybookException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    public static class CLIException
    extends Exception {
        private final boolean error;

        public CLIException(boolean error) {
            this.error = error;
        }

        public CLIException(boolean error, String message) {
            super(message);
            this.error = error;
        }

        public CLIException(boolean error, String message, Throwable cause) {
            super(message, cause);
            this.error = error;
        }

        public CLIException(boolean error, Throwable cause) {
            super(cause);
            this.error = error;
        }

        public CLIException(boolean error, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }
    }

    public static class Pair<T1, T2> {
        public final T1 first;
        public final T2 second;

        public Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }
    }
}

