/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.cli;

import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.ui.commandline.BaseCli;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.ExtraInfoCallback;
import be.iminds.ilabt.jfed.util.library.JFedVersionInfo;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.LoggerFactory;

public class ExperimenterCommandLineParser {
    public static final String CHOOSE_PROJECT_AUTOMATICALLY_OPTION = "CHOOSE_AUTOMATICALLY";
    private final Command command;
    private final Options options;
    public final CommandLine line;
    public final String sliceIdArg;
    public String projectNameArg;
    public final String sliceExpirationDateArg;
    public final String sliceExpirationHoursArg;
    public final String rspecArg;
    public final String bindRspecArg;
    public final String shareSliceUsersArg;
    public final String outputFormatArg;
    public final String amApiVersionArg;
    public final String sshKeysArg;
    public final String manifestArg;
    public final String callLogArg;
    public final String sliceRecoverInfoArg;
    public final boolean createSliceArg;
    public final boolean rewriteRspecArg;
    public final boolean stitchingArg;
    public final boolean debug;
    public final boolean printCalls;
    public final boolean fake;
    public final boolean logbackLogging;
    public final boolean fakeSliver;
    public final boolean waitUntilReady;
    public final boolean silent;
    public final boolean abortIfSliversExist;
    public final boolean deleteOnCreateFailure;
    public final boolean deleteOnBecomeReadyFailure;
    public final String[] speaksForArgs;
    public final String poaActionArg;
    public final String poaTargetSliverUrnArg;
    public final String ansibleDirName;
    public final String ansiblePlayBookExe;
    public final boolean ansibleExecuteRspecPlaybooks;
    public final String[] ansibleExtraPlaybooks;
    public final boolean noPlaybookToExecute;
    public final boolean ansibleAllowPlaybookInputfile;
    public final boolean ansibleAllowAnyPlaybookOutputFile;
    public final boolean ansibleDebug;
    public final boolean runLinkTest;
    public final Integer socketConnectTimeoutMs;
    public final Integer socketReadTimeoutMs;
    public static final List<String> actionOptions = Arrays.asList("ReloadOS", "Restart", "ConsoleUrl");
    public static final String actionOptionsString;
    private final PrintStream out;
    private final PrintStream err;
    private final InputStream in;
    private final BaseCli baseCli;
    public final String manifestFilename;
    public final GeniUrn poaTargetSliverUrn;
    public final File ansibleDir;
    public final boolean isJson;
    public final boolean isTextOutput;
    public final boolean sshKeysUserCert;
    public final boolean sshKeysUserServerKeys;
    public final boolean sshKeysSharedUserKeys;
    public final boolean sshKeysRspec;
    public final String sliceName;
    public final Date requestedExpirationDate;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExperimenterCommandLineParser(String[] args, final PrintStream out, final PrintStream err, final InputStream in, BaseCli baseCli) throws IOException, ClassNotFoundException, CLIParseException {
        this.out = out;
        this.err = err;
        this.in = in;
        this.baseCli = baseCli;
        Object cliCommand = null;
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        if (argList.isEmpty()) {
            ExperimenterCommandLineParser.generalHelp(err);
            throw new CLIParseException(true, "No arguments");
        }
        if (Objects.equals(argList.get(0), "version") || Objects.equals(argList.get(0), "--version") || Objects.equals(argList.get(0), "-version") || Objects.equals(argList.get(0), "-v")) {
            ExperimenterCommandLineParser.showVersion(out);
            throw new CLIParseException(false, "Version requested");
        }
        String cliCommandString = argList.removeFirst();
        this.command = Command.parse(cliCommandString);
        if (this.command == null) {
            err.println("ERROR: unknown command \"" + cliCommandString + "\"");
            ExperimenterCommandLineParser.generalHelp(err);
            throw new CLIParseException(false, "Unknown command \"" + cliCommandString + "\"");
        }
        BasicParser parser = new BasicParser();
        this.options = new Options();
        BaseCli.addUserConfig((Options)this.options, (String)"The properties file containing context details (only the login info in the context file is used by this tool)", (boolean)false);
        BaseCli.addAuthoritiesConfig((Options)this.options);
        if (this.command.isRequireSlice()) {
            this.options.addOption(Option.builder("s").longOpt("slice").desc("The URN or name of the slice to use. (auto detected)").hasArg().argName("SLICE URN OR NAME").required().build());
        }
        this.options.addOption(Option.builder().longOpt("speaks-for").desc("The speaksFor certificate (in a file), enabling you make calls on behalf of another user.").hasArg().argName("CERTIFICATE FILENAME").build());
        this.options.addOption(Option.builder().longOpt("socket-read-timeout").desc("Set the read timeout for all sockets. In ms. default: 120000 (2 min)").hasArg().type(Number.class).argName("TIMEOUT (in ms)").build());
        this.options.addOption(Option.builder().longOpt("socket-connect-timeout").desc("Set the connect timeout for all sockets. In ms. default: 10000 (10s)").hasArg().type(Number.class).argName("TIMEOUT (in ms)").build());
        if (this.command.isRequireSlice()) {
            this.options.addOption(Option.builder("S").longOpt("project-name").desc("The name of the project (= sub authority) of the slice. This is an optional argument (however some authorities might require a project!). You can also use \"CHOOSE_AUTOMATICALLY\" as project name, in that case, the last (determined by your SA) project you are a member of will be used.").hasArg().argName("PROJECT NAME").build());
        }
        if (this.command == Command.CREATE || this.command == Command.RENEW || this.command == Command.CREATE_SLICE_ONLY) {
            this.options.addOption(Option.builder().longOpt("expiration-date").desc("The date and time at which this slice expires. In RFC3339 format. This is an optional argument. default: 2 hours in the future").hasArg().argName("RFC3339 DATE").build());
            this.options.addOption(Option.builder("e").longOpt("expiration-hours").desc("The number of hours after which this slice expires. This is an optional argument. default: 2 hours in the future").hasArg().argName("INTEGER").build());
        }
        if (this.command == Command.CREATE || this.command == Command.CREATE_SLICE_ONLY) {
            this.options.addOption(Option.builder().longOpt("share-slice").desc("List of users to share slice with. Either use the URN of each user, or the short username. You can also specify the special value \"PROJECTUSERS\", which will automatically share the slice with all users in the project. Multiple users can be specified by separating them with a comma.").hasArg().argName("USERNAME(S)").build());
        }
        if (this.command == Command.LIST_USER_INFO || this.command == Command.SHOW_SLICE_INFO || this.command == Command.CREATE_SLICE_ONLY || this.command == Command.STATUS) {
            this.options.addOption(Option.builder().longOpt("output-format").desc("The output format to use (for user information). Choices: \"text\" or \"json\". Default:json").hasArg().argName("FORMAT").build());
        }
        if (this.command == Command.POA) {
            this.options.addOption(Option.builder("a").longOpt("action").desc("The operational action to perform. (Options: " + actionOptionsString + ")").hasArg().argName("ACTION").required().build());
            this.options.addOption(Option.builder("t").longOpt("target-sliver").desc("The URN of the sliver to perform the action on.").hasArg().argName("SLIVER or SLICE URN").required().build());
        }
        if (this.command == Command.CREATE) {
            this.options.addOption(Option.builder("r").longOpt("rspec").desc("The rspec file to use for creating a sliver").hasArg().argName("RSPEC XML FILE").required().build());
            this.options.addOption(Option.builder().longOpt("run-link-test").desc("Run a link test once the experiment is done (and fail if the test fails).").build());
        }
        if (this.command == Command.STATUS || this.command == Command.RENEW || this.command == Command.POA) {
            this.options.addOption(Option.builder("r").longOpt("rspec").desc("The rspec file to get the needed authority information from (manifest or request)  (not mandatory, but might not work without)").hasArg().argName("RSPEC XML FILE").build());
        }
        if (this.command == Command.CREATE || this.command == Command.MANIFEST) {
            this.options.addOption(Option.builder().longOpt("ansible-dir").desc("The dir in which to save ansible config files. Will be created if it doesn't exist. Will overwrite any existing files.").hasArg().argName("DIR").build());
        }
        if (this.command == Command.CREATE || this.command == Command.MANIFEST) {
            this.options.addOption(Option.builder().longOpt("ansible-execute-rspec-playbooks").desc("Execute all ansible playbooks found within request Rspec " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " elements. (default: ignore them)").build());
            this.options.addOption(Option.builder().longOpt("ansible-add-playbook").desc("Add an ansible playbook to execute. The argument specifies the source, and optionally (after a space) the target (this option can be specified multiple times)").numberOfArgs(2).argName(RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + " [" + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE.getLocalPart() + "]").build());
            this.options.addOption(Option.builder().longOpt("ansible-allow-playbook-inputfile").desc("Allow local files in " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + ". (default: only allow URLs as " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE.getLocalPart() + ")").build());
            this.options.addOption(Option.builder().longOpt("ansible-allow-any-playbook-outputfile").desc("Allow any local file as " + RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK.getLocalPart() + " " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE.getLocalPart() + ". (default: only use the basename of the specified " + RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE.getLocalPart() + ", and use the --ansible-dir as directory)").build());
            this.options.addOption(Option.builder().longOpt("ansible-playbook-exe").desc("Executable for the ansible playbook. Default is \"ansible-playbook\" and is usually fine. On some systems might need to be \"/usr/bin/python2 /usr/bin/ansible-playbook\"").hasArg().build());
            this.options.addOption(Option.builder().longOpt("ansible-debug").desc("Set debug flags when calling ansible playbook.").build());
        }
        this.options.addOption(Option.builder().longOpt("manifest").desc("The file in which the manifest must be stored. (default: manifest-<SLICENAME>.rspec)").hasArg().argName("FILE").build());
        if (this.command == Command.DELETE) {
            this.options.addOption(Option.builder("r").longOpt("rspec").desc("The rspec file to get the needed authority information from (manifest or request) (not mandatory, but might not work without)").hasArg().argName("RSPEC XML FILE").build());
        }
        if (this.command == Command.CREATE) {
            this.options.addOption(Option.builder().longOpt("delete-on-create-failure").desc("If there is a failure in a call made to create the sliver(s), delete all resources everywhere before exiting.").build());
            this.options.addOption(Option.builder().longOpt("delete-on-become-ready-failure").desc("If there is a failure in a call while waiting for the sliver(s) to become ready, delete all resources everywhere before exiting.").build());
            this.options.addOption(Option.builder().longOpt("abort-if-slivers-exist").desc("Do not create any slivers if any sliver already exists on any of the authorities.").build());
            this.options.addOption(Option.builder().longOpt("create-slice").desc("Create the slice if it doesn't exist. (if it exists, this option is ignored)").build());
            this.options.addOption(Option.builder().longOpt("rewrite-rspec").desc("Parse the provided RSpec, and reconstruct it again, before sending it to the server. This can help prevent some server sides bug caused by valid but atypical RSpecs.").build());
            this.options.addOption(Option.builder().longOpt("bind-rspec").desc("Bind any unbound nodes in the RSpec to a specified authority. This leaves bound nodes as they are. (this imples --rewrite-rspec)").hasArg().argName("COMPONENT MANAGER URN").build());
            this.options.addOption(Option.builder("k").longOpt("ssh-keys").desc("Specify which ssh keys to add. The argument is a (comma separated) list of options.\nAvailable options: usercert,userkeys,rspec,shareduserallkeys\n   usercert: add the user making the calls, with the ssh key from the certificate in the login PEM file.\n   userkeys: add the user making the calls, with the ssh keys that are stored on the user authority MA server. (usercert and userkeys can be combined to add all keys)\n   shareduserallkeys: add the ssh keys that are stored on the user authority MA server for the users the slice is shared with AND the ssh keys from that user's login certificate.\n   rspec: add the users and keys specified in the RSpec itself.\nThis option is optional, default: usercert,rspec,shareduserallkeys").hasArg().argName("OPTION LIST").build());
            this.options.addOption(Option.builder().longOpt("stitching").desc("If the RSpec requires stitching, allow it. By default, RSpecs that require stitching cause an abort").build());
            this.options.addOption(Option.builder().longOpt("slice-recover-info").desc("A file into which slice recover info will be stored. This can be used by the jFed GUI (if copied to the correct directory).").hasArg().argName("FILE").build());
            this.options.addOption(Option.builder().longOpt("nowait").desc("Do not wait until sliver is ready (default: wait until ready)").build());
        }
        this.options.addOption(Option.builder().longOpt("call-log").desc("A file into which all call details will be stored").hasArg().argName("FILE").build());
        this.options.addOption(Option.builder().longOpt("print-calls").desc("Print all calls to stdout").build());
        this.options.addOption(Option.builder("am").longOpt("am-api").desc("The AM Api version to use (\"2\" and \"3\" supported, default: choose automatically)").hasArg().argName("AM API VERSION").build());
        this.options.addOption(Option.builder().longOpt("fake").desc("Do everything, expect actually making the slice and sliver calls. Useful for debugging syntax. (will make calls relating to retrieving user data)").build());
        if (this.command != Command.CREATE_SLICE_ONLY && this.command != Command.SHOW_SLICE_INFO) {
            this.options.addOption(Option.builder().longOpt("fake-sliver").desc("Do everything, expect actually making the sliver calls. (will make calls relating to retrieving user data and creating or retrieving slice)").build());
        }
        this.options.addOption("q", "quiet", false, "less output");
        this.options.addOption(null, "silent", false, "less output (same as --quiet)");
        this.options.addOption("d", "debug", false, "extra debugging output");
        this.options.addOption("l", "logging", false, "activate logback logging output");
        this.options.addOption("v", "version", false, "show version and exit");
        try {
            String[] leftoverArgs = new String[argList.size()];
            int i = 0;
            for (String arg : argList) {
                leftoverArgs[i++] = arg;
            }
            this.line = parser.parse(this.options, leftoverArgs);
        }
        catch (ParseException exp) {
            err.println("Command line argument Syntax error: " + exp.getMessage());
            ExperimenterCommandLineParser.commandHelp(err, this.options, this.command);
            throw new CLIParseException(true, "Command line argument Syntax error: " + exp.getMessage());
        }
        if (this.line.hasOption("version")) {
            ExperimenterCommandLineParser.showVersion(out);
            throw new CLIParseException(false, "Show version");
        }
        this.sliceIdArg = this.line.getOptionValue("slice");
        this.projectNameArg = this.line.getOptionValue("project-name");
        this.sliceExpirationDateArg = this.line.getOptionValue("expiration-date");
        this.sliceExpirationHoursArg = this.line.getOptionValue("expiration-hours");
        this.rspecArg = this.line.getOptionValue("rspec");
        this.bindRspecArg = this.line.getOptionValue("bind-rspec");
        this.shareSliceUsersArg = this.line.getOptionValue("share-slice");
        this.outputFormatArg = this.line.getOptionValue("output-format") == null ? "json" : this.line.getOptionValue("output-format");
        this.amApiVersionArg = this.line.getOptionValue("am-api");
        this.sshKeysArg = this.line.getOptionValue("ssh-keys");
        this.manifestArg = this.line.getOptionValue("manifest");
        this.callLogArg = this.line.getOptionValue("call-log");
        this.sliceRecoverInfoArg = this.line.getOptionValue("slice-recover-info");
        this.createSliceArg = this.line.hasOption("create-slice");
        this.rewriteRspecArg = this.line.hasOption("rewrite-rspec") || this.bindRspecArg != null;
        this.stitchingArg = this.line.hasOption("stitching");
        this.debug = this.line.hasOption("debug");
        this.printCalls = this.line.hasOption("print-calls");
        this.fake = this.line.hasOption("fake");
        this.logbackLogging = this.line.hasOption("logging");
        this.fakeSliver = this.line.hasOption("fake-sliver");
        this.waitUntilReady = !this.line.hasOption("nowait");
        this.silent = !this.debug && (this.line.hasOption("quiet") || this.line.hasOption("silent"));
        this.abortIfSliversExist = this.line.hasOption("abort-if-slivers-exist");
        this.deleteOnCreateFailure = this.line.hasOption("--delete-on-create-failure");
        this.deleteOnBecomeReadyFailure = this.line.hasOption("--delete-on-become-ready-failure");
        this.speaksForArgs = this.line.getOptionValues("speaks-for");
        this.poaActionArg = this.line.getOptionValue("action");
        this.poaTargetSliverUrnArg = this.line.getOptionValue("target-sliver");
        this.ansibleDirName = this.line.getOptionValue("ansible-dir");
        this.ansiblePlayBookExe = this.line.getOptionValue("ansible-playbook-exe", "ansible-playbook");
        this.ansibleExecuteRspecPlaybooks = this.line.hasOption("ansible-execute-rspec-playbooks");
        this.ansibleExtraPlaybooks = this.line.getOptionValues("ansible-add-playbook");
        this.noPlaybookToExecute = !this.ansibleExecuteRspecPlaybooks && (this.ansibleExtraPlaybooks == null || this.ansibleExtraPlaybooks.length == 0);
        this.ansibleAllowPlaybookInputfile = this.line.hasOption("ansible-allow-playbook-inputfile");
        this.ansibleAllowAnyPlaybookOutputFile = this.line.hasOption("ansible-allow-any-playbook-outputfile");
        this.ansibleDebug = this.line.hasOption("ansible-debug");
        this.runLinkTest = this.line.hasOption("run-link-test");
        try {
            this.socketConnectTimeoutMs = this.line.hasOption("socket-connect-timeout") ? Integer.valueOf(((Number)this.line.getParsedOptionValue("socket-connect-timeout")).intValue()) : null;
        }
        catch (ParseException e) {
            throw new CLIParseException(true, "Error parsing socket-connect-timeout", e);
        }
        try {
            this.socketReadTimeoutMs = this.line.hasOption("socket-read-timeout") ? Integer.valueOf(((Number)this.line.getParsedOptionValue("socket-read-timeout")).intValue()) : null;
        }
        catch (ParseException e) {
            throw new CLIParseException(true, "Error parsing socket-connect-timeout", e);
        }
        if (this.debug) {
            for (Option o : this.line.getOptions()) {
                out.println("ARG: " + o.getOpt() + " " + o.getLongOpt() + " " + o.getValue() + " " + String.valueOf(o.getValuesList()) + " " + o.getValuesList().size());
            }
        }
        if (this.isCommand(Command.POA) && this.poaActionArg != null) {
            boolean validAction = false;
            for (String o : actionOptions) {
                if (!o.equalsIgnoreCase(this.poaActionArg.trim())) continue;
                validAction = true;
            }
            if (!validAction) {
                err.println("Unsupported action option \"" + this.poaActionArg + "\" specified. Valid options are: " + actionOptionsString);
                this.commandHelp();
                throw new CLIParseException(true, "Argument error.");
            }
        }
        if (this.isCommand(Command.POA) && this.poaTargetSliverUrnArg != null) {
            this.poaTargetSliverUrn = GeniUrn.parse((String)this.poaTargetSliverUrnArg);
            if (this.poaTargetSliverUrn == null) {
                err.println("Invalid URN specified for option target sliver: \"" + this.poaTargetSliverUrnArg + "\"");
                this.commandHelp();
                throw new CLIParseException(true, "Invalid URN specified for option target sliver: \"" + this.poaTargetSliverUrnArg + "\"");
            }
            if (!Objects.equals(this.poaTargetSliverUrn.getResourceType(), "sliver") && !Objects.equals(this.poaTargetSliverUrn.getResourceType(), "slice")) {
                err.println("\n\n**WARNING** URN specified for option target sliver is not a sliver URN: \"" + this.poaTargetSliverUrnArg + "\"\n            This will be ignored, but will likely not cause the desired results.\n\n");
            }
        } else {
            this.poaTargetSliverUrn = null;
        }
        if (this.ansibleDirName != null) {
            this.ansibleDir = new File(this.ansibleDirName);
            if (!this.ansibleDir.exists() && !this.ansibleDir.getParentFile().exists()) {
                err.println("Specified ansible-dir does not exist, and neither does parent dir: \"" + this.ansibleDirName + "\"");
                this.commandHelp();
                throw new CLIParseException(true, "Argument error.");
            }
        } else {
            this.ansibleDir = null;
        }
        if (!this.noPlaybookToExecute && this.ansibleDirName == null) {
            err.println("the --ansible-execute-rspec-playbooks and --ansible-add-playbook options requires that the ansible-dir option is specified.");
            throw new CLIParseException(true, "Argument error.");
        }
        if (this.debug) {
            out.println("Showing version because debug is enabled:");
            this.showVersion();
        }
        if (this.logbackLogging) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            InputStream configStream = ExperimenterCommandLineParser.class.getResourceAsStream("/logback_debug.xml");
            configurator.setContext((Context)loggerContext);
            try {
                configurator.doConfigure(configStream);
            }
            catch (JoranException e) {
                err.println("Failed to configure logback! " + e.getMessage());
                e.printStackTrace();
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
            if (configStream != null) {
                configStream.close();
            }
        }
        if (this.getCommand().isRequireSlice() && this.sliceIdArg == null) {
            err.println("The slice option is mandatory");
            this.commandHelp();
            throw new CLIParseException(true, "Argument error.");
        }
        if (this.isCommand(Command.LIST_USER_INFO, Command.SHOW_SLICE_INFO, Command.CREATE_SLICE_ONLY, Command.STATUS)) {
            boolean knownFormat = false;
            if (this.outputFormatArg.trim().equalsIgnoreCase("json")) {
                this.isJson = true;
                knownFormat = true;
            } else {
                this.isJson = false;
            }
            if (this.outputFormatArg.trim().equalsIgnoreCase("text")) {
                this.isTextOutput = true;
                knownFormat = true;
            } else {
                this.isTextOutput = false;
            }
            if (!knownFormat) {
                err.println("Output format \"" + this.outputFormatArg + "\" is unknown");
                this.commandHelp();
                throw new CLIParseException(true, "Argument error.");
            }
        } else {
            this.isJson = false;
            this.isTextOutput = false;
        }
        ExtraInfoCallback.setAnyLoginCallback((ExtraInfoCallback.AnyLoginCallback)new ExtraInfoCallback.AnyLoginCallback(){
            private LoginInfo cachedLogin = null;

            public LoginInfo getLogin(String serviceName, String friendlyName) {
                err.println("Login callback called.");
                if (this.cachedLogin == null) {
                    out.println("\n");
                    out.println("==============================================================");
                    String username = IOUtils.askCommandLineInput((String)("Please enter " + friendlyName + " username:"), (InputStream)in);
                    String password = new String(IOUtils.askCommandLinePassword((String)("Please enter " + friendlyName + " password:"), (InputStream)in));
                    this.cachedLogin = new LoginInfo(serviceName, username, password);
                    out.println("==============================================================\n");
                }
                return this.cachedLogin;
            }
        });
        if (this.sshKeysArg == null) {
            this.sshKeysUserCert = true;
            this.sshKeysUserServerKeys = false;
            this.sshKeysSharedUserKeys = true;
            this.sshKeysRspec = true;
        } else {
            String[] opts = this.sshKeysArg.split(",");
            boolean tmpSshKeysUserCert = false;
            boolean tmpSshKeysUserServerKeys = false;
            boolean tmpSshKeysSharedUserKeys = false;
            boolean tmpSshKeysRspec = false;
            for (String opt : opts) {
                boolean validOpt = false;
                if (opt.equalsIgnoreCase("usercert")) {
                    tmpSshKeysUserCert = true;
                    validOpt = true;
                }
                if (opt.equalsIgnoreCase("userkeys")) {
                    tmpSshKeysUserServerKeys = true;
                    validOpt = true;
                }
                if (opt.equalsIgnoreCase("shareduserallkeys")) {
                    tmpSshKeysSharedUserKeys = true;
                    validOpt = true;
                }
                if (opt.equalsIgnoreCase("rspec")) {
                    tmpSshKeysRspec = true;
                    validOpt = true;
                }
                if (validOpt) continue;
                err.println("The ssh-keys option you have specified (" + opt + ") is not valid");
                this.commandHelp();
                throw new CLIParseException(true, "Argument error.");
            }
            this.sshKeysUserCert = tmpSshKeysUserCert;
            this.sshKeysUserServerKeys = tmpSshKeysUserServerKeys;
            this.sshKeysSharedUserKeys = tmpSshKeysSharedUserKeys;
            this.sshKeysRspec = tmpSshKeysRspec;
        }
        if (this.getCommand().isRequireSlice() && this.sliceIdArg.startsWith("urn:")) {
            String sliceUrnprojectName;
            GeniUrn sliceUrn = GeniUrn.parse((String)this.sliceIdArg);
            if (sliceUrn == null) {
                err.println("Error parsing provided slice URN: " + this.sliceIdArg);
                throw new CLIParseException(true, "Argument error.");
            }
            if (this.projectNameArg != null != ((sliceUrnprojectName = sliceUrn.getEncodedSubAuthName()) != null) || this.projectNameArg != null && sliceUrnprojectName != null && !Objects.equals(this.projectNameArg, sliceUrnprojectName)) {
                if (this.projectNameArg != null) {
                    if (!Objects.equals(this.projectNameArg, CHOOSE_PROJECT_AUTOMATICALLY_OPTION)) {
                        err.println("The project-name you have specified (" + this.projectNameArg + ") does not match the sub authority in the slice URN you have specified (" + this.sliceIdArg + ")");
                        throw new CLIParseException(true, "Argument error.");
                    }
                    this.projectNameArg = sliceUrnprojectName;
                } else {
                    this.projectNameArg = sliceUrnprojectName;
                }
            }
        }
        this.sliceName = !this.getCommand().isRequireSlice() ? null : (this.sliceIdArg.startsWith("urn:") ? GeniUrn.parse((String)this.sliceIdArg).getEncodedResourceName() : this.sliceIdArg);
        this.manifestFilename = this.manifestArg == null ? "manifest-" + this.sliceName + ".rspec" : this.manifestArg;
        if (this.sliceExpirationDateArg != null && this.sliceExpirationHoursArg != null) {
            err.println("You may not specify both expiration-date and expiration-hours. You need to specify only one.");
            throw new CLIParseException(true, "Argument error.");
        }
        if (this.sliceExpirationDateArg == null) {
            if (this.sliceExpirationHoursArg == null) {
                this.requestedExpirationDate = new Date(System.currentTimeMillis() + 0x6DDD00L);
            } else {
                try {
                    int hours = Integer.parseInt(this.sliceExpirationHoursArg);
                    this.requestedExpirationDate = new Date(System.currentTimeMillis() + (long)(hours * 60 * 60) * 1000L);
                }
                catch (NumberFormatException e) {
                    err.println("Specified slice expiration hours (\"" + this.sliceExpirationDateArg + "\") is not a valid number.");
                    throw new CLIParseException(true, "Argument error.");
                }
            }
        } else {
            try {
                this.requestedExpirationDate = RFC3339Util.rfc3339StringToDate((String)this.sliceExpirationDateArg);
            }
            catch (java.text.ParseException e) {
                err.println("Specified slice expiration date (\"" + this.sliceExpirationDateArg + "\") is not in RFC3339 format. The current date in RFC3339 format is: " + RFC3339Util.dateToRFC3339String((Date)new Date()));
                throw new CLIParseException(true, "Argument error.");
            }
        }
        if (this.amApiVersionArg != null && !Objects.equals(this.amApiVersionArg, "2") && !Objects.equals(this.amApiVersionArg, "3")) {
            err.println("Unsupported AM api version: \"" + this.amApiVersionArg + "\"");
            this.commandHelp();
            throw new CLIParseException(true, "Argument error.");
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isCommand(Command ... anyCommmands) {
        for (Command c : anyCommmands) {
            if (!Objects.equals((Object)this.command, (Object)c)) continue;
            return true;
        }
        return false;
    }

    private static void commandHelp(PrintStream err, Options options, Command command) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(200, "jfed-experimenter-cli <command> [command_options ... ]", "Available commands: create,delete,status,renew,manifest,userinfo,sliceinfo,createslice\n" + command.getAliases().get(0) + " options:", options, "\n\nTemplate Context Properties File:\n  username = <username>\n  passwordFilename = <filename of file containing password>\n  pemKeyAndCertFilename = <filename of file containing user certificate and private key in PEM format>\n  userAuthorityUrn = <URN of test user's authority>\n");
    }

    public void commandHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(200, "jfed-experimenter-cli <command> [command_options ... ]", "Available commands: create,delete,status,renew,manifest,userinfo,sliceinfo,createslice\n" + this.command.getAliases().get(0) + " options:", this.options, "\n\nTemplate Context Properties File:\n  username = <username>\n  passwordFilename = <filename of file containing password>\n  pemKeyAndCertFilename = <filename of file containing user certificate and private key in PEM format>\n  userAuthorityUrn = <URN of test user's authority>\n");
    }

    public void showVersion() {
        ExperimenterCommandLineParser.showVersion(this.out);
    }

    public static void showVersion(PrintStream out) {
        out.println("jFed Experimenter CLI -- http://jfed.iminds.be/");
        out.println("Send bugreports to: jfed-bugreports@atlantis.ugent.be");
        JFedVersionInfo jFedVersionInfo = new JFedVersionInfo();
        out.println("Version: " + jFedVersionInfo.getFullVersionString());
        out.println("Environment: " + jFedVersionInfo.getEnvironmentString());
    }

    public static void generalHelp(PrintStream err) {
        err.println("Syntax: jfed-experimenter-cli <command> [command_options ... ]\nAvailable Commands: create,delete,status,renew,userinfo,sliceinfo,createslice\n");
    }

    static {
        Object actionOptionsStringTmp = "";
        for (String a : actionOptions) {
            if (!((String)actionOptionsStringTmp).isEmpty()) {
                actionOptionsStringTmp = (String)actionOptionsStringTmp + ", ";
            }
            actionOptionsStringTmp = (String)actionOptionsStringTmp + a;
        }
        actionOptionsString = actionOptionsStringTmp;
    }

    public static class CLIParseException
    extends Exception {
        private final boolean error;

        public CLIParseException(boolean error) {
            this.error = error;
        }

        public CLIParseException(boolean error, String message) {
            super(message);
            this.error = error;
        }

        public CLIParseException(boolean error, String message, Throwable cause) {
            super(message, cause);
            this.error = error;
        }

        public CLIParseException(boolean error, Throwable cause) {
            super(cause);
            this.error = error;
        }

        public CLIParseException(boolean error, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }
    }

    public static enum Command {
        CREATE(true, "create", "createsliver", "createslivers"),
        RENEW(true, "renew"),
        DELETE(true, "delete"),
        POA(true, "performOperationalAction", "poa", "perform-operational-action", "perform_operational_action"),
        STATUS(true, "status"),
        MANIFEST(true, "manifest"),
        SHOW_SLICE_INFO(true, "show-slice", Pattern.compile("(show(-)?)?(slice(-)?)?((cred(ential)?)|(info(rmation)?))")),
        CREATE_SLICE_ONLY(true, "create-slice", Pattern.compile("(create(-)?)?slice((-)?only)?")),
        LIST_USER_INFO(false, "userinfo");

        private final List<String> aliases;
        private final Pattern pattern;
        private final boolean requireSlice;

        private Command(boolean requireSlice, String ... aliases) {
            this.requireSlice = requireSlice;
            this.aliases = Arrays.asList(aliases);
            this.pattern = null;
        }

        private Command(boolean requireSlice, String mainAlias, Pattern pattern) {
            this.requireSlice = requireSlice;
            this.aliases = Collections.singletonList(mainAlias);
            this.pattern = pattern;
        }

        public boolean matches(String cliCommand) {
            if (this.pattern == null) {
                for (String alias : this.aliases) {
                    if (!alias.equalsIgnoreCase(cliCommand)) continue;
                    return true;
                }
                return false;
            }
            return this.pattern.matcher(cliCommand).matches();
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public boolean isRequireSlice() {
            return this.requireSlice;
        }

        public static Command parse(String cliCommand) {
            for (Command command : Command.values()) {
                if (!command.matches(cliCommand)) continue;
                return command;
            }
            return null;
        }
    }
}

